/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.comment.domain.DocumentTopicRelationMgr;
import com.trs.components.comment.persistent.DocumentTopic;
import com.trs.components.comment.service.ICommentService;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class CommentService
implements ICommentService {
    private DocumentTopicRelationMgr topicMgr = (DocumentTopicRelationMgr)DreamFactory.createObjectById("DocumentTopicRelationMgr");

    @Override
    public boolean isInRelatedTopic(String _sRelatedDocIds, int _nDocId) {
        boolean result = false;
        try {
            result = this.topicMgr.isInRelatedTopic(_sRelatedDocIds, _nDocId);
        }
        catch (Exception e) {
            return false;
        }
        return result;
    }

    @Override
    public void saveDocTopicRelation(int _nTopicId, int _nDocChannelId, String _sRelatedDocIds) throws WCMException {
        try {
            if (CMyString.isEmpty(_sRelatedDocIds)) {
                this.topicMgr.saveDocTopicRelation(_nTopicId, _nDocChannelId, null);
                return;
            }
            String[] arStrDocIds = _sRelatedDocIds.split(",");
            int[] arIntDocIds = new int[arStrDocIds.length];
            for (int i = 0; i < arStrDocIds.length; ++i) {
                String sDocId = arStrDocIds[i];
                arIntDocIds[i] = Integer.parseInt(sDocId);
            }
            this.topicMgr.saveDocTopicRelation(_nTopicId, _nDocChannelId, arIntDocIds);
        }
        catch (Exception ex) {
            throw new WCMException("Failed to save the relationship for topic[" + _nTopicId + "]", ex);
        }
    }

    @Override
    public DocumentTopic getDocumentTopic(int _nTopicId) {
        return this.topicMgr.getDocumentTopic(_nTopicId);
    }

    @Override
    public String getRelatedDocIds(int _nTopicId, int _nDocChannelId) throws WCMException {
        String result = "";
        try {
            result = this.topicMgr.getRelatedDocIds(_nTopicId, _nDocChannelId);
        }
        catch (CMyException ex) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label2", "\u8bd5\u56fe\u67e5\u627e[TopicId=") + _nTopicId + "], [Doc ChannelId=" + _nDocChannelId + I18NMessage.get(CommentService.class, "CommentService.label3", "]\u5173\u8054\u7684\u6587\u6863\u5931\u8d25\uff01"), ex);
        }
        return result;
    }

    @Override
    public String getRelatedDocIds(int _nTopicId) throws WCMException {
        String result = "";
        try {
            result = this.topicMgr.getRelatedDocIds(_nTopicId);
        }
        catch (CMyException ex) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label2", "\u8bd5\u56fe\u67e5\u627e[TopicId=") + _nTopicId + I18NMessage.get(CommentService.class, "CommentService.label3", "]\u5173\u8054\u7684\u6587\u6863\u5931\u8d25\uff01"), ex);
        }
        return result;
    }

    @Override
    public String getNoneRelatedDocIds(int _nTopicId, int _nDocChannelId) throws WCMException {
        String result = "";
        try {
            result = this.topicMgr.getNoneRelatedDocIds(_nTopicId, _nDocChannelId);
        }
        catch (CMyException ex) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label2", "\u8bd5\u56fe\u67e5\u627e[TopicId=") + _nTopicId + I18NMessage.get(CommentService.class, "CommentService.label3", "]\u5173\u8054\u7684\u6587\u6863\u5931\u8d25\uff01"), ex);
        }
        return result;
    }

    @Override
    public DocumentTopic getDocumentTopic(int _nDocId, int _nChnlId) throws WCMException {
        try {
            return this.topicMgr.getDocumentTopic(_nDocId, _nChnlId);
        }
        catch (CMyException ex) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label4", "\u8bd5\u56fe\u67e5\u627e\u6307\u5b9a[DocumentId=") + _nDocId + "], [ChannelId=" + _nChnlId + I18NMessage.get(CommentService.class, "CommentService.label5", "]\u7684\u76f8\u5173\u4e3b\u9898\u65f6\u5931\u8d25\uff01"), ex);
        }
    }

    @Override
    public Documents getRelatedDocs(int _nTopicId, WCMFilter _oFilter) throws WCMException {
        String sRelatedDocIds = this.getRelatedDocIds(_nTopicId);
        if (CMyString.isEmpty(sRelatedDocIds)) {
            return new Documents(ContextHelper.getLoginUser());
        }
        String sWhere = "DOCID IN(" + sRelatedDocIds + ")";
        if (!CMyString.isEmpty(_oFilter.getWhere())) {
            sWhere = sWhere + " AND " + _oFilter.getWhere();
        }
        _oFilter.setWhere(sWhere);
        Documents result = Documents.openWCMObjs(ContextHelper.getLoginUser(), _oFilter);
        return result;
    }

    @Override
    public void cancelDocTopicRelation(int _nDocumentTopicId, int _nDelDocumentId) throws WCMException {
        this.topicMgr.deleteTopicDocRelation(_nDocumentTopicId, _nDelDocumentId);
    }
}

