/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.Flowable;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class FlowableLCListenerAfterModify
implements IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(FlowableLCListenerAfterModify.class);

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof Flowable)) {
            return;
        }
        CMSObj oCMSObj = (CMSObj)_oObjModified;
        IFlowContent content = null;
        try {
            content = FlowContentFactory.makeFlowContent(oCMSObj);
        }
        catch (Exception e) {
            logger.error((Object)("FlowableLCListenerAfterModify\u65e0\u6cd5\u76d1\u542c\u5f53\u524d\u5bf9\u8c61[" + _oObjModified.getClass().getName() + "]\u7684\u4fee\u6539!"));
            return;
        }
        if (content == null) {
            logger.error((Object)("FlowableLCListenerAfterModify\u65e0\u6cd5\u76d1\u542c\u5f53\u524d\u5bf9\u8c61[" + _oObjModified.getClass().getName() + "]\u7684\u4fee\u6539!"));
            return;
        }
        boolean bIsObjDeleted = content.isDeleted();
        WCMFilter filter = new WCMFilter("", "OBJTYPE=? and OBJID=?", "");
        filter.addSearchValues(oCMSObj.getWCMType());
        filter.addSearchValues(oCMSObj.getId());
        FlowDocs oFlowDocs = FlowDocs.openWCMObjs(null, filter);
        if (oFlowDocs.size() <= 0) {
            return;
        }
        int nSize = oFlowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc oFlowDoc = (FlowDoc)oFlowDocs.getAt(i);
            if (oFlowDoc == null || oFlowDoc.getPropertyAsBoolean("isObjDeleted", false) == bIsObjDeleted) continue;
            oFlowDoc.setObjDeleted(bIsObjDeleted);
            oFlowDoc.save();
        }
    }
}

