/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;

public class FlowDocs
extends CMSBaseObjs {
    public FlowDocs(User _currUser) {
        super(_currUser);
    }

    public FlowDocs(User _currUser, int initialCapacity, int capacityIncrement) {
        super(_currUser, initialCapacity, capacityIncrement);
    }

    @Override
    protected String getDbTableName() {
        return "WCMFLOWDOC";
    }

    @Override
    public String getIdFieldName() {
        return "FLOWDOCID";
    }

    @Override
    public Class getElementClass() {
        return FlowDoc.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new FlowDocs(this.currUser);
    }

    public static final FlowDocs findByIds(User _currUser, String _sIds) {
        FlowDocs currFlowDocs = FlowDocs.createNewInstance(_currUser);
        if (_sIds == null || _sIds.length() <= 0) {
            return currFlowDocs;
        }
        currFlowDocs.addElement(_sIds);
        return currFlowDocs;
    }

    public static final FlowDocs findByIdsOfDealer(User _currUser, String _sIds, User _dealer) throws WCMException {
        if (_dealer == null) {
            throw new WCMException(I18NMessage.get(FlowDocs.class, "FlowDocs.label1", "\u6ca1\u6709\u6307\u5b9a\u5904\u7406\u4eba\uff01"));
        }
        FlowDocs currFlowDocs = FlowDocs.findByIds(_currUser, _sIds);
        for (int i = currFlowDocs.size() - 1; i >= 0; --i) {
            FlowDoc flowDoc = (FlowDoc)currFlowDocs.getAt(i);
            if (flowDoc != null && flowDoc.getToUserId() == _dealer.getId()) continue;
            currFlowDocs.removeAt(i, false);
        }
        return currFlowDocs;
    }

    public static final FlowDocs findByIdsOfPoster(User _currUser, String _sIds, User _poster) throws WCMException {
        if (_poster == null) {
            throw new WCMException(I18NMessage.get(FlowDocs.class, "FlowDocs.label1", "\u6ca1\u6709\u6307\u5b9a\u5904\u7406\u4eba\uff01"));
        }
        FlowDocs currFlowDocs = FlowDocs.findByIds(_currUser, _sIds);
        for (int i = currFlowDocs.size() - 1; i >= 0; --i) {
            FlowDoc flowDoc = (FlowDoc)currFlowDocs.getAt(i);
            if (flowDoc != null && _poster.getName().equalsIgnoreCase(flowDoc.getPostUserName())) continue;
            currFlowDocs.removeAt(i, false);
        }
        return currFlowDocs;
    }

    public static final FlowDocs findOfContent(User _currUser, int _nContentType, int _nContentId, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=?", "");
        filter.addSearchValues(_nContentType);
        filter.addSearchValues(_nContentId);
        filter.mergeWith(_extraFilter);
        return FlowDocs.openWCMObjs(_currUser, filter);
    }

    public static final FlowDocs openWCMObjs(User _currUser, WCMFilter _filter) throws WCMException {
        FlowDocs currFlowDocs = FlowDocs.createNewInstance(_currUser);
        currFlowDocs.open(_filter);
        return currFlowDocs;
    }

    public static FlowDocs createNewInstance(User _currUser) {
        return new FlowDocs(_currUser);
    }
}

