/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class Flow
extends CMSObj {
    private static final long serialVersionUID = 1L;
    public static final int OBJ_TYPE = 401;
    public static final String DB_TABLE_NAME = "WCMFLOW";
    public static final String DB_ID_NAME = "FLOWID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 401;
    }

    public String getName() {
        return (String)this.getProperty("FLOWNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("FLOWNAME", _name);
    }

    public String getStartNodeName() {
        return (String)this.getProperty("SNAME");
    }

    public boolean setStartNodeName(String _sNodeName) throws WCMException {
        return this.setProperty("SNAME", _sNodeName);
    }

    public FlowNode getStartNode() throws WCMException {
        return FlowNode.findByName(this.getId(), this.getStartNodeName());
    }

    public String getEndNodeName() {
        return (String)this.getProperty("ENAME");
    }

    public boolean setEndNodeName(String _sNodeName) throws WCMException {
        return this.setProperty("ENAME", _sNodeName);
    }

    public FlowNode getEndNode() throws WCMException {
        return FlowNode.findByName(this.getId(), this.getEndNodeName());
    }

    public String getDesc() {
        return (String)this.getProperty("FLOWDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("FLOWDESC", _desc);
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public BaseObj getOwner() throws WCMException {
        int nOwnerType = this.getOwnerType();
        if (nOwnerType == 1 || nOwnerType == 0) {
            return new WCMSystemObject(this.getOwnerId());
        }
        return BaseObj.findById(this.getOwnerType(), this.getOwnerId());
    }

    public boolean setOwner(int _nOwnerType, int _nOwnerId) throws WCMException {
        return this.setOwnerType(_nOwnerType) && this.setOwnerId(_nOwnerId);
    }

    public boolean setOwnerType(int _nOwnerType) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Flow.class, "Flow.label1", "\u5de5\u4f5c\u6d41\u6240\u5728\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4fee\u6539\uff01"));
        }
        return this.setProperty("OWNERTYPE", _nOwnerType);
    }

    public int getOwnerType() {
        return this.getPropertyAsInt("OWNERTYPE", 0);
    }

    public boolean setOwnerId(int _nOwnerId) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Flow.class, "Flow.label1", "\u5de5\u4f5c\u6d41\u6240\u5728\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4fee\u6539\uff01"));
        }
        return this.setProperty("OWNERID", _nOwnerId);
    }

    public int getOwnerId() {
        return this.getPropertyAsInt("OWNERID", 0);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _sAttribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _sAttribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getProperty("FLOWNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(Flow.class, "Flow.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Flow.isValid)"));
            }
            if (this.getProperty("SNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Flow.class, "Flow.label3", "\u5c5e\u6027StartNodeName\u6ca1\u6709\u8bbe\u7f6e\uff08Flow.isValid\uff09"));
            }
            if (this.getProperty("ENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Flow.class, "Flow.label4", "\u5c5e\u6027EndNodeName\u6ca1\u6709\u8bbe\u7f6e\uff08Flow.isValid\uff09"));
            }
            if (this.getProperty("OWNERTYPE") == null) {
                this.setOwnerType(0);
            }
            if (this.getProperty("OWNERID") == null) {
                this.setOwnerId(0);
            }
        } else {
            sName = (String)this.getNewProperty("FLOWNAME");
        }
        if (sName != null) {
            String strCondition = "(FLOWNAME='" + CMyString.filterForSQL(sName) + "' AND OwnerType=" + this.getOwnerType() + " AND OwnerId=" + this.getOwnerId() + ")";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and (" + this.getIdFieldName() + "<>" + this.getId() + ") ";
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(Flow.class, "Flow.label5", "\u540d\u79f0[") + sName + I18NMessage.get(Flow.class, "Flow.label6", "]\u5df2\u7ecf\u5b58\u5728(Flow.isValid)"));
            }
        }
        return true;
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        try {
            String[] strSQLs = new String[]{"delete  from wcmFlowMonOper where FlowId=" + this.getId()};
            this.getDBManager().sqlExecuteUpdate(strSQLs);
        }
        catch (Exception ex) {
            throw new WCMException(40, I18NMessage.get(Flow.class, "Flow.label7", "\u5220\u9664\u76d1\u63a7\u7528\u6237\u548c\u7528\u6237\u7ec4\u5931\u8d25\uff08Flow.delete\uff09"), ex);
        }
        try {
            FlowNodes flowNodes = this.getFlowNodes(_currUser);
            flowNodes.removeAll();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Flow.class, "Flow.label8", "\u5220\u9664\u5de5\u4f5c\u6d41\u8282\u70b9\u5931\u8d25\uff08Flow.delete\uff09"), ex);
        }
        String[] strSQL = new String[]{"delete from wcmChnlFlow where FlowId = " + this.getId()};
        this.getDBManager().sqlExecuteUpdate(strSQL);
        return super.delete(_currUser);
    }

    public FlowNodes getFlowNodes(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "FlowId=" + this.getId(), "");
        return FlowNodes.openWCMObjs(_currUser, filter);
    }

    public Users getMonitorUsers(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("wcmFlowMonOper", "OperType=204 and  FlowId=" + this.getId(), "", "OPERID as USERID");
        return Users.openWCMObjs(_currUser, filter);
    }

    public Groups getMonitorGroups(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("wcmFlowMonOper", "OperType=201 and  FlowId=" + this.getId(), "", "OPERID as GROUPID");
        return Groups.openWCMObjs(_currUser, filter);
    }

    public static final Flow findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Flow)BaseObj.findById(Flow.class, _nId);
    }

    public static final Flow createNewInstance() throws WCMException {
        return (Flow)BaseObj.createNewInstance(Flow.class);
    }

    public static final Flow findByKey(Object _oKey) throws WCMException {
        return (Flow)BaseObj.findByKey(Flow.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Flow.class, "Flow.label10", "[\u5de5\u4f5c\u6d41-") + this.getId() + "]";
    }
}

