/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.service.IUserService;
import org.apache.log4j.Logger;

public class UserManagerHelper {
    private static Logger logger = Logger.getLogger(UserManagerHelper.class);

    public static final void validLoginUserIsAdminOfOperator(User loginUser, int _nOperType, int _nOperId) throws WCMException {
        CMSObj operator = null;
        switch (_nOperType) {
            case 204: {
                operator = User.findById(_nOperId);
                break;
            }
            case 201: {
                operator = Group.findById(_nOperId);
                break;
            }
            case 203: {
                operator = Role.findById(_nOperId);
            }
        }
        if (operator == null) {
            throw new WCMException("\u65e0\u6548\u53c2\u6570[Type:" + _nOperType + "][Id:" + _nOperId + "]!");
        }
        UserManagerHelper.validLoginUserIsAdminOfOperator(loginUser, operator);
    }

    public static final void validLoginUserIsAdminOfOperator(User _oLoginUser, CMSObj _oOperator) throws WCMException {
        if (_oOperator == null) {
            throw new WCMException("\u65e0\u6548\u53c2\u6570!");
        }
        IUserService userService = (IUserService)DreamFactory.createObjectById("IUserService");
        if (_oLoginUser.isSecurityAdmin()) {
            return;
        }
        if (userService.isManagerOfRole(_oLoginUser)) {
            return;
        }
        switch (_oOperator.getWCMType()) {
            case 204: {
                User user = (User)_oOperator;
                if (user.getId() == _oLoginUser.getId()) {
                    return;
                }
                Groups groups = user.getGroups();
                int nSize = groups.size();
                for (int i = 0; i < nSize; ++i) {
                    Group group = (Group)groups.getAt(i);
                    if (group == null || !UserManagerHelper.isAdminOfGroup(_oLoginUser, group)) continue;
                    return;
                }
                break;
            }
            case 201: {
                if (!UserManagerHelper.isAdminOfGroup(_oLoginUser, (Group)_oOperator)) break;
                return;
            }
            case 203: {
                if (!_oLoginUser.getName().equals(_oOperator.getCrUserName())) break;
                return;
            }
        }
        logger.error((Object)("\u7528\u6237[" + _oLoginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406" + _oOperator + "\uff01"), (Throwable)new Exception("who call me!"));
        throw new WCMException("\u7528\u6237[" + _oLoginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406\uff01");
    }

    public static final boolean isAdminOfGroup(User loginUser, Group group) throws WCMException {
        if (group == null) {
            return false;
        }
        if (group.isAdministrator(loginUser)) {
            return true;
        }
        return UserManagerHelper.isAdminOfGroup(loginUser, group.getParent());
    }
}

