/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class RightMgr
implements IRightMgr {
    @Override
    public Right getRight(int _objType, int _objId, int _oprType, int _oprId) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=? and OprType=? and OprId=?", "");
        filter.addSearchValues(_objType);
        filter.addSearchValues(_objId);
        filter.addSearchValues(_oprType);
        filter.addSearchValues(_oprId);
        filter.setMaxRowNumber(1);
        Rights rights = Rights.openWCMObjs(null, filter);
        if (rights.isEmpty()) {
            return null;
        }
        return (Right)rights.getAt(0);
    }

    @Override
    public Right getRight(CMSObj _currObj, CMSObj _currOperator) throws WCMException {
        return this.getRight(_currObj.getWCMType(), _currObj.getId(), _currOperator.getWCMType(), _currOperator.getId());
    }

    @Override
    public Right saveRight(Right _saveRight) throws WCMException {
        _saveRight.save(ContextHelper.getLoginUser());
        return null;
    }

    @Override
    public Right deleteRight(Right _delRight) throws WCMException {
        _delRight.delete(ContextHelper.getLoginUser());
        return _delRight;
    }

    @Override
    public Rights getRights(CMSObj _currObj, int _operatorType) throws WCMException {
        WCMFilter filter = null;
        Rights rights = null;
        try {
            filter = new WCMFilter("", "ObjType=" + _currObj.getWCMType() + " and ObjId=" + _currObj.getId() + " and OprType=" + _operatorType, "RIGHTID asc ");
            rights = new Rights(ContextHelper.getLoginUser());
            rights.open(filter);
            return rights;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightMgr.class, "RightMgr.label1", "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRights)", ex);
        }
    }

    @Override
    public Rights getRights(CMSObj _currObj) throws WCMException {
        WCMFilter filter = null;
        Rights rights = null;
        try {
            filter = new WCMFilter("", "ObjType=" + _currObj.getWCMType() + " and ObjId=" + _currObj.getId(), "RIGHTID asc ");
            rights = new Rights(ContextHelper.getLoginUser());
            rights.open(filter);
            return rights;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightMgr.class, "RightMgr.label1", "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRights)", ex);
        }
    }

    @Override
    public Rights getRights(CMSObj _currObj, String _groupIds, String _roleIds) throws WCMException {
        WCMFilter filter = null;
        Rights rights = null;
        try {
            int objId;
            int objType;
            rights = new Rights(ContextHelper.getLoginUser());
            if (CMyString.isEmpty(_groupIds) && CMyString.isEmpty(_roleIds)) {
                return rights;
            }
            if (_currObj == null) {
                objType = 1;
                objId = 1;
            } else {
                objType = _currObj.getWCMType();
                objId = _currObj.getId();
            }
            StringBuffer sbWhere = new StringBuffer(256);
            sbWhere.append("ObjType=").append(objType);
            sbWhere.append(" AND ObjId=").append(objId).append(" AND (");
            if (!CMyString.isEmpty(_groupIds)) {
                sbWhere.append("OprType=201 AND OprId IN(");
                sbWhere.append(_groupIds).append(')');
                if (!CMyString.isEmpty(_roleIds)) {
                    sbWhere.append(" OR ");
                    sbWhere.append("OprType=203 AND OprId IN(");
                    sbWhere.append(_roleIds).append(')');
                }
            } else {
                sbWhere.append("OprType=203 AND OprId IN(");
                sbWhere.append(_roleIds).append(')');
            }
            sbWhere.append(')');
            filter = new WCMFilter("", sbWhere.toString(), "RIGHTID desc ");
            rights.open(filter);
            return rights;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightMgr.class, "RightMgr.label1", "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRights)", ex);
        }
    }

    @Override
    public Rights getRights(int objType, int objId) throws WCMException {
        WCMFilter filter = null;
        Rights rights = null;
        try {
            filter = new WCMFilter("", "ObjType=" + objType + " and ObjId=" + objId, "RIGHTID asc ");
            rights = new Rights(ContextHelper.getLoginUser());
            rights.open(filter);
            return rights;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightMgr.class, "RightMgr.label1", "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRights)", ex);
        }
    }

    @Override
    public RightValue getRightValue(CMSObj _currObj, CMSObj _currOperator) throws WCMException {
        User user;
        if (_currOperator.getWCMType() == 204 && (user = (User)_currOperator).isSystem()) {
            return new RightValue(0L);
        }
        RightValue rightValue = new RightValue();
        try {
            rightValue.load(_currOperator.getWCMType(), _currOperator.getId(), _currObj.getWCMType(), _currObj.getId());
            return rightValue;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightMgr.class, "RightMgr.label2", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRightValue)", ex);
        }
    }
}

