/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.GroupUsers;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;

public class GrpUserIdsMan
extends BaseIdsMan {
    private GroupUsers m_oGroupUsers = null;
    private GroupMgr m_oMgr = null;
    private Group m_oGroup = null;

    public GrpUserIdsMan(int _nGroupId) throws WCMException {
        this.m_oGroup = Group.findById(_nGroupId);
        this.m_oMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        this.m_oGroupUsers = this.m_oMgr.getGroupUsers(this.m_oGroup, null);
    }

    @Override
    protected int getExistsSize() {
        return this.m_oGroupUsers.size();
    }

    @Override
    protected int getExistsIdAt(int _nExistsIndex) {
        return ((GroupUser)this.m_oGroupUsers.getAt(_nExistsIndex)).getUserId();
    }

    @Override
    protected void deleteExists(int _nExistsIndex) throws WCMException {
        GroupUser groupUser = (GroupUser)this.m_oGroupUsers.getAt(_nExistsIndex);
        User userToDel = User.findById(groupUser.getUserId());
        String sLogDesc = CMyString.format("\u5220\u9664{0}\u7684\u7528\u6237{1}", new String[]{this.m_oGroup.toString(), userToDel.toString()});
        User loginUser = ContextHelper.getLoginUser();
        long lStartTime = LogServer.startRecord(loginUser.getName(), "GROUPUSER_DEL", sLogDesc, this.m_oGroup);
        try {
            this.m_oGroupUsers.removeAt(_nExistsIndex);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, "\u4ece\u7ec4\u7ec7\u4e2d\u5220\u9664\u7528\u6237\u5931\u8d25!", t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
    }

    @Override
    protected void addRelation(int _nNewId) throws WCMException {
        User userToAdd = User.findById(_nNewId);
        String sLogDesc = CMyString.format("\u5411{0}\u6dfb\u52a0{1}", new String[]{this.m_oGroup.toString(), userToAdd.toString()});
        User loginUser = ContextHelper.getLoginUser();
        long lStartTime = LogServer.startRecord(loginUser.getName(), "GROUPUSER_ADD", sLogDesc, this.m_oGroup);
        try {
            this.m_oMgr.addUser(userToAdd, this.m_oGroup);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, "\u5f80\u7ec4\u7ec7\u6dfb\u52a0\u7528\u6237\u5931\u8d25!", t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
    }
}

