/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.support.log.LogServer;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class PublishTaskLogger
extends AbstractLogger {
    private static final Logger LOG = Logger.getLogger(PublishTaskLogger.class);

    @Override
    public int startLog(MethodConfig conf, MethodContext context) {
        String sUserName = ContextHelper.getLoginUser().getName();
        String sLogType = this.getLogType(conf, context);
        if (sLogType == null) {
            sLogType = "UNKNOWN_OPERTYPE";
        }
        CMSObj logobj = null;
        try {
            IPublishElements publishElements = PublishElementFactory.lookupElements(context.getValue("ObjectType", 0), context.getObjectIds());
            if (publishElements == null || publishElements.isEmpty()) {
                return 0;
            }
            StringBuffer desc = new StringBuffer(256);
            desc.append(sLogType).append(", \u88ab\u53d1\u5e03\u7684\u5bf9\u8c61\u662f: ");
            int size = publishElements.size();
            for (int i = 0; i < size; ++i) {
                IPublishElement ele = publishElements.get(i);
                if (ele == null || ele.getSubstance() == null) continue;
                if (logobj == null) {
                    logobj = ele.getSubstance();
                }
                desc.append(ele.getSubstance());
                desc.append(", ");
            }
            if (logobj == null) {
                LOG.warn((Object)"No need to log a pubish operate: no object found.");
                return 0;
            }
            return (int)LogServer.startRecord(sUserName, sLogType, desc.substring(0, desc.length() - 2), logobj);
        }
        catch (WCMException ex) {
            LOG.error((Object)"Failed to log a publish operate.", (Throwable)ex);
            return 0;
        }
    }

    protected String getLogType(MethodConfig conf, MethodContext context) {
        int nPublishType = context.getValue("PublishType", 0);
        int nObjType = context.getValue("ObjectType", -1);
        String sLogType = WCMTypes.getObjName(nObjType, true) + "\u7684" + PublishConstants.getPublishTypeName(nPublishType, "\u672a\u77e5\u53d1\u5e03\u7c7b\u578b");
        try {
            if (!LogServer.existsLogType(sLogType)) {
                this.createLogTypeIfNeed(sLogType, sLogType);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"get logtype fail", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)"get logtype fail", throwable);
        }
        return sLogType;
    }

    @Override
    public String getClassDesc() {
        return "\u680f\u76ee/\u7ad9\u70b9\u53d1\u5e03";
    }
}

