/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentPublishHelper;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.ajaxservice.enums.PulishTypeEnum;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMContentPublishConfig;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.components.wcm.publish.domain.job.WithDrawJobWorker;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import com.trs.wcm.publish.PreviewURLSign;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PublishServiceProvider
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(PublishServiceProvider.class);
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private static int m_nUnpubWorkerId = 0;
    public static final String KEY_PRIVATE_PREVIEW_ACCESS = ConfigConstants.DIR_APPROOT + "private_platform_log.key";

    public Object getPublishConfig(MethodContext _methodContext) throws Throwable {
        Object config;
        if (_methodContext.getObjectId() == 0) {
            return "";
        }
        User loginUser = this.getLoginUser();
        IPublishElement publishElement = this.findPublishElement(_methodContext);
        if (publishElement.isFolder() && ((IPublishFolder)publishElement).isRoot()) {
            WebSite site = (WebSite)publishElement.getSubstance();
            if (!WebSiteHelper.isVisible(loginUser, site)) {
                throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\uff1a") + site + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label2", "\u7684\u53d1\u5e03\u5c5e\u6027\uff01"));
            }
        } else if (!AuthServer.hasRight(loginUser, publishElement.getSubstance(), 64)) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\uff1a") + publishElement.getInfo() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label2", "\u7684\u53d1\u5e03\u5c5e\u6027\uff01"));
        }
        if (publishElement.isFolder()) {
            config = new WCMFolderPublishConfig((IPublishFolder)publishElement);
            return config;
        }
        config = new WCMContentPublishConfig(loginUser, (IPublishContent)publishElement);
        return config;
    }

    public boolean savePublishConfig(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishElement publishElement = this.findPublishElement(_methodContext);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (!publishElement.isFolder() && nFlowDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, publishElement.getSubstance(), nFlowDocId, 0, I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label3", "\u53d1\u5e03"));
        } else if (!publishElement.isCanDoSave(loginUser)) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\uff1a") + publishElement.getInfo() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label2", "\u7684\u53d1\u5e03\u5c5e\u6027\uff01"));
        }
        if (publishElement.isFolder()) {
            WCMFolderPublishConfig config = new WCMFolderPublishConfig((IPublishFolder)publishElement);
            String[] pLogicFields = new String[]{"ObjectId"};
            config = (WCMFolderPublishConfig)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, config, pLogicFields);
            if (!"true".equals(_methodContext.getValue("isAdd")) || !"0".equals(_methodContext.getValue("OutlineTemplates")) || _methodContext.getValue("DetailTemplate", 0) != 0) {
                if (_methodContext.containsParameter("OutlineTemplates")) {
                    config.setOutlineTemplateId(_methodContext.getValue("OutlineTemplates"));
                }
                if (_methodContext.containsParameter("DetailTemplate")) {
                    config.setDetailTemplateId(_methodContext.getValue("DetailTemplate", 0));
                }
            }
            if (_methodContext.containsParameter("InfoviewPrintTemplate")) {
                config.setInfoviewPrintTemplateId(_methodContext.getValue("InfoviewPrintTemplate", 0));
            }
            if (_methodContext.containsParameter("STATUSESCANDOPUB") || _methodContext.containsParameter("StatusIdAfterModify")) {
                config.setDefineStatus(!CMyString.isEmpty(_methodContext.getValue("STATUSESCANDOPUB")) || _methodContext.containsParameter("StatusIdAfterModify"));
            }
            if (_methodContext.containsParameter("ScheduleMode")) {
                config.setDefineSchedule(_methodContext.getValue("ScheduleMode", 0) != 0);
            }
            config.canEdit(loginUser);
            config.save(loginUser);
            return true;
        }
        WCMContentPublishConfig config = new WCMContentPublishConfig(loginUser, (IPublishContent)publishElement);
        if (_methodContext.containsParameter("DetailTemplate")) {
            config.setDetialTemplate(_methodContext.getValue("DetailTemplate", 0));
        }
        if (_methodContext.containsParameter("ScheduleTime")) {
            config.setSchedulePublish(_methodContext.getValue("ScheduleTime", new CMyDateTime()));
        }
        return true;
    }

    public Reports publish(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPublishType = _methodContext.getValue("PublishType", 8);
        String sObjectIds = _methodContext.getObjectIds();
        IPublishElements publishElements = PublishElementFactory.lookupElements(_methodContext.getValue("ObjectType", 0), sObjectIds);
        String sTitle = I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label3", "\u53d1\u5e03");
        Reports reports = new Reports(sTitle);
        ArrayList<IPublishContent> toPublishContents = new ArrayList<IPublishContent>();
        int nSize = publishElements.size();
        for (int i = 0; i < nSize; ++i) {
            IPublishElement publishElement = publishElements.get(i);
            if (publishElement == null) continue;
            try {
                this.checkPublishElementRight(loginUser, publishElement, nPublishType, _methodContext);
                if (publishElement.isFolder()) {
                    Reports nreports = this.publishFolder(loginUser, publishElement, nPublishType, _methodContext);
                    reports.merge(nreports);
                    continue;
                }
                toPublishContents.add((IPublishContent)publishElement);
                continue;
            }
            catch (Exception ex) {
                String errorMsg = this.getI18nPublishResult(publishElement.getInfo(), false);
                logger.error((Object)errorMsg, (Throwable)ex);
                reports.addFailedReport(errorMsg + this.extractErrorMsg(ex), null);
            }
        }
        if (!toPublishContents.isEmpty()) {
            reports = this.publishContents(toPublishContents, nPublishType, reports);
        }
        return reports;
    }

    private Reports publishContents(List<IPublishContent> _toPublishContents, int _nPublishType, Reports _reports) throws Exception {
        if (_toPublishContents == null) {
            return _reports;
        }
        Map<IPublishFolder, List<IPublishContent>> contentsMap = this.groupByFolder(_toPublishContents);
        for (Map.Entry<IPublishFolder, List<IPublishContent>> entry : contentsMap.entrySet()) {
            String titles = this.getPublishContentsTitle(entry.getValue());
            try {
                this.publishContents(entry.getKey(), entry.getValue(), _nPublishType);
                _reports.addSucessedReport(this.getI18nPublishResult(titles, true));
            }
            catch (Exception ex) {
                String errorMsg = this.getI18nPublishResult(titles, false);
                logger.error((Object)errorMsg, (Throwable)ex);
                _reports.addFailedReport(errorMsg + this.extractErrorMsg(ex), null);
            }
        }
        return _reports;
    }

    private String getPublishContentsTitle(List<IPublishContent> _contents) {
        if (_contents == null || _contents.isEmpty()) {
            return "";
        }
        String titles = "";
        int len = _contents.size();
        for (int i = 0; i < len - 1; ++i) {
            titles = titles + _contents.get(i).getInfo() + ", ";
        }
        titles = titles + _contents.get(_contents.size() - 1).getInfo();
        return titles;
    }

    private void publishContents(IPublishFolder _folder, List<IPublishContent> _contents, int _nPublishType) throws Exception {
        if (_folder == null || _contents == null || _contents.isEmpty()) {
            return;
        }
        PublishElementsListImpl list = new PublishElementsListImpl();
        int len = _contents.size();
        for (int i = 0; i < len; ++i) {
            list.add(_contents.get(i));
        }
        if (_nPublishType == 7) {
            this.m_oPublishServer.deleteContents(list, _folder);
        } else {
            this.m_oPublishServer.publishContents(list, _folder, _nPublishType);
        }
    }

    private Map<IPublishFolder, List<IPublishContent>> groupByFolder(List<IPublishContent> publishContents) {
        HashMap<IPublishFolder, List<IPublishContent>> result = new HashMap<IPublishFolder, List<IPublishContent>>();
        if (publishContents == null) {
            return result;
        }
        int len = publishContents.size();
        for (int i = 0; i < len; ++i) {
            ArrayList<IPublishContent> folderContents = (ArrayList<IPublishContent>)result.get(publishContents.get(i).getFolder());
            if (null == folderContents) {
                folderContents = new ArrayList<IPublishContent>();
                result.put(publishContents.get(i).getFolder(), folderContents);
            }
            folderContents.add(publishContents.get(i));
        }
        return result;
    }

    private String extractErrorMsg(Exception ex) {
        if (ex == null) {
            return "";
        }
        String sDetailMsg = ex.getMessage();
        int nPos = sDetailMsg.lastIndexOf("[ERR-");
        if (nPos >= 0 && (nPos = sDetailMsg.indexOf(93, nPos + 1)) > 0) {
            sDetailMsg = sDetailMsg.substring(nPos + 1);
        }
        return sDetailMsg;
    }

    private String getI18nPublishResult(String elementsInfo, boolean isSuccess) {
        if (isSuccess) {
            return CMyString.format(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label12", "\u53d1\u5e03{0}\u6210\u529f\uff01"), new String[]{elementsInfo});
        }
        return CMyString.format(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label11", "\u53d1\u5e03{0}\u5931\u8d25\uff01"), new String[]{elementsInfo});
    }

    private void checkPublishElementRight(User _loginUser, IPublishElement _publishElement, int _nPublishType, MethodContext _methodContext) throws WCMException, Exception {
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (!_publishElement.isFolder() && nFlowDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(_loginUser, _publishElement.getSubstance(), nFlowDocId, 2, I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label3", "\u53d1\u5e03"));
        } else {
            int nRightIndex = this.getPubRightIndexByType(_publishElement.getType(), _nPublishType);
            if (_publishElement.getType() == 605 ? !DocumentAuthServer.hasRight(_loginUser, null, (Document)_publishElement.getSubstance(), nRightIndex) : !AuthServer.hasRight(_loginUser, _publishElement.getSubstance(), nRightIndex)) {
                throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label5", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label7", "]\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\u64cd\u4f5c\uff01"));
            }
        }
    }

    private Reports publishFolder(User _loginUser, IPublishElement _publishElement, int _nPublishType, MethodContext _methodContext) throws WCMException, Exception {
        Reports reports = new Reports("");
        if (_loginUser == null || _publishElement == null || _methodContext == null || !_publishElement.isFolder()) {
            return reports;
        }
        if (_nPublishType == 13) {
            String sStartTime = _methodContext.getValue("StartDocCrtime");
            String sEndTime = _methodContext.getValue("EndDocCrtime");
            if (CMyString.isEmpty(sStartTime) || CMyString.isEmpty(sEndTime)) {
                throw new WCMException("\u53d1\u5e03\u5df2\u53d1\u7684\u6587\u6863\u53ca\u5176\u6982\u89c8 \u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u6587\u6863\u7684\u521b\u5efa\u65f6\u95f4\u8303\u56f4\uff01");
            }
            CMyDateTime startTime = new CMyDateTime();
            startTime.setDateTimeWithString(sStartTime);
            CMyDateTime endTime = new CMyDateTime();
            endTime.setDateTimeWithString(sEndTime);
            this.m_oPublishServer.publishFolderAndPublishedDocs((IPublishFolder)_publishElement, _nPublishType, startTime, endTime);
            reports.addSucessedReport(this.getI18nPublishResult(_publishElement.getInfo(), true));
        } else if (_nPublishType == 14) {
            IPublishFolder folder = (IPublishFolder)_publishElement;
            String docStatuses = _methodContext.getValue("DOCSTATUSES");
            boolean containsChildren = _methodContext.getValue("CONTAINSCHILDREN", true);
            reports = this.selectivePublish(folder, reports, docStatuses, containsChildren);
        } else {
            IPublishFolder iPublishFolder = (IPublishFolder)_publishElement;
            this.m_oPublishServer.publishFolder(iPublishFolder, _nPublishType);
            reports.addSucessedReport(this.getI18nPublishResult(_publishElement.getInfo(), true));
            if (iPublishFolder.isRoot()) {
                SimpleLogServer.operation(LogConstant.Module.EDITORCENTER.desc, LogUserUtil.getLogUser(), PulishTypeEnum.getDesc(_nPublishType), "\u5c06\u7ad9\u70b9[" + iPublishFolder.getInfo() + "][\u7ad9\u70b9ID=" + iPublishFolder.getSubstance().getId() + "]\u53d1\u5e03", iPublishFolder.getInfo());
            } else {
                SimpleLogServer.operation(LogConstant.Module.EDITORCENTER.desc, LogUserUtil.getLogUser(), PulishTypeEnum.getDesc(_nPublishType), "\u5c06\u680f\u76ee[" + iPublishFolder.getInfo() + "][\u680f\u76eeID=" + iPublishFolder.getSubstance().getId() + "]\u53d1\u5e03", iPublishFolder.getInfo());
            }
        }
        if (_nPublishType == 7) {
            String sRecallChildrenChannel = ConfigServer.getServer().getSysConfigValue("RECALL_CHILDREN_CHANNEL", "false");
            boolean bRecallChildrenChannel = sRecallChildrenChannel.equalsIgnoreCase("true");
            this.publishRecallFolder((IPublishFolder)_publishElement, bRecallChildrenChannel);
            reports.addSucessedReport(this.getI18nPublishResult(_publishElement.getInfo(), true));
        }
        return reports;
    }

    private Reports selectivePublish(IPublishFolder folder, Reports reports, String docStatuses, boolean containsChildren) throws WCMException {
        if (!folder.isRoot()) {
            IPublishElements contents = this.getAllContents(folder, docStatuses);
            try {
                if (contents != null) {
                    this.m_oPublishServer.publishContents(contents, folder, 3);
                    reports.addSucessedReport(this.getI18nPublishResult(folder.getInfo(), true));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                reports.addFailedReport(this.getI18nPublishResult(folder.getInfo(), false) + e.getMessage(), null);
            }
        }
        if (containsChildren) {
            IPublishElements elements = folder.getChildren();
            for (int i = 0; i < elements.size(); ++i) {
                IPublishFolder nfolder = (IPublishFolder)elements.get(i);
                if (nfolder == null) continue;
                this.selectivePublish(nfolder, reports, docStatuses, true);
            }
        }
        return reports;
    }

    private IPublishElements getAllContents(IPublishFolder folder, String docStatuses) throws WCMException {
        if (!(folder.getSubstance() instanceof Channel)) {
            return null;
        }
        Channel channel = (Channel)folder.getSubstance();
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "WCMCHNLDOC.DOCSTATUS in(?";
        filter.addSearchValues(docStatuses);
        sWhere = sWhere + ")";
        filter.setWhere(sWhere);
        Documents docs = DocumentsGetHelper.getDocuments(channel, filter);
        if (docs == null || docs.isEmpty()) {
            return null;
        }
        return new PublishElementsCMSObjsImpl(docs);
    }

    public String preview(MethodContext _methodContext) throws Throwable {
        _methodContext.setReturnJSON(true);
        HashMap previewResult = this.getPreviewResult(_methodContext);
        return JSONHelper.toSimpleJSON(previewResult, 0);
    }

    protected HashMap getPreviewResult(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sObjectIds = _methodContext.getObjectIds();
        IPublishElements publishElements = PublishElementFactory.lookupElements(_methodContext.getValue("ObjectType", 0), sObjectIds);
        Template template = Template.findById(_methodContext.getValue("TemplateId", 0));
        IPublishFolder folder = null;
        if (_methodContext.getValue("FolderId", 0) > 0) {
            folder = this.findFolder(_methodContext);
        }
        String[] pWarning = new String[1];
        HashMap<String, Object> hResult = new HashMap<String, Object>(2);
        int nURLCount = 0;
        Object[] pResult = new Object[publishElements.size()];
        HashMap<String, Object> hTemp = null;
        int nSize = publishElements.size();
        for (int i = 0; i < nSize; ++i) {
            hTemp = new HashMap<String, Object>(2);
            IPublishElement publishElement = publishElements.get(i);
            if (publishElement == null) {
                hTemp.put("Exception", I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label4", "\u5bf9\u8c61\u6ca1\u6709\u627e\u5230!"));
                hTemp.put("URLs", new String[0]);
            } else {
                hTemp.put("Name", publishElement.getInfo());
                int nRightIndex = this.getPreviewRightIndexByType(publishElement.getType());
                boolean isCannotPreview = false;
                if (publishElement.getType() == 605) {
                    if (!DocumentAuthServer.hasRight(loginUser, null, (Document)publishElement.getSubstance(), nRightIndex)) {
                        isCannotPreview = true;
                    }
                } else if (!AuthServer.hasRight(loginUser, publishElement.getSubstance(), nRightIndex)) {
                    isCannotPreview = true;
                }
                if (isCannotPreview) {
                    hTemp.put("Exception", I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label5", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label6", "]\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u9884\u89c8\u64cd\u4f5c\uff01"));
                    hTemp.put("URLs", new String[0]);
                } else {
                    String[] pURL;
                    try {
                        if (publishElement.isFolder()) {
                            pURL = this.m_oPublishServer.previewFolder((IPublishFolder)publishElement, pWarning, template);
                        } else {
                            IPublishContent content = (IPublishContent)publishElement;
                            if (folder != null) {
                                content.setFolder(folder);
                            }
                            pURL = new String[]{this.m_oPublishServer.previewContent((IPublishContent)publishElement, pWarning, template)};
                        }
                        PreviewURLSign.getUniqueSignedStrs(pURL, KEY_PRIVATE_PREVIEW_ACCESS);
                        if (pWarning[0] != null) {
                            hTemp.put("Warning", pWarning[0]);
                        }
                    }
                    catch (Exception e) {
                        pURL = new String[]{};
                        int nPos = e.getMessage().indexOf(10);
                        String sMessage = e.getMessage();
                        if (nPos > 0) {
                            sMessage = sMessage.substring(0, nPos);
                        }
                        hTemp.put("Exception", sMessage);
                        hTemp.put("ExceptionDetail", CMyException.getStackTraceText(e));
                    }
                    nURLCount += pURL.length;
                    hTemp.put("URLs", pURL);
                }
            }
            pResult[i] = hTemp;
        }
        hResult.put("URLCount", String.valueOf(nURLCount));
        hResult.put("Data", pResult);
        return hResult;
    }

    public void publishContents(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPublishType = _methodContext.getValue("PublishType", 8);
        IPublishFolder folder = this.findFolder(_methodContext);
        String sObjectIds = _methodContext.getObjectIds();
        int nObjectType = _methodContext.getValue("ObjectType", 0);
        IPublishElements contents = PublishElementFactory.lookupElements(nObjectType, sObjectIds);
        if (!AuthServer.hasRight(loginUser, folder.getSubstance(), 39)) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label5", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label7", "]\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\u64cd\u4f5c\uff01"));
        }
        if (nObjectType == 605 && nPublishType == 7) {
            DocumentPublishHelper.delete(sObjectIds, folder.getId());
        } else {
            this.m_oPublishServer.publishContents(contents, folder, nPublishType);
        }
    }

    private void publishRecallFolder(IPublishFolder _publishFolder, boolean _bRecallChildrenChannel) throws WCMException, Exception {
        BaseChannel baseChannel;
        if (_publishFolder == null) {
            return;
        }
        this.m_oPublishServer.deleteFolder(_publishFolder);
        if (!_bRecallChildrenChannel) {
            return;
        }
        ChannelMgr chnlMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        Channels channels = (Channels)chnlMgr.getChildren(baseChannel = (BaseChannel)BaseChannel.findById(_publishFolder.getType(), _publishFolder.getId()), -1, true, null);
        if (channels.size() == 0) {
            return;
        }
        IPublishElements publishElements = PublishElementFactory.lookupElements(101, channels.getIdListAsString());
        int nSize = publishElements.size();
        for (int i = 0; i < nSize; ++i) {
            IPublishElement publishElement = publishElements.get(i);
            if (publishElement == null) continue;
            this.publishRecallFolder((IPublishFolder)publishElement, _bRecallChildrenChannel);
        }
    }

    private int getPubRightIndexByType(int _nElementType, int _nPublishType) {
        switch (_nElementType) {
            case 605: {
                return 39;
            }
            case 101: {
                if (_nPublishType == 2 || _nPublishType == 7) {
                    return 16;
                }
                return 17;
            }
            case 103: {
                if (_nPublishType == 2 || _nPublishType == 7) {
                    return 4;
                }
                return 5;
            }
        }
        return 64;
    }

    private int getPreviewRightIndexByType(int _nElementType) {
        switch (_nElementType) {
            case 605: {
                return 38;
            }
            case 101: {
                return 15;
            }
            case 103: {
                return 3;
            }
        }
        return 64;
    }

    private IPublishElement findPublishElement(MethodContext _methodContext) throws WCMException {
        int nObjectId;
        int nObjectType = _methodContext.getValue("ObjectType", 0);
        IPublishElement publishElement = PublishElementFactory.lookupElement(nObjectType, nObjectId = _methodContext.getObjectId());
        if (publishElement == null) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label8", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + nObjectType + ", Id=" + nObjectId + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label9", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return publishElement;
    }

    private IPublishFolder findFolder(MethodContext _methodContext) throws WCMException {
        int nObjectId;
        int nObjectType = _methodContext.getValue("FolderType", 0);
        IPublishFolder publishElement = (IPublishFolder)PublishElementFactory.lookupElement(nObjectType, nObjectId = _methodContext.getValue("FolderId", 0));
        if (publishElement == null) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label10", "\u6307\u5b9a\u7684\u680f\u76ee[Type=") + nObjectType + ", Id=" + nObjectId + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label9", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return publishElement;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    public Object getUnpubSchedule(MethodContext context) throws WCMException {
        int nSenderId = context.getValue("SenderId", 0);
        int nSenderType = context.getValue("SenderType", 605);
        User user = ContextHelper.getLoginUser();
        Schedules schedules = new Schedules(user);
        WCMFilter filter = new WCMFilter("", "SENDERID=? and SENDERTYPE=? and OPTYPE=?", "");
        filter.setSelect("SCHID,ETIME");
        filter.addSearchValues(nSenderId);
        filter.addSearchValues(nSenderType);
        if (m_nUnpubWorkerId == 0) {
            JobWorkerType worker = JobWorkerType.findByClassName(WithDrawJobWorker.class.getName());
            if (worker != null) {
                m_nUnpubWorkerId = worker.getId();
            } else {
                logger.fatal((Object)"no worker for unpub job.");
            }
        }
        filter.addSearchValues(m_nUnpubWorkerId);
        schedules.open(filter);
        if (!schedules.isEmpty()) {
            return (Schedule)schedules.getAt(0);
        }
        return null;
    }

    public void setUnpubSchedule(MethodContext context) throws WCMException {
        int nSchId = context.getValue("SchId", 0);
        CMyDateTime etime = context.getValue("ETIME", CMyDateTime.now());
        User user = ContextHelper.getLoginUser();
        Schedule schedule = Schedule.findById(nSchId);
        if (schedule == null) {
            schedule = new Schedule();
            int nSenderId = context.getValue("SenderId", 0);
            int nSenderType = context.getValue("SenderType", 605);
            schedule.setSender(nSenderType, nSenderId);
            schedule.setName("\u5b9a\u65f6\u64a4\u9500\u53d1\u5e03\u8ba1\u5212[ObjType=" + nSenderType + ", ObjId=" + nSenderId + "] ");
            schedule.setMode(3);
            schedule.setExeTime(etime);
            if (m_nUnpubWorkerId == 0) {
                JobWorkerType worker = JobWorkerType.findByClassName(WithDrawJobWorker.class.getName());
                if (worker != null) {
                    m_nUnpubWorkerId = worker.getId();
                } else {
                    logger.fatal((Object)"no worker for unpub job.");
                }
            }
            schedule.setWorkerType(m_nUnpubWorkerId);
            schedule.save(user);
        } else {
            boolean zUnset = context.getValue("Unset", false);
            if (zUnset) {
                schedule.delete();
            } else {
                CMyDateTime dtEtime = schedule.getExeTime();
                if (!etime.toString("yyyy-MM-dd HH:mm").equals(dtEtime.toString("yyyy-MM-dd HH:mm"))) {
                    schedule.setExeTime(etime);
                    schedule.save(user);
                }
            }
        }
    }
}

