/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.GroupRoleMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class GroupServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
    }

    public void saveGroups(MethodContext _methodContext) throws Throwable {
        int i;
        User loginUser = ContextHelper.getLoginUser();
        int nUserId = _methodContext.getValue("UserId", 0);
        Groups currGroups = Groups.findByIds(loginUser, _methodContext.getValue("CurrGroupIds"));
        User currUser = null;
        if (nUserId > 0) {
            currUser = User.findById(nUserId);
            if (currUser == null) {
                throw new WCMException(I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label4", "\u6ca1\u6709\u627e\u5230ID\u4e3a[") + nUserId + "]" + I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label3", "\u7684\u7528\u6237\uff01"));
            }
        } else {
            throw new WCMException(I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label8", "\u83b7\u53d6\u7684\u7528\u6237ID\u4e0d\u6b63\u786e\uff01"));
        }
        UserMgr userMgr = (UserMgr)DreamFactory.createObjectById("UserMgr");
        if (!loginUser.isSecurityAdmin() && !userMgr.isManagerOfUser(currUser)) {
            throw new WCMException("\u4f60\u6ca1\u6709\u6743\u9650\u4fee\u6539\u8be5\u7528\u6237\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        Groups origGroups = currUser.getGroups();
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        for (i = 0; i < currGroups.size(); ++i) {
            if (origGroups.indexOf(currGroups.getAt(i)) >= 0) continue;
            groupMgr.addUser(currUser, (Group)currGroups.getAt(i));
        }
        for (i = 0; i < origGroups.size(); ++i) {
            if (currGroups.indexOf(origGroups.getAt(i)) >= 0) continue;
            groupMgr.removeUser(currUser, (Group)origGroups.getAt(i));
        }
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        UserMgr userMgr = (UserMgr)DreamFactory.createObjectById("UserMgr");
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        if (!loginUser.isSecurityAdmin() && !userMgr.isAdminOfGroup(loginUser)) {
            throw new WCMException("\u4f60\u6ca1\u6709\u6743\u9650\u67e5\u8be2\u7cfb\u7edf\u4e2d\u7684\u7ec4\u7ec7\uff01");
        }
        WCMFilter extraFilter = new WCMFilter(context.getQueryFilter());
        Groups allGroups = Groups.openWCMObjs(ContextHelper.getLoginUser(), extraFilter);
        if (!loginUser.isSecurityAdmin()) {
            for (int i = allGroups.size() - 1; i >= 0; --i) {
                if (groupMgr.isAdministrator((Group)allGroups.getAt(i), loginUser, true)) continue;
                allGroups.remove(allGroups.getAt(i), false);
            }
        }
        return allGroups;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    public Groups getGroupsForCurrUser(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        return groupMgr.getGroups(loginUser, null);
    }

    public Groups getGroupsForRole(MethodContext context) throws Throwable {
        RoleMgr roleMgr;
        int nRoleId = context.getValue("roleId", 0);
        if (nRoleId == 0) {
            throw new WCMException("\u6ca1\u6709\u4f20\u5165\u6307\u5b9a\u7684roleId\u53c2\u6570");
        }
        User loginUser = ContextHelper.getLoginUser();
        if (!loginUser.isSecurityAdmin() && !(roleMgr = new RoleMgr()).isRoleManagers(loginUser)) {
            throw new WCMException("\u4f60\u6ca1\u6709\u6743\u9650\u67e5\u770b\u89d2\u8272id\u4e3a[" + nRoleId + "]\u5173\u8054\u7684\u7ec4\u7ec7\u4fe1\u606f");
        }
        GroupRoleMgr groupRoleMgr = new GroupRoleMgr();
        return groupRoleMgr.getGroups(Role.findById(nRoleId), null);
    }
}

