/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.filter.logicProcessor.AbstractIDSCmdProcessor;
import com.trs.idm.interact.agent.AgentUtil;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.CookieHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LoginProcessor
extends AbstractIDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(LoginProcessor.class);
    private IAgent agent;
    private final String idsCmd = "login";

    public LoginProcessor(IAgent agent) {
        this.agent = agent;
    }

    public String getIDSCmd() {
        return "login";
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.debug((Object)"LoginProcessor login....");
        String coSessionId = this.agent.getServletAppActorV2().getSessionId(req, resp, false);
        InetAddress localHost = InetAddress.getLocalHost();
        String ssoSessionId = req.getHeader("ssoSessionId");
        if (coSessionId == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ignore expired local session [" + coSessionId + "], ssoSessionId=" + ssoSessionId));
            }
            resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "login");
        } else {
            SSOUser ssoUser = null;
            try {
                ssoUser = this.agent.findLoginSSOUser(ssoSessionId, coSessionId);
                LOG.debug((Object)("Find SSOUser from IDS by agent.findLoginSSOUser(ssoSessionId, coSessionId), ssoSessionId:" + ssoSessionId + "; coSessionId: " + coSessionId));
                LOG.debug((Object)("SSOUser found: " + ssoUser));
            }
            catch (Exception e) {
                LOG.error((Object)("agent.findUserInSession(" + coSessionId + ") error! ssoSessionId=" + ssoSessionId), (Throwable)e);
                resp.getOutputStream().print("agent.findUserInSession(" + coSessionId + ") fail! host=" + localHost);
                return;
            }
            if (ssoUser == null) {
                LOG.error((Object)("agent.findLoginSSOUser(" + coSessionId + ") == null! ssoSessionId=" + ssoSessionId + ", host=" + localHost));
                resp.getOutputStream().print("agent.findUserInSession(" + coSessionId + ") == null! host=" + localHost);
                return;
            }
            if (resp.isCommitted()) {
                return;
            }
            AgentUtil.removeSSOBind((CookieHelper)new CookieHelper(req, resp), (IAgent)this.agent);
            try {
                this.agent.getServletAppActorV2().loadLoginUser(req, resp, ssoUser);
                if (resp.isCommitted()) {
                    return;
                }
                resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "login" + " " + coSessionId);
            }
            catch (Throwable e) {
                LOG.error((Object)(this.agent.getServletAppActorV2() + ".loadLoginUser fail! (sessId,user)=" + coSessionId + "," + ssoUser.getUserName() + ". host=" + localHost), e);
                resp.getOutputStream().print(this.agent.getServletAppActorV2() + ".loadLoginUser fail! host=" + localHost);
            }
        }
    }

    private SSOUser parseLoginSSOUser(HttpServletRequest req) {
        try {
            req.setCharacterEncoding("GBK");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"fail set request encoding!", (Throwable)e);
        }
        Properties props = new Properties();
        Enumeration enu = req.getParameterNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            props.setProperty(key, req.getParameter(key));
        }
        String userName = props.getProperty("userName");
        if (userName == null || userName.length() == 0) {
            return null;
        }
        LOG.debug((Object)("user props: " + props));
        return new SSOUser(props);
    }
}

