/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.JDK13SocketUtilImpl;
import com.trs.idm.util.JDK14SocketUtilImpl;
import com.trs.idm.util.SocketUtilInternal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class SocketUtil {
    private static final Logger LOG = Logger.getLogger(SocketUtil.class);
    private static final SocketUtilInternal suImpl = EnvUtil.isJDK14OrHigher() ? new JDK14SocketUtilImpl() : (EnvUtil.isJDK13OrHigher() ? new JDK13SocketUtilImpl() : null);

    public static void setTimeout(Socket socket, int timeout) {
        if (socket != null) {
            try {
                socket.setSoTimeout(timeout);
            }
            catch (SocketException e) {
                LOG.warn((Object)("cannot set socket timeout! timeout(ms)=" + timeout), (Throwable)e);
            }
        }
    }

    public static void setTcpNoDelay(Socket socket, boolean noDelay) {
        if (socket != null) {
            try {
                socket.setTcpNoDelay(noDelay);
            }
            catch (SocketException e) {
                LOG.error((Object)("cannot set socket tcpNoDelay to " + noDelay), (Throwable)e);
            }
        }
    }

    public static String getSocketDetail(Socket socket) {
        return suImpl.getSocketDetail(socket);
    }

    public static String getSocketDetail(ServerSocket ss) {
        return suImpl.getSocketDetail(ss);
    }

    public static String sendMessage(String serverIP, int serverPort, String message) throws Exception {
        Socket socket = null;
        try {
            socket = new Socket(serverIP, serverPort);
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            byte[] inbytes = new byte[200];
            in.read(inbytes);
            byte[] outbytes = message.getBytes();
            out.write(outbytes);
            out.flush();
            in.read(inbytes);
            String string = new String(inbytes);
            return string;
        }
        catch (Exception ex) {
            LOG.error((Object)("Send message(" + message + ") to (" + serverIP + ":" + serverPort + ") error:" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int getTimeout(Socket socket) {
        if (socket == null) {
            return -1;
        }
        try {
            return socket.getSoTimeout();
        }
        catch (SocketException e) {
            return -2;
        }
    }
}

