/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.ArrayUtil;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.EnvConst;
import com.trs.dev4.jdk16.utils.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StringHelper {
    public static final String EMPTY = "";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte byteAt(String strHead, int index) {
        byte result = (byte)strHead.charAt(index);
        result = (byte)(result - 48);
        return result;
    }

    public static String[] split(String origin, String token) {
        if (origin == null) {
            return null;
        }
        StringTokenizer st = token == null ? new StringTokenizer(origin) : new StringTokenizer(origin, token);
        int countTokens = st.countTokens();
        if (countTokens <= 0) {
            return new String[]{origin};
        }
        String[] results = new String[countTokens];
        int i = 0;
        while (i < countTokens) {
            results[i] = st.nextToken();
            ++i;
        }
        return results;
    }

    public static String reverse(String origin) {
        if (origin == null) {
            return null;
        }
        return new StringBuilder(origin).reverse().toString();
    }

    public static String encodingByISO8859_1(String string) {
        if (string != null && !EMPTY.equals(string)) {
            try {
                return new String(string.getBytes(), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                return string;
            }
        }
        return string;
    }

    @Deprecated
    public static String[] splitAlways(String origin, String token) {
        return StringHelper.split(origin, token);
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return "null!";
        }
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return new String(out);
    }

    public static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        char[] data = str.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters!");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = StringHelper.toDigit(data[j], j) << 4;
            f |= StringHelper.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static String filterForHTMLValue(String _sContent) {
        if (_sContent == null) {
            return EMPTY;
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return EMPTY;
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        int i = 0;
        while (i < nLen) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '&': {
                    if (i + 1 < nLen) {
                        cTemp = srcBuff[i + 1];
                        if (cTemp == '#') {
                            retBuff.append("&");
                            break;
                        }
                        retBuff.append("&amp;");
                        break;
                    }
                    retBuff.append("&amp;");
                    break;
                }
                case '<': {
                    retBuff.append("&lt;");
                    break;
                }
                case '>': {
                    retBuff.append("&gt;");
                    break;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    break;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
            ++i;
        }
        return retBuff.toString();
    }

    public static String toString(Object[] objs) {
        return StringHelper.toString(objs, false, ", ");
    }

    public static String toString(Object[] objs, boolean showOrder) {
        return StringHelper.toString(objs, showOrder, ",");
    }

    public static String toString(Object[] objs, boolean showOrder, String token) {
        if (objs == null) {
            return "null";
        }
        int len = objs.length;
        StringBuffer sb = new StringBuffer(10 * len);
        int i = 0;
        while (i < len) {
            if (showOrder) {
                sb.append(i).append(':');
            }
            sb.append(objs[i]);
            if (i < len - 1) {
                sb.append(token);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String avoidNull(String str) {
        return str == null ? EMPTY : str;
    }

    public static String assertNotEmptyAndTrim(String str) {
        AssertUtil.notNullOrEmpty(str, "the string is empty!");
        return str.trim();
    }

    public static String avoidEmpty(String str, String defaultStr) {
        return StringHelper.isEmpty(str) ? defaultStr : str;
    }

    public static String join(int[] array, String separator) {
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        StringBuilder buf = new StringBuilder(200);
        if (array.length > 0) {
            buf.append(array[0]);
        }
        int i = 1;
        while (i < array.length) {
            buf.append(separator);
            buf.append(array[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String join(Object[] array) {
        return StringHelper.join(array, ",");
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringHelper.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHelper.join(array, separator, 0, array.length);
    }

    static String join(Object[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return EMPTY;
        }
        StringBuffer buf = new StringBuffer(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + 1);
        int i = startIndex;
        while (i < endIndex) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] != null) {
                buf.append(array[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int bufSize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((bufSize = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StringBuffer buf = new StringBuffer(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + separator.length());
        int i = startIndex;
        while (i < endIndex) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] != null) {
                buf.append(array[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String capitalize(String str) {
        return StringHelper.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringHelper.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        if (capitalize) {
            buf.append(Character.toUpperCase(str.charAt(0)));
        } else {
            buf.append(Character.toLowerCase(str.charAt(0)));
        }
        buf.append(str.substring(1));
        return buf.toString();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public static String[] splitAndTrim(String origin, String token) {
        if (origin == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(origin = origin.trim(), token);
        int countTokens = st.countTokens();
        if (countTokens <= 0) {
            return new String[]{origin};
        }
        ArrayList<String> strs = new ArrayList<String>(countTokens);
        int i = 0;
        while (i < countTokens) {
            String str = st.nextToken().trim();
            if (str.length() > 0) {
                strs.add(str);
            }
            ++i;
        }
        return strs.toArray(new String[0]);
    }

    public static String hexToStr(String hex) {
        return new String(StringHelper.toBytes(hex));
    }

    public static String truncateAndTrim(String str, String delim) {
        if (str == null || delim == null) {
            return str;
        }
        int nStart = str.indexOf(delim);
        if (nStart < 0) {
            return str;
        }
        return str.substring(nStart + delim.length()).trim();
    }

    public static String getStringByEncoding(String originalStr, String encoding) {
        return StringHelper.getStringByEncoding(originalStr, "ISO8859-1", encoding);
    }

    public static String getStringByEncoding(String str, String fromEncoding, String toEncoding) {
        if (str == null) {
            return null;
        }
        if (StringHelper.isEmpty(fromEncoding)) {
            return str;
        }
        try {
            return new String(str.getBytes(fromEncoding), toEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String truncate(String str, int maxLength) {
        if (str == null) {
            return str;
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Illegal value of maxLength: " + maxLength + "! It must be a positive integer.");
        }
        int strLength = str.length();
        if (maxLength >= strLength) {
            return str;
        }
        String DELIT = "...";
        StringBuilder sb = new StringBuilder(maxLength);
        int splitPos = maxLength - "...".length();
        sb.append(str.substring(0, splitPos));
        sb.append("...");
        return sb.toString();
    }

    public static String adjustLength(String str, int maxLength) {
        if (str == null) {
            return str;
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Illegal value of maxLength: " + maxLength + "! It must be a positive integer.");
        }
        int strLength = str.length();
        if (maxLength > strLength) {
            return str;
        }
        String DELIT = "...";
        StringBuilder sb = new StringBuilder(maxLength);
        int splitPos = (maxLength - "...".length()) / 2;
        sb.append(str.substring(0, splitPos));
        sb.append("...");
        sb.append(str.substring(strLength - splitPos));
        return sb.toString();
    }

    public static String getURLSafe(String url) {
        if (url == null || EMPTY.equals(url)) {
            return EMPTY;
        }
        StringBuffer strBuff = new StringBuffer();
        char[] charArray = url.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] != '<' && charArray[i] != '>') {
                strBuff.append(charArray[i]);
            }
            ++i;
        }
        return strBuff.toString();
    }

    public static String removeLastSlashChar(String str) {
        if (str == null) {
            return null;
        }
        if (str.endsWith("/")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String smartAppendSlashToEnd(String str) {
        return StringHelper.smartAppendSuffix(str, "/");
    }

    public static String smartAppendSuffix(String str, String endingStr) {
        if (str == null) {
            return null;
        }
        return str.endsWith(endingStr) ? str : String.valueOf(str) + endingStr;
    }

    public static String replaceAll(String origin, String oldPart, String replacement) {
        if (origin == null || replacement == null) {
            return origin;
        }
        if (oldPart == null || oldPart.length() == 0) {
            return origin;
        }
        int index = origin.indexOf(oldPart);
        if (index < 0) {
            return origin;
        }
        StringBuffer sb = new StringBuffer(origin);
        do {
            sb.replace(index, index + oldPart.length(), replacement);
        } while ((index = (origin = sb.toString()).indexOf(oldPart)) != -1);
        return origin;
    }

    public static String removeBeginPart(String origin, String beginPart) {
        if (origin == null || beginPart == null) {
            return origin;
        }
        int pos = origin.indexOf(beginPart);
        if (pos != 0) {
            return origin;
        }
        return origin.substring(beginPart.length());
    }

    public static int[] split2IntArray(String data) {
        String[] splited = StringHelper.splitAndTrim(data, ",");
        return ArrayUtil.toIntArray(splited);
    }

    public static String int2String(int num) {
        try {
            String str = String.valueOf(num);
            return str;
        }
        catch (Exception e) {
            return EMPTY;
        }
    }

    public static String replaceEnter2HtmlBr(String origin) {
        return StringHelper.replaceAll(origin, EnvConst.NEWLINE, "<br>");
    }

    public static String substring(String origin, String begin, String end) {
        int endIndex;
        if (origin == null) {
            return origin;
        }
        int beginIndex = begin == null ? 0 : origin.indexOf(begin) + begin.length();
        int n = endIndex = end == null ? origin.length() : origin.indexOf(end, beginIndex);
        if (endIndex == -1) {
            return origin.substring(beginIndex);
        }
        return origin.substring(beginIndex, endIndex);
    }

    public static String substring(String origin, String begin) {
        return StringHelper.substring(origin, begin, null);
    }

    public static int parseInt(String value) {
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static int parseIntUsingFormat(String source, String formatPattern) {
        DecimalFormat df = new DecimalFormat(formatPattern);
        try {
            return df.parse(source).intValue();
        }
        catch (ParseException e) {
            return -1;
        }
    }

    public static Map<String, String> parseAsMap(String src, String propertyDelimiter, String fieldDelimiter) {
        String[] properties;
        HashMap<String, String> parsedMap = new HashMap<String, String>();
        if (StringHelper.isEmpty(src)) {
            return parsedMap;
        }
        String[] stringArray = properties = StringHelper.split(src, propertyDelimiter);
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            int keyIndex = property.indexOf(fieldDelimiter);
            if (keyIndex != -1) {
                String key = property.substring(0, keyIndex);
                String value = property.substring(keyIndex + fieldDelimiter.length());
                parsedMap.put(key, value);
            }
            ++n2;
        }
        return parsedMap;
    }

    public static Map<String, String> parseAsMap(String src) {
        return StringHelper.parseAsMap(src, ";", "=");
    }

    public static String trimQuote(String value) {
        if (value == null) {
            return value;
        }
        int length = (value = value.trim()).length();
        if (length < 2) {
            return value;
        }
        if (value.charAt(0) != '\"' || value.charAt(length - 1) != '\"') {
            return value;
        }
        return value.substring(1, length - 1);
    }

    public static String addQuote(String str) {
        if (str.indexOf(32) > 0) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    public static boolean isNumeric(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-|+]?(\\d+)(\\.\\d+)?");
        return pattern.matcher(input).matches();
    }

    public static boolean isInteger(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-|+]?[1-9][0-9]*");
        return pattern.matcher(input).matches();
    }

    public static boolean isPositiveInteger(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[1-9][0-9]*");
        return pattern.matcher(input).matches();
    }

    public static boolean isTelphone(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(((\\+|0)[0-9]{2,3})-)?((0[0-9]{2,3})-)?([0-9]{8})(-([0-9]{3,4}))?$");
        return pattern.matcher(input).matches();
    }

    public static boolean isMobile(String input) {
        if (!StringHelper.isNumeric(input)) {
            return false;
        }
        return input.length() == 11 && input.charAt(0) == '1';
    }

    public static boolean isAccountName(String input, int minLength, int maxLength) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]{4,15}$");
        if (!pattern.matcher(input).matches()) {
            return false;
        }
        return StringHelper.limitedLength(input, minLength, maxLength);
    }

    public static boolean limitedLength(String input, int minLength, int maxLength) {
        if (StringHelper.isEmpty(input)) {
            return minLength <= 0;
        }
        return input.length() >= minLength && input.length() <= maxLength;
    }

    public static boolean isEmail(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[A-Za-z0-9._%+-]+@(\\w+\\.)+[a-zA-Z]{2,3}");
        return pattern.matcher(input).matches();
    }

    public static boolean isDomainName(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+");
        return pattern.matcher(input).matches();
    }

    public static boolean isIP(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("((25[0-5])|(2[0-4]\\d)|(1\\d\\d)|([1-9]\\d)|\\d)(\\.((25[0-5])|(2[0-4]\\d)|(1\\d\\d)|([1-9]\\d)|\\d)){3}");
        return pattern.matcher(input).matches();
    }

    public static boolean isMultiIPs(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(input, ",");
        boolean isMultiIPs = true;
        while (st.hasMoreTokens() && isMultiIPs) {
            String token = st.nextToken();
            isMultiIPs &= StringHelper.isIP(token);
        }
        return isMultiIPs;
    }

    public static boolean isHttpUrl(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("http://(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(:\\d{2,4})?(\\/[^#$]+)*");
        return pattern.matcher(input).matches();
    }

    public static boolean isRtmpUrl(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        input = StringHelper.removeLastSlashChar(input);
        Pattern pattern = Pattern.compile("rtmp://(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(:\\d{2,4})?(\\/[^#$]+)*");
        return pattern.matcher(input).matches();
    }

    public static boolean isFtpUrl(String input) {
        URL url;
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        try {
            url = new URL(input);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return UrlUtil.isFtp(url);
    }

    public static boolean isMediaUrl(String input) {
        return StringHelper.isRtmpUrl(input) || StringHelper.isHttpUrl(input);
    }

    public static boolean isQQ(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[1-9]\\d{4,8}$");
        return pattern.matcher(input).matches();
    }

    public static boolean isDate(String input) {
        if (StringHelper.isEmpty(input)) {
            return false;
        }
        String eL = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        return Pattern.compile(eL).matcher(input).matches();
    }

    public static String toSecurityMaskForm(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            sb.append('*');
            ++i;
        }
        return sb.toString();
    }

    public static String join(Map<String, ?> entities, String separator) {
        if (entities == null) {
            return null;
        }
        if (separator == null) {
            separator = ",";
        }
        StringBuilder buf = new StringBuilder(200);
        String[] keys = entities.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            buf.append(keys[i]).append("=").append(StringHelper.avoidNull(entities.get(keys[i]).toString())).append(separator);
            ++i;
        }
        return buf.toString();
    }

    public static boolean isNotEmpty(String str) {
        return !StringHelper.isEmpty(str);
    }
}

