/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.debug;

import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.DebugManager;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.Startable;
import com.trs.infra.cluster.debug.DebugMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DebugManagerImpl
implements DebugManager,
Startable {
    private static final Logger s_logger;
    private final byte[] debugSequenceSynchronizer = new byte[0];
    private int debugSequence = 0;
    private ClusterContext context = null;
    private Map messages = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.debug.DebugManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextDebugSequence() {
        byte[] byArray = this.debugSequenceSynchronizer;
        synchronized (this.debugSequenceSynchronizer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.debugSequence++;
        }
    }

    public int getAcceptedMessage() {
        return 7;
    }

    public void receive(ClusterMessage message, Member sender) {
        DebugMessage debugMessage = (DebugMessage)message;
        switch (debugMessage.getMinorId()) {
            case 0: {
                this.recevieDebug(debugMessage, sender);
                break;
            }
            case 1: {
                this.recevieAck(debugMessage, sender);
                break;
            }
            default: {
                s_logger.error((Object)"Unknown minor message id ");
            }
        }
    }

    void recevieDebug(DebugMessage debugMessage, Member sender) {
        this.sendAck(debugMessage, sender);
    }

    private void sendAck(DebugMessage debugMessage, Member sender) {
        debugMessage.setAckFor(debugMessage.getDebugSequence());
        debugMessage.setMinorId(1);
        this.context.send((ClusterMessage)debugMessage, sender);
    }

    void recevieAck(DebugMessage debugMessage, Member sender) {
        DebugMessage src = (DebugMessage)this.messages.get(String.valueOf(debugMessage.getAckFor()));
        if (src != null) {
            src.setAckTime();
        }
    }

    public DebugMessage buildDebugMessage() {
        DebugMessage msg = new DebugMessage();
        msg.setMinorId(0);
        int debugSequence = this.nextDebugSequence();
        msg.setDebugSequence(debugSequence);
        this.messages.put(String.valueOf(debugSequence), msg);
        return msg;
    }

    public DebugMessage buildDebugMessage(Member to) {
        throw new UnsupportedOperationException("No implement yet.");
    }

    public final ClusterContext getClusterContext() {
        return this.context;
    }

    public final void setClusterContext(ClusterContext context) {
        this.context = context;
    }

    public Map getMessages() {
        return this.messages;
    }

    public void debug() {
        Iterator itr = this.messages.values().iterator();
        if (!s_logger.isDebugEnabled()) {
            s_logger.setLevel(Level.DEBUG);
        }
        while (itr.hasNext()) {
            s_logger.debug(itr.next());
        }
    }

    public void start() {
        this.messages = new HashMap(1024);
    }

    public void close() {
        this.messages.clear();
    }
}

