/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.ack;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.trs.infra.cluster.ACK;
import com.trs.infra.cluster.ACKManager;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberManager;
import com.trs.infra.cluster.Startable;
import com.trs.infra.cluster.ack.ACKImpl;
import com.trs.infra.cluster.ack.ACKImplResultImp;
import com.trs.infra.cluster.ack.ACKMessage;
import com.trs.infra.cluster.ack.NULLACK;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ACKManagerImpl
implements ACKManager,
Startable {
    private ClusterContext clusterContext;
    private MemberManager memberManager;
    private Map allWaitAcks;

    public final ClusterContext getClusterContext() {
        return this.clusterContext;
    }

    public final void setClusterContext(ClusterContext clusterContext) {
        this.clusterContext = clusterContext;
    }

    public void start() {
        this.memberManager = this.clusterContext.getMemberManager();
        this.allWaitAcks = new ConcurrentHashMap(64);
    }

    public void close() {
        this.allWaitAcks.clear();
    }

    public void prepare() {
    }

    public int getAcceptedMessage() {
        return 1;
    }

    public void receive(ClusterMessage msg, Member sender) {
        if (msg == null || !(msg instanceof ACKMessage)) {
            return;
        }
        ACKMessage message = (ACKMessage)msg;
        ACKImpl waitACK = (ACKImpl)this.allWaitAcks.get(String.valueOf(message.getAckFor()));
        if (waitACK != null) {
            ACKImplResultImp result = new ACKImplResultImp(sender);
            result.setValue(message.getValue());
            result.setTime(System.currentTimeMillis());
            if (waitACK.result(result)) {
                this.allWaitAcks.remove(String.valueOf(message.getAckFor()));
            }
        }
    }

    public void memberFailed(Member member) {
        this.ackAllWaitOn(member);
    }

    public void memberJoined(Member member) {
    }

    public void memberLeft(Member member) {
        this.ackAllWaitOn(member);
    }

    public Iterator acks() {
        return this.allWaitAcks.values().iterator();
    }

    public int count() {
        return this.allWaitAcks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceACK(ACK ack) {
        ACK aCK = ack;
        synchronized (aCK) {
            ack.state(ACK.State.FINISH);
            ack.notifyAll();
        }
    }

    public void bindWaitACK(ClusterMessage message, Member member, Member[] members) {
        ACK waitACK = null;
        if (member != null) {
            if ((member = this.memberManager.find(member)) == null || member.isLocal() || !member.isValid()) {
                waitACK = NULLACK.INSTANCE;
            } else {
                ArrayList<ACKImplResultImp> expects = new ArrayList<ACKImplResultImp>(1);
                expects.add(new ACKImplResultImp(member));
                waitACK = new ACKImpl(expects);
            }
        } else if (members != null) {
            int count = 0;
            int i = members.length - 1;
            while (i >= 0) {
                member = this.memberManager.find(members[i]);
                if (member == null || member.isLocal() || !member.isValid()) {
                    members[i] = null;
                } else {
                    ++count;
                }
                --i;
            }
            if (count <= 0) {
                waitACK = NULLACK.INSTANCE;
            } else {
                ArrayList<ACKImplResultImp> expects = new ArrayList<ACKImplResultImp>(count);
                int i2 = members.length - 1;
                while (i2 >= 0) {
                    member = members[i2];
                    if (member != null) {
                        expects.add(new ACKImplResultImp(member));
                    }
                    --i2;
                }
                waitACK = new ACKImpl(expects);
            }
        } else if (!this.memberManager.hasMember()) {
            waitACK = NULLACK.INSTANCE;
        } else {
            ArrayList<ACKImplResultImp> expects = new ArrayList<ACKImplResultImp>(this.memberManager.count() - 1);
            Iterator itr = this.memberManager.members();
            while (itr.hasNext()) {
                member = (Member)itr.next();
                if (member == null || member.isLocal() || !member.isValid()) continue;
                expects.add(new ACKImplResultImp(member));
            }
            waitACK = expects.isEmpty() ? NULLACK.INSTANCE : new ACKImpl(expects);
        }
        if (waitACK != NULLACK.INSTANCE) {
            this.allWaitAcks.put(String.valueOf(message.getSequence()), waitACK);
        }
        message.setWaitACK(waitACK);
    }

    private void ackAllWaitOn(Member member) {
        Iterator itr = this.allWaitAcks.entrySet().iterator();
        Map.Entry entry = null;
        while (itr.hasNext()) {
            ACKImpl ack;
            entry = itr.next();
            if (entry == null || !(ack = (ACKImpl)entry.getValue()).revokeExpected(member)) continue;
            itr.remove();
        }
    }
}

