/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster;

import com.trs.infra.cluster.ACKManager;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.ClusterMessageListener;
import com.trs.infra.cluster.DebugManager;
import com.trs.infra.cluster.ExtensionManager;
import com.trs.infra.cluster.InnerState;
import com.trs.infra.cluster.LockManager;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberManager;
import com.trs.infra.cluster.Startable;
import com.trs.infra.cluster.Statistic;
import com.trs.infra.cluster.TokenManager;
import com.trs.infra.cluster.session.SessionManager;

public interface ClusterContext
extends Startable {
    public void send(ClusterMessage var1);

    public void send(ClusterMessage var1, Member var2);

    public void send(ClusterMessage var1, Member[] var2);

    public void addListener(ClusterMessageListener var1);

    public void removeListener(ClusterMessageListener var1);

    public long currentTimeMillis();

    public ClusterConfig getConfig();

    public ACKManager getACKManager();

    public LockManager getLockManager();

    public TokenManager getTokenManager();

    public MemberManager getMemberManager();

    public SessionManager getSessionManager();

    public ExtensionManager getExtensionManager();

    public void setExtensionManager(ExtensionManager var1);

    public DebugManager getDebugManager();

    public State getState();

    public Statistic getReceivStatistic();

    public Statistic getSendStatistic();

    public static final class State
    extends InnerState {
        private static final int INT_SHUTDOWN = 1;
        private static final int INT_STARTING = 2;
        private static final int INT_RUNNING = 3;
        private static final int INT_STOPPING = 4;
        public static final State SHUTDOWN = new State(1, "SHUTDOWN");
        public static final State STARTING = new State(2, "STARTING");
        public static final State RUNNING = new State(3, "RUNNING");
        public static final State STOPPING = new State(4, "STOPPING");

        public static final State valueOf(int id) {
            switch (id) {
                case 1: {
                    return SHUTDOWN;
                }
                case 2: {
                    return STARTING;
                }
                case 3: {
                    return RUNNING;
                }
                case 4: {
                    return STOPPING;
                }
            }
            throw new IllegalArgumentException();
        }

        private State(int id, String name) {
            super(id, name);
        }
    }
}

