/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.DateTimeUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class DateTimeUtilTest
extends TestCase {
    public void testAdd() throws Exception {
        Date date = DateTimeUtil.getDateFromYMDHMS("2008-01-31 23:59:59");
        DateTimeUtilTest.assertEquals((String)"2009-01-31 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 1, 1)));
        DateTimeUtilTest.assertEquals((String)"2007-01-31 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 1, -1)));
        DateTimeUtilTest.assertEquals((String)"2008-02-29 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 2, 1)));
        DateTimeUtilTest.assertEquals((String)"2007-12-31 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 2, -1)));
        DateTimeUtilTest.assertEquals((String)"2008-02-07 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 3, 1)));
        DateTimeUtilTest.assertEquals((String)"2008-01-24 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 3, -1)));
        DateTimeUtilTest.assertEquals((String)"2008-02-01 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 5, 1)));
        DateTimeUtilTest.assertEquals((String)"2008-01-30 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 5, -1)));
        DateTimeUtilTest.assertEquals((String)"2008-02-01 00:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 11, 1)));
        DateTimeUtilTest.assertEquals((String)"2008-01-31 22:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 11, -1)));
        DateTimeUtilTest.assertEquals((String)"2008-02-01 00:00:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 12, 1)));
        DateTimeUtilTest.assertEquals((String)"2008-01-31 23:58:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 12, -1)));
        DateTimeUtilTest.assertEquals((String)"2008-02-01 00:00:00", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 13, 1)));
        DateTimeUtilTest.assertEquals((String)"2008-01-31 23:59:58", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 13, -1)));
        DateTimeUtilTest.assertEquals((String)"2009-01-31 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(DateTimeUtil.add(date, 1, 1)));
    }

    public void testGetByField() throws Exception {
        Date date = DateTimeUtil.getDateFromYMDHMS("2008-10-31 23:59:59");
        DateTimeUtilTest.assertEquals((int)2008, (int)DateTimeUtil.getByField(date, 1));
        DateTimeUtilTest.assertEquals((int)9, (int)DateTimeUtil.getByField(date, 2));
        DateTimeUtilTest.assertEquals((int)31, (int)DateTimeUtil.getByField(date, 5));
        DateTimeUtilTest.assertEquals((int)23, (int)DateTimeUtil.getByField(date, 11));
        DateTimeUtilTest.assertEquals((int)59, (int)DateTimeUtil.getByField(date, 12));
        DateTimeUtilTest.assertEquals((int)59, (int)DateTimeUtil.getByField(date, 13));
        DateTimeUtilTest.assertEquals((int)0, (int)DateTimeUtil.getByField(date, 14));
        DateTimeUtilTest.assertEquals((int)5, (int)DateTimeUtil.getByField(date, 4));
        DateTimeUtilTest.assertEquals((int)44, (int)DateTimeUtil.getByField(date, 3));
    }

    public void testGetDateBegin() throws Exception {
        Date date = DateTimeUtil.getDateFromYMDHMS("2008-01-18 21:10:17");
        Date dateBegin = DateTimeUtil.getDateBegin(date);
        DateTimeUtilTest.assertEquals((String)"2008-01-18 00:00:00", (String)DateTimeUtil.getYMDHMSFromDate(dateBegin));
    }

    public void testGetDateEnd() throws Exception {
        Date date = DateTimeUtil.getDateFromYMDHMS("2008-01-18 21:10:17");
        Date dateEnd = DateTimeUtil.getDateEnd(date);
        DateTimeUtilTest.assertEquals((String)"2008-01-18 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(dateEnd));
    }

    public void testGetDateFromYMD() throws Exception {
        Date date = new GregorianCalendar(2008, 4, 7).getTime();
        DateTimeUtilTest.assertEquals((Object)date, (Object)DateTimeUtil.getDateFromYMD("2008-5-7"));
        DateTimeUtilTest.assertEquals((Object)date, (Object)DateTimeUtil.getDateFromYMD("2008-5-7"));
        DateTimeUtilTest.assertEquals((Object)date, (Object)DateTimeUtil.getDateFromYMD("2008-05-07"));
    }

    public void testGetDateFromYMDHMS() throws Exception {
        Date date = new GregorianCalendar(2008, 4, 7, 2, 12, 12).getTime();
        DateTimeUtilTest.assertEquals((Object)date, (Object)DateTimeUtil.getDateFromYMDHMS("2008-5-7 02:12:12"));
        DateTimeUtilTest.assertEquals((Object)date, (Object)DateTimeUtil.getDateFromYMDHMS("2008-5-7 2:12:12"));
        DateTimeUtilTest.assertEquals((Object)date, (Object)DateTimeUtil.getDateFromYMDHMS("2008-05-07 2:12:12"));
    }

    public void testGetFormatStrFromDate() throws Exception {
        DateTimeUtilTest.assertEquals((String)DateTimeUtil.getFormatFromDate(null, "yyyy-MM-dd HH:mm:ss"), (String)"");
        DateTimeUtilTest.assertEquals((String)DateTimeUtil.getFormatFromDate(null, "yyyy-MM-dd"), (String)"");
        Date date = new GregorianCalendar(2008, 2, 21, 22, 22, 22).getTime();
        DateTimeUtilTest.assertEquals((String)"2008-03-21", (String)DateTimeUtil.getFormatFromDate(date, "yyyy-MM-dd"));
        DateTimeUtilTest.assertEquals((String)"2008-03-21 22:22:22", (String)DateTimeUtil.getFormatFromDate(date, "yyyy-MM-dd HH:mm:ss"));
        DateTimeUtilTest.assertEquals((String)"2008-03-21 22:22:22.000+0800", (String)DateTimeUtil.getFormatFromDate(date, "yyyy-MM-dd HH:mm:ss.SSSZ"));
    }

    public void testGetMonthBegin() throws Exception {
        Date date = DateTimeUtil.getDateFromYMDHMS("2008-01-18 21:10:17");
        Date monthBegin = DateTimeUtil.getMonthBegin(date);
        DateTimeUtilTest.assertEquals((String)"2008-01-01 00:00:00", (String)DateTimeUtil.getYMDHMSFromDate(monthBegin));
    }

    public void testGetMonthEnd() throws Exception {
        Date date = DateTimeUtil.getDateFromYMDHMS("2008-01-18 21:10:17");
        Date monthEnd = DateTimeUtil.getMonthEnd(date);
        DateTimeUtilTest.assertEquals((String)"2008-01-31 23:59:59", (String)DateTimeUtil.getYMDHMSFromDate(monthEnd));
    }

    public void testGetYMDFromDate() throws Exception {
        DateTimeUtilTest.assertEquals((String)DateTimeUtil.getYMDFromDate(null), (String)"");
        Date date = new GregorianCalendar(2008, 2, 21).getTime();
        DateTimeUtilTest.assertEquals((String)"2008-03-21", (String)DateTimeUtil.getYMDFromDate(date));
    }

    public void testGetYMDHMSFromDate() throws Exception {
        DateTimeUtilTest.assertEquals((String)DateTimeUtil.getYMDFromDate(null), (String)"");
        Date date = new GregorianCalendar(2008, 2, 21, 22, 22, 22).getTime();
        DateTimeUtilTest.assertEquals((String)"2008-03-21 22:22:22", (String)DateTimeUtil.getYMDHMSFromDate(date));
    }

    public void testGetYMDHMSZFromDate() throws Exception {
        DateTimeUtilTest.assertEquals((String)DateTimeUtil.getYMDFromDate(null), (String)"");
        Date date = new GregorianCalendar(2008, 2, 21, 22, 22, 22).getTime();
        DateTimeUtilTest.assertEquals((String)"2008-03-21 22:22:22.000+0800", (String)DateTimeUtil.getYMDHMSZFromDate(date));
    }
}

