/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.servlet;

import com.trs.cis4.bean.SysApplication;
import com.trs.cis4.bean.User;
import com.trs.cis4.timer.task.UserStatusData;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class UserValidateFilter
implements Filter {
    private Logger log = Logger.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.isWeblogicCycle(request, response, filterChain)) {
            return;
        }
        String requestDo = this.getRequestDo(request);
        String requestParams = this.getRequestParams(request);
        this.recordLog(requestDo, requestParams);
        this.setLastaccessedtime(request, requestDo);
        String userValidateFilters = SysApplication.getUserValidateFilters();
        if (userValidateFilters != null && userValidateFilters.indexOf(requestDo.substring(1)) >= 0) {
            filterChain.doFilter(request, response);
            return;
        }
        int loginStat = this.getSessionStat(request);
        if (loginStat > 0) {
            String forward = "/jsp/default.jsp";
            forward = requestParams.length() > 0 ? String.valueOf(forward) + "?addr=" + requestDo + "?" + requestParams : String.valueOf(forward) + "?addr=" + requestDo;
            this.log.info((Object)("OUT:" + forward));
            request.getRequestDispatcher(forward).forward(request, response);
            return;
        }
        if (requestParams.equals("")) {
            this.doBlankRequest(request, response, filterChain, requestDo);
        } else if (requestParams.indexOf("pageCode") >= 0 || requestParams.indexOf("pageOrderby") >= 0) {
            this.doPageCodeRequest(request, response, filterChain, requestDo, requestParams);
        } else {
            this.doNormalRequest(request, response, filterChain, requestDo, requestParams);
        }
        this.saveRequestAddr(request, requestDo);
    }

    protected void recordLog(String requestDo, String requestParams) {
        if (requestParams.length() > 0) {
            this.log.info((Object)("IN :" + requestDo + "?" + requestParams));
        } else {
            this.log.info((Object)("IN :" + requestDo));
        }
    }

    private void setLastaccessedtime(ServletRequest request, String requestDo) {
        User user;
        HttpSession session;
        String userValidateDefaults = SysApplication.getUserValidateDefaults();
        if (userValidateDefaults == null || userValidateDefaults.equals("")) {
            userValidateDefaults = "_default.do";
        }
        if (userValidateDefaults.indexOf(requestDo.substring(1)) == -1 && (session = ((HttpServletRequest)request).getSession(true)) != null && (user = (User)session.getAttribute("user")) != null) {
            user.setLastaccessedtime(System.currentTimeMillis());
            session.setAttribute("user", (Object)user);
        }
    }

    protected void doBlankRequest(ServletRequest request, ServletResponse response, FilterChain filterChain, String requestDo) {
        try {
            this.log.info((Object)("requestDo=" + requestDo));
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            String forward = "";
            if (session.getAttribute("UserUrlStack") != null) {
                Hashtable stack = (Hashtable)session.getAttribute("UserUrlStack");
                forward = (String)stack.get(requestDo);
            }
            if (forward == null || forward.equals("")) {
                filterChain.doFilter(request, response);
            } else {
                String url = String.valueOf(requestDo) + "?" + forward;
                this.log.info((Object)("OUT:" + url));
                session.setAttribute("cycleFlag", (Object)Boolean.TRUE);
                request.getRequestDispatcher(url).forward(request, response);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("doBlankRequest " + e));
        }
    }

    protected void doNormalRequest(ServletRequest request, ServletResponse response, FilterChain filterChain, String requestDo, String requestParams) {
        try {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            if (requestDo != null && requestDo.indexOf("List.do") > 0) {
                Hashtable stack = session.getAttribute("UserUrlStack") == null ? new Hashtable() : (Hashtable)session.getAttribute("UserUrlStack");
                stack.put(requestDo, requestParams);
                session.setAttribute("UserUrlStack", (Object)stack);
            }
            filterChain.doFilter(request, response);
        }
        catch (Exception e) {
            this.log.error((Object)("doNormalRequest " + e));
        }
    }

    protected void doPageCodeRequest(ServletRequest request, ServletResponse response, FilterChain filterChain, String requestDo, String requestParams) {
        try {
            Hashtable stack;
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            String oldurl = "";
            if (session.getAttribute("UserUrlStack") != null) {
                stack = (Hashtable)session.getAttribute("UserUrlStack");
                oldurl = (String)stack.get(requestDo);
            }
            if (oldurl == null) {
                oldurl = "";
            }
            String forward = "";
            if (requestParams.indexOf("pageCode") >= 0) {
                forward = this.getUrlsByPageCode(oldurl, requestParams);
            } else if (requestParams.indexOf("pageOrderby") >= 0) {
                forward = this.getUrlsByOrderBy(oldurl, requestParams);
            }
            if (forward == null || forward.equals("")) {
                filterChain.doFilter(request, response);
            } else {
                String url = String.valueOf(requestDo) + "?" + forward;
                this.log.info((Object)("OUT:" + url));
                stack = session.getAttribute("UserUrlStack") == null ? new Hashtable() : (Hashtable)session.getAttribute("UserUrlStack");
                stack.put(requestDo, forward);
                session.setAttribute("UserUrlStack", (Object)stack);
                session.setAttribute("cycleFlag", (Object)Boolean.TRUE);
                request.getRequestDispatcher(url).forward(request, response);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("doPageCodeRequest " + e));
        }
    }

    protected String getUrlsByPageCode(String oldurl, String params) {
        try {
            if (oldurl.indexOf("pageCode") < 0 || params.indexOf(oldurl) != -1) {
                oldurl = oldurl.equals("") ? params : String.valueOf(oldurl) + "&" + params;
            }
            String newCodePage = params.substring(params.indexOf("=") + 1);
            String[] urls = oldurl.split("&");
            int i = 0;
            while (i < urls.length) {
                if (urls[i].indexOf("pageCode") >= 0) {
                    urls[i] = "pageCode=" + newCodePage;
                    break;
                }
                ++i;
            }
            StringBuffer newurl = new StringBuffer("");
            int i2 = 0;
            while (i2 < urls.length) {
                if (i2 != 0) {
                    newurl.append("&");
                }
                newurl.append(urls[i2]);
                ++i2;
            }
            return newurl.toString();
        }
        catch (Exception e) {
            this.log.error((Object)("getUrlsByPageCode " + e));
            return null;
        }
    }

    protected String getUrlsByOrderBy(String oldurl, String params) {
        try {
            if (oldurl.indexOf("pageOrderby") < 0) {
                oldurl = oldurl.equals("") || params.indexOf(oldurl) != -1 ? params : String.valueOf(oldurl) + "&" + params;
            }
            String[] tmpStrArr = params.split("&");
            String newOrderby = "";
            String newDesc = "";
            int i = 0;
            while (i < tmpStrArr.length) {
                if (tmpStrArr[i].indexOf("pageOrderby") >= 0) {
                    newOrderby = tmpStrArr[i].substring(tmpStrArr[i].indexOf("=") + 1);
                }
                if (tmpStrArr[i].indexOf("pageDesc") >= 0) {
                    newDesc = tmpStrArr[i].substring(tmpStrArr[i].indexOf("=") + 1);
                }
                ++i;
            }
            if (newOrderby.equals("")) {
                this.log.error((Object)("newOrderby\u4e3a\u7a7a\uff01params=" + params + " oldurl=" + oldurl));
            }
            if (newDesc.equals("")) {
                this.log.error((Object)("newDesc\u4e3a\u7a7a\uff01params=" + params + " oldurl=" + oldurl));
            }
            String[] urls = oldurl.split("&");
            int i2 = 0;
            while (i2 < urls.length) {
                if (urls[i2].indexOf("pageOrderby") >= 0) {
                    urls[i2] = "pageOrderby=" + newOrderby;
                } else if (urls[i2].indexOf("pageDesc") >= 0) {
                    urls[i2] = "pageDesc=" + newDesc;
                }
                ++i2;
            }
            StringBuffer newurl = new StringBuffer("");
            int i3 = 0;
            while (i3 < urls.length) {
                if (i3 != 0) {
                    newurl.append("&");
                }
                newurl.append(urls[i3]);
                ++i3;
            }
            return newurl.toString();
        }
        catch (Exception e) {
            this.log.error((Object)("getUrlsByOrderBy " + e));
            return null;
        }
    }

    protected int getSessionStat(ServletRequest request) {
        int loginStat = 0;
        try {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            User user = (User)session.getAttribute("user");
            if (user == null) {
                loginStat = 1;
            } else {
                Hashtable users = new Hashtable();
                users.putAll(UserStatusData.getPlatformUsers());
                if (!users.containsKey(session.getId())) {
                    loginStat = 1;
                }
            }
            if (loginStat == 0) {
                loginStat = this.checkRequestRight(request);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("getSessionStat " + e));
            loginStat = 1;
        }
        return loginStat;
    }

    protected int checkRequestRight(ServletRequest request) {
        int loginStat = 0;
        return loginStat;
    }

    protected boolean isWeblogicCycle(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            Boolean cycleFlag = Boolean.FALSE;
            if (session.getAttribute("cycleFlag") == null) {
                session.setAttribute("cycleFlag", (Object)Boolean.FALSE);
            } else {
                cycleFlag = (Boolean)session.getAttribute("cycleFlag");
            }
            String applicationServer = SysApplication.getApplicationServer();
            if (cycleFlag.booleanValue() && "weblogic".equals(applicationServer)) {
                session.setAttribute("cycleFlag", (Object)Boolean.FALSE);
                filterChain.doFilter(request, response);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)("isWeblogicCycle " + e));
        }
        return false;
    }

    protected void saveRequestAddr(ServletRequest request, String requestDo) {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpSession session = httpServletRequest.getSession(true);
            Stack stack = session.getAttribute("helpIndexList") == null ? new Stack() : (Stack)session.getAttribute("helpIndexList");
            if (stack.search(requestDo) > 0) {
                stack.removeElement(requestDo);
            }
            stack.push(requestDo);
            session.setAttribute("helpIndexList", (Object)stack);
        }
        catch (Exception e) {
            this.log.error((Object)("saveRequestAddr " + e));
        }
    }

    protected String getFullURL(String serverName, int serverPort, String requestParams, String requestUri) {
        String requestURL = "";
        try {
            requestURL = requestParams.length() > 0 ? (serverPort == 80 ? "http://" + serverName + requestUri + "?" + requestParams : "http://" + serverName + ":" + serverPort + requestUri + "?" + requestParams) : (serverPort == 80 ? "http://" + serverName + requestUri : "http://" + serverName + ":" + serverPort + requestUri);
            this.log.info((Object)("------------- " + requestURL));
        }
        catch (Exception e) {
            this.log.error((Object)("getFullURL " + e));
        }
        return requestURL;
    }

    protected String getRequestParams(ServletRequest request) {
        String params = "";
        try {
            StringBuffer param = new StringBuffer("");
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String paramName = (String)e.nextElement();
                String[] paramValue = request.getParameterValues(paramName);
                param.append(paramName);
                param.append("=");
                param.append(paramValue[0]);
                param.append("&");
            }
            if (param.length() > 1) {
                param = param.deleteCharAt(param.length() - 1);
            }
            params = param.toString();
        }
        catch (Exception e) {
            this.log.error((Object)("getRequestParams " + e));
        }
        return params;
    }

    protected String getRequestDo(ServletRequest request) {
        String requestDo = "";
        try {
            requestDo = ((HttpServletRequest)request).getRequestURI().substring(((HttpServletRequest)request).getRequestURI().lastIndexOf("/"), ((HttpServletRequest)request).getRequestURI().length());
        }
        catch (Exception e) {
            this.log.error((Object)("getRequestDo " + e));
        }
        return requestDo;
    }

    protected String getRequestUri(ServletRequest request) {
        String requestUrl = "";
        try {
            requestUrl = ((HttpServletRequest)request).getRequestURI();
        }
        catch (Exception e) {
            this.log.error((Object)("getRequestUri " + e));
        }
        return requestUrl;
    }

    protected String getServerName(ServletRequest request) {
        String requestName = "";
        try {
            requestName = request.getServerName();
        }
        catch (Exception e) {
            this.log.error((Object)("getServerName " + e));
        }
        return requestName;
    }

    protected int getServerPort(ServletRequest request) {
        int requestPort = 80;
        try {
            requestPort = request.getServerPort();
        }
        catch (Exception e) {
            this.log.error((Object)("getServerPort " + e));
        }
        return requestPort;
    }
}

