/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.rdb.impl;

import com.trs.cis4.rdb.IBasicDAO;
import com.trs.cis4.rdb.impl.StandardDAOImpl;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class BasicDAOImpl
extends StandardDAOImpl
implements IBasicDAO {
    public void delete(Object id) throws ExceptionUtil {
        this.getHibernateTemplate().delete(this.get(id));
    }

    public int count() throws ExceptionUtil {
        String className = this.getEntity().getClassName();
        return ((Long)this.getHibernateTemplate().iterate("select count(*) from " + className + " as " + className).next()).intValue();
    }

    public Object get(Object id) throws ExceptionUtil {
        Object object = this.getEntity().getObject();
        Class classBean = (Class)object;
        if (id instanceof String) {
            return this.getHibernateTemplate().get(classBean, (Serializable)((Object)((String)id)));
        }
        return this.getHibernateTemplate().get(classBean, (Serializable)((Integer)id));
    }

    public List gets() throws ExceptionUtil {
        String entityName = this.getEntity().getClassName();
        return this.getHibernateTemplate().find("from " + entityName + " as " + entityName);
    }

    public List gets(String orderBy) throws ExceptionUtil {
        String entityName = this.getEntity().getClassName();
        orderBy = this.processOrderBy(orderBy);
        return this.getHibernateTemplate().find("from " + entityName + " as " + entityName + " order by " + orderBy);
    }

    public int count(String fieldName, String value) throws ExceptionUtil {
        String entityName = this.getEntity().getClassName();
        fieldName = this.processFieldName(fieldName);
        return ((Long)this.getHibernateTemplate().iterate("select count(*) from " + entityName + " as " + entityName + " where " + fieldName + " = '" + value + "'").next()).intValue();
    }

    public List gets(String fieldName, String value) throws ExceptionUtil {
        String entityName = this.getEntity().getClassName();
        fieldName = this.processFieldName(fieldName);
        return this.getHibernateTemplate().find("from " + entityName + " as " + entityName + " where " + fieldName + " = '" + value + "'");
    }

    public List gets(String fieldName, String value, String orderBy) throws ExceptionUtil {
        String entityName = this.getEntity().getClassName();
        fieldName = this.processFieldName(fieldName);
        orderBy = this.processOrderBy(orderBy);
        return this.getHibernateTemplate().find("from " + entityName + " as " + entityName + " where " + fieldName + " = '" + value + "' order by " + orderBy);
    }

    public void save(Object object) throws ExceptionUtil {
        this.getHibernateTemplate().save(object);
    }

    public void update(Object object) throws ExceptionUtil {
        this.getHibernateTemplate().update(object);
    }

    public void saveOrUpdate(Object object) throws ExceptionUtil {
        this.getHibernateTemplate().saveOrUpdate(object);
    }

    public List find(String hql) throws ExceptionUtil {
        return this.getHibernateTemplate().find(hql);
    }

    public boolean contains(Object object) throws DataAccessException {
        return this.getHibernateTemplate().contains(object);
    }

    private String processFieldName(String fieldName) throws ExceptionUtil {
        String entityName = this.getEntity().getClassName();
        if (fieldName.indexOf(entityName) == -1) {
            fieldName = String.valueOf(entityName) + "." + fieldName;
        }
        return fieldName;
    }

    private String processOrderBy(String orderBy) throws ExceptionUtil {
        String entityName = this.getEntity().getClassName();
        if (orderBy.indexOf(entityName) == -1) {
            if (orderBy.indexOf(",") == -1) {
                orderBy = String.valueOf(entityName) + "." + orderBy;
            } else {
                orderBy = "," + orderBy;
                orderBy = StringUtil.replaceString(orderBy, ",", "," + entityName + ".");
                orderBy = orderBy.substring(1);
            }
        }
        return orderBy;
    }
}

