/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.NamingException;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jndi.JndiLocatorSupport;

public class JndiDestinationResolver
extends JndiLocatorSupport
implements DestinationResolver {
    private boolean fallbackToDynamicDestination = false;
    private final Map destinationCache = Collections.synchronizedMap(new HashMap());

    public void setFallbackToDynamicDestination(boolean fallbackToDynamicDestination) {
        this.fallbackToDynamicDestination = fallbackToDynamicDestination;
    }

    public boolean isFallbackToDynamicDestination() {
        return this.fallbackToDynamicDestination;
    }

    public Destination resolveDestinationName(Session session, String destinationName, boolean isPubSubDomain) throws JMSException {
        Object dest = (Destination)this.destinationCache.get(destinationName);
        if (dest == null) {
            try {
                dest = (Destination)this.lookup(destinationName);
            }
            catch (NamingException ex) {
                if (this.isFallbackToDynamicDestination()) {
                    dest = isPubSubDomain ? session.createTopic(destinationName) : session.createQueue(destinationName);
                }
                throw new DestinationResolutionException("Could not get destination name [" + destinationName + "] from JNDI", ex);
            }
            this.destinationCache.put(destinationName, dest);
        }
        return dest;
    }
}

