/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Xid;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import java.io.IOException;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DB2XAResource
implements XAResource {
    private XAConnection xacon;

    public DB2XAResource(XAConnection xAConnection) throws SQLException {
        this.xacon = xAConnection;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n;
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.write(xid.getFormatId());
            dB2Request.write(xid.getGlobalTransactionId());
            dB2Request.write(xid.getBranchQualifier());
            dB2Request.write(bl);
            dB2Request.sendAndRecv();
            n = dB2Request.readInt();
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public void end(Xid xid, int n) throws XAException {
        int n2;
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.write(xid.getFormatId());
            dB2Request.write(xid.getGlobalTransactionId());
            dB2Request.write(xid.getBranchQualifier());
            dB2Request.write(n);
            dB2Request.sendAndRecv();
            n2 = dB2Request.readInt();
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        if (n2 != 0) {
            throw new XAException(n2);
        }
    }

    public void forget(Xid xid) throws XAException {
        int n;
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.write(xid.getFormatId());
            dB2Request.write(xid.getGlobalTransactionId());
            dB2Request.write(xid.getBranchQualifier());
            dB2Request.sendAndRecv();
            n = dB2Request.readInt();
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof DB2XAResource)) {
            return false;
        }
        if ((DB2XAResource)xAResource == this) {
            return true;
        }
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.sendAndRecv();
            return dB2Request.readBoolean();
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n;
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.write(xid.getFormatId());
            dB2Request.write(xid.getGlobalTransactionId());
            dB2Request.write(xid.getBranchQualifier());
            dB2Request.sendAndRecv();
            n = dB2Request.readInt();
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        if (n != 0 && n != 3) {
            throw new XAException(n);
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.write(n);
            dB2Request.sendAndRecv();
            int n2 = dB2Request.readInt();
            if (n2 != 0) {
                throw new XAException(n2);
            }
            int n3 = dB2Request.readInt();
            if (n3 > 0) {
                byte[] byArray = null;
                byte[] byArray2 = null;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = dB2Request.readInt();
                    byArray = dB2Request.readBytes();
                    byArray2 = dB2Request.readBytes();
                    xidArray[n4] = new DB2Xid(n5, byArray, byArray2);
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        int n;
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.write(xid.getFormatId());
            dB2Request.write(xid.getGlobalTransactionId());
            dB2Request.write(xid.getBranchQualifier());
            dB2Request.sendAndRecv();
            n = dB2Request.readInt();
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        int n2;
        try {
            DB2Request dB2Request = new DB2Request(((DB2Connection)this.xacon.getConnection()).getSocket());
            dB2Request.write(xid.getFormatId());
            dB2Request.write(xid.getGlobalTransactionId());
            dB2Request.write(xid.getBranchQualifier());
            dB2Request.write(n);
            dB2Request.sendAndRecv();
            n2 = dB2Request.readInt();
        }
        catch (IOException iOException) {
            throw new XAException(iOException.toString());
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        if (n2 != 0) {
            throw new XAException(n2);
        }
    }
}

