/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2DatabaseMetaData;
import COM.ibm.db2.jdbc.app.DB2DatabaseMetaDataTrace;
import COM.ibm.db2.jdbc.app.DB2Driver;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class DB2Connection
implements Connection {
    protected int connectionHandle = 0;
    protected boolean SPConnected;
    protected DB2Driver ourDriver;
    protected String source;
    protected String user = "";
    protected String password = "";
    protected String conArgs = "";
    protected boolean closed = true;
    protected boolean describeCached = false;
    protected boolean describeParam = true;
    protected int realSqlType = -1;
    protected int blobSqlType = 0;
    protected int returnCode = 0;
    protected int hostType = 0;
    private int typeMaxChar = -1;
    private int typeMaxVarChar = -1;
    private int typeMaxLongVarChar = -1;
    private int typeMaxDecimal = -1;
    private Boolean supportsLOB = null;
    private DB2Statement inputStreamStmt = null;
    int JDBCLevel = 200;
    protected ResourceBundle errMsgClass = null;
    protected SQLExceptionGenerator sqlExcptGen;
    private int sqlSuccess = 0;
    private boolean isLDCompat = false;
    protected boolean isReadOnly = false;
    protected boolean autoClose = false;
    private boolean disconnected = true;
    SQLWarning warnings = null;
    private int[] timeZoneOffset;

    public DB2Connection() {
        int[] nArray = new int[3];
        nArray[0] = 100;
        this.timeZoneOffset = nArray;
    }

    public DB2Connection(String string, Properties properties, int n, boolean bl) throws SQLException {
        int[] nArray = new int[3];
        nArray[0] = 100;
        this.timeZoneOffset = nArray;
        this.connect(string, properties, null, n, bl);
    }

    public DB2Connection(String string, Properties properties, DB2Driver dB2Driver) throws SQLException {
        int[] nArray = new int[3];
        nArray[0] = 100;
        this.timeZoneOffset = nArray;
        this.connect(string, properties, dB2Driver, 0, false);
    }

    public DB2Connection(String string, Properties properties, DB2Driver dB2Driver, int n) throws SQLException {
        int[] nArray = new int[3];
        nArray[0] = 100;
        this.timeZoneOffset = nArray;
        this.connect(string, properties, dB2Driver, n, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2Connection(Properties properties, DB2Driver dB2Driver) throws SQLException {
        int[] nArray = new int[3];
        nArray[0] = 100;
        this.timeZoneOffset = nArray;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Connection( info, " + dB2Driver + " )");
            }
            this.loadDefaultMessage();
            this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
            this.ourDriver = dB2Driver;
            this.warnings = null;
            this.returnCode = this.sqlSuccess;
            this.connectionHandle = this.SPConnect(this.connectionHandle);
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "connectionHandle", this.connectionHandle);
            }
            if (this.returnCode != this.sqlSuccess) {
                try {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                catch (SQLException sQLException) {
                    if (this.connectionHandle <= 0) throw sQLException;
                    this.SQLFreeConnect(this.connectionHandle);
                    throw sQLException;
                }
            }
            this.isReadOnly = false;
            this.realSqlType = -1;
            this.closed = false;
            this.autoClose = false;
            this.SPConnected = true;
            this.disconnected = false;
            try {
                this.setAutoCommit2(true);
            }
            catch (SQLException sQLException) {
            }
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "DB2Connection()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "DB2Connection()");
    }

    protected native int SPConnect(int var1);

    protected native int SQLCommit(int var1);

    protected native int SQLConnect(String var1, int var2);

    protected native int SQLDisconnect(int var1);

    protected native int SQLFreeConnect(int var1);

    protected native int SQLGetConnectOption(int var1, int var2);

    protected native int SQLGetDescribeParamSupported(int var1);

    protected native int SQLGetHostType(int var1);

    protected native int SQLGetTypeMaxLen(int var1, int var2);

    protected native int SQLHasType(int var1, int var2);

    protected native String SQLNativeSQL(String var1, int var2);

    protected native int SQLRollback(int var1);

    protected native int SQLSetCodePage(int var1);

    protected native int SQLSetConnectOptionInt(int var1, int var2, int var3);

    protected native int SQLSetConnectOptionString(int var1, String var2, int var3);

    public synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            SQLWarning sQLWarning2 = this.warnings;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
        }
    }

    int adjust(int n) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "adjust( " + n + " )");
        }
        int n2 = n;
        switch (n) {
            case 9: {
                n2 = 91;
                break;
            }
            case 10: {
                n2 = 92;
                break;
            }
            case 11: {
                n2 = 93;
                break;
            }
            case -95: 
            case -8: {
                n2 = 1;
                break;
            }
            case -96: 
            case -9: {
                n2 = 12;
                break;
            }
            case -97: 
            case -10: {
                n2 = -1;
                break;
            }
            case -350: {
                n2 = -99;
                break;
            }
            case -400: {
                n2 = 70;
                break;
            }
            case -450: {
                n2 = 2001;
                break;
            }
        }
        if (n2 == -99 || n2 == -98) {
            n2 = this.is20() ? (n2 == -99 ? 2005 : 2004) : (n2 == -99 ? -1 : -4);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "adjust()", n2);
        }
        return n2;
    }

    public synchronized void clearWarnings() {
        this.warnings = null;
    }

    public void close() throws SQLException {
        block5: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close( Closed=" + this.closed + " )");
                }
                if (this.closed) break block5;
                this.close2();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "close()", String.valueOf(this.closed));
                    DB2Trace.flush();
                }
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "close()", String.valueOf(this.closed));
            DB2Trace.flush();
        }
    }

    protected synchronized void close2() throws SQLException {
        int n;
        int n2;
        block11: {
            n2 = -99999;
            n = -99999;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close2( Closed=" + this.closed + " Disconnected=" + this.disconnected + ")");
                    DB2Trace.data(10, "connectionHandle", this.connectionHandle);
                }
                if (!this.disconnected) {
                    if (this.inputStreamStmt != null) {
                        try {
                            this.inputStreamStmt.close();
                        }
                        catch (SQLException sQLException) {}
                        this.inputStreamStmt = null;
                    }
                    if ((n2 = this.SQLDisconnect(this.connectionHandle)) != this.sqlSuccess) {
                        this.sqlExcptGen.check_return_code(this, n2);
                    }
                    this.disconnected = true;
                }
                if (this.connectionHandle <= 0) break block11;
                n = this.SQLFreeConnect(this.connectionHandle);
                if (n != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                this.closed = true;
                this.connectionHandle = 0;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "SQLDisconnect()", n2);
                    DB2Trace.data(20, "SQLFreeConnect()", n);
                    DB2Trace.methodExit((Object)this, "close2()", String.valueOf(this.closed));
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(20, "SQLDisconnect()", n2);
            DB2Trace.data(20, "SQLFreeConnect()", n);
            DB2Trace.methodExit((Object)this, "close2()", String.valueOf(this.closed));
        }
    }

    public void commit() throws SQLException {
        int n;
        block5: {
            n = this.sqlSuccess;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "commit()");
                    DB2Trace.data(10, "Connection handle ", this.connectionHandle);
                }
                if ((n = this.SQLCommit(this.connectionHandle)) == this.sqlSuccess) break block5;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "commit()", n);
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "commit()", n);
        }
    }

    private void connect(String string, Properties properties, DB2Driver dB2Driver, int n, boolean bl) throws SQLException {
        try {
            Object object;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "connect( " + string + ", info, " + dB2Driver + ", " + n + ", " + bl + " )");
            }
            this.loadDefaultMessage();
            this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
            this.ourDriver = dB2Driver;
            this.warnings = null;
            this.source = string;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object).equals("user")) {
                    this.user = properties.getProperty("user", "");
                    continue;
                }
                if (((String)object).equals("password")) {
                    this.password = properties.getProperty("password", "");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("JDBCVERSION")) {
                    String string2 = (String)((Hashtable)properties).get(object);
                    if (string2 == null) continue;
                    this.JDBCLevel = new Integer(string2);
                    if (!DB2Trace.TraceOn) continue;
                    DB2Trace.data(20, "JDBCLevel key", this.JDBCLevel);
                    continue;
                }
                if (((String)object).equals("connectionAttribute")) {
                    this.conArgs = String.valueOf(this.conArgs) + ";" + properties.getProperty((String)object, "");
                    continue;
                }
                if (((String)object).equals("language")) continue;
                this.conArgs = String.valueOf(this.conArgs) + ";" + (String)object + "=" + properties.getProperty((String)object, "");
            }
            this.connectionHandle = n;
            this.returnCode = this.sqlSuccess;
            if (!bl) {
                object = this;
                synchronized (object) {
                    this.connectionHandle = this.SQLConnect("DSN=" + string + ";UID=" + this.user + ";PWD=" + this.password + this.conArgs, this.connectionHandle);
                }
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "conArg", this.conArgs);
                DB2Trace.data(10, "connectionHandle", this.connectionHandle);
            }
            if (this.returnCode != this.sqlSuccess) {
                try {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                catch (SQLException sQLException) {
                    if (this.connectionHandle > 0) {
                        this.SQLFreeConnect(this.connectionHandle);
                    }
                    throw sQLException;
                }
            }
            this.isReadOnly = false;
            this.closed = false;
            this.autoClose = false;
            this.SPConnected = false;
            this.disconnected = false;
        }
        finally {
            Object var7_10 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "connect()");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Statement createStatement() throws SQLException {
        DB2Statement dB2Statement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "createStatement()");
            }
            dB2Statement = new DB2Statement(this);
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2Statement;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "createStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "createStatement()");
        return dB2Statement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return new DB2Statement(this, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Statement createStatement(boolean bl) throws SQLException {
        DB2Statement dB2Statement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "createStatement( " + bl + " )");
            }
            dB2Statement = new DB2Statement(this, bl);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return dB2Statement;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "createStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "createStatement()");
        return dB2Statement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            if (!this.closed) {
                String string = "DB2Connection closed in finalizer" + this.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, string);
                }
                DriverManager.println(string);
                try {
                    this.close();
                }
                finally {
                    Object var5_2 = null;
                    if (!this.closed) {
                        this.rollback();
                        this.close();
                    }
                }
            }
            Object var2_7 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "finalize()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "finalize()");
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    public boolean getAutoCommit() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int n = this.SQLGetConnectOption(102, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            if (n == 1) {
                boolean bl = true;
                Object var3_5 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_6 = null;
            return bl;
        }
    }

    protected int getBlobSqlType() throws SQLException {
        if (this.blobSqlType == 0) {
            int n = this.SQLHasType(this.connectionHandle, -98);
            this.blobSqlType = n == 0 ? -98 : -4;
        }
        return this.blobSqlType;
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getConnectOption(int n) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getConnectOption( " + n + " )");
            }
            this.returnCode = this.sqlSuccess;
            n3 = this.SQLGetConnectOption(n, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getConnectOption()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getConnectOption()", n3);
        return n2;
    }

    public int getConnectionHandle() {
        return this.connectionHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDQPFlag() throws SQLException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDQPFlag()");
            }
            n = n2 = this.getConnectOption(2466);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDQPFlag()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getDQPFlag()", n2);
        return n;
    }

    protected int getDecMaxLength(int n, int n2) throws SQLException {
        return this.getTypeMaxLength(n);
    }

    ResourceBundle getErrMsgClass() {
        return this.errMsgClass;
    }

    public int getHandle() {
        return this.connectionHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getHostType() {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getHostType()");
            }
            if (this.hostType == 0) {
                this.hostType = this.SQLGetHostType(this.connectionHandle);
            }
            n = this.hostType;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getHostType()", this.hostType);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getHostType()", this.hostType);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized DB2Statement getInputStreamStmt() throws SQLException {
        DB2Statement dB2Statement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getInputStreamStmt()");
            }
            if (this.inputStreamStmt == null) {
                this.inputStreamStmt = new DB2Statement(this, true);
            }
            dB2Statement = this.inputStreamStmt;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2Statement;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getInputStreamStmt()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getInputStreamStmt()");
        return dB2Statement;
    }

    public final int getJDBCLevel() {
        return this.JDBCLevel;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DB2DatabaseMetaData dB2DatabaseMetaData = DB2Trace.TraceOn ? new DB2DatabaseMetaDataTrace(this) : new DB2DatabaseMetaData(this);
        return dB2DatabaseMetaData;
    }

    protected int getRealSqlType() throws SQLException {
        if (this.realSqlType == -1) {
            int n = this.SQLHasType(this.connectionHandle, 7);
            this.realSqlType = n == 0 ? 7 : 8;
        }
        return this.realSqlType;
    }

    public String getSource() {
        return this.source;
    }

    public int[] getTimeZoneOffset() {
        int[] nArray = this.timeZoneOffset;
        synchronized (nArray) {
            if (this.timeZoneOffset[0] == 100) {
                this.setTimeZoneOffset(this.connectionHandle, this.timeZoneOffset);
            }
        }
        return this.timeZoneOffset;
    }

    public int getTransactionIsolation() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int n = this.SQLGetConnectOption(108, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            int n2 = n;
            Object var3_4 = null;
            return n2;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getTypeMap");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getTypeMaxLength(int n) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTypeMaxLength( " + n + " )");
            }
            switch (n) {
                case -2: 
                case 1: {
                    n3 = this.typeMaxChar;
                    break;
                }
                case -3: 
                case 12: {
                    n3 = this.typeMaxVarChar;
                    break;
                }
                case -4: 
                case -1: {
                    n3 = this.typeMaxLongVarChar;
                    break;
                }
                case -99: 
                case -98: {
                    n3 = Integer.MAX_VALUE;
                    break;
                }
                case -95: {
                    n3 = this.typeMaxChar;
                    if (n3 == -1) break;
                    n3 /= 2;
                    break;
                }
                case -96: {
                    n3 = this.typeMaxVarChar;
                    if (n3 == -1) break;
                    n3 /= 2;
                    break;
                }
                case -97: {
                    n3 = this.typeMaxLongVarChar;
                    if (n3 == -1) break;
                    n3 /= 2;
                    break;
                }
                case -350: {
                    n3 = 0x3FFFFFFF;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = this.typeMaxDecimal;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Length", n3);
            }
            if (n3 == -1) {
                this.returnCode = this.sqlSuccess;
                n3 = this.SQLGetTypeMaxLen(this.connectionHandle, n);
                if (this.sqlSuccess != this.returnCode) {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                switch (n) {
                    case -2: 
                    case 1: {
                        this.typeMaxChar = n3;
                        break;
                    }
                    case -3: 
                    case 12: {
                        this.typeMaxVarChar = n3;
                        break;
                    }
                    case -4: 
                    case -1: {
                        this.typeMaxLongVarChar = n3;
                        break;
                    }
                    case -95: {
                        this.typeMaxChar = n3 * 2;
                        break;
                    }
                    case -96: {
                        this.typeMaxVarChar = n3 * 2;
                        break;
                    }
                    case -97: {
                        this.typeMaxLongVarChar = n3 * 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.typeMaxDecimal = n3;
                        break;
                    }
                }
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getTypeMaxLength()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getTypeMaxLength()", n3);
        return n2;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public final boolean is20() {
        return this.JDBCLevel == 200;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected native boolean isConnectionAlive(int var1);

    protected boolean isDescribeParamSupported() {
        if (this.describeCached) {
            return this.describeParam;
        }
        int n = this.SQLGetDescribeParamSupported(this.connectionHandle);
        this.describeParam = n == this.sqlSuccess;
        this.describeCached = true;
        return this.describeParam;
    }

    protected boolean isLOBSupported() throws SQLException {
        if (this.supportsLOB == null) {
            int n = this.SQLHasType(this.connectionHandle, -98);
            this.supportsLOB = n == 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.supportsLOB;
    }

    public boolean isLongDataCompat() {
        return this.isLDCompat;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    protected void loadDefaultMessage() {
        this.errMsgClass = ResourceBundle.getBundle("COM.ibm.db2.mri.DB2ErrorMessages");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String nativeSQL(String string) throws SQLException {
        String string2;
        String string3 = null;
        this.returnCode = this.sqlSuccess;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "nativeSQL( " + string + " )");
            }
            DB2Connection dB2Connection = this;
            synchronized (dB2Connection) {
                string3 = this.SQLNativeSQL(string, this.connectionHandle);
            }
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            string2 = string3;
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return string2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "nativeSQL()", string3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "nativeSQL()", string3);
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        DB2CallableStatement dB2CallableStatement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareCall( " + string + " )");
            }
            dB2CallableStatement = new DB2CallableStatement(string, this);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return dB2CallableStatement;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "prepareCall()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "prepareCall()");
        return dB2CallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return new DB2CallableStatement(string, this, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        DB2PreparedStatement dB2PreparedStatement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareStatement( " + string + " )");
            }
            dB2PreparedStatement = new DB2PreparedStatement(string, this);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return dB2PreparedStatement;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "prepareStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "prepareStatement()");
        return dB2PreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new DB2PreparedStatement(string, this, n, n2);
    }

    public void rollback() throws SQLException {
        int n;
        block5: {
            n = this.sqlSuccess;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "rollback()");
                    DB2Trace.data(10, "Connection handle ", this.connectionHandle);
                }
                if ((n = this.SQLRollback(this.connectionHandle)) == this.sqlSuccess) break block5;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "rollback()", n);
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "rollback()", n);
        }
    }

    public void setAutoClose(boolean bl) throws SQLException {
        if (bl) {
            this.sqlExcptGen.connException("S1C00");
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.setAutoCommit2(bl);
        }
    }

    protected void setAutoCommit2(boolean bl) throws SQLException {
        int n;
        block5: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setAutoCommit2( " + bl + " )");
                    DB2Trace.data(10, "Connection handle ", this.connectionHandle);
                }
                if ((n = bl ? this.SQLSetConnectOptionInt(102, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(102, 0, this.connectionHandle)) == this.sqlSuccess) break block5;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "setAutoCommit2()", n);
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setAutoCommit2()", n);
        }
    }

    public void setCatalog(String string) throws SQLException {
    }

    synchronized void setClosed(boolean bl) {
        this.closed = bl;
    }

    public void setCodePage(int n) throws SQLException {
        int n2 = this.SQLSetCodePage(n);
        if (n2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
    }

    public void setConnectOption(int n, int n2) throws SQLException {
        int n3 = this.SQLSetConnectOptionInt(n, n2, this.connectionHandle);
        if (n3 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, n3);
        }
    }

    public void setConnectOption(int n, String string) throws SQLException {
        int n2;
        if (string == null) {
            string = "";
        }
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            n2 = this.SQLSetConnectOptionString(n, string, this.connectionHandle);
        }
        if (n2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
    }

    public void setDQPFlag(int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDQPFlag( " + n + " )");
            }
            this.setConnectOption(2466, n);
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setDQPFlag()");
            }
        }
    }

    void setErrMsgClass(ResourceBundle resourceBundle) {
        this.errMsgClass = resourceBundle;
        this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
    }

    public void setLongDataCompat(boolean bl) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            int n = bl ? this.SQLSetConnectOptionInt(1253, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(1253, 0, this.connectionHandle);
            if (n != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, n);
            }
            this.isLDCompat = bl;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.isReadOnly != bl) {
            int n = 0;
            DB2Connection dB2Connection = this;
            synchronized (dB2Connection) {
                n = bl ? this.SQLSetConnectOptionInt(101, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(101, 0, this.connectionHandle);
            }
            if (n != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, n);
            }
            this.isReadOnly ^= true;
        }
    }

    private native void setTimeZoneOffset(int var1, int[] var2);

    public void setTransactionIsolation(int n) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            int n2 = this.SQLSetConnectOptionInt(108, n, this.connectionHandle);
            if (n2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setTypeMap");
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("\n" + string + "DB2Connection\n" + string + "{\n");
        stringBuffer.append(String.valueOf(string) + "    connectionHandle = " + this.connectionHandle + "\n");
        stringBuffer.append(String.valueOf(string) + "    SPConnected = " + this.SPConnected + "\n");
        stringBuffer.append(String.valueOf(string) + "    source = " + this.source + "\n");
        stringBuffer.append(String.valueOf(string) + "    user = " + this.user + "\n");
        stringBuffer.append(String.valueOf(string) + "    conArgs = " + this.conArgs + "\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\n");
        stringBuffer.append(String.valueOf(string) + "    describeCached = " + this.describeCached + "\n");
        stringBuffer.append(String.valueOf(string) + "    describeParam = " + this.describeParam + "\n");
        stringBuffer.append(String.valueOf(string) + "    isReadOnly = " + this.isReadOnly + "\n");
        stringBuffer.append(String.valueOf(string) + "    autoClose = " + this.autoClose + "\n");
        stringBuffer.append(String.valueOf(string) + "    LONGDATA compat = " + this.isLDCompat + "\n");
        stringBuffer.append(String.valueOf(string) + "}\n");
        return stringBuffer.toString();
    }
}

