/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2ConnectionInfo;
import COM.ibm.db2.jdbc.DB2PooledConnection;
import COM.ibm.db2.jdbc.DB2Trace;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

class DB2ConnectionPool
implements ConnectionEventListener {
    private DB2ConnectionInfo[] connectionList = new DB2ConnectionInfo[1024];
    private int numConnections = 0;
    private int lastEntryChecked = -1;

    DB2ConnectionPool() {
    }

    void clear() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "clear()");
        }
        DB2ConnectionInfo dB2ConnectionInfo = null;
        int n = 0;
        while (n < this.numConnections) {
            dB2ConnectionInfo = this.connectionList[n];
            if (dB2ConnectionInfo.isValid()) {
                dB2ConnectionInfo.getPooledConnection().close();
            }
            ++n;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "clear()");
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "connectionClosed( event )");
        }
        DB2PooledConnection dB2PooledConnection = (DB2PooledConnection)connectionEvent.getSource();
        int n = dB2PooledConnection.getID();
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "numConnections", this.numConnections);
        }
        if (n == 0) {
            this.connectionList[this.numConnections] = new DB2ConnectionInfo();
            this.connectionList[this.numConnections].setPooledConnection(dB2PooledConnection);
            ++this.numConnections;
            dB2PooledConnection.setID(this.numConnections);
        } else {
            this.connectionList[n - 1].setAvailable(true);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "connectionClosed()");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        DB2PooledConnection dB2PooledConnection;
        int n;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "connectionErrorOccurred( event )");
        }
        if ((n = (dB2PooledConnection = (DB2PooledConnection)connectionEvent.getSource()).getID()) != 0) {
            this.connectionList[n - 1].setValid(false);
        }
        try {
            dB2PooledConnection.close();
        }
        catch (SQLException sQLException) {}
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "connectionErrorOccurred()");
        }
    }

    PooledConnection lookup(String string, String string2) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "lookup()");
        }
        PooledConnection pooledConnection = null;
        int n = this.lastEntryChecked + 1;
        pooledConnection = this.searchList(n, this.numConnections, string, string2);
        if (pooledConnection == null) {
            pooledConnection = this.searchList(0, n, string, string2);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "lookup()");
        }
        return pooledConnection;
    }

    PooledConnection searchList(int n, int n2, String string, String string2) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "searchList( " + n + ", " + n2 + ", " + string + ", <password> )");
        }
        DB2ConnectionInfo dB2ConnectionInfo = null;
        DB2PooledConnection dB2PooledConnection = null;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        int n3 = n;
        while (n3 < n2) {
            this.lastEntryChecked = n3;
            dB2ConnectionInfo = this.connectionList[n3];
            if (dB2ConnectionInfo.isAvailable() && dB2ConnectionInfo.isValid()) {
                dB2PooledConnection = (DB2PooledConnection)dB2ConnectionInfo.getPooledConnection();
                if (string.equals(dB2PooledConnection.info.getProperty("user", "")) && string2.equals(dB2PooledConnection.info.getProperty("password", ""))) {
                    dB2ConnectionInfo.setAvailable(false);
                    break;
                }
                dB2PooledConnection = null;
            }
            ++n3;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "searchList()", dB2PooledConnection == null ? "null" : "PooledConnection(id=" + (n3 + 1) + ")");
        }
        return dB2PooledConnection;
    }
}

