/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobReader;
import COM.ibm.db2.app.ClobWithIO;
import COM.ibm.db2.app.ClobWriter;
import COM.ibm.db2.app.Lob;
import java.io.Reader;
import java.io.Writer;

class ClobWithDB2Buffer
extends Lob
implements ClobWithIO {
    int bufferPtr;
    int bufferSize;
    int bufferUsedPtr;
    int bufferType;
    int bufferCodepage;

    ClobWithDB2Buffer(int n, int n2, int n3, int n4, int n5) throws Exception {
        this.bufferPtr = n;
        this.bufferSize = n2;
        this.bufferUsedPtr = n3;
        this.bufferType = n4;
        this.bufferCodepage = n5;
    }

    public void close() {
        this.bufferPtr = 0;
    }

    void assertOpen() throws Exception {
        if (this.bufferPtr == 0) {
            throw new Exception("Clob is closed.");
        }
    }

    public long size() throws Exception {
        this.assertOpen();
        return ClobWithDB2Buffer.getSize(this.bufferUsedPtr, this.bufferType, this.bufferCodepage);
    }

    public Reader getReader() throws Exception {
        return new ClobReader(this);
    }

    public Writer getWriter() throws Exception {
        return new ClobWriter(this);
    }

    public synchronized void append(char[] cArray, int n, int n2) throws Exception {
        this.assertOpen();
        if (this.size() + (long)n2 > (long)this.bufferSize) {
            throw new Exception("cannot exceed maximum length: " + this.bufferSize);
        }
        ClobWithDB2Buffer.doAppend(cArray, n, n2, this.bufferPtr, this.bufferUsedPtr, this.bufferType, this.bufferCodepage);
    }

    public synchronized int substr(int n, char[] cArray, int n2, int n3) throws Exception {
        this.assertOpen();
        int n4 = Math.min((int)this.size() - n, n3);
        ClobWithDB2Buffer.doSubstr(n, cArray, n2, n3, this.bufferPtr, this.bufferType, this.bufferCodepage);
        return n4;
    }

    static native int getSize(int var0, int var1, int var2) throws Exception;

    static native int getMaxSize(int var0, int var1, int var2) throws Exception;

    static native void doAppend(char[] var0, int var1, int var2, int var3, int var4, int var5, int var6) throws Exception;

    static native void doSubstr(int var0, char[] var1, int var2, int var3, int var4, int var5, int var6) throws Exception;
}

