/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import sun.rmi.rmic.Main;

public class Rmic
extends MatchingTask {
    private String base;
    private String classname;
    private String sourceBase;
    private String stubVersion;
    private Path compileClasspath;
    private boolean verify = false;
    private boolean filtering = false;
    private Vector compileList = new Vector();
    static /* synthetic */ Class class$java$rmi$Remote;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void execute() throws BuildException {
        int j;
        File baseDir = this.project.resolveFile(this.base);
        if (baseDir == null) {
            throw new BuildException("base attribute must be set!", this.location);
        }
        if (!baseDir.exists()) {
            throw new BuildException("base does not exist!", this.location);
        }
        if (this.verify) {
            this.log("Verify has been turned on.", 2);
        }
        File sourceBaseFile = null;
        if (this.sourceBase != null) {
            sourceBaseFile = this.project.resolveFile(this.sourceBase);
        }
        Path classpath = this.getCompileClasspath(baseDir);
        if (this.classname == null) {
            DirectoryScanner ds = this.getDirectoryScanner(baseDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(baseDir, files, this.verify);
        }
        Main compiler = new Main((OutputStream)System.out, "rmic");
        int argCount = 5;
        int i = 0;
        if (this.stubVersion != null) {
            ++argCount;
        }
        if (this.sourceBase != null) {
            ++argCount;
        }
        if (this.compileList.size() > 0) {
            argCount += this.compileList.size() - 1;
        }
        String[] args = new String[argCount];
        args[i++] = "-d";
        args[i++] = baseDir.getAbsolutePath();
        args[i++] = "-classpath";
        args[i++] = classpath.toString();
        if (this.stubVersion != null) {
            args[i++] = "1.1".equals(this.stubVersion) ? "-v1.1" : ("1.2".equals(this.stubVersion) ? "-v1.2" : "-vcompat");
        }
        if (this.sourceBase != null) {
            args[i++] = "-keepgenerated";
        }
        if (this.classname != null) {
            if (this.shouldCompile(new File(baseDir, String.valueOf(this.classname.replace('.', File.separatorChar)) + ".class"))) {
                args[i++] = this.classname;
                compiler.compile(args);
            }
        } else if (this.compileList.size() > 0) {
            this.log("RMI Compiling " + this.compileList.size() + " classes to " + baseDir, 2);
            j = 0;
            while (j < this.compileList.size()) {
                args[i++] = (String)this.compileList.elementAt(j);
                ++j;
            }
            compiler.compile(args);
        }
        if (this.sourceBase != null) {
            if (this.classname != null) {
                this.moveGeneratedFile(baseDir, sourceBaseFile, this.classname);
            } else {
                j = 0;
                while (j < this.compileList.size()) {
                    this.moveGeneratedFile(baseDir, sourceBaseFile, (String)this.compileList.elementAt(j));
                    ++j;
                }
            }
        }
    }

    private Path getCompileClasspath(File baseFile) {
        String bootcp;
        Path classpath = new Path(this.project, baseFile.getAbsolutePath());
        if (this.compileClasspath != null) {
            classpath.addExisting(this.compileClasspath);
        }
        classpath.addExisting(Path.systemClasspath);
        if (Project.getJavaVersion().startsWith("1.2") && (bootcp = System.getProperty("sun.boot.class.path")) != null) {
            classpath.addExisting(new Path(this.project, bootcp));
        }
        return classpath;
    }

    private boolean isValidRmiRemote(Class testClass) {
        Class rmiRemote;
        Class clazz = rmiRemote = class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = Rmic.class$("java.rmi.Remote"));
        if (rmiRemote.equals(testClass)) {
            return true;
        }
        Class<?>[] interfaces = testClass.getInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                if (rmiRemote.equals(interfaces[i])) {
                    return true;
                }
                if (this.isValidRmiRemote(interfaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void moveGeneratedFile(File baseDir, File sourceBaseFile, String classname) throws BuildException {
        String stubFileName = String.valueOf(classname.replace('.', File.separatorChar)) + "_Stub.java";
        File oldStubFile = new File(baseDir, stubFileName);
        File newStubFile = new File(sourceBaseFile, stubFileName);
        try {
            this.project.copyFile(oldStubFile, newStubFile, this.filtering);
            oldStubFile.delete();
        }
        catch (IOException ioe) {
            String msg = "Failed to copy " + oldStubFile + " to " + newStubFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.location);
        }
        if (!"1.2".equals(this.stubVersion)) {
            String skelFileName = String.valueOf(classname.replace('.', '/')) + "_Skel.java";
            File oldSkelFile = new File(baseDir, skelFileName);
            File newSkelFile = new File(sourceBaseFile, skelFileName);
            try {
                this.project.copyFile(oldSkelFile, newSkelFile, this.filtering);
                oldSkelFile.delete();
            }
            catch (IOException ioe) {
                String msg = "Failed to copy " + oldSkelFile + " to " + newSkelFile + " due to " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.location);
            }
        }
    }

    protected void scanDir(File baseDir, String[] files, boolean shouldVerify) {
        this.compileList.removeAllElements();
        int i = 0;
        while (i < files.length) {
            File baseFile = new File(baseDir, files[i]);
            if (files[i].endsWith(".class") && !files[i].endsWith("_Stub.class") && !files[i].endsWith("_Skel.class") && this.shouldCompile(baseFile)) {
                String classname = files[i].replace(File.separatorChar, '.');
                classname = classname.substring(0, classname.indexOf(".class"));
                boolean shouldAdd = true;
                if (shouldVerify) {
                    try {
                        Class<?> testClass = Class.forName(classname);
                        if (testClass.isInterface() || !this.isValidRmiRemote(testClass)) {
                            shouldAdd = false;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.log("Unable to verify class " + classname + ". It could not be found.", 1);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        this.log("Unable to verify class " + classname + ". It is not defined.", 1);
                    }
                }
                if (shouldAdd) {
                    this.log("Adding: " + classname + " to compile list", 3);
                    this.compileList.addElement(classname);
                }
            }
            ++i;
        }
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setFiltering(boolean filter) {
        this.filtering = filter;
    }

    public void setSourceBase(String sourceBase) {
        this.sourceBase = sourceBase;
    }

    public void setStubVersion(String stubVersion) {
        this.stubVersion = stubVersion;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    private boolean shouldCompile(File classFile) {
        long now = new Date().getTime();
        File stubFile = new File(String.valueOf(classFile.getAbsolutePath().substring(0, classFile.getAbsolutePath().indexOf(".class"))) + "_Stub.class");
        File skelFile = new File(String.valueOf(classFile.getAbsolutePath().substring(0, classFile.getAbsolutePath().indexOf(".class"))) + "_Skel.class");
        if (classFile.exists()) {
            if (classFile.lastModified() > now) {
                this.log("Warning: file modified in the future: " + classFile, 1);
            }
            if (classFile.lastModified() > stubFile.lastModified()) {
                return true;
            }
            return classFile.lastModified() > skelFile.lastModified();
        }
        return true;
    }
}

