/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import java.util.StringTokenizer;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserFeedback;

public class HTMLTagParser {
    public static final int TAG_BEFORE_PARSING_STATE = 1;
    public static final int TAG_BEGIN_PARSING_STATE = 2;
    public static final int TAG_FINISHED_PARSING_STATE = 3;
    public static final int TAG_ILLEGAL_STATE = 4;
    public static final int TAG_IGNORE_DATA_STATE = 5;
    public static final int TAG_IGNORE_BEGIN_TAG_STATE = 6;
    public static final String ENCOUNTERED_QUERY_MESSAGE = "HTMLTagParser : Encountered > after a query. Accepting without correction and continuing parsing";
    private HTMLParserFeedback feedback;
    private boolean encounteredQuery;
    private int i;

    public HTMLTagParser(HTMLParserFeedback feedback) {
        this.feedback = feedback;
    }

    public HTMLTag find(HTMLReader reader, String input, int position) {
        int state = 1;
        StringBuffer tagContents = new StringBuffer();
        this.i = position;
        HTMLTag tag = new HTMLTag(0, 0, "", input, reader.getLineCount() - 1);
        this.encounteredQuery = false;
        while (this.i < tag.getTagLine().length() && state != 3 && state != 4) {
            char ch = tag.getTagLine().charAt(this.i);
            state = this.automataInput(state, ch, tag);
            this.i = this.incrementCounter(reader, state, tag);
        }
        if (state == 3) {
            return tag;
        }
        return null;
    }

    protected int automataInput(int state, char ch, HTMLTag tag) {
        state = this.checkIllegalState(state, ch, tag);
        state = this.checkFinishedState(state, ch, tag);
        if ((state = this.toggleIgnoringState(state, ch)) == 5 && ch == '<') {
            state = 6;
        }
        if (state == 6 && ch == '>') {
            state = 5;
        }
        this.checkIfAppendable(state, ch, tag);
        state = this.checkBeginParsingState(state, ch, tag);
        return state;
    }

    private int checkBeginParsingState(int state, char ch, HTMLTag tag) {
        if (ch == '<' && (state == 1 || state == 4)) {
            tag.setTagBegin(this.i);
            state = 2;
        }
        return state;
    }

    private int checkFinishedState(int state, char ch, HTMLTag tag) {
        if (ch == '>') {
            if (state == 2) {
                state = 3;
                tag.setTagEnd(this.i);
            } else if (state == 5) {
                if (this.encounteredQuery) {
                    this.encounteredQuery = false;
                    this.feedback.info(ENCOUNTERED_QUERY_MESSAGE);
                    return state;
                }
                state = 3;
                tag.setTagEnd(this.i);
                this.correctTag(tag);
                StringBuffer msg = new StringBuffer();
                msg.append("HTMLTagParser : Encountered > inside inverted commas in line \n");
                msg.append(tag.getTagLine());
                msg.append(", location ");
                msg.append(this.i);
                msg.append("\n");
                for (int j = 0; j < this.i; ++j) {
                    msg.append(' ');
                }
                msg.append('^');
                msg.append("\nAutomatically corrected.");
                this.feedback.warning(msg.toString());
            }
        } else if (ch == '<' && state == 2 && tag.getText().charAt(0) != '%') {
            state = 3;
            tag.setTagEnd(this.i - 1);
            --this.i;
        }
        return state;
    }

    private void checkIfAppendable(int state, char ch, HTMLTag tag) {
        if (state == 5 || state == 2 || state == 6) {
            if (ch == '?') {
                this.encounteredQuery = true;
            }
            tag.append(ch);
        }
    }

    private int checkIllegalState(int state, char ch, HTMLTag tag) {
        if (ch == '/' && this.i > 0 && tag.getTagLine().charAt(this.i - 1) == '<' && state != 5 && state != 6) {
            state = 4;
        }
        return state;
    }

    public void correctTag(HTMLTag tag) {
        if (tag.getTagName() != null && (tag.getTagName().equalsIgnoreCase("TRS_COLUMN") || tag.getTagName().equalsIgnoreCase("TRS_OUTLINE"))) {
            return;
        }
        String tempText = tag.getText();
        StringBuffer absorbedText = new StringBuffer();
        for (int j = 0; j < tempText.length(); ++j) {
            char c = tempText.charAt(j);
            if (c == '\"') continue;
            absorbedText.append(c);
        }
        StringBuffer result = this.insertInvertedCommasCorrectly(absorbedText);
        tag.setText(result.toString());
    }

    public StringBuffer insertInvertedCommasCorrectly(StringBuffer absorbedText) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(absorbedText.toString(), "=", false);
        String token = tok.nextToken();
        result.append(String.valueOf(String.valueOf(token)).concat("="));
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
            token = HTMLTagParser.pruneSpaces(token);
            result.append('\"');
            int lastIndex = token.lastIndexOf(32);
            if (lastIndex != -1 && tok.hasMoreTokens()) {
                result.append(token.substring(0, lastIndex));
                result.append('\"');
                result.append(token.substring(lastIndex, token.length()));
            } else {
                result.append(String.valueOf(String.valueOf(token)).concat(String.valueOf(String.valueOf('\"'))));
            }
            if (!tok.hasMoreTokens()) continue;
            result.append("=");
        }
        return result;
    }

    public static String pruneSpaces(String token) {
        int firstSpace = token.indexOf(32);
        while (firstSpace == 0) {
            token = token.substring(1, token.length());
            firstSpace = token.indexOf(32);
        }
        int lastSpace = token.lastIndexOf(32);
        while (lastSpace == token.length() - 1) {
            token = token.substring(0, token.length() - 1);
            lastSpace = token.lastIndexOf(32);
        }
        return token;
    }

    private int toggleIgnoringState(int state, char ch) {
        if (ch == '\"' || ch == '\'') {
            if (state == 5) {
                state = 2;
            } else if (state == 2) {
                state = 5;
            }
        }
        return state;
    }

    public int incrementCounter(HTMLReader reader, int state, HTMLTag tag) {
        String nextLine = null;
        if ((state == 2 || state == 5) && this.i == tag.getTagLine().length() - 1) {
            while ((nextLine = reader.getNextLine()) != null && nextLine.length() == 0) {
            }
            if (nextLine == null) {
                nextLine = ">";
            } else {
                tag.append(HTMLNode.getLineSeparator());
            }
            tag.setTagLine(nextLine);
            this.i = -1;
        }
        return ++this.i;
    }

    static {
        TAG_BEFORE_PARSING_STATE = 1;
        TAG_BEGIN_PARSING_STATE = 2;
        TAG_FINISHED_PARSING_STATE = 3;
        TAG_ILLEGAL_STATE = 4;
        TAG_IGNORE_DATA_STATE = 5;
        TAG_IGNORE_BEGIN_TAG_STATE = 6;
        ENCOUNTERED_QUERY_MESSAGE = ENCOUNTERED_QUERY_MESSAGE;
    }
}

