/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class JSLocaleProperties {
    private static Logger logger = Logger.getLogger(JSLocaleProperties.class);
    public static final String SEPARATOR_IN_ITEM = "=============";
    public static final String SEPARATOR_BETWEEN_ITEM = "#####################################";
    public static final String FILE_ENCODING = "GB2312";

    public static SortedMap load(String sLocaleFileName) throws CMyException {
        TreeMap<String, String> properties = new TreeMap<String, String>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String pair1 = (String)o1;
                String pair2 = (String)o2;
                return pair1.compareTo(pair2);
            }
        });
        String sEncoding = CharsetDetector.detect(sLocaleFileName);
        String sContent = CMyFile.readFile(sLocaleFileName, sEncoding);
        String[] items = sContent.split(SEPARATOR_BETWEEN_ITEM);
        for (int i = 0; i < items.length; ++i) {
            String[] info;
            if (items[i].trim().length() <= 0 || (info = items[i].trim().split(SEPARATOR_IN_ITEM)).length < 1 || CMyString.isEmpty(info[0])) continue;
            properties.put(info[0].trim(), info.length > 1 ? info[1].trim() : "");
        }
        return properties;
    }

    public static void store(String sLocaleFileName, Map properties) throws CMyException {
        if (properties.size() <= 0) {
            return;
        }
        StringBuffer sbResult = new StringBuffer(properties.size() * 100);
        for (Map.Entry entry : properties.entrySet()) {
            sbResult.append(entry.getKey());
            sbResult.append("\n");
            sbResult.append(SEPARATOR_IN_ITEM);
            sbResult.append("\n");
            sbResult.append(CMyString.showNull((String)entry.getValue()));
            sbResult.append("\n");
            sbResult.append(SEPARATOR_BETWEEN_ITEM);
            sbResult.append("\n");
        }
        CMyFile.writeFile(sLocaleFileName, sbResult.toString(), FILE_ENCODING);
    }

    public static void merge(String sLocaleFileName1, String sLocaleFileName2, String sOutputFile) throws CMyException {
        SortedMap locales1 = JSLocaleProperties.load(sLocaleFileName1);
        SortedMap locales2 = JSLocaleProperties.load(sLocaleFileName2);
        for (Map.Entry entry : locales1.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (locales2.containsKey(key)) {
                if (value.equals(locales2.get(key))) continue;
                logger.warn((Object)("\u51fa\u73b0\u4e86\u91cd\u590d\u5b9a\u4e49\u7684\u8d44\u6e90\u53d8\u91cf\uff0ckey\u76f8\u540c\uff1a[" + key + "]\n\u4f46value\u4e0d\u540c\uff1a\n[" + value + "]\n[" + locales2.get(key) + "]\n"));
                continue;
            }
            locales2.put(key, entry.getValue());
        }
        if (sOutputFile.equals(sLocaleFileName2)) {
            CMyFile.copyFile(sLocaleFileName2, sLocaleFileName2 + ".bak");
        }
        JSLocaleProperties.store(sOutputFile, locales2);
    }

    public static void findNotExistsKeyToFile(String sTmpLocaleFileName, String sLocaleFileName, String sOutputFile) throws CMyException {
        TreeMap m_newLocales = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                String pair1 = (String)o1;
                String pair2 = (String)o2;
                return pair1.compareTo(pair2);
            }
        });
        SortedMap tmpLocales = JSLocaleProperties.load(sTmpLocaleFileName);
        SortedMap locales = JSLocaleProperties.load(sLocaleFileName);
        for (Map.Entry entry : tmpLocales.entrySet()) {
            Object key = entry.getKey();
            if (locales.containsKey(key)) continue;
            m_newLocales.put(key, entry.getValue());
        }
        JSLocaleProperties.store(sOutputFile, m_newLocales);
    }

    public static void main(String[] args) throws CMyException {
        if (args.length < 3) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u56db\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u5bf9\u8d44\u6e90\u6587\u4ef6\u5c06\u8fdb\u884c\u7684\u64cd\u4f5c\uff0c\u5982\uff1amerge,findNotExistsKeyToFile\n");
            sbInfo.append("\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u8d44\u6e90\u6587\u4ef6\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/wcm6-locale/js_en_tmp.properties");
            sbInfo.append("\n\u7b2c\u4e09\u4e2a\u53c2\u6570\u5df2\u7ecf\u7ffb\u8bd1\u597d\u7684\u6807\u51c6\u8d44\u6e90\u6587\u4ef6\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/wcm6-locale/js_en.properties");
            sbInfo.append("\n\u7b2c\u56db\u4e2a\u53c2\u6570\u662f\u524d\u4e24\u4e2a\u8d44\u6e90\u6587\u4ef6\u8fdb\u884c\u67d0\u79cd\u64cd\u4f5c\u4e4b\u540e\u7684\u4ea7\u751f\u7684\u8d44\u6e90\u6587\u4ef6\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/wcm6-locale/js_en_4_translation.properties");
            logger.error((Object)sbInfo);
            return;
        }
        if ("merge".equalsIgnoreCase(args[0])) {
            JSLocaleProperties.merge(args[1], args[2], args[3]);
        } else {
            JSLocaleProperties.findNotExistsKeyToFile(args[1], args[2], args[3]);
        }
    }
}

