/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.scm.domain.ISCMAccountMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.sdk.OAuthTemp.AutoOAuth4Code;
import com.trs.scm.service.SCMWorkFlowServiceProvider;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.dbunit.util.Base64;
import weibo4j.http.AccessToken;

public class SinaAutoBindTimer
extends TimerTask {
    private ISCMAccountMgr m_oSCMAccountMgr = (ISCMAccountMgr)DreamFactory.createObjectById("ISCMAccountMgr");
    private static Logger logger = Logger.getLogger(SCMWorkFlowServiceProvider.class);

    @Override
    public void run() {
        ContextHelper.initContext(User.findByName("admin"));
        long sExpireIn = 72000L;
        try {
            WCMFilter oFilter = new WCMFilter("", "STATUS=1 and ISAUTOBIND=1", "");
            Accounts tempAccounts = this.m_oSCMAccountMgr.query(oFilter);
            if (tempAccounts != null) {
                boolean isFirst = true;
                for (int i = 0; i < tempAccounts.size(); ++i) {
                    Account tempAccount = (Account)tempAccounts.getAt(i);
                    if (tempAccount == null) continue;
                    String sUserId = tempAccount.getUserId();
                    String sPasswd = Base64.decodeToString((String)tempAccount.getAccountPassword());
                    if (CMyString.isEmpty(sUserId) && CMyString.isEmpty(sPasswd)) {
                        logger.debug((Object)("\u6b64\u65b0\u6d6a\u8d26\u53f7UID=[" + tempAccount.getUId() + "]\uff0c\u81ea\u52a8\u6388\u6743\u4fe1\u606f\u4e0d\u5b58\u5728\u8bf7\u786e\u8ba4\u662f\u5426\u5f00\u542f\u4e86\u65b0\u6d6a\u8d26\u53f7\u81ea\u52a8\u5ef6\u671f\uff01\uff08\u82e5\u672a\u5f00\u542f\u6b64\u6761\u4fe1\u606f\u53ef\u5ffd\u7565\uff09"));
                    }
                    String sAutoOAuth = null;
                    AccessToken oAutoOAuth = AutoOAuth4Code.AccessTokenRefresh(sUserId, sPasswd);
                    String sAutoToken = null;
                    if (oAutoOAuth != null && oAutoOAuth.toString().indexOf("accessToken=") > 0) {
                        sAutoOAuth = oAutoOAuth.toString();
                        sAutoToken = sAutoOAuth.substring(sAutoOAuth.indexOf("accessToken=") + 12, sAutoOAuth.indexOf(","));
                        if (isFirst) {
                            sExpireIn = Long.parseLong(sAutoOAuth.substring(sAutoOAuth.indexOf("expireIn=") + 9, sAutoOAuth.indexOf(", ref")));
                            isFirst = false;
                        }
                    }
                    if (sAutoToken == null) continue;
                    tempAccount.setAccessToken(sAutoToken);
                    long ltime = System.currentTimeMillis();
                    CMyDateTime ct = new CMyDateTime(sExpireIn * 1000L + ltime);
                    tempAccount.setExpiresIn(ct.getDateTimeAsString("yyyy-MM-dd hh:mm:ss"));
                    tempAccount.save();
                }
            }
            Timer timer = new Timer();
            timer.schedule((TimerTask)new SinaAutoBindTimer(), (sExpireIn - 3600L) * 1000L);
        }
        catch (Exception e) {
            logger.debug((Object)"\u65b0\u6d6a\u8d26\u53f7\u81ea\u52a8\u5ef6\u671f\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }
}

