/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j.analysis;

import com.chenlb.mmseg4j.Dictionary;
import com.chenlb.mmseg4j.MaxWordSeg;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.analysis.MMSegTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public class MMSegAnalyzer
extends Analyzer {
    protected Dictionary dic;

    public MMSegAnalyzer() {
        this.dic = Dictionary.getInstance();
    }

    public MMSegAnalyzer(String string) {
        this.dic = Dictionary.getInstance(string);
    }

    public MMSegAnalyzer(File file) {
        this.dic = Dictionary.getInstance(file);
    }

    public MMSegAnalyzer(Dictionary dictionary) {
        this.dic = dictionary;
    }

    protected Seg newSeg() {
        return new MaxWordSeg(this.dic);
    }

    public Dictionary getDict() {
        return this.dic;
    }

    public TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        MMSegTokenizer mMSegTokenizer = (MMSegTokenizer)((Object)this.getPreviousTokenStream());
        if (mMSegTokenizer == null) {
            mMSegTokenizer = new MMSegTokenizer(this.newSeg(), reader);
            this.setPreviousTokenStream((Object)mMSegTokenizer);
        } else {
            mMSegTokenizer.reset(reader);
        }
        return mMSegTokenizer;
    }

    public TokenStream tokenStream(String string, Reader reader) {
        MMSegTokenizer mMSegTokenizer = new MMSegTokenizer(this.newSeg(), reader);
        return mMSegTokenizer;
    }
}

