/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.MultipartUpload;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestBase {
    protected static String bucketName;
    protected static OSSClient defaultClient;
    protected static OSSClient secondClient;
    private static final Credentials defaultCreds;
    private static final Credentials secondCreds;
    protected static final String DEFAULT_ENCODING_TYPE = "url";
    protected static final String APPENDABLE_OBJECT_TYPE = "Appendable";
    protected static final int LIST_PART_MAX_RETURNS = 1000;

    static {
        defaultCreds = new DefaultCredentials("k6v3sL0ZTaIaVvMs", "aIEyqeEnFhBi9LqsODzFaHP9lPodTQ");
        secondCreds = new DefaultCredentials("nz2pc56s936cv9l", "dGkyeDRoa3NwdmJnajN2ZnVmMjA");
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        TestBase.cleanUpAllBuckets(TestBase.getDefaultClient(), "oss-java-sdk-");
        TestBase.cleanUpAllBuckets(TestBase.getSecondClient(), "oss-java-sdk-");
    }

    @Before
    public void setUp() throws Exception {
        bucketName = TestBase.createBucket();
    }

    @After
    public void tearDown() throws Exception {
        TestBase.deleteBucket(bucketName);
        TestBase.cleanUp();
    }

    public static OSSClient getDefaultClient() {
        if (defaultClient == null) {
            defaultClient = new OSSClient("https://oss-cn-hangzhou.aliyuncs.com", new DefaultCredentialProvider(defaultCreds), new ClientConfiguration().setSupportCname(false).setSLDEnabled(true));
        }
        return defaultClient;
    }

    public static OSSClient getSecondClient() {
        if (secondClient == null) {
            secondClient = new OSSClient("http://oss-test.aliyun-inc.com", new DefaultCredentialProvider(secondCreds), new ClientConfiguration().setSupportCname(false).setSLDEnabled(true));
        }
        return secondClient;
    }

    public static String createBucket() {
        long ticks = new Date().getTime() / 1000L + (long)new Random().nextInt(5000);
        String bucketName = "oss-java-sdk-" + ticks;
        TestBase.getDefaultClient().createBucket(bucketName);
        TestBase.getSecondClient().createBucket(bucketName);
        TestUtils.waitForCacheExpiration(2);
        return bucketName;
    }

    public static void deleteBucket(String bucketName) {
        TestBase.abortAllMultipartUploads(defaultClient, bucketName);
        TestBase.deleteBucketWithObjects(defaultClient, bucketName);
        TestBase.abortAllMultipartUploads(secondClient, bucketName);
        TestBase.deleteBucketWithObjects(secondClient, bucketName);
    }

    protected static void deleteBucketWithObjects(OSSClient client, String bucketName) {
        if (!client.doesBucketExist(bucketName)) {
            return;
        }
        List<String> allObjects = TestBase.listAllObjects(client, bucketName);
        int total = allObjects.size();
        if (total > 0) {
            int opLoops = total / 1000;
            if (total % 1000 != 0) {
                ++opLoops;
            }
            List<String> objectsToDel = null;
            int i = 0;
            while (i < opLoops) {
                int fromIndex = i * 1000;
                int len = 0;
                len = total <= 1000 ? total : (i + 1 == opLoops ? total - fromIndex : 1000);
                objectsToDel = allObjects.subList(fromIndex, fromIndex + len);
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
                deleteObjectsRequest.setEncodingType(DEFAULT_ENCODING_TYPE);
                deleteObjectsRequest.setKeys(objectsToDel);
                client.deleteObjects(deleteObjectsRequest);
                ++i;
            }
        }
        client.deleteBucket(bucketName);
    }

    protected static void abortAllMultipartUploads(OSSClient client, String bucketName) {
        if (!client.doesBucketExist(bucketName)) {
            return;
        }
        String keyMarker = null;
        String uploadIdMarker = null;
        ListMultipartUploadsRequest listMultipartUploadsRequest = null;
        MultipartUploadListing multipartUploadListing = null;
        List<MultipartUpload> multipartUploads = null;
        do {
            listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            listMultipartUploadsRequest.setKeyMarker(keyMarker);
            listMultipartUploadsRequest.setUploadIdMarker(uploadIdMarker);
            multipartUploadListing = client.listMultipartUploads(listMultipartUploadsRequest);
            multipartUploads = multipartUploadListing.getMultipartUploads();
            for (MultipartUpload mu : multipartUploads) {
                String key = mu.getKey();
                String uploadId = mu.getUploadId();
                client.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, key, uploadId));
            }
            keyMarker = multipartUploadListing.getKeyMarker();
            uploadIdMarker = multipartUploadListing.getUploadIdMarker();
        } while (multipartUploadListing != null && multipartUploadListing.isTruncated());
    }

    protected static List<String> listAllObjects(OSSClient client, String bucketName) {
        ArrayList<String> objs = new ArrayList<String>();
        ObjectListing objectListing = null;
        String nextMarker = null;
        do {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName, null, nextMarker, null, 1000);
            listObjectsRequest.setEncodingType(DEFAULT_ENCODING_TYPE);
            objectListing = client.listObjects(listObjectsRequest);
            nextMarker = DEFAULT_ENCODING_TYPE.equals(objectListing.getEncodingType()) ? HttpUtil.urlDecode(objectListing.getNextMarker(), "UTF-8") : objectListing.getNextMarker();
            List<OSSObjectSummary> sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                if (DEFAULT_ENCODING_TYPE.equals(objectListing.getEncodingType())) {
                    objs.add(HttpUtil.urlDecode(s.getKey(), "UTF-8"));
                    continue;
                }
                objs.add(s.getKey());
            }
        } while (objectListing.isTruncated());
        return objs;
    }

    protected static List<String> listAllBuckets(OSSClient client, String bucketPrefix) {
        ArrayList<String> bkts = new ArrayList<String>();
        String nextMarker = null;
        BucketList bucketList = null;
        do {
            ListBucketsRequest listBucketsRequest = new ListBucketsRequest(bucketPrefix, nextMarker, 1000);
            bucketList = client.listBuckets(listBucketsRequest);
            nextMarker = bucketList.getNextMarker();
            for (Bucket b : bucketList.getBucketList()) {
                bkts.add(b.getName());
            }
        } while (bucketList.isTruncated());
        return bkts;
    }

    protected static void cleanUpAllBuckets(OSSClient client, String bucketPrefix) {
        List<String> bkts = TestBase.listAllBuckets(client, bucketPrefix);
        for (String b : bkts) {
            TestBase.abortAllMultipartUploads(client, b);
            TestBase.deleteBucketWithObjects(client, b);
        }
    }

    public static void restoreDefaultCredentials() {
        TestBase.getDefaultClient().switchCredentials(defaultCreds);
    }

    public static void restoreDefaultEndpoint() {
        TestBase.getDefaultClient().setEndpoint("https://oss-cn-hangzhou.aliyuncs.com");
    }

    public static void cleanUp() {
        if (defaultClient != null) {
            defaultClient.shutdown();
            defaultClient = null;
        }
        if (secondClient != null) {
            secondClient.shutdown();
            secondClient = null;
        }
    }
}

