/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Test;

public class OSSClientArgCheckTest {
    private static final String validBucketName = "bucket";
    private static final String invalidBucketName = "bucket*";
    private static final String objectKey = "object";

    @Test
    public void testValidateObjectKey() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < 1023) {
            builder.append("o");
            ++i;
        }
        Assert.assertTrue((boolean)OSSUtils.validateObjectKey(builder.toString()));
        builder.append("o");
        Assert.assertFalse((boolean)OSSUtils.validateObjectKey(builder.toString()));
        Assert.assertTrue((boolean)OSSUtils.validateObjectKey("\t 123_.*  \u4e2d\u6587-!@#$%^&*()_+-=;'\"~`><?/':[]|\\"));
    }

    @Test
    public void testBucketArgChecking() throws Exception {
        OSS client = OSSClientArgCheckTest.getOSSClient();
        try {
            client.createBucket(invalidBucketName);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            client.deleteBucket(invalidBucketName);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            client.setBucketAcl(invalidBucketName, CannedAccessControlList.PublicRead);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            client.getBucketAcl(invalidBucketName);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            client.listObjects(invalidBucketName);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(validBucketName);
        try {
            listObjectsRequest.setMaxKeys(1001);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        listObjectsRequest.setMaxKeys(100);
    }

    @Test
    public void testPutObjectArgChecking() throws Exception {
        OSS client = OSSClientArgCheckTest.getOSSClient();
        String content = "\u4e2dEnglish\u6df7\u5408\u7684Content\u3002\nThis is the 2nd line.";
        byte[] contentBuffer = null;
        try {
            contentBuffer = content.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
        }
        ByteArrayInputStream input = new ByteArrayInputStream(contentBuffer);
        ObjectMetadata metadata = new ObjectMetadata();
        try {
            InputStream instream = null;
            client.putObject(validBucketName, objectKey, instream, metadata);
        }
        catch (IllegalArgumentException instream) {
            // empty catch block
        }
        long G5 = 0x140000000L;
        metadata.setContentLength(0x140000000L);
        metadata.setContentLength(contentBuffer.length);
        try {
            client.putObject(invalidBucketName, objectKey, input, metadata);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetObjectArgChecking() throws Exception {
        OSS client = OSSClientArgCheckTest.getOSSClient();
        try {
            client.getObject(invalidBucketName, objectKey);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            client.getObjectMetadata(invalidBucketName, objectKey);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            client.deleteObject(invalidBucketName, objectKey);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static OSS getOSSClient() {
        return new OSSClient("http://localhost", "id", "key");
    }
}

