/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.utils;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xmlmiddleware.conversions.formatters.DateFormatter;
import org.xmlmiddleware.conversions.formatters.NumberFormatter;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.utils.Sort;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.ClassMapBase;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.InlineClassMap;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmldbms.maps.factories.MapConst;
import org.xmlmiddleware.xmlutils.XMLName;
import org.xmlmiddleware.xmlutils.XMLWriter;

public class MapSerializer
extends XMLWriter {
    private static String XMLDBMS2DTD = "xmldbms2.dtd";
    private static String SPACE = " ";
    private XMLDBMSMap map;
    private Hashtable uris;
    private Hashtable prefixes;
    private Hashtable defaultFormatters = new Hashtable();
    private Hashtable formatterNames = new Hashtable();

    public MapSerializer() {
        this.allocateAttrs(6);
    }

    public MapSerializer(Writer writer) {
        super(writer);
        this.allocateAttrs(6);
    }

    public void setWriter(Writer writer) {
        this.setWriter(writer);
    }

    public void usePrefixes(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            this.prefixes = null;
            this.uris = null;
            return;
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("prefixes and uris arrays must be same length.");
        }
        this.prefixes = new Hashtable(stringArray.length);
        this.uris = new Hashtable(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.prefixes.put(stringArray2[n], stringArray[n]);
            this.uris.put(stringArray[n], stringArray2[n]);
            ++n;
        }
    }

    public void serialize(XMLDBMSMap xMLDBMSMap) throws IOException, XMLMiddlewareException {
        this.map = xMLDBMSMap;
        this.serialize(null, null);
    }

    public void serialize(XMLDBMSMap xMLDBMSMap, String string, String string2) throws IOException, XMLMiddlewareException {
        this.map = xMLDBMSMap;
        if (string == null) {
            string = XMLDBMS2DTD;
        }
        this.serialize(string, string2);
    }

    private void serialize(String string, String string2) throws IOException, XMLMiddlewareException {
        this.writeMapStart(string, string2);
        this.writeOptions();
        this.writeDatabases();
        this.writeMaps();
        this.writeMapEnd();
    }

    private void writeAttribute(XMLName xMLName) throws IOException, XMLMiddlewareException {
        this.attrs[0] = MapConst.ATTR_NAME;
        this.values[0] = this.getQualifiedName(xMLName);
        this.writeElementStart(MapConst.ELEM_ATTRIBUTE, 1, true);
    }

    private void writeClassMap(ClassMap classMap) throws IOException, XMLMiddlewareException {
        this.writeElementStart(MapConst.ELEM_CLASSMAP, 0, false);
        this.writeElementType(classMap.getElementTypeName());
        ClassMap classMap2 = classMap.getUsedClassMap();
        if (classMap2 != null) {
            this.writeUseClassMap(classMap2);
        } else {
            this.writeExtends(classMap);
            Table table = classMap.getTable();
            int n = this.setTableNameAttributes(table);
            this.writeElementStart(MapConst.ELEM_TOCLASSTABLE, n, true);
            this.writePropertyInlineRelatedMaps(classMap);
        }
        this.writeElementEnd(MapConst.ELEM_CLASSMAP);
    }

    private void writeClassMaps() throws IOException, XMLMiddlewareException {
        Enumeration enumeration = this.map.getClassMaps();
        while (enumeration.hasMoreElements()) {
            ClassMap classMap = (ClassMap)enumeration.nextElement();
            this.writeClassMap(classMap);
        }
    }

    private void writeColumns(Table table) throws IOException {
        Enumeration enumeration = table.getColumns();
        while (enumeration.hasMoreElements()) {
            Column column = (Column)enumeration.nextElement();
            this.writeColumn(column);
        }
    }

    private void writeColumn(Column column) throws IOException {
        String string;
        int n;
        int n2;
        int n3 = 0;
        this.attrs[n3] = MapConst.ATTR_NAME;
        this.values[n3++] = column.getName();
        int n4 = column.getType();
        if (n4 != 0) {
            this.attrs[n3] = MapConst.ATTR_DATATYPE;
            this.values[n3++] = JDBCTypes.getName(column.getType());
        }
        if ((JDBCTypes.typeIsChar(n4) || JDBCTypes.typeIsBinary(n4)) && (n2 = column.getLength()) != -1) {
            this.attrs[n3] = MapConst.ATTR_LENGTH;
            this.values[n3++] = String.valueOf(n2);
        }
        if (n4 == 3 || n4 == 2) {
            int n5;
            int n6 = column.getPrecision();
            if (n6 != -1) {
                this.attrs[n3] = MapConst.ATTR_PRECISION;
                this.values[n3++] = String.valueOf(n6);
            }
            if ((n5 = column.getScale()) != Integer.MIN_VALUE) {
                this.attrs[n3] = MapConst.ATTR_SCALE;
                this.values[n3++] = String.valueOf(n5);
            }
        }
        if ((n = column.getNullability()) == 1) {
            this.attrs[n3] = MapConst.ATTR_NULLABLE;
            this.values[n3++] = MapConst.ENUM_YES;
        } else if (n == 0) {
            this.attrs[n3] = MapConst.ATTR_NULLABLE;
            this.values[n3++] = MapConst.ENUM_NO;
        }
        StringFormatter stringFormatter = column.getFormatter();
        if (stringFormatter != null && (string = (String)this.formatterNames.get(stringFormatter)) != null) {
            this.attrs[n3] = MapConst.ATTR_FORMAT;
            this.values[n3++] = string;
        }
        this.writeElementStart(MapConst.ELEM_COLUMN, n3, true);
    }

    private void writeDatabases() throws IOException {
        Object object;
        Vector<String> vector = new Vector<String>();
        Vector<Table> vector2 = new Vector<Table>();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        this.writeElementStart(MapConst.ELEM_DATABASES, 0, false);
        Enumeration enumeration = this.map.getTables();
        while (enumeration.hasMoreElements()) {
            object = (Table)enumeration.nextElement();
            vector.addElement(((Table)object).getHashName());
            vector2.addElement((Table)object);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new Table[vector2.size()];
        vector2.copyInto(objectArray2);
        Sort.sort((String[])objectArray, objectArray2);
        int n = 0;
        while (n < objectArray2.length) {
            int n2;
            object = objectArray2[n];
            string2 = ((Table)object).getDatabaseName();
            string4 = ((Table)object).getCatalogName();
            string6 = ((Table)object).getSchemaName();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.nameChanged(string2, string) || n == 0) {
                bl = true;
                bl2 = true;
                bl3 = true;
            } else if (this.nameChanged(string4, string3)) {
                bl2 = true;
                bl3 = true;
            } else if (this.nameChanged(string6, string5)) {
                bl3 = true;
            }
            if (n != 0) {
                if (bl3) {
                    this.writeElementEnd(MapConst.ELEM_SCHEMA);
                }
                if (bl2) {
                    this.writeElementEnd(MapConst.ELEM_CATALOG);
                }
                if (bl) {
                    this.writeElementEnd(MapConst.ELEM_DATABASE);
                }
            }
            if (bl) {
                this.attrs[0] = MapConst.ATTR_NAME;
                this.values[0] = string2;
                this.writeElementStart(MapConst.ELEM_DATABASE, 1, false);
                string = string2;
            }
            if (bl2) {
                n2 = 0;
                if (string4 != null) {
                    this.attrs[n2] = MapConst.ATTR_NAME;
                    this.values[n2++] = string4;
                }
                this.writeElementStart(MapConst.ELEM_CATALOG, n2, false);
                string3 = string4;
            }
            if (bl3) {
                n2 = 0;
                if (string6 != null) {
                    this.attrs[n2] = MapConst.ATTR_NAME;
                    this.values[n2++] = string6;
                }
                this.writeElementStart(MapConst.ELEM_SCHEMA, n2, false);
                string5 = string6;
            }
            this.writeTable((Table)object);
            ++n;
        }
        this.writeElementEnd(MapConst.ELEM_SCHEMA);
        this.writeElementEnd(MapConst.ELEM_CATALOG);
        this.writeElementEnd(MapConst.ELEM_DATABASE);
        this.writeElementEnd(MapConst.ELEM_DATABASES);
    }

    private void writeDefaultFormatElements() throws IOException {
        Enumeration enumeration = this.defaultFormatters.keys();
        while (enumeration.hasMoreElements()) {
            StringFormatter stringFormatter = (StringFormatter)enumeration.nextElement();
            Vector vector = (Vector)this.defaultFormatters.get(stringFormatter);
            String string = (String)this.formatterNames.get(stringFormatter);
            this.writeFormatElement(stringFormatter, vector, string);
        }
    }

    private void writeElementType(XMLName xMLName) throws IOException, XMLMiddlewareException {
        this.attrs[0] = MapConst.ATTR_NAME;
        this.values[0] = this.getQualifiedName(xMLName);
        this.writeElementStart(MapConst.ELEM_ELEMENTTYPE, 1, true);
    }

    private void writeEmptyStringIsNull() throws IOException {
        if (this.map.emptyStringIsNull()) {
            this.writeElementStart(MapConst.ELEM_EMPTYSTRINGISNULL, 0, true);
        }
    }

    private void writeExtends(ClassMap classMap) throws IOException, XMLMiddlewareException {
        ClassMap classMap2 = classMap.getBaseClassMap();
        if (classMap2 == null) {
            return;
        }
        this.attrs[0] = MapConst.ATTR_ELEMENTTYPE;
        this.values[0] = this.getQualifiedName(classMap2.getElementTypeName());
        this.writeElementStart(MapConst.ELEM_EXTENDS, 1, false);
        LinkInfo linkInfo = classMap.getBaseLinkInfo();
        if (linkInfo == null) {
            return;
        }
        this.attrs[0] = MapConst.ATTR_KEYINBASETABLE;
        this.values[0] = linkInfo.parentKeyIsUnique() ? MapConst.ENUM_UNIQUE : MapConst.ENUM_FOREIGN;
        this.writeElementStart(MapConst.ELEM_USEBASETABLE, 1, false);
        this.writeLinkInfo(linkInfo);
        this.writeElementEnd(MapConst.ELEM_USEBASETABLE);
        this.writeElementEnd(MapConst.ELEM_EXTENDS);
    }

    private void writeFormatElement(StringFormatter stringFormatter, Vector vector, String string) throws IOException {
        int n = 0;
        if (vector != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < vector.size()) {
                if (n2 != 0) {
                    stringBuffer.append(SPACE);
                }
                int n3 = (Integer)vector.elementAt(n2);
                stringBuffer.append(JDBCTypes.getName(n3));
                ++n2;
            }
            this.attrs[n] = MapConst.ATTR_DEFAULTFORTYPES;
            this.values[n++] = stringBuffer.toString();
        }
        if (string != null) {
            this.attrs[n] = MapConst.ATTR_NAME;
            this.values[n++] = string;
        }
        if (stringFormatter instanceof NumberFormatter) {
            NumberFormat numberFormat = ((NumberFormatter)stringFormatter).getNumberFormat();
            if (numberFormat instanceof DecimalFormat) {
                this.attrs[n] = MapConst.ATTR_PATTERN;
                this.values[n++] = ((DecimalFormat)numberFormat).toLocalizedPattern();
                this.writeElementStart(MapConst.ELEM_DECIMALFORMAT, n, true);
                return;
            }
        } else if (stringFormatter instanceof DateFormatter) {
            DateFormat dateFormat = ((DateFormatter)stringFormatter).getDateFormat();
            if (dateFormat instanceof SimpleDateFormat) {
                this.attrs[n] = MapConst.ATTR_PATTERN;
                this.values[n++] = ((SimpleDateFormat)dateFormat).toLocalizedPattern();
                this.writeElementStart(MapConst.ELEM_SIMPLEDATEFORMAT, n, true);
                return;
            }
        } else {
            this.attrs[n] = MapConst.ATTR_CLASS;
            this.values[n++] = stringFormatter.getClass().getName();
            this.writeElementStart(MapConst.ELEM_FORMATCLASS, n, true);
        }
    }

    private void writeFormatElements() throws IOException {
        this.buildDefaultFormatters();
        this.buildFormatterNames();
        this.writeDefaultFormatElements();
        this.writeNamedFormatElements();
    }

    private void writeInlineClassMap(InlineClassMap inlineClassMap) throws IOException, XMLMiddlewareException {
        this.writeElementStart(MapConst.ELEM_INLINEMAP, 0, false);
        this.writeElementType(inlineClassMap.getElementTypeName());
        this.writeOrderInfo(inlineClassMap.getOrderInfo(), false);
        this.writePropertyInlineRelatedMaps(inlineClassMap);
        this.writeElementEnd(MapConst.ELEM_INLINEMAP);
    }

    private void writeKey(Key key, String string, boolean bl) throws IOException {
        this.attrs[0] = MapConst.ATTR_NAME;
        this.values[0] = key.getName();
        this.writeElementStart(string, 1, false);
        if (bl) {
            Table table = key.getRemoteTable();
            int n = this.setTableNameAttributes(table);
            this.writeElementStart(MapConst.ELEM_USETABLE, n, true);
            this.attrs[0] = MapConst.ATTR_NAME;
            this.values[0] = key.getRemoteKey().getName();
            this.writeElementStart(MapConst.ELEM_USEUNIQUEKEY, 1, true);
        }
        this.writeUseColumns(key.getColumns());
        this.writeElementEnd(string);
    }

    private void writeKeys(Enumeration enumeration, String string, boolean bl) throws IOException {
        while (enumeration.hasMoreElements()) {
            Key key = (Key)enumeration.nextElement();
            this.writeKey(key, string, bl);
        }
    }

    private void writeLinkInfo(LinkInfo linkInfo) throws IOException {
        String string = linkInfo.getParentKey().getName();
        String string2 = linkInfo.getChildKey().getName();
        this.attrs[0] = MapConst.ATTR_NAME;
        this.values[0] = linkInfo.parentKeyIsUnique() ? string : string2;
        this.writeElementStart(MapConst.ELEM_USEUNIQUEKEY, 1, true);
        this.values[0] = linkInfo.parentKeyIsUnique() ? string2 : string;
        this.writeElementStart(MapConst.ELEM_USEFOREIGNKEY, 1, true);
    }

    private void writeMapEnd() throws IOException {
        this.writeElementEnd(MapConst.ELEM_XMLTODBMS);
    }

    private void writeMaps() throws IOException, XMLMiddlewareException {
        this.writeElementStart(MapConst.ELEM_MAPS, 0, false);
        this.writeClassMaps();
        this.writeElementEnd(MapConst.ELEM_MAPS);
    }

    private void writeMapStart(String string, String string2) throws IOException {
        this.attrs[0] = MapConst.ATTR_VERSION;
        this.values[0] = MapConst.DEF_VERSION;
        this.attrs[1] = "xmlns";
        this.values[1] = MapConst.URI_XMLDBMSV2;
        this.writeXMLDecl();
        this.writeDOCTYPE(MapConst.ELEM_XMLTODBMS, string, string2);
        this.writeElementStart(MapConst.ELEM_XMLTODBMS, 2, false);
    }

    private void writeNamedFormatElements() throws IOException {
        Enumeration enumeration = this.formatterNames.keys();
        while (enumeration.hasMoreElements()) {
            StringFormatter stringFormatter = (StringFormatter)enumeration.nextElement();
            if (this.defaultFormatters.get(stringFormatter) != null) continue;
            String string = (String)this.formatterNames.get(stringFormatter);
            this.writeFormatElement(stringFormatter, null, string);
        }
    }

    private void writeNamespaces() throws IOException {
        Hashtable hashtable = this.uris;
        if (hashtable == null) {
            hashtable = this.map.getNamespaceURIs();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.attrs[0] = MapConst.ATTR_PREFIX;
            this.values[0] = string;
            this.attrs[1] = MapConst.ATTR_URI;
            this.values[1] = (String)hashtable.get(string);
            this.writeElementStart(MapConst.ELEM_NAMESPACE, 2, true);
        }
    }

    private void writeOptions() throws IOException {
        this.writeElementStart(MapConst.ELEM_OPTIONS, 0, false);
        this.writeEmptyStringIsNull();
        this.writeFormatElements();
        this.writeNamespaces();
        this.writeElementEnd(MapConst.ELEM_OPTIONS);
    }

    private void writeOrderInfo(OrderInfo orderInfo, boolean bl) throws IOException {
        if (orderInfo == null) {
            return;
        }
        this.attrs[0] = MapConst.ATTR_DIRECTION;
        String string = this.values[0] = orderInfo.isAscending() ? MapConst.ENUM_ASCENDING : MapConst.ENUM_DESCENDING;
        if (orderInfo.orderValueIsFixed()) {
            this.attrs[1] = MapConst.ATTR_VALUE;
            this.values[1] = String.valueOf(orderInfo.getFixedOrderValue());
            this.writeElementStart(MapConst.ELEM_FIXEDORDER, 2, true);
            return;
        }
        this.attrs[1] = MapConst.ATTR_NAME;
        this.values[1] = orderInfo.getOrderColumn().getName();
        this.attrs[2] = MapConst.ATTR_GENERATE;
        this.values[2] = orderInfo.generateOrder() ? MapConst.ENUM_YES : MapConst.ENUM_NO;
        String string2 = bl ? MapConst.ELEM_TLORDERCOLUMN : MapConst.ELEM_ORDERCOLUMN;
        this.writeElementStart(string2, 3, true);
    }

    private void writePrimaryKey(Key key) throws IOException {
        String string = null;
        int n = 0;
        if (key != null) {
            int n2 = key.getKeyGeneration();
            if (n2 == 3) {
                string = MapConst.VALUE_DATABASE;
            } else if (n2 == 2) {
                string = key.getKeyGeneratorName();
            }
            if (string != null) {
                this.attrs[n] = MapConst.ATTR_KEYGENERATOR;
                this.values[n++] = string;
            }
            this.writeElementStart(MapConst.ELEM_PRIMARYKEY, n, false);
            this.writeUseColumns(key.getColumns());
            this.writeElementEnd(MapConst.ELEM_PRIMARYKEY);
        }
    }

    private void writePropertyInlineRelatedMaps(ClassMapBase classMapBase) throws IOException, XMLMiddlewareException {
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        Enumeration enumeration = classMapBase.getAttributeMaps();
        while (enumeration.hasMoreElements()) {
            this.writePropertyMap((PropertyMap)enumeration.nextElement());
        }
        this.writePropertyMap(classMapBase.getPCDATAMap());
        enumeration = classMapBase.getChildMaps();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof PropertyMap) {
                this.writePropertyMap((PropertyMap)e);
                continue;
            }
            if (e instanceof RelatedClassMap) {
                stack.push(e);
                continue;
            }
            stack2.push(e);
        }
        while (!stack2.empty()) {
            this.writeInlineClassMap((InlineClassMap)stack2.pop());
        }
        while (!stack.empty()) {
            this.writeRelatedClassMap((RelatedClassMap)stack.pop());
        }
    }

    private void writePropertyMap(PropertyMap propertyMap) throws IOException, XMLMiddlewareException {
        int n = 0;
        if (propertyMap == null) {
            return;
        }
        this.attrs[n] = MapConst.ATTR_TOKENLIST;
        String string = this.values[n++] = propertyMap.isTokenList() ? MapConst.ENUM_YES : MapConst.ENUM_NO;
        if (propertyMap.getType() == 1) {
            this.attrs[n] = MapConst.ATTR_CONTAINSXML;
            this.values[n++] = propertyMap.containsXML() ? MapConst.ENUM_YES : MapConst.ENUM_NO;
        }
        this.writeElementStart(MapConst.ELEM_PROPERTYMAP, n, false);
        switch (propertyMap.getType()) {
            case 2: {
                this.writeAttribute(propertyMap.getXMLName());
                break;
            }
            case 3: {
                this.writeElementStart(MapConst.ELEM_PCDATA, 0, true);
                break;
            }
            case 1: {
                this.writeElementType(propertyMap.getXMLName());
                break;
            }
        }
        this.writeToPropertyTable(propertyMap);
        this.writeToColumn(propertyMap.getColumn());
        this.writeOrderInfo(propertyMap.getOrderInfo(), false);
        if (propertyMap.isTokenList()) {
            this.writeOrderInfo(propertyMap.getTokenListOrderInfo(), true);
        }
        this.writeElementEnd(MapConst.ELEM_PROPERTYMAP);
    }

    private void writeRelatedClassMap(RelatedClassMap relatedClassMap) throws IOException, XMLMiddlewareException {
        LinkInfo linkInfo = relatedClassMap.getLinkInfo();
        this.attrs[0] = MapConst.ATTR_KEYINPARENTTABLE;
        this.values[0] = linkInfo.parentKeyIsUnique() ? MapConst.ENUM_UNIQUE : MapConst.ENUM_FOREIGN;
        this.writeElementStart(MapConst.ELEM_RELATEDCLASS, 1, false);
        XMLName xMLName = relatedClassMap.getElementTypeName();
        this.writeElementType(xMLName);
        ClassMap classMap = relatedClassMap.getClassMap();
        XMLName xMLName2 = classMap.getElementTypeName();
        if (!xMLName2.getUniversalName().equals(xMLName.getUniversalName())) {
            this.writeUseClassMap(classMap);
        }
        this.writeLinkInfo(linkInfo);
        this.writeOrderInfo(relatedClassMap.getOrderInfo(), false);
        this.writeElementEnd(MapConst.ELEM_RELATEDCLASS);
    }

    private void writeTable(Table table) throws IOException {
        this.attrs[0] = MapConst.ATTR_NAME;
        this.values[0] = table.getTableName();
        this.writeElementStart(MapConst.ELEM_TABLE, 1, false);
        this.writeColumns(table);
        this.writePrimaryKey(table.getPrimaryKey());
        this.writeKeys(table.getUniqueKeys(), MapConst.ELEM_UNIQUEKEY, false);
        this.writeKeys(table.getForeignKeys(), MapConst.ELEM_FOREIGNKEY, true);
        this.writeElementEnd(MapConst.ELEM_TABLE);
    }

    private void writeToColumn(Column column) throws IOException {
        this.attrs[0] = MapConst.ATTR_NAME;
        this.values[0] = column.getName();
        this.writeElementStart(MapConst.ELEM_TOCOLUMN, 1, true);
    }

    private void writeToPropertyTable(PropertyMap propertyMap) throws IOException {
        Table table = propertyMap.getTable();
        if (table == null) {
            return;
        }
        int n = this.setTableNameAttributes(table);
        LinkInfo linkInfo = propertyMap.getLinkInfo();
        this.attrs[n] = MapConst.ATTR_KEYINPARENTTABLE;
        this.values[n++] = linkInfo.parentKeyIsUnique() ? MapConst.ENUM_UNIQUE : MapConst.ENUM_FOREIGN;
        this.writeElementStart(MapConst.ELEM_TOPROPERTYTABLE, n, false);
        this.writeLinkInfo(linkInfo);
        this.writeElementEnd(MapConst.ELEM_TOPROPERTYTABLE);
    }

    private void writeUseClassMap(ClassMap classMap) throws IOException, XMLMiddlewareException {
        this.attrs[0] = MapConst.ATTR_ELEMENTTYPE;
        this.values[0] = this.getQualifiedName(classMap.getElementTypeName());
        this.writeElementStart(MapConst.ELEM_USECLASSMAP, 1, true);
    }

    private void writeUseColumn(Column column) throws IOException {
        this.attrs[0] = MapConst.ATTR_NAME;
        this.values[0] = column.getName();
        this.writeElementStart(MapConst.ELEM_USECOLUMN, 1, true);
    }

    private void writeUseColumns(Column[] columnArray) throws IOException {
        int n = 0;
        while (n < columnArray.length) {
            this.writeUseColumn(columnArray[n]);
            ++n;
        }
    }

    private int setTableNameAttributes(Table table) {
        int n = 0;
        String string = table.getDatabaseName();
        if (!string.equals(MapConst.DEF_DATABASENAME)) {
            this.attrs[n] = MapConst.ATTR_DATABASE;
            this.values[n++] = string;
        }
        if ((string = table.getCatalogName()) != null) {
            this.attrs[n] = MapConst.ATTR_CATALOG;
            this.values[n++] = string;
        }
        if ((string = table.getSchemaName()) != null) {
            this.attrs[n] = MapConst.ATTR_SCHEMA;
            this.values[n++] = string;
        }
        this.attrs[n] = MapConst.ATTR_NAME;
        this.values[n++] = table.getTableName();
        return n;
    }

    private String getQualifiedName(XMLName xMLName) {
        if (this.prefixes != null) {
            return XMLName.getQualifiedName(xMLName.getUniversalName(), this.prefixes);
        }
        return xMLName.getQualifiedName();
    }

    private boolean nameChanged(String string, String string2) {
        if (string == null) {
            return string2 != null;
        }
        return !string.equals(string2);
    }

    private void buildDefaultFormatters() {
        this.defaultFormatters.clear();
        Hashtable hashtable = this.map.getDefaultFormatters();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            StringFormatter stringFormatter = (StringFormatter)hashtable.get(k);
            if (!this.formatterSerializable(stringFormatter)) continue;
            Vector vector = (Vector)this.defaultFormatters.get(stringFormatter);
            if (vector == null) {
                vector = new Vector();
                this.defaultFormatters.put(stringFormatter, vector);
            }
            vector.addElement(k);
        }
    }

    private void buildFormatterNames() {
        this.formatterNames.clear();
        Enumeration enumeration = this.map.getNamedFormatters().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            StringFormatter stringFormatter = this.map.getNamedFormatter(string);
            if (!this.formatterSerializable(stringFormatter)) continue;
            this.formatterNames.put(stringFormatter, string);
        }
    }

    private boolean formatterSerializable(StringFormatter stringFormatter) {
        if (stringFormatter instanceof DateFormatter) {
            DateFormat dateFormat = ((DateFormatter)stringFormatter).getDateFormat();
            return dateFormat instanceof SimpleDateFormat;
        }
        if (stringFormatter instanceof NumberFormatter) {
            NumberFormat numberFormat = ((NumberFormatter)stringFormatter).getNumberFormat();
            return numberFormat instanceof DecimalFormat;
        }
        return true;
    }
}

