/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.factories;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlmiddleware.conversions.formatters.DateFormatter;
import org.xmlmiddleware.conversions.formatters.NumberFormatter;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.utils.TokenList;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.InlineClassMap;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmldbms.maps.factories.MapConst;
import org.xmlmiddleware.xmldbms.maps.utils.MapInverter;
import org.xmlmiddleware.xmlutils.XMLName;

public class MapCompiler
implements ContentHandler {
    private static final int iSTATE_NONE = 0;
    private static final int iSTATE_KEY = 1;
    private static final int iSTATE_CLASSMAP = 2;
    private static final int iSTATE_USEBASETABLE = 3;
    private static final int iSTATE_PROPERTYMAP = 4;
    private static final int iSTATE_RELATEDCLASS = 5;
    private static final int iSTATE_INLINECLASS = 6;
    private static final int iSTATE_TOPROPERTYTABLE = 7;
    private static final Integer STATE_NONE = new Integer(0);
    private static final Integer STATE_KEY = new Integer(1);
    private static final Integer STATE_CLASSMAP = new Integer(2);
    private static final Integer STATE_USEBASETABLE = new Integer(3);
    private static final Integer STATE_PROPERTYMAP = new Integer(4);
    private static final Integer STATE_RELATEDCLASS = new Integer(5);
    private static final Integer STATE_INLINECLASS = new Integer(6);
    private static final Integer STATE_TOPROPERTYTABLE = new Integer(7);
    private static String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private XMLReader xmlReader;
    private TokenList elementTokens;
    private TokenList enumTokens;
    private Integer state;
    private Stack stateStack = new Stack();
    private Stack fkWrapperStack = new Stack();
    private Stack baseTableWrapperStack = new Stack();
    private Stack rcmWrapperStack = new Stack();
    private Stack inlineClassMapStack = new Stack();
    private Vector keyColumns = new Vector();
    private Hashtable propTables = new Hashtable();
    private Hashtable classTables = new Hashtable();
    private Hashtable formatTypes = new Hashtable();
    private XMLDBMSMap map;
    private String databaseName;
    private String catalogName;
    private String schemaName;
    private Table table;
    private Key key;
    private Locale locale;
    private String pattern;
    private String formatName;
    private String defaultForTypes;
    private int dateStyle;
    private int timeStyle;
    private XMLName elementTypeName;
    private ClassMap classMap;
    private PropertyMap propMap;
    private Table propertyTable;
    private boolean parentKeyIsUnique;
    private boolean isTokenList;
    private boolean containsXML;
    private Key uniqueKey;
    private BaseTableWrapper baseTableWrapper;
    private RCMWrapper rcmWrapper;
    private InlineClassMap inlineClassMap;
    private int indent;
    private boolean debug = false;

    public MapCompiler(XMLReader xMLReader) throws SAXException {
        if (xMLReader == null) {
            throw new IllegalArgumentException("xmlReader argument must not be null.");
        }
        this.xmlReader = xMLReader;
        this.xmlReader.setContentHandler(this);
        this.xmlReader.setFeature(NAMESPACES, true);
        this.init();
    }

    public XMLDBMSMap compile(InputSource inputSource) throws XMLMiddlewareException {
        if (inputSource == null) {
            throw new IllegalArgumentException("src argument must not be null.");
        }
        try {
            this.xmlReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                if (exception instanceof XMLMiddlewareException) {
                    throw (XMLMiddlewareException)exception;
                }
                throw new XMLMiddlewareException(exception);
            }
            throw new XMLMiddlewareException(sAXException);
        }
        catch (IOException iOException) {
            throw new XMLMiddlewareException(iOException);
        }
        MapInverter mapInverter = new MapInverter();
        mapInverter.createDatabaseView(this.map);
        return this.map;
    }

    public void startDocument() throws SAXException {
        if (this.debug) {
            System.out.println("Document started.");
        }
        this.state = STATE_NONE;
        this.stateStack.removeAllElements();
        this.fkWrapperStack.removeAllElements();
        this.baseTableWrapperStack.removeAllElements();
        this.rcmWrapperStack.removeAllElements();
        this.inlineClassMapStack.removeAllElements();
        this.propTables.clear();
        this.classTables.clear();
        this.formatTypes.clear();
        this.map = new XMLDBMSMap();
        this.inlineClassMap = null;
    }

    public void endDocument() throws SAXException {
        try {
            this.resolveRCMWrappers();
            this.resolveBaseTableWrappers();
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SAXException(xMLMiddlewareException);
        }
        if (this.debug) {
            System.out.println("Document ended.");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.debug) {
            this.indent();
            System.out.println(String.valueOf(string2) + " (start)");
            this.indent += 3;
        }
        try {
            if (!string.equals(MapConst.URI_XMLDBMSV2)) {
                throw new XMLMiddlewareException("Unrecognized namespace URI: " + string);
            }
            switch (this.elementTokens.getToken(string2)) {
                case 0: {
                    this.processAttribute(attributes);
                    return;
                }
                case 1: {
                    this.processCatalog(attributes);
                    return;
                }
                case 2: {
                    this.stateStack.push(this.state);
                    this.state = STATE_CLASSMAP;
                    return;
                }
                case 3: {
                    this.processColumn(attributes);
                    return;
                }
                case 4: {
                    this.processDatabase(attributes);
                    return;
                }
                case 6: {
                    this.processDateFormatStart(attributes, true, false);
                    return;
                }
                case 7: {
                    this.processDateFormatStart(attributes, true, true);
                    return;
                }
                case 8: {
                    this.processDecimalFormatStart(attributes);
                    return;
                }
                case 9: {
                    this.processElementType(attributes);
                    return;
                }
                case 10: {
                    this.processEmptyStringIsNull();
                    return;
                }
                case 11: {
                    this.processExtends(attributes);
                    return;
                }
                case 12: {
                    this.processFixedOrder(attributes);
                    return;
                }
                case 13: {
                    this.stateStack.push(this.state);
                    this.state = STATE_KEY;
                    this.processForeignKey(attributes);
                    return;
                }
                case 14: {
                    this.processFormatClass(attributes);
                    return;
                }
                case 15: {
                    this.stateStack.push(this.state);
                    this.state = STATE_INLINECLASS;
                    this.inlineClassMapStack.push(this.inlineClassMap);
                    return;
                }
                case 16: {
                    this.processLocale(attributes);
                    return;
                }
                case 18: {
                    this.processNamespace(attributes);
                    return;
                }
                case 19: {
                    this.processFormatStart(attributes);
                    return;
                }
                case 21: {
                    this.processOrderColumn(attributes, false);
                    return;
                }
                case 22: {
                    this.processPCDATA();
                    return;
                }
                case 23: {
                    this.stateStack.push(this.state);
                    this.state = STATE_KEY;
                    this.processPrimaryKey(attributes);
                    return;
                }
                case 24: {
                    this.processPropertyMap(attributes);
                    this.stateStack.push(this.state);
                    this.state = STATE_PROPERTYMAP;
                    return;
                }
                case 25: {
                    this.stateStack.push(this.state);
                    this.state = STATE_RELATEDCLASS;
                    this.processRelatedClass(attributes);
                    return;
                }
                case 26: {
                    this.processSchema(attributes);
                    return;
                }
                case 27: {
                    this.processSimpleDateFormatStart(attributes);
                    return;
                }
                case 28: {
                    this.processTableStart(attributes);
                    return;
                }
                case 29: {
                    this.processDateFormatStart(attributes, false, true);
                    return;
                }
                case 30: {
                    this.processOrderColumn(attributes, true);
                    return;
                }
                case 31: {
                    this.processToClassTable(attributes);
                    return;
                }
                case 32: {
                    this.processToColumn(attributes);
                    return;
                }
                case 33: {
                    this.processToPropertyTable(attributes);
                    this.stateStack.push(this.state);
                    this.state = STATE_TOPROPERTYTABLE;
                    return;
                }
                case 34: {
                    this.stateStack.push(this.state);
                    this.state = STATE_KEY;
                    this.processUniqueKey(attributes);
                    return;
                }
                case 35: {
                    this.processUseBaseTable(attributes);
                    this.stateStack.push(this.state);
                    this.state = STATE_USEBASETABLE;
                    return;
                }
                case 36: {
                    this.processUseClassMap(attributes);
                    return;
                }
                case 37: {
                    this.processUseColumn(attributes);
                    return;
                }
                case 38: {
                    this.processUseForeignKey(attributes);
                    return;
                }
                case 39: {
                    this.processUseTable(attributes);
                    return;
                }
                case 40: {
                    this.processUseUniqueKey(attributes);
                    return;
                }
                case 41: {
                    this.processXMLToDBMS(attributes);
                    return;
                }
                case -999: {
                    throw new XMLMiddlewareException("Unrecognized XML-DBMS mapping language element type: " + string2);
                }
                default: {
                    return;
                }
            }
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SAXException(xMLMiddlewareException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.debug) {
            this.indent -= 3;
            this.indent();
            System.out.println(String.valueOf(string2) + " (end)");
        }
        try {
            if (!string.equals(MapConst.URI_XMLDBMSV2)) {
                throw new XMLMiddlewareException("Unrecognized namespace URI: " + string);
            }
            switch (this.elementTokens.getToken(string2)) {
                case 5: {
                    this.resolveFKWrappers();
                    return;
                }
                case 6: {
                    this.processDateFormatEnd();
                    return;
                }
                case 7: {
                    this.processDateTimeFormatEnd();
                    return;
                }
                case 8: {
                    this.processDecimalFormatEnd();
                    return;
                }
                case 13: {
                    this.processKeyEnd();
                    this.state = (Integer)this.stateStack.pop();
                    return;
                }
                case 15: {
                    this.state = (Integer)this.stateStack.pop();
                    this.inlineClassMap = (InlineClassMap)this.inlineClassMapStack.pop();
                    return;
                }
                case 19: {
                    this.processNumberFormatEnd();
                    return;
                }
                case 23: {
                    this.processKeyEnd();
                    this.state = (Integer)this.stateStack.pop();
                    return;
                }
                case 27: {
                    this.processSimpleDateFormatEnd();
                    return;
                }
                case 28: {
                    this.processTableEnd();
                    return;
                }
                case 29: {
                    this.processTimeFormatEnd();
                    return;
                }
                case 34: {
                    this.processKeyEnd();
                    this.state = (Integer)this.stateStack.pop();
                    return;
                }
                case 2: 
                case 24: 
                case 25: 
                case 33: 
                case 35: {
                    this.state = (Integer)this.stateStack.pop();
                    return;
                }
                case -999: {
                    throw new XMLMiddlewareException("Unrecognized XML-DBMS mapping language element type: " + string2);
                }
                default: {
                    return;
                }
            }
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SAXException(xMLMiddlewareException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    private void processAttribute(Attributes attributes) throws XMLMiddlewareException {
        if (this.containsXML) {
            throw new XMLMiddlewareException("The ContainsXML attribute may not be set to 'Yes' for PropertyMaps that map attributes.");
        }
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        XMLName xMLName = XMLName.create(string, this.map.getNamespaceURIs());
        this.propMap = PropertyMap.create(xMLName, 2);
        switch ((Integer)this.stateStack.peek()) {
            case 2: {
                this.classMap.addAttributeMap(this.propMap);
                break;
            }
            case 6: {
                this.inlineClassMap.addAttributeMap(this.propMap);
                break;
            }
        }
        this.propMap.setIsTokenList(this.isTokenList);
    }

    private void processCatalog(Attributes attributes) {
        this.catalogName = this.getAttrValue(attributes, MapConst.ATTR_NAME);
    }

    private void processColumn(Attributes attributes) throws XMLMiddlewareException {
        int n = 0;
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        Column column = Column.create(string);
        this.table.addColumn(column);
        String string2 = this.getAttrValue(attributes, MapConst.ATTR_DATATYPE);
        if (string2 != null) {
            n = JDBCTypes.getType(string2);
            if (n == 0) {
                throw new XMLMiddlewareException("Invalid data type: " + string2);
            }
            column.setType(n);
        }
        if ((string2 = this.getAttrValue(attributes, MapConst.ATTR_LENGTH)) != null) {
            column.setLength(this.parseInt(string2));
        }
        if ((string2 = this.getAttrValue(attributes, MapConst.ATTR_PRECISION)) != null) {
            column.setPrecision(this.parseInt(string2));
        }
        if ((string2 = this.getAttrValue(attributes, MapConst.ATTR_SCALE)) != null) {
            column.setScale(this.parseInt(string2));
        }
        if ((string2 = this.getAttrValue(attributes, MapConst.ATTR_NULLABLE)) != null) {
            int n2 = this.enumTokens.getToken(string2);
            switch (n2) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 0: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                default: {
                    throw new XMLMiddlewareException("Invalid nullability value: " + string2);
                }
            }
            column.setNullability(n2);
        }
        if ((string2 = this.getAttrValue(attributes, MapConst.ATTR_FORMAT)) != null) {
            StringFormatter stringFormatter = this.map.getNamedFormatter(string2);
            if (stringFormatter == null) {
                throw new XMLMiddlewareException("Column " + string + " uses the named format " + string2 + ". The format was not declared.");
            }
            column.setFormatter(stringFormatter);
            return;
        }
        if (n != 0) {
            column.setFormatter(this.map.getDefaultFormatter(n));
        }
    }

    private void processDatabase(Attributes attributes) {
        this.databaseName = this.getAttrValue(attributes, MapConst.ATTR_NAME, MapConst.DEF_DATABASENAME);
    }

    private void processDateFormatEnd() throws XMLMiddlewareException {
        DateFormat dateFormat = this.locale == null ? DateFormat.getDateInstance(this.dateStyle) : DateFormat.getDateInstance(this.dateStyle, this.locale);
        DateFormatter dateFormatter = new DateFormatter(dateFormat);
        this.addNamedFormatter(this.formatName, dateFormatter);
        this.addDefaultFormatter(this.defaultForTypes, dateFormatter);
    }

    private void processDateFormatStart(Attributes attributes, boolean bl, boolean bl2) throws XMLMiddlewareException {
        this.processFormatStart(attributes);
        if (bl) {
            this.dateStyle = this.enumTokens.getToken(this.getAttrValue(attributes, MapConst.ATTR_DATESTYLE));
        }
        if (bl2) {
            this.timeStyle = this.enumTokens.getToken(this.getAttrValue(attributes, MapConst.ATTR_TIMESTYLE));
        }
    }

    private void processDateTimeFormatEnd() throws XMLMiddlewareException {
        DateFormat dateFormat = this.locale == null ? DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle) : DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale);
        DateFormatter dateFormatter = new DateFormatter(dateFormat);
        this.addNamedFormatter(this.formatName, dateFormatter);
        this.addDefaultFormatter(this.defaultForTypes, dateFormatter);
    }

    private void processDecimalFormatStart(Attributes attributes) throws XMLMiddlewareException {
        this.processFormatStart(attributes);
        this.pattern = this.getAttrValue(attributes, MapConst.ATTR_PATTERN);
    }

    private void processDecimalFormatEnd() throws XMLMiddlewareException {
        NumberFormat numberFormat;
        if (this.locale != null) {
            try {
                numberFormat = NumberFormat.getInstance(this.locale);
                ((DecimalFormat)numberFormat).applyLocalizedPattern(this.pattern);
            }
            catch (ClassCastException classCastException) {
                throw new XMLMiddlewareException("No DecimalFormat object available for locale with country " + this.locale.getCountry() + " and language " + this.locale.getLanguage() + ".");
            }
        } else {
            numberFormat = new DecimalFormat(this.pattern);
        }
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        this.addNamedFormatter(this.formatName, numberFormatter);
        this.addDefaultFormatter(this.defaultForTypes, numberFormatter);
    }

    private void processElementType(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        this.elementTypeName = XMLName.create(string, this.map.getNamespaceURIs());
        switch (this.state) {
            case 2: {
                this.classMap = this.map.createClassMap(this.elementTypeName);
                return;
            }
            case 4: {
                this.propMap = PropertyMap.create(this.elementTypeName, 1);
                this.propMap.setIsTokenList(this.isTokenList);
                this.propMap.setContainsXML(this.containsXML);
                switch ((Integer)this.stateStack.peek()) {
                    case 2: {
                        this.classMap.addChildMap(this.propMap);
                        return;
                    }
                    case 6: {
                        this.inlineClassMap.addChildMap(this.propMap);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 5: {
                this.rcmWrapper.relatedClassMap = RelatedClassMap.create(this.elementTypeName);
                switch ((Integer)this.stateStack.peek()) {
                    case 2: {
                        this.classMap.addChildMap(this.rcmWrapper.relatedClassMap);
                        return;
                    }
                    case 6: {
                        this.inlineClassMap.addChildMap(this.rcmWrapper.relatedClassMap);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 6: {
                this.inlineClassMap = InlineClassMap.create(this.elementTypeName);
                switch ((Integer)this.stateStack.peek()) {
                    case 2: {
                        this.classMap.addChildMap(this.inlineClassMap);
                        return;
                    }
                    case 6: {
                        InlineClassMap inlineClassMap = (InlineClassMap)this.inlineClassMapStack.peek();
                        inlineClassMap.addChildMap(this.inlineClassMap);
                        return;
                    }
                }
            }
        }
    }

    private void processEmptyStringIsNull() {
        this.map.setEmptyStringIsNull(true);
    }

    private void processExtends(Attributes attributes) throws XMLMiddlewareException {
        throw new XMLMiddlewareException("Extends keyword not yet implemented.");
    }

    private void processFixedOrder(Attributes attributes) throws XMLMiddlewareException {
        if (this.state == 4 && this.propMap.getType() == 2) {
            throw new XMLMiddlewareException("A PropertyMap for an attribute may not contain a FixedOrder element. (If the attribute value is a token list, it may contain an TLOrderColumn element.)");
        }
        OrderInfo orderInfo = this.createOrderInfo(attributes, false);
        String string = this.getAttrValue(attributes, MapConst.ATTR_VALUE);
        orderInfo.setFixedOrderValue(this.parseInt(string));
    }

    private void processForeignKey(Attributes attributes) throws XMLMiddlewareException {
        this.keyColumns.removeAllElements();
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        this.key = Key.createForeignKey(string);
        this.table.addForeignKey(this.key);
        FKWrapper fKWrapper = new FKWrapper();
        this.fkWrapperStack.push(fKWrapper);
        fKWrapper.foreignKey = this.key;
    }

    private void processFormatClass(Attributes attributes) throws XMLMiddlewareException {
        StringFormatter stringFormatter;
        this.processFormatStart(attributes);
        String string = this.getAttrValue(attributes, MapConst.ATTR_CLASS);
        try {
            stringFormatter = (StringFormatter)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
        this.addNamedFormatter(this.formatName, stringFormatter);
        this.addDefaultFormatter(this.defaultForTypes, stringFormatter);
    }

    private void processFormatStart(Attributes attributes) throws XMLMiddlewareException {
        this.formatName = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        this.defaultForTypes = this.getAttrValue(attributes, MapConst.ATTR_DEFAULTFORTYPES);
        if (this.formatName == null && this.defaultForTypes == null) {
            throw new XMLMiddlewareException("At least one of the attributes Name and DefaultForTypes must be present on a formatting element.");
        }
        this.locale = null;
    }

    private void processKeyEnd() {
        Column[] columnArray = new Column[this.keyColumns.size()];
        int n = 0;
        while (n < columnArray.length) {
            columnArray[n] = (Column)this.keyColumns.elementAt(n);
            ++n;
        }
        this.key.setColumns(columnArray);
    }

    private void processLocale(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_COUNTRY);
        String string2 = this.getAttrValue(attributes, MapConst.ATTR_LANGUAGE);
        this.locale = new Locale(string2, string);
    }

    private void processNamespace(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_PREFIX);
        if (string == null) {
            string = "";
        }
        String string2 = this.getAttrValue(attributes, MapConst.ATTR_URI);
        this.map.addNamespace(string, string2);
    }

    private void processNumberFormatEnd() throws XMLMiddlewareException {
        NumberFormat numberFormat = NumberFormat.getInstance(this.locale);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        this.addNamedFormatter(this.formatName, numberFormatter);
        this.addDefaultFormatter(this.defaultForTypes, numberFormatter);
    }

    private void processOrderColumn(Attributes attributes, boolean bl) throws XMLMiddlewareException {
        Table table = null;
        OrderInfo orderInfo = this.createOrderInfo(attributes, bl);
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        boolean bl2 = this.isYes(this.getAttrValue(attributes, MapConst.ATTR_GENERATE, MapConst.DEF_GENERATE));
        switch (this.state) {
            case 4: {
                LinkInfo linkInfo;
                if (bl) {
                    if (!this.propMap.isTokenList()) {
                        throw new XMLMiddlewareException("A PropertyMap cannot contain a TLOrderColumn element unless the TokenList attribute is set to 'Yes'.");
                    }
                } else if (this.propMap.getType() == 2) {
                    throw new XMLMiddlewareException("A PropertyMap for an attribute may not contain an OrderColumn element. (If the attribute value is a token list, it may contain a TLOrderColumn element.)");
                }
                if ((linkInfo = this.propMap.getLinkInfo()) == null) {
                    table = this.classMap.getTable();
                    break;
                }
                if (linkInfo.parentKeyIsUnique()) {
                    table = this.propMap.getTable();
                    break;
                }
                table = this.classMap.getTable();
                break;
            }
            case 5: {
                this.rcmWrapper.orderColumnName = string;
                this.rcmWrapper.generateOrder = bl2;
                return;
            }
            case 6: {
                table = this.classMap.getTable();
                break;
            }
        }
        Column column = table.getColumn(string);
        if (column == null) {
            throw new XMLMiddlewareException("Order column " + string + " not found in table " + table.getUniversalName());
        }
        orderInfo.setOrderColumn(column);
        orderInfo.setGenerateOrder(bl2);
    }

    private void processPCDATA() throws XMLMiddlewareException {
        if (this.containsXML) {
            throw new XMLMiddlewareException("The ContainsXML attribute may not be set to 'Yes' for PropertyMaps that map PCDATA.");
        }
        this.propMap = PropertyMap.create(null, 3);
        this.propMap.setIsTokenList(this.isTokenList);
        switch ((Integer)this.stateStack.peek()) {
            case 2: {
                this.classMap.addPCDATAMap(this.propMap);
                return;
            }
            case 6: {
                this.inlineClassMap.addPCDATAMap(this.propMap);
                return;
            }
        }
    }

    private void processPrimaryKey(Attributes attributes) throws XMLMiddlewareException {
        int n;
        this.keyColumns.removeAllElements();
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME, MapConst.VALUE_PRIMARYKEY);
        this.key = Key.createPrimaryKey(string);
        this.table.addPrimaryKey(this.key);
        String string2 = this.getAttrValue(attributes, MapConst.ATTR_KEYGENERATOR);
        if (string2 == null) {
            n = 1;
        } else if (string2.equals(MapConst.VALUE_DATABASE)) {
            n = 3;
            string2 = null;
        } else {
            n = 2;
        }
        this.key.setKeyGeneration(n, string2);
    }

    private void processPropertyMap(Attributes attributes) {
        String string = this.getAttrValue(attributes, MapConst.ATTR_TOKENLIST, MapConst.DEF_TOKENLIST);
        this.isTokenList = this.isYes(string);
        string = this.getAttrValue(attributes, MapConst.ATTR_CONTAINSXML, MapConst.DEF_CONTAINSXML);
        this.containsXML = this.isYes(string);
    }

    private void processRelatedClass(Attributes attributes) {
        this.rcmWrapper = new RCMWrapper();
        this.rcmWrapperStack.push(this.rcmWrapper);
        this.rcmWrapper.parentClassMap = this.classMap;
        this.rcmWrapper.parentKeyIsUnique = this.getParentKeyIsUnique(attributes, MapConst.ATTR_KEYINPARENTTABLE);
    }

    private void processSchema(Attributes attributes) {
        this.schemaName = this.getAttrValue(attributes, MapConst.ATTR_NAME);
    }

    private void processSimpleDateFormatEnd() throws XMLMiddlewareException {
        SimpleDateFormat simpleDateFormat = this.locale == null ? new SimpleDateFormat(this.pattern) : new SimpleDateFormat(this.pattern, this.locale);
        DateFormatter dateFormatter = new DateFormatter(simpleDateFormat);
        this.addNamedFormatter(this.formatName, dateFormatter);
        this.addDefaultFormatter(this.defaultForTypes, dateFormatter);
    }

    private void processSimpleDateFormatStart(Attributes attributes) throws XMLMiddlewareException {
        this.processFormatStart(attributes);
        this.pattern = this.getAttrValue(attributes, MapConst.ATTR_PATTERN);
    }

    private void processTableStart(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        this.table = Table.create(this.databaseName, this.catalogName, this.schemaName, string);
        this.map.addTable(this.table);
    }

    private void processTableEnd() throws XMLMiddlewareException {
        Enumeration enumeration = this.table.getColumns();
        int n = 1;
        while (n <= this.table.getNumberOfColumns()) {
            Column column = (Column)enumeration.nextElement();
            column.setResultSetIndex(n);
            ++n;
        }
    }

    private void processTimeFormatEnd() throws XMLMiddlewareException {
        DateFormat dateFormat = this.locale == null ? DateFormat.getTimeInstance(this.timeStyle) : DateFormat.getTimeInstance(this.timeStyle, this.locale);
        DateFormatter dateFormatter = new DateFormatter(dateFormat);
        this.addNamedFormatter(this.formatName, dateFormatter);
        this.addDefaultFormatter(this.defaultForTypes, dateFormatter);
    }

    private void processToClassTable(Attributes attributes) throws XMLMiddlewareException {
        Table table = this.getTable(attributes);
        String string = table.getHashName();
        if (this.propTables.get(string) != null) {
            throw new XMLMiddlewareException("Table already mapped as a property table: " + table.getUniversalName());
        }
        if (this.classTables.get(string) != null) {
            throw new XMLMiddlewareException("Table already mapped as a class table: " + table.getUniversalName());
        }
        this.classTables.put(string, table);
        this.classMap.setTable(table);
    }

    private void processToColumn(Attributes attributes) throws XMLMiddlewareException {
        String string;
        Column column;
        Table table = this.propMap.getTable();
        if (table == null) {
            table = this.classMap.getTable();
        }
        if ((column = table.getColumn(string = this.getAttrValue(attributes, MapConst.ATTR_NAME))) == null) {
            throw new XMLMiddlewareException("Property column " + string + " not found in table " + table.getUniversalName());
        }
        this.propMap.setColumn(column);
    }

    private void processToPropertyTable(Attributes attributes) throws XMLMiddlewareException {
        this.propertyTable = this.getTable(attributes);
        this.parentKeyIsUnique = true;
        String string = this.propertyTable.getHashName();
        if (this.propTables.get(string) != null) {
            throw new XMLMiddlewareException("Table already mapped as a property table: " + this.propertyTable.getUniversalName());
        }
        if (this.classTables.get(string) != null) {
            throw new XMLMiddlewareException("Table already mapped as a class table: " + this.propertyTable.getUniversalName());
        }
        this.propTables.put(string, this.propertyTable);
    }

    private void processUniqueKey(Attributes attributes) throws XMLMiddlewareException {
        this.keyColumns.removeAllElements();
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        this.key = Key.createUniqueKey(string);
        this.table.addUniqueKey(this.key);
    }

    private void processUseBaseTable(Attributes attributes) {
        this.baseTableWrapper = new BaseTableWrapper();
        this.baseTableWrapperStack.push(this.baseTableWrapper);
        this.baseTableWrapper.extendedClassMap = this.classMap;
        this.baseTableWrapper.baseKeyIsUnique = this.getParentKeyIsUnique(attributes, MapConst.ATTR_KEYINBASETABLE);
    }

    private void processUseClassMap(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_ELEMENTTYPE);
        XMLName xMLName = XMLName.create(string, this.map.getNamespaceURIs());
        ClassMap classMap = this.map.createClassMap(xMLName);
        switch (this.state) {
            case 2: {
                this.classMap.useClassMap(classMap);
                return;
            }
            case 5: {
                this.rcmWrapper.relatedClassMap.setClassMap(classMap);
                return;
            }
        }
    }

    private void processUseColumn(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        Column column = this.table.getColumn(string);
        if (column == null) {
            throw new XMLMiddlewareException("Key column " + string + " not found in table " + this.table.getUniversalName());
        }
        this.keyColumns.addElement(column);
    }

    private void processUseForeignKey(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        switch (this.state) {
            case 7: {
                Table table = this.parentKeyIsUnique ? this.propertyTable : this.classMap.getTable();
                Table table2 = this.parentKeyIsUnique ? this.classMap.getTable() : this.propertyTable;
                Key key = this.getForeignKey(table, string);
                this.checkUniqueKey(MapConst.ELEM_TOPROPERTYTABLE, table, key, table2, this.uniqueKey);
                LinkInfo linkInfo = this.parentKeyIsUnique ? LinkInfo.create(this.uniqueKey, key) : LinkInfo.create(key, this.uniqueKey);
                this.propMap.setTable(this.propertyTable, linkInfo);
                return;
            }
            case 5: {
                this.rcmWrapper.foreignKeyName = string;
                return;
            }
            case 3: {
                this.baseTableWrapper.foreignKeyName = string;
                return;
            }
        }
    }

    private void processUseTable(Attributes attributes) {
        FKWrapper fKWrapper = (FKWrapper)this.fkWrapperStack.peek();
        fKWrapper.remoteDatabaseName = this.getAttrValue(attributes, MapConst.ATTR_DATABASE, MapConst.DEF_DATABASENAME);
        fKWrapper.remoteCatalogName = this.getAttrValue(attributes, MapConst.ATTR_CATALOG);
        fKWrapper.remoteSchemaName = this.getAttrValue(attributes, MapConst.ATTR_SCHEMA);
        fKWrapper.remoteTableName = this.getAttrValue(attributes, MapConst.ATTR_NAME);
    }

    private void processUseUniqueKey(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_NAME);
        switch (this.state) {
            case 1: {
                FKWrapper fKWrapper = (FKWrapper)this.fkWrapperStack.peek();
                fKWrapper.remoteKeyName = string;
                return;
            }
            case 7: {
                Table table = this.parentKeyIsUnique ? this.classMap.getTable() : this.propertyTable;
                this.uniqueKey = this.getUniqueKey(table, string);
                return;
            }
            case 5: {
                this.rcmWrapper.uniqueKeyName = string;
                if (this.rcmWrapper.relatedClassMap.getClassMap() != null) break;
                this.rcmWrapper.relatedClassMap.setClassMap(this.map.createClassMap(this.elementTypeName));
                return;
            }
            case 3: {
                this.baseTableWrapper.uniqueKeyName = string;
                return;
            }
        }
    }

    private void processXMLToDBMS(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, MapConst.ATTR_VERSION, MapConst.DEF_VERSION);
        if (!string.equals(MapConst.DEF_VERSION)) {
            throw new XMLMiddlewareException("Unsupported XML-DBMS version: " + string);
        }
    }

    private void init() {
        this.elementTokens = new TokenList(MapConst.ELEMS, MapConst.ELEM_TOKENS, -999);
        this.enumTokens = new TokenList(MapConst.ENUMS, MapConst.ENUM_TOKENS, -999);
    }

    private OrderInfo createOrderInfo(Attributes attributes, boolean bl) {
        OrderInfo orderInfo = OrderInfo.create();
        switch (this.state) {
            case 4: {
                if (bl) {
                    this.propMap.setTokenListOrderInfo(orderInfo);
                    break;
                }
                this.propMap.setOrderInfo(orderInfo);
                break;
            }
            case 5: {
                this.rcmWrapper.relatedClassMap.setOrderInfo(orderInfo);
                break;
            }
            case 6: {
                this.inlineClassMap.setOrderInfo(orderInfo);
                break;
            }
        }
        String string = this.getAttrValue(attributes, MapConst.ATTR_DIRECTION, MapConst.DEF_DIRECTION);
        orderInfo.setIsAscending(string.equals(MapConst.ENUM_ASCENDING));
        return orderInfo;
    }

    private void addNamedFormatter(String string, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (string == null) {
            return;
        }
        this.map.addNamedFormatter(string, stringFormatter);
    }

    private void addDefaultFormatter(String string, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = JDBCTypes.getType(string2);
            if (n == 0) {
                throw new XMLMiddlewareException("Invalid JDBC type name: " + string2);
            }
            if (this.formatTypes.get(string2) != null) {
                throw new XMLMiddlewareException("Default format already set for type: " + string2);
            }
            this.formatTypes.put(string2, string2);
            this.map.setDefaultFormatter(n, stringFormatter);
        }
    }

    private void resolveFKWrappers() throws XMLMiddlewareException {
        while (!this.fkWrapperStack.empty()) {
            this.resolveFKWrapper((FKWrapper)this.fkWrapperStack.pop());
        }
    }

    private void resolveFKWrapper(FKWrapper fKWrapper) throws XMLMiddlewareException {
        Table table = this.map.getTable(fKWrapper.remoteDatabaseName, fKWrapper.remoteCatalogName, fKWrapper.remoteSchemaName, fKWrapper.remoteTableName);
        if (table == null) {
            throw new XMLMiddlewareException("Table not found: " + Table.getUniversalName(fKWrapper.remoteDatabaseName, fKWrapper.remoteCatalogName, fKWrapper.remoteSchemaName, fKWrapper.remoteTableName) + ". Referenced by foreign key: " + fKWrapper.foreignKey.getName());
        }
        Key key = this.getUniqueKey(table, fKWrapper.remoteKeyName);
        fKWrapper.foreignKey.setRemoteKey(table, key);
    }

    private void resolveRCMWrappers() throws XMLMiddlewareException {
        while (!this.rcmWrapperStack.empty()) {
            this.resolveRCMWrapper((RCMWrapper)this.rcmWrapperStack.pop());
        }
    }

    private void resolveRCMWrapper(RCMWrapper rCMWrapper) throws XMLMiddlewareException {
        Table table = rCMWrapper.parentClassMap.getTable();
        Table table2 = rCMWrapper.relatedClassMap.getClassMap().getTable();
        if (table2 == null) {
            throw new XMLMiddlewareException("Element type " + rCMWrapper.relatedClassMap.getClassMap().getElementTypeName().getUniversalName() + " mapped as a related class but never mapped as a class.");
        }
        Table table3 = rCMWrapper.parentKeyIsUnique ? table : table2;
        Key key = this.getUniqueKey(table3, rCMWrapper.uniqueKeyName);
        Table table4 = rCMWrapper.parentKeyIsUnique ? table2 : table;
        Key key2 = this.getForeignKey(table4, rCMWrapper.foreignKeyName);
        this.checkUniqueKey(MapConst.ELEM_RELATEDCLASS, table4, key2, table3, key);
        LinkInfo linkInfo = rCMWrapper.parentKeyIsUnique ? LinkInfo.create(key, key2) : LinkInfo.create(key2, key);
        rCMWrapper.relatedClassMap.setLinkInfo(linkInfo);
        if (rCMWrapper.orderColumnName != null) {
            Table table5 = rCMWrapper.parentKeyIsUnique ? rCMWrapper.relatedClassMap.getClassMap().getTable() : rCMWrapper.parentClassMap.getTable();
            Column column = table5.getColumn(rCMWrapper.orderColumnName);
            if (column == null) {
                throw new XMLMiddlewareException("Order column " + rCMWrapper.orderColumnName + " not found in table " + table5.getUniversalName() + ".");
            }
            OrderInfo orderInfo = rCMWrapper.relatedClassMap.getOrderInfo();
            orderInfo.setOrderColumn(column);
            orderInfo.setGenerateOrder(rCMWrapper.generateOrder);
        }
    }

    private void resolveBaseTableWrappers() throws XMLMiddlewareException {
        while (!this.baseTableWrapperStack.empty()) {
            this.resolveBaseTableWrapper((BaseTableWrapper)this.baseTableWrapperStack.pop());
        }
    }

    private void resolveBaseTableWrapper(BaseTableWrapper baseTableWrapper) throws XMLMiddlewareException {
        Table table = baseTableWrapper.extendedClassMap.getTable();
        Table table2 = baseTableWrapper.extendedClassMap.getBaseClassMap().getTable();
        if (table2 == null) {
            throw new XMLMiddlewareException("Element type " + baseTableWrapper.extendedClassMap.getBaseClassMap().getElementTypeName().getUniversalName() + " mapped as a base class but never mapped as a class.");
        }
        Table table3 = baseTableWrapper.baseKeyIsUnique ? table2 : table;
        Key key = this.getUniqueKey(table3, baseTableWrapper.uniqueKeyName);
        Table table4 = baseTableWrapper.baseKeyIsUnique ? table : table2;
        Key key2 = this.getForeignKey(table4, baseTableWrapper.foreignKeyName);
        this.checkUniqueKey(MapConst.ELEM_USEBASETABLE, table4, key2, table3, key);
        LinkInfo linkInfo = baseTableWrapper.baseKeyIsUnique ? LinkInfo.create(key, key2) : LinkInfo.create(key2, key);
        baseTableWrapper.extendedClassMap.setBaseLinkInfo(linkInfo);
    }

    private String getAttrValue(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private String getAttrValue(Attributes attributes, String string, String string2) {
        String string3 = this.getAttrValue(attributes, string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private boolean getParentKeyIsUnique(Attributes attributes, String string) {
        String string2 = this.getAttrValue(attributes, string);
        return string2.equals(MapConst.ENUM_UNIQUE);
    }

    private Table getTable(Attributes attributes) throws XMLMiddlewareException {
        String string;
        String string2;
        String string3;
        String string4 = this.getAttrValue(attributes, MapConst.ATTR_DATABASE, MapConst.DEF_DATABASENAME);
        Table table = this.map.getTable(string4, string3 = this.getAttrValue(attributes, MapConst.ATTR_CATALOG), string2 = this.getAttrValue(attributes, MapConst.ATTR_SCHEMA), string = this.getAttrValue(attributes, MapConst.ATTR_NAME));
        if (table == null) {
            throw new XMLMiddlewareException("Table not found: " + Table.getUniversalName(string4, string3, string2, string));
        }
        return table;
    }

    private boolean isYes(String string) {
        return string.equals(MapConst.ENUM_YES);
    }

    private int parseInt(String string) throws XMLMiddlewareException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLMiddlewareException("Invalid integer value: " + string + ". " + numberFormatException.getMessage());
        }
        return n;
    }

    private Key getUniqueKey(Table table, String string) throws XMLMiddlewareException {
        Key key = table.getPrimaryKey();
        if (!string.equals(key.getName()) && (key = table.getUniqueKey(string)) == null) {
            throw new XMLMiddlewareException("Unique or primary key with the name " + string + " not found in table " + table.getUniversalName());
        }
        return key;
    }

    private Key getForeignKey(Table table, String string) throws XMLMiddlewareException {
        Key key = table.getForeignKey(string);
        if (key == null) {
            throw new XMLMiddlewareException("Foreign key " + string + " not found in table " + table.getUniversalName());
        }
        return key;
    }

    private void checkUniqueKey(String string, Table table, Key key, Table table2, Key key2) throws XMLMiddlewareException {
        Table table3 = key.getRemoteTable();
        if (!table3.equals(table2)) {
            throw new XMLMiddlewareException("<" + string + ">" + " uses foreign key " + key.getName() + " on table " + table.getUniversalName() + ". This references table " + table3.getUniversalName() + " but <UseUniqueKey> uses table " + table2.getUniversalName());
        }
        Key key3 = key.getRemoteKey();
        if (!key3.equals(key2)) {
            throw new XMLMiddlewareException("<" + string + ">" + " uses foreign key " + key.getName() + " on table " + table.getUniversalName() + ". This references unique key " + key3.getName() + " on table " + table3.getUniversalName() + " but <UseUniqueKey> uses key " + key2.getName() + " on table " + table2.getUniversalName());
        }
    }

    private void indent() {
        int n = 0;
        while (n < this.indent) {
            System.out.print(" ");
            ++n;
        }
    }

    class FKWrapper {
        Key foreignKey;
        String remoteDatabaseName;
        String remoteCatalogName;
        String remoteSchemaName;
        String remoteTableName;
        String remoteKeyName;

        FKWrapper() {
            MapCompiler.this = MapCompiler.this;
        }
    }

    class RCMWrapper {
        ClassMap parentClassMap;
        RelatedClassMap relatedClassMap;
        boolean parentKeyIsUnique = false;
        String uniqueKeyName;
        String foreignKeyName;
        String orderColumnName;
        boolean generateOrder = false;

        RCMWrapper() {
            MapCompiler.this = MapCompiler.this;
        }
    }

    class BaseTableWrapper {
        ClassMap extendedClassMap;
        boolean baseKeyIsUnique = false;
        String uniqueKeyName;
        String foreignKeyName;

        BaseTableWrapper() {
            MapCompiler.this = MapCompiler.this;
        }
    }
}

