/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.datahandlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.xmlmiddleware.conversions.ByteArray;
import org.xmlmiddleware.conversions.ConvertObject;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.Column;

public class Parameters {
    public static void setParameters(PreparedStatement preparedStatement, int n, Column[] columnArray, Object[] objectArray) throws SQLException {
        int n2 = 0;
        while (n2 < objectArray.length) {
            Parameters.setParameter(preparedStatement, n2 + n + 1, columnArray[n2], objectArray[n2]);
            ++n2;
        }
    }

    public static void setParameter(PreparedStatement preparedStatement, int n, Column column, Object object) throws SQLException {
        int n2 = column.getType();
        if (object == null) {
            preparedStatement.setNull(n, n2);
            return;
        }
        try {
            switch (n2) {
                case -7: {
                    preparedStatement.setBoolean(n, (Boolean)object);
                    return;
                }
                case -6: {
                    preparedStatement.setByte(n, (Byte)object);
                    return;
                }
                case 5: {
                    preparedStatement.setShort(n, (Short)object);
                    return;
                }
                case 4: {
                    preparedStatement.setInt(n, (Integer)object);
                    return;
                }
                case -5: {
                    preparedStatement.setLong(n, (Long)object);
                    return;
                }
                case 7: {
                    preparedStatement.setFloat(n, ((Float)object).floatValue());
                    return;
                }
                case 6: 
                case 8: {
                    preparedStatement.setDouble(n, (Double)object);
                    return;
                }
                case 2: 
                case 3: {
                    preparedStatement.setBigDecimal(n, (BigDecimal)object);
                    return;
                }
                case 1: 
                case 12: {
                    preparedStatement.setString(n, (String)object);
                    return;
                }
                case -1: {
                    try {
                        byte[] byArray = ((String)object).getBytes("UTF-16");
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        preparedStatement.setUnicodeStream(n, byteArrayInputStream, byArray.length);
                        return;
                    }
                    catch (Exception exception) {
                        try {
                            byte[] byArray = ((String)object).getBytes("US-ASCII");
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                            preparedStatement.setAsciiStream(n, (InputStream)byteArrayInputStream, byArray.length);
                            return;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SQLException("[XML-DBMS] " + unsupportedEncodingException.getMessage());
                        }
                    }
                }
                case -3: 
                case -2: {
                    byte[] byArray = ((ByteArray)object).getBytes();
                    preparedStatement.setBytes(n, byArray);
                    return;
                }
                case -4: {
                    byte[] byArray = ((ByteArray)object).getBytes();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
                    return;
                }
                case 91: {
                    preparedStatement.setDate(n, (Date)object);
                    return;
                }
                case 92: {
                    preparedStatement.setTime(n, (Time)object);
                    return;
                }
                case 93: {
                    preparedStatement.setTimestamp(n, (Timestamp)object);
                    return;
                }
            }
            String string = JDBCTypes.getName(n2);
            if (string == null) {
                string = Integer.toString(n2);
            }
            throw new SQLException("Unsupported JDBC Type: " + string);
        }
        catch (ClassCastException classCastException) {
            Parameters.convertAndSetParameter(preparedStatement, n, column, object);
            return;
        }
    }

    public static void convertAndSetParameters(PreparedStatement preparedStatement, int n, Column[] columnArray, Object[] objectArray) throws SQLException {
        int n2 = 0;
        while (n2 < objectArray.length) {
            Parameters.convertAndSetParameter(preparedStatement, n2 + n + 1, columnArray[n2], objectArray[n2]);
            ++n2;
        }
    }

    public static void convertAndSetParameter(PreparedStatement preparedStatement, int n, Column column, Object object) throws SQLException {
        Object object2;
        int n2 = column.getType();
        if (object == null) {
            preparedStatement.setNull(n, n2);
            return;
        }
        try {
            StringFormatter stringFormatter = column.getFormatter();
            object2 = object instanceof String ? stringFormatter.parse((String)object, n2) : ConvertObject.convertObject(object, n2, stringFormatter);
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SQLException("[XML-DBMS] " + xMLMiddlewareException.getMessage());
        }
        Parameters.setParameter(preparedStatement, n, column, object2);
    }
}

