/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.utils;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public abstract class Pool {
    protected Hashtable m_objects = new Hashtable();
    protected Hashtable m_checked = new Hashtable();

    public void finalize() {
        this.clear();
    }

    public Object checkOut(Object object) throws XMLMiddlewareException {
        Stack stack;
        Object object2 = null;
        if (this.m_objects.containsKey(object) && !(stack = (Stack)this.m_objects.get(object)).empty()) {
            object2 = stack.pop();
        }
        if (object2 == null) {
            object2 = this.createObject(object);
        }
        this.m_checked.put(object2, object);
        return object2;
    }

    public void checkIn(Object object) throws XMLMiddlewareException {
        if (!this.m_checked.containsKey(object)) {
            throw new XMLMiddlewareException("Object does not belong to this pool.");
        }
        Object v = this.m_checked.remove(object);
        if (!this.m_objects.containsKey(v)) {
            this.m_objects.put(v, new Stack());
        }
        Stack stack = (Stack)this.m_objects.get(v);
        stack.push(object);
    }

    protected abstract Object createObject(Object var1) throws XMLMiddlewareException;

    protected abstract void closeObject(Object var1) throws XMLMiddlewareException;

    protected void clear() {
        this.closeCheckedInObjects();
        this.closeCheckedOutObjects();
        this.m_objects.clear();
        this.m_checked.clear();
    }

    protected void remove(Object object) throws XMLMiddlewareException {
        if (!this.m_checked.containsKey(object)) {
            throw new XMLMiddlewareException("Object not in pool");
        }
        try {
            this.closeObject(object);
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {}
        this.m_checked.remove(object);
    }

    protected void closeCheckedInObjects() {
        Enumeration enumeration = this.m_objects.elements();
        while (enumeration.hasMoreElements()) {
            Stack stack = (Stack)enumeration.nextElement();
            while (!stack.empty()) {
                try {
                    this.closeObject(stack.pop());
                }
                catch (XMLMiddlewareException xMLMiddlewareException) {}
            }
        }
    }

    protected void closeCheckedOutObjects() {
        Enumeration enumeration = this.m_checked.keys();
        while (enumeration.hasMoreElements()) {
            try {
                this.closeObject(enumeration.nextElement());
            }
            catch (XMLMiddlewareException xMLMiddlewareException) {}
        }
    }
}

