/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.video.publish;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.video.VSConfig;
import com.trs.components.video.VideoDocUtil;
import com.trs.components.video.domain.XVideoMgr;
import com.trs.components.video.persistent.XVideo;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class VideoTagParser
extends BaseTagParser {
    private static final Logger LOG;
    static final String FIELD_DURATION = "_DURATION";
    static final String FIELD_THUMBURL = "_THUMBURL";
    static final String FIELD_VIDEOURL = "_VIDEOURL";
    public static final String TAG_NAME = "TRS_VIDEO";
    private String thumbUrlRoot = VSConfig.getThumbsHomeUrl();
    private String videoUrlRoot = VSConfig.getUploadFMSAppUrl();
    private TagBeanInfo tagBeanInfo = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.publish.VideoTagParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public VideoTagParser() {
        this.buildTagBeanInfo();
    }

    private void buildTagBeanInfo() {
        TagBeanInfo tbi = new TagBeanInfo();
        tbi.setName(TAG_NAME);
        tbi.setDesc(TAG_NAME);
        tbi.setType(TagBeanInfo.BodyType.IGNORE);
        TagBeanAttrInfo tbai = new TagBeanAttrInfo();
        tbai.setName("FIELD");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setDefaultValue(FIELD_THUMBURL);
        tbai.setEnumValue(new String[]{FIELD_THUMBURL, FIELD_DURATION, FIELD_VIDEOURL});
        tbi.addAttrInfo(tbai);
        this.tagBeanInfo = tbi;
    }

    public TagBeanInfo getBeanInfo() {
        return this.tagBeanInfo;
    }

    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishElement upperHost = _context.getUpperHost();
        if (upperHost.isFolder()) {
            StringBuffer stringBuffer = new StringBuffer(TAG_NAME);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.publish.VideoTagParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WCMException(stringBuffer.append(CMyString.format((String)I18NMessage.get((Class)clazz, (String)"VideoTagParser.label1", (String)"\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u680f\u76ee[{0}]\u4e0a\uff01"), (String[])new String[]{upperHost.getInfo()})).toString());
        }
        CMSObj substance = upperHost.getSubstance();
        if (!(substance instanceof Document)) {
            StringBuffer stringBuffer = new StringBuffer(TAG_NAME);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.publish.VideoTagParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WCMException(stringBuffer.append(CMyString.format((String)I18NMessage.get((Class)clazz, (String)"VideoTagParser.label3", (String)"\u7f6e\u6807\u76ee\u524d\u53ea\u80fd\u7528\u5230\u6587\u6863\u5bf9\u8c61\u4e0a\uff0c\u4e0d\u80fd\u7528\u5230\u5176\u5b83\u5bf9\u8c61[{0}]\u4e0a\uff01"), (String[])new String[]{upperHost.getInfo()})).toString());
        }
        Document document = (Document)substance;
        XVideo xvideo = XVideo.findByDocIdAndQuality(document.getDocId(), 1);
        if (xvideo == null) {
            xvideo = XVideo.findByDocIdAndQuality(document.getDocId(), 0);
        }
        if (xvideo == null || xvideo.getConvertStatus() == 0) {
            return new String[]{""};
        }
        String sFieldName = _context.getAttribute("FIELD");
        String result = null;
        if (sFieldName == null || FIELD_THUMBURL.equalsIgnoreCase(sFieldName)) {
            result = XVideoMgr.getThumbUrl(xvideo);
        } else if (FIELD_DURATION.equalsIgnoreCase(sFieldName)) {
            result = VideoDocUtil.getReadbleDurationByInt(xvideo.getDuration());
        } else if (FIELD_VIDEOURL.equalsIgnoreCase(sFieldName)) {
            result = XVideoMgr.getPlayUrl(xvideo);
        } else {
            LOG.warn((Object)("[ " + sFieldName + " ] is not a valid field!"));
            result = "";
        }
        if (LOG.isInfoEnabled()) {
            LOG.debug((Object)("parsed result: " + result));
        }
        return new String[]{result};
    }
}

