/*
 * Decompiled with CFR 0.152.
 */
package trs.org.objectweb.asm.xml;

import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import trs.org.objectweb.asm.AnnotationVisitor;
import trs.org.objectweb.asm.Type;
import trs.org.objectweb.asm.xml.SAXAdapter;
import trs.org.objectweb.asm.xml.SAXClassAdapter;

public class SAXAnnotationAdapter
extends SAXAdapter
implements AnnotationVisitor {
    private final String elementName;

    public SAXAnnotationAdapter(ContentHandler h, String elementName, int visible, String name, String desc) {
        this(h, elementName, visible, desc, name, -1);
    }

    public SAXAnnotationAdapter(ContentHandler h, String elementName, int visible, int parameter, String desc) {
        this(h, elementName, visible, desc, null, parameter);
    }

    private SAXAnnotationAdapter(ContentHandler h, String elementName, int visible, String desc, String name, int parameter) {
        super(h);
        this.elementName = elementName;
        AttributesImpl att = new AttributesImpl();
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (visible != 0) {
            att.addAttribute("", "visible", "visible", "", visible > 0 ? "true" : "false");
        }
        if (parameter != -1) {
            att.addAttribute("", "parameter", "parameter", "", Integer.toString(parameter));
        }
        if (desc != null) {
            att.addAttribute("", "desc", "desc", "", desc);
        }
        this.addStart(elementName, att);
    }

    public void visit(String name, Object value) {
        Class<?> c = value.getClass();
        if (c.isArray()) {
            AnnotationVisitor av = this.visitArray(name);
            if (value instanceof byte[]) {
                byte[] b = (byte[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, new Byte(b[i]));
                    ++i;
                }
            } else if (value instanceof char[]) {
                char[] b = (char[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, new Character(b[i]));
                    ++i;
                }
            } else if (value instanceof boolean[]) {
                boolean[] b = (boolean[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, b[i]);
                    ++i;
                }
            } else if (value instanceof int[]) {
                int[] b = (int[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, new Integer(b[i]));
                    ++i;
                }
            } else if (value instanceof long[]) {
                long[] b = (long[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, new Long(b[i]));
                    ++i;
                }
            } else if (value instanceof float[]) {
                float[] b = (float[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, new Float(b[i]));
                    ++i;
                }
            } else if (value instanceof double[]) {
                double[] b = (double[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, new Double(b[i]));
                    ++i;
                }
            }
            av.visitEnd();
        } else {
            this.addValueElement("annotationValue", name, Type.getDescriptor(c), value.toString());
        }
    }

    public void visitEnum(String name, String desc, String value) {
        this.addValueElement("annotationValueEnum", name, desc, value);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueAnnotation", 0, name, desc);
    }

    public AnnotationVisitor visitArray(String name) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueArray", 0, name, null);
    }

    public void visitEnd() {
        this.addEnd(this.elementName);
    }

    private void addValueElement(String element, String name, String desc, String value) {
        AttributesImpl att = new AttributesImpl();
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (desc != null) {
            att.addAttribute("", "desc", "desc", "", desc);
        }
        if (value != null) {
            att.addAttribute("", "value", "value", "", SAXClassAdapter.encode(value));
        }
        this.addElement(element, att);
    }
}

