/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.video.domain;

import com.trs.components.video.VSConfig;
import com.trs.components.video.persistent.XVideo;
import com.trs.components.video.util.HttpAPIClient;
import com.trs.components.video.util.HttpUtil;
import com.trs.components.video.util.StringUtil;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.dev4.util.JSONUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class XVideoMgr {
    private Connection oConn = null;
    private Statement oStmt = null;
    private ResultSet rsData = null;
    final String DB_TABLE_NAME = "WCMDOCUMENT";
    final String DB_TABLE_NAME_CHNL = "WCMCHNLDOC";
    final String DB_TABLE_NAME_XVIDEO = "XWCMVIDEO_SP2";
    private static final Logger LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.domain.XVideoMgr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    private void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isUsedByOthers(XVideo xvideo) throws WCMException {
        String fileName = xvideo.getFileName();
        return this.getCopiedCount(fileName) > 1;
    }

    public boolean isUsedByOthers(String token) throws WCMException {
        return this.getCopiedCount(token) > 1;
    }

    private int getCopiedCount(String fileName) throws WCMException {
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("select count(*) from XWCMVIDEO_SP2 where fileName='");
        sqlSb.append(fileName);
        sqlSb.append("'");
        return DBManager.getDBManager().sqlExecuteIntQuery(sqlSb.toString());
    }

    public String sendDeleteReuqest(String tokens) {
        String string = null;
        try {
            string = HttpAPIClient.getResponseTextWithPost(String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/delete", "tokens=" + tokens);
            LOG.info((Object)("send delete request : " + VSConfig.getUploadJavaAppIntranetUrl() + "params: " + tokens));
        }
        catch (WCMException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.domain.XVideoMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"XVideoMgr.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + VSConfig.getUploadJavaAppIntranetUrl() + "/service/delete"));
            e.printStackTrace();
        }
        LOG.info((Object)("send delete request,reponse is : " + string));
        return string;
    }

    public boolean sendConvertRequest(int createType, String token, String title, String appKey, String sampleId) {
        if (createType == 10) {
            return this.sendConvertVideoRequest(token, title, appKey, sampleId);
        }
        if (createType == 20) {
            return this.sendConvertRecordVideoRequest(token);
        }
        return false;
    }

    public boolean sendConvertRequest(int createType, String token, int sampleId) {
        if (createType == 10) {
            return this.sendConvertVideoRequest(token, sampleId);
        }
        if (createType == 20) {
            return this.sendConvertRecordVideoRequest(token);
        }
        return false;
    }

    private boolean sendConvertVideoRequest(String token, int sampleId) {
        return HttpUtil.requestWithPost(String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/jobSubmit", "token=" + token + "&sampleId=" + sampleId);
    }

    public boolean sendUpdateRequest(String token, String title) {
        boolean flag = false;
        try {
            flag = HttpAPIClient.requestWithPost(null, String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/update", "token=" + token + "&title=" + HttpAPIClient.urlEncode(title));
        }
        catch (WCMException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.domain.XVideoMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"XVideoMgr.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + VSConfig.getUploadJavaAppIntranetUrl() + "/service/jobSubmit"));
            e.printStackTrace();
        }
        return flag;
    }

    public boolean sendConvertCutRequest(String token) {
        boolean flag = false;
        try {
            flag = HttpAPIClient.requestWithPost(null, String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/jobSubmit", "tokens=" + token);
        }
        catch (WCMException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.domain.XVideoMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"XVideoMgr.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + VSConfig.getUploadJavaAppIntranetUrl() + "/service/jobSubmit"));
        }
        return flag;
    }

    private boolean sendConvertVideoRequest(String token, String title, String appKey, String sampleId) {
        boolean flag = false;
        try {
            flag = HttpAPIClient.requestWithPost(null, String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/jobSubmit", "token=" + token + "&title=" + HttpAPIClient.urlEncode(title) + "&appKey=" + HttpAPIClient.urlEncode(appKey) + "&sampleId=" + HttpAPIClient.urlEncode(sampleId));
        }
        catch (WCMException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.domain.XVideoMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"XVideoMgr.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + VSConfig.getUploadJavaAppIntranetUrl() + "/service/jobSubmit"));
            e.printStackTrace();
        }
        return flag;
    }

    public int sendConvertVideoRequestAndGetMASID(String token, String title, String appKey, String sampleId) throws Exception {
        int vid = 0;
        String responseStr = null;
        try {
            responseStr = HttpAPIClient.getResponseTextWithPost(String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/masJobSubmit", "token=" + token + "&title=" + HttpAPIClient.urlEncode(title) + "&appKey=" + HttpAPIClient.urlEncode(appKey) + "&sampleId=" + HttpAPIClient.urlEncode(sampleId));
            LOG.info((Object)("request MAS job submit url is : " + VSConfig.getUploadJavaAppIntranetUrl() + "/service/masJobSubmit&token=" + token + "&title=" + HttpAPIClient.urlEncode(title) + "&appKey=" + HttpAPIClient.urlEncode(appKey) + "&sampleId=" + HttpAPIClient.urlEncode(sampleId)));
        }
        catch (WCMException e) {
            LOG.error((Object)("http request error\uff0curl is:" + VSConfig.getUploadJavaAppIntranetUrl() + "/service/masJobSubmit"));
            throw new WCMException("\u8bf7\u6c42MAS\u5904\u7406\u89c6\u9891\u5f02\u5e38", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MAS responseStr is: " + responseStr));
        }
        if (StringUtil.isEmpty(responseStr)) {
            LOG.error((Object)("request MAS JobSubmit repsonse is null, url is: " + VSConfig.getUploadJavaAppIntranetUrl() + "/service/jobSubmit"));
            throw new WCMException("\u8bf7\u6c42MAS\u5904\u7406\u89c6\u9891\u5f02\u5e38\uff0cMAS\u8fd4\u56de\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u7684URL\uff1a" + VSConfig.getUploadJavaAppIntranetUrl() + "/service/jobSubmit");
        }
        String masIdStr = JSONUtil.getValue((String)responseStr, (String)"MASVID");
        String errInfo = JSONUtil.getValue((String)responseStr, (String)"err");
        if (masIdStr != null) {
            vid = Integer.parseInt(masIdStr);
        }
        if (errInfo != null) {
            LOG.error((Object)("request MAS JobSubmit error,detail info is: " + errInfo));
            throw new WCMException("\u8bf7\u6c42MAS\u5904\u7406\u89c6\u9891\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + errInfo);
        }
        return vid;
    }

    private boolean sendConvertRecordVideoRequest(String record) {
        boolean flag = false;
        try {
            flag = HttpAPIClient.requestWithPost(null, String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/jobSubmit", "record=" + record);
        }
        catch (WCMException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.domain.XVideoMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"XVideoMgr.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + VSConfig.getUploadJavaAppIntranetUrl() + "/service/jobSubmit"));
            e.printStackTrace();
        }
        return flag;
    }

    public boolean update(XVideo xvideo) throws WCMException {
        if (xvideo == null) {
            return false;
        }
        xvideo.setAddMode(false);
        xvideo.save();
        return true;
    }

    public boolean insert(XVideo xvideo) throws WCMException {
        if (xvideo == null) {
            return false;
        }
        xvideo.setAddMode(true);
        xvideo.save();
        return true;
    }

    public boolean copyXVideo(int _fromDocId, int _newDocId) throws WCMException {
        List xvideos = XVideo.findXVideosByDocId(_fromDocId);
        int i = 0;
        while (i < xvideos.size()) {
            XVideo oldXVideo = (XVideo)((Object)xvideos.get(i));
            if (oldXVideo == null) {
                return false;
            }
            oldXVideo.setCopied();
            this.update(oldXVideo);
            XVideo newXVideo = new XVideo();
            newXVideo.setDocId(_newDocId);
            newXVideo.setCopied();
            this.copyXVideoMetadata(newXVideo, oldXVideo);
            if (!this.insert(newXVideo)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void copyXVideoMetadata(XVideo newXVideo, XVideo oldXVideo) throws WCMException {
        newXVideo.setThumb(oldXVideo.getThumb());
        newXVideo.setDuration(oldXVideo.getDuration());
        newXVideo.setWidth(oldXVideo.getWidth());
        newXVideo.setHeight(oldXVideo.getHeight());
        newXVideo.setFPS(oldXVideo.getFPS());
        newXVideo.setBitrate(oldXVideo.getBitrate());
        newXVideo.setCreateType(oldXVideo.getCreateType());
        newXVideo.setConvertStatus(oldXVideo.getConvertStatus());
        newXVideo.setRefCount(oldXVideo.getRefCount());
        newXVideo.setPlayCount(oldXVideo.getPlayCount());
        newXVideo.setQuality(oldXVideo.getQuality());
        newXVideo.setSrcFileName(oldXVideo.getSrcFileName());
        newXVideo.setFileName(oldXVideo.getFileName());
        newXVideo.setThumbUrl(oldXVideo.getThumbUrl());
        newXVideo.setPlayUrl(oldXVideo.getPlayUrl());
        newXVideo.setVideoId(oldXVideo.getVideoId());
    }

    public String getPlayURL(XVideo video) {
        return XVideoMgr.getPlayUrl(video);
    }

    public String getiOSPlayURL(XVideo video) {
        return this.buildHttpPlayUrl(video, ".mp4");
    }

    public String getHttpPlayFlvURL(XVideo video) {
        return this.buildHttpPlayUrl(video, ".flv");
    }

    String buildHttpPlayUrl(XVideo video, String suffix) {
        String fileName = video.getFileName();
        if (fileName == null || "".equals(fileName)) {
            return null;
        }
        int dotPos = fileName.lastIndexOf(46);
        String relativePath = dotPos < 0 ? fileName : String.valueOf(fileName.substring(0, dotPos)) + suffix;
        return String.valueOf(VSConfig.getThumbsHomeUrl()) + "/" + relativePath;
    }

    public String getThumbURL(XVideo video) {
        return XVideoMgr.getThumbUrl(video);
    }

    public List findXVideos(Document document) throws WCMException {
        return XVideo.findXVideosByDocId(document.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteFailVideo(List list) throws Exception {
        if (list == null || list.equals("")) {
            return 0;
        }
        StringBuffer sql = new StringBuffer("delete").append(" from ");
        sql.append("WCMDOCUMENT");
        sql.append(" where ").append("DOCID = ");
        StringBuffer deleteSql = new StringBuffer("delete").append(" from ");
        deleteSql.append("WCMCHNLDOC");
        deleteSql.append(" where ").append("DOCID = ");
        StringBuffer deleteSqlSP1 = new StringBuffer("delete").append(" from ");
        deleteSqlSP1.append("XWCMVIDEO_SP2");
        deleteSqlSP1.append(" where ").append("DOCID = ");
        int count = 0;
        int i = 0;
        while (i < list.size()) {
            Object var9_8;
            int ids = new Integer("" + list.get(i));
            try {
                try {
                    this.oConn = DBManager.getDBManager().getConnection();
                    this.oConn.setAutoCommit(false);
                    this.oStmt = this.oConn.createStatement();
                    this.oStmt.executeUpdate(String.valueOf(sql.toString()) + ids);
                    this.oStmt.executeUpdate(String.valueOf(deleteSql.toString()) + ids);
                    this.oStmt.executeUpdate(String.valueOf(deleteSqlSP1.toString()) + ids);
                    ++count;
                    this.oConn.commit();
                }
                catch (WCMException e) {
                    this.oConn.rollback();
                    LOG.error((Object)("ids is :" + ids + "exception is : " + (Object)((Object)e)));
                    throw e;
                }
                catch (SQLException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var9_8 = null;
                this.closeResultSet(this.rsData);
                throw throwable;
            }
            {
                var9_8 = null;
                this.closeResultSet(this.rsData);
                ++i;
                continue;
            }
            break;
        }
        return count;
    }

    public boolean sendDeleteRequest(String token) {
        boolean flag = false;
        try {
            flag = HttpAPIClient.requestWithPost(null, String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/delete", "token=" + token);
        }
        catch (WCMException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.domain.XVideoMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"XVideoMgr.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + VSConfig.getUploadJavaAppIntranetUrl() + "/service/jobSubmit"));
            e.printStackTrace();
        }
        return flag;
    }

    public static String getPlayUrl(XVideo video) {
        String playUrl = video.getCreateType() == 50 ? (video.getPlayUrl() == null || "null".equals(video.getPlayUrl()) || video.getPlayUrl().equals("") ? String.valueOf(VSConfig.getVideoRootUrl()) + "/" + video.getFileName() : String.valueOf(VSConfig.getUploadFMSAppUrl()) + "/" + video.getFileName()) : String.valueOf(VSConfig.getUploadFMSAppUrl()) + "/" + video.getFileName();
        return playUrl;
    }

    public static String getThumbUrl(XVideo video) {
        String thumbUrl = video.getCreateType() == 50 ? (video.getPlayUrl() == null || "null".equals(video.getPlayUrl()) || video.getPlayUrl().equals("") ? (VSConfig.getThumbRootUrl().contains("masvod") ? String.valueOf(VSConfig.getThumbRootUrl().replace("/masvod", "/")) + video.getThumb() : String.valueOf(VSConfig.getThumbRootUrl()) + "/" + video.getThumb()) : String.valueOf(VSConfig.getThumbsHomeUrl()) + "/" + video.getThumb()) : String.valueOf(VSConfig.getThumbsHomeUrl()) + "/" + video.getThumb();
        return thumbUrl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteXvideoByVideoId(int videoId) throws Exception {
        List Xvideos = this.getDocIdsByVideoId(videoId);
        StringBuffer sql = new StringBuffer("delete").append(" from ");
        sql.append("WCMDOCUMENT");
        sql.append(" where ").append("DOCID = ");
        StringBuffer deleteSql = new StringBuffer("delete").append(" from ");
        deleteSql.append("WCMCHNLDOC");
        deleteSql.append(" where ").append("DOCID = ");
        StringBuffer deleteSqlSP1 = new StringBuffer("delete").append(" from ");
        deleteSqlSP1.append("XWCMVIDEO_SP2");
        deleteSqlSP1.append(" where ").append("DOCID = ");
        int i = 0;
        while (i < Xvideos.size()) {
            Object var9_8;
            int ids = new Integer("" + Xvideos.get(i));
            try {
                try {
                    this.oConn = DBManager.getDBManager().getConnection();
                    this.oConn.setAutoCommit(false);
                    this.oStmt = this.oConn.createStatement();
                    this.oStmt.executeUpdate(String.valueOf(sql.toString()) + ids);
                    this.oStmt.executeUpdate(String.valueOf(deleteSql.toString()) + ids);
                    this.oStmt.executeUpdate(String.valueOf(deleteSqlSP1.toString()) + ids);
                    this.oConn.commit();
                }
                catch (WCMException e) {
                    this.oConn.rollback();
                    LOG.error((Object)("ids is :" + ids + "exception is : " + (Object)((Object)e)));
                    throw e;
                }
                catch (SQLException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var9_8 = null;
                this.closeResultSet(this.rsData);
                throw throwable;
            }
            {
                var9_8 = null;
                this.closeResultSet(this.rsData);
                ++i;
                continue;
            }
            break;
        }
        return;
    }

    private List getDocIdsByVideoId(int videoId) throws Exception {
        ArrayList<Integer> docIds = new ArrayList<Integer>();
        WCMFilter filter = new WCMFilter("XWCMVIDEO_SP2", "VIDEOID= " + videoId, "");
        Documents docs = Documents.openWCMObjs(null, (WCMFilter)filter);
        if (docs == null) {
            return docIds;
        }
        int i = 0;
        while (i < docs.size()) {
            if (docs.getAt(i) != null) {
                docIds.add(new Integer(docs.getAt(i).getId()));
            }
            ++i;
        }
        return docIds;
    }
}

