/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.NoRetryStrategy;
import com.aliyun.oss.common.comm.RequestHandler;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.RequestProgressHanlder;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ResponseProgressHandler;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSErrorResponseHandler;
import com.aliyun.oss.internal.OSSRequestSigner;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.WebServiceRequest;
import java.net.URI;
import java.util.List;

public abstract class OSSOperation {
    private volatile URI endpoint;
    private CredentialsProvider credsProvider;
    private ServiceClient client;
    protected static OSSErrorResponseHandler errorResponseHandler = new OSSErrorResponseHandler();
    protected static ResponseParsers.EmptyResponseParser emptyResponseParser = new ResponseParsers.EmptyResponseParser();
    protected static RetryStrategy noRetryStrategy = new NoRetryStrategy();

    protected OSSOperation(ServiceClient client, CredentialsProvider credsProvider) {
        this.client = client;
        this.credsProvider = credsProvider;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = URI.create(endpoint.toString());
    }

    protected ServiceClient getInnerClient() {
        return this.client;
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context) throws OSSException, ClientException {
        return this.send(request, context, false);
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws OSSException, ClientException {
        ResponseMessage response = null;
        try {
            ResponseMessage responseMessage = response = this.client.sendRequest(request, context);
            return responseMessage;
        }
        catch (ServiceException e) {
            assert (e instanceof OSSException);
            throw (OSSException)e;
        }
        finally {
            if (response != null && !keepResponseOpen) {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, false);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, keepResponseOpen, null, null);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen, List<RequestHandler> requestHandlers, List<ResponseHandler> reponseHandlers) throws OSSException, ClientException {
        WebServiceRequest originalRequest = request.getOriginalRequest();
        request.getHeaders().putAll(originalRequest.getHeaders());
        request.getParameters().putAll(originalRequest.getParameters());
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key);
        if (context.getCredentials().useSecurityToken() && !request.isUseUrlSignature()) {
            request.addHeader("x-oss-security-token", context.getCredentials().getSecurityToken());
        }
        context.addRequestHandler(new RequestProgressHanlder());
        if (requestHandlers != null) {
            for (RequestHandler requestHandler : requestHandlers) {
                context.addRequestHandler(requestHandler);
            }
        }
        context.addResponseHandler(new ResponseProgressHandler(originalRequest));
        if (reponseHandlers != null) {
            for (ResponseHandler responseHandler : reponseHandlers) {
                context.addResponseHandler(responseHandler);
            }
        }
        ResponseMessage responseMessage = this.send(request, context, keepResponseOpen);
        try {
            return parser.parse(responseMessage);
        }
        catch (ResponseParseException rpe) {
            OSSException oe = ExceptionFactory.createInvalidResponseException(responseMessage.getRequestId(), responseMessage.getErrorResponseAsString(), rpe);
            LogUtils.logException("Unable to parse response error: ", oe);
            throw oe;
        }
    }

    private static RequestSigner createSigner(HttpMethod method, String bucketName, String key, Credentials creds) {
        String resourcePath = "/" + (bucketName != null ? String.valueOf(bucketName) + "/" : "") + (key != null ? key : "");
        return new OSSRequestSigner(method.toString(), resourcePath, creds);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName, String key) {
        ExecutionContext context = new ExecutionContext();
        context.setCharset("utf-8");
        context.setSigner(OSSOperation.createSigner(method, bucketName, key, this.credsProvider.getCredentials()));
        context.addResponseHandler(errorResponseHandler);
        if (method == HttpMethod.POST) {
            context.setRetryStrategy(noRetryStrategy);
        }
        context.setCredentials(this.credsProvider.getCredentials());
        return context;
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName) {
        return this.createDefaultContext(method, bucketName, null);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method) {
        return this.createDefaultContext(method, null, null);
    }
}

