/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;

public class UploadPartCopyTest
extends TestBase {
    private static final int LIST_PART_MAX_RETURNS = 1000;

    @Test
    public void testNormalUploadPartCopy() {
        String sourceBucket = "normal-upload-part-copy-bucket-source";
        String targetBucket = "normal-upload-part-copy-bucket-target";
        String sourceKey = "normal-upload-part-copy-object-source";
        String targetKey = "normal-upload-part-copy-object-target";
        long partSize = 131072L;
        try {
            try {
                secondClient.createBucket("normal-upload-part-copy-bucket-source");
                secondClient.createBucket("normal-upload-part-copy-bucket-target");
                TestUtils.waitForCacheExpiration(5);
                String eTag = null;
                try {
                    InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                    PutObjectResult result = secondClient.putObject("normal-upload-part-copy-bucket-source", "normal-upload-part-copy-object-source", instream, null);
                    eTag = result.getETag();
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                String uploadId = TestUtils.claimUploadId(secondClient, "normal-upload-part-copy-bucket-target", "normal-upload-part-copy-object-target");
                boolean partNumber = true;
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("normal-upload-part-copy-bucket-source", "normal-upload-part-copy-object-source", "normal-upload-part-copy-bucket-target", "normal-upload-part-copy-object-target");
                uploadPartCopyRequest.setPartNumber(1);
                uploadPartCopyRequest.setUploadId(uploadId);
                UploadPartCopyResult uploadPartCopyResult = secondClient.uploadPartCopy(uploadPartCopyRequest);
                partETags.add(uploadPartCopyResult.getPartETag());
                Assert.assertEquals((String)eTag, (String)uploadPartCopyResult.getETag());
                Assert.assertEquals((int)1, (int)uploadPartCopyResult.getPartNumber());
                ListPartsRequest listPartsRequest = new ListPartsRequest("normal-upload-part-copy-bucket-target", "normal-upload-part-copy-object-target", uploadId);
                PartListing partListing = secondClient.listParts(listPartsRequest);
                Assert.assertEquals((int)1, (int)partListing.getParts().size());
                Assert.assertEquals((String)"normal-upload-part-copy-bucket-target", (String)partListing.getBucketName());
                Assert.assertEquals((String)"normal-upload-part-copy-object-target", (String)partListing.getKey());
                Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
                Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
                Assert.assertNotNull((Object)partListing.getNextPartNumberMarker());
                Assert.assertFalse((boolean)partListing.isTruncated());
                CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest("normal-upload-part-copy-bucket-target", "normal-upload-part-copy-object-target", uploadId, partETags);
                CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", "normal-upload-part-copy-bucket-target", "normal-upload-part-copy-object-target"), (String)completeMultipartUploadResult.getLocation());
                Assert.assertEquals((String)"normal-upload-part-copy-bucket-target", (String)completeMultipartUploadResult.getBucketName());
                Assert.assertEquals((String)"normal-upload-part-copy-object-target", (String)completeMultipartUploadResult.getKey());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
                OSSObject o = secondClient.getObject("normal-upload-part-copy-bucket-target", "normal-upload-part-copy-object-target");
                long objectSize = 131072L;
                Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-bucket-source");
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-bucket-target");
            }
        }
        finally {
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-bucket-source");
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-bucket-target");
        }
    }

    @Test
    public void testUnormalUploadPartCopy() {
        String sourceBucket = "unormal-upload-part-copy-bucket-source";
        String targetBucket = "unormal-upload-part-copy-bucket-target";
        String sourceKey = "unormal-upload-part-copy-object-source";
        String targetKey = "unormal-upload-part-copy-object-target";
        long partSize = 65536L;
        try {
            try {
                secondClient.createBucket("unormal-upload-part-copy-bucket-source");
                secondClient.createBucket("unormal-upload-part-copy-bucket-target");
                TestUtils.waitForCacheExpiration(5);
                String eTag = null;
                try {
                    InputStream instream = TestUtils.genFixedLengthInputStream(65536L);
                    PutObjectResult result = secondClient.putObject("unormal-upload-part-copy-bucket-source", "unormal-upload-part-copy-object-source", instream, null);
                    eTag = result.getETag();
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                String uploadId = TestUtils.claimUploadId(secondClient, "unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target");
                String nonexistentSourceBucket = "nonexistent-source-bucket";
                boolean partNumber = true;
                try {
                    UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("nonexistent-source-bucket", "unormal-upload-part-copy-object-source", "unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target");
                    uploadPartCopyRequest.setPartNumber(1);
                    uploadPartCopyRequest.setUploadId(uploadId);
                    secondClient.uploadPartCopy(uploadPartCopyRequest);
                    Assert.fail((String)"Upload part copy should not be successfuly");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
                }
                String nonexistentSourceKey = "nonexistent-source-key";
                try {
                    UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("unormal-upload-part-copy-bucket-source", "nonexistent-source-key", "unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target");
                    uploadPartCopyRequest.setPartNumber(1);
                    uploadPartCopyRequest.setUploadId(uploadId);
                    secondClient.uploadPartCopy(uploadPartCopyRequest);
                    Assert.fail((String)"Upload part copy should not be successfuly");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchKey", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The specified key does not exist."));
                }
                String nonexistentTargetBucket = "nonexistent-target-key";
                try {
                    UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("unormal-upload-part-copy-bucket-source", "unormal-upload-part-copy-object-source", "nonexistent-target-key", "unormal-upload-part-copy-object-target");
                    uploadPartCopyRequest.setPartNumber(1);
                    uploadPartCopyRequest.setUploadId(uploadId);
                    secondClient.uploadPartCopy(uploadPartCopyRequest);
                    Assert.fail((String)"Upload part copy should not be successfuly");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
                }
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                try {
                    UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("unormal-upload-part-copy-bucket-source", "unormal-upload-part-copy-object-source", "unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target");
                    uploadPartCopyRequest.setPartNumber(1);
                    uploadPartCopyRequest.setUploadId(uploadId);
                    UploadPartCopyResult uploadPartCopyResult = secondClient.uploadPartCopy(uploadPartCopyRequest);
                    partETags.add(uploadPartCopyResult.getPartETag());
                    Assert.assertEquals((String)eTag, (String)uploadPartCopyResult.getETag());
                    Assert.assertEquals((int)1, (int)uploadPartCopyResult.getPartNumber());
                    uploadPartCopyRequest = new UploadPartCopyRequest("unormal-upload-part-copy-bucket-source", "unormal-upload-part-copy-object-source", "unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target");
                    uploadPartCopyRequest.setPartNumber(2);
                    uploadPartCopyRequest.setUploadId(uploadId);
                    uploadPartCopyResult = secondClient.uploadPartCopy(uploadPartCopyRequest);
                    partETags.add(uploadPartCopyResult.getPartETag());
                    Assert.assertEquals((String)eTag, (String)uploadPartCopyResult.getETag());
                    Assert.assertEquals((int)2, (int)uploadPartCopyResult.getPartNumber());
                    ListPartsRequest listPartsRequest = new ListPartsRequest("unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target", uploadId);
                    PartListing partListing = secondClient.listParts(listPartsRequest);
                    Assert.assertEquals((int)2, (int)partListing.getParts().size());
                    Assert.assertEquals((String)"unormal-upload-part-copy-bucket-target", (String)partListing.getBucketName());
                    Assert.assertEquals((String)"unormal-upload-part-copy-object-target", (String)partListing.getKey());
                    Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
                    Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
                    Assert.assertNotNull((Object)partListing.getNextPartNumberMarker());
                    Assert.assertFalse((boolean)partListing.isTruncated());
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                try {
                    CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest("unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target", uploadId, partETags);
                    secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                    Assert.fail((String)"Upload part copy should not be successfuly");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"EntityTooSmall", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("Your proposed upload smaller than the minimum allowed size."));
                }
                try {
                    AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest("unormal-upload-part-copy-bucket-target", "unormal-upload-part-copy-object-target", uploadId);
                    secondClient.abortMultipartUpload(abortMultipartUploadRequest);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-bucket-source");
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-bucket-target");
            }
        }
        finally {
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-bucket-source");
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-bucket-target");
        }
    }

    @Test
    public void testNormalUploadPartCopyByRange() {
        String sourceBucket = "normal-upload-part-copy-by-range-bucket-source";
        String targetBucket = "normal-upload-part-copy-by-range-bucket-target";
        String sourceKey = "normal-upload-part-copy-by-range-object-source";
        String targetKey = "normal-upload-part-copy-by-range-object-target";
        long partSize = 131072L;
        try {
            try {
                secondClient.createBucket("normal-upload-part-copy-by-range-bucket-source");
                secondClient.createBucket("normal-upload-part-copy-by-range-bucket-target");
                TestUtils.waitForCacheExpiration(5);
                long inputStreamLength = 524288L;
                try {
                    InputStream instream = TestUtils.genFixedLengthInputStream(524288L);
                    secondClient.putObject("normal-upload-part-copy-by-range-bucket-source", "normal-upload-part-copy-by-range-object-source", instream, null);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                String uploadId = TestUtils.claimUploadId(secondClient, "normal-upload-part-copy-by-range-bucket-target", "normal-upload-part-copy-by-range-object-target");
                boolean partNumber = true;
                long beginIndex = 131072L;
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("normal-upload-part-copy-by-range-bucket-source", "normal-upload-part-copy-by-range-object-source", "normal-upload-part-copy-by-range-bucket-target", "normal-upload-part-copy-by-range-object-target");
                uploadPartCopyRequest.setPartNumber(1);
                uploadPartCopyRequest.setUploadId(uploadId);
                uploadPartCopyRequest.setBeginIndex(131072L);
                uploadPartCopyRequest.setPartSize(131072L);
                UploadPartCopyResult uploadPartCopyResult = secondClient.uploadPartCopy(uploadPartCopyRequest);
                partETags.add(uploadPartCopyResult.getPartETag());
                Assert.assertEquals((int)1, (int)uploadPartCopyResult.getPartNumber());
                ListPartsRequest listPartsRequest = new ListPartsRequest("normal-upload-part-copy-by-range-bucket-target", "normal-upload-part-copy-by-range-object-target", uploadId);
                PartListing partListing = secondClient.listParts(listPartsRequest);
                Assert.assertEquals((int)1, (int)partListing.getParts().size());
                Assert.assertEquals((String)"normal-upload-part-copy-by-range-bucket-target", (String)partListing.getBucketName());
                Assert.assertEquals((String)"normal-upload-part-copy-by-range-object-target", (String)partListing.getKey());
                Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
                Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
                Assert.assertNotNull((Object)partListing.getNextPartNumberMarker());
                Assert.assertFalse((boolean)partListing.isTruncated());
                CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest("normal-upload-part-copy-by-range-bucket-target", "normal-upload-part-copy-by-range-object-target", uploadId, partETags);
                CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", "normal-upload-part-copy-by-range-bucket-target", "normal-upload-part-copy-by-range-object-target"), (String)completeMultipartUploadResult.getLocation());
                Assert.assertEquals((String)"normal-upload-part-copy-by-range-bucket-target", (String)completeMultipartUploadResult.getBucketName());
                Assert.assertEquals((String)"normal-upload-part-copy-by-range-object-target", (String)completeMultipartUploadResult.getKey());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
                OSSObject o = secondClient.getObject("normal-upload-part-copy-by-range-bucket-target", "normal-upload-part-copy-by-range-object-target");
                long objectSize = 131072L;
                Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-source");
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-target");
            }
        }
        finally {
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-source");
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-target");
        }
    }

    @Test
    public void testNormalUploadPartCopyWithSpecialChars() {
        String sourceBucket = "normal-upload-part-copy-by-range-bucket-source";
        String targetBucket = "normal-upload-part-copy-by-range-bucket-target";
        String sourceKey = "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip";
        String targetKey = "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip";
        long partSize = 131072L;
        try {
            try {
                secondClient.createBucket("normal-upload-part-copy-by-range-bucket-source");
                secondClient.createBucket("normal-upload-part-copy-by-range-bucket-target");
                long inputStreamLength = 524288L;
                try {
                    InputStream instream = TestUtils.genFixedLengthInputStream(524288L);
                    secondClient.putObject("normal-upload-part-copy-by-range-bucket-source", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip", instream, null);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                String uploadId = TestUtils.claimUploadId(secondClient, "normal-upload-part-copy-by-range-bucket-target", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip");
                boolean partNumber = true;
                long beginIndex = 131072L;
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("normal-upload-part-copy-by-range-bucket-source", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip", "normal-upload-part-copy-by-range-bucket-target", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip");
                uploadPartCopyRequest.setPartNumber(1);
                uploadPartCopyRequest.setUploadId(uploadId);
                uploadPartCopyRequest.setBeginIndex(131072L);
                uploadPartCopyRequest.setPartSize(131072L);
                UploadPartCopyResult uploadPartCopyResult = secondClient.uploadPartCopy(uploadPartCopyRequest);
                partETags.add(uploadPartCopyResult.getPartETag());
                Assert.assertEquals((int)1, (int)uploadPartCopyResult.getPartNumber());
                ListPartsRequest listPartsRequest = new ListPartsRequest("normal-upload-part-copy-by-range-bucket-target", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip", uploadId);
                PartListing partListing = secondClient.listParts(listPartsRequest);
                Assert.assertEquals((int)1, (int)partListing.getParts().size());
                Assert.assertEquals((String)"normal-upload-part-copy-by-range-bucket-target", (String)partListing.getBucketName());
                Assert.assertEquals((String)"\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip", (String)partListing.getKey());
                Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
                Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
                Assert.assertNotNull((Object)partListing.getNextPartNumberMarker());
                Assert.assertFalse((boolean)partListing.isTruncated());
                CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest("normal-upload-part-copy-by-range-bucket-target", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip", uploadId, partETags);
                CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", "normal-upload-part-copy-by-range-bucket-target", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip"), (String)completeMultipartUploadResult.getLocation());
                Assert.assertEquals((String)"normal-upload-part-copy-by-range-bucket-target", (String)completeMultipartUploadResult.getBucketName());
                Assert.assertEquals((String)"\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip", (String)completeMultipartUploadResult.getKey());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
                OSSObject o = secondClient.getObject("normal-upload-part-copy-by-range-bucket-target", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip");
                long objectSize = 131072L;
                Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-source");
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-target");
            }
        }
        finally {
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-source");
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "normal-upload-part-copy-by-range-bucket-target");
        }
    }

    @Test
    public void testUnormalUploadPartCopyByRange() {
        String sourceBucket = "unormal-upload-part-copy-by-range-bucket-source";
        String targetBucket = "unormal-upload-part-copy-by-range-bucket-target";
        String sourceKey = "unormal-upload-part-copy-by-range-object-source";
        String targetKey = "unormal-upload-part-copy-by-range-object-target";
        long partSize = 131072L;
        try {
            try {
                secondClient.createBucket("unormal-upload-part-copy-by-range-bucket-source");
                secondClient.createBucket("unormal-upload-part-copy-by-range-bucket-target");
                long inputStreamLength = 524288L;
                String eTag = null;
                try {
                    InputStream instream = TestUtils.genFixedLengthInputStream(524288L);
                    PutObjectResult result = secondClient.putObject("unormal-upload-part-copy-by-range-bucket-source", "unormal-upload-part-copy-by-range-object-source", instream, null);
                    eTag = result.getETag();
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                String uploadId = TestUtils.claimUploadId(secondClient, "unormal-upload-part-copy-by-range-bucket-target", "unormal-upload-part-copy-by-range-object-target");
                boolean partNumber = true;
                long beginIndex = 131072L;
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest("unormal-upload-part-copy-by-range-bucket-source", "unormal-upload-part-copy-by-range-object-source", "unormal-upload-part-copy-by-range-bucket-target", "unormal-upload-part-copy-by-range-object-target");
                uploadPartCopyRequest.setPartNumber(1);
                uploadPartCopyRequest.setUploadId(uploadId);
                uploadPartCopyRequest.setBeginIndex(131072L);
                uploadPartCopyRequest.setPartSize(524288L);
                UploadPartCopyResult uploadPartCopyResult = secondClient.uploadPartCopy(uploadPartCopyRequest);
                partETags.add(uploadPartCopyResult.getPartETag());
                Assert.assertEquals((String)eTag, (String)uploadPartCopyResult.getETag());
                Assert.assertEquals((int)1, (int)uploadPartCopyResult.getPartNumber());
                ListPartsRequest listPartsRequest = new ListPartsRequest("unormal-upload-part-copy-by-range-bucket-target", "unormal-upload-part-copy-by-range-object-target", uploadId);
                PartListing partListing = secondClient.listParts(listPartsRequest);
                Assert.assertEquals((int)1, (int)partListing.getParts().size());
                Assert.assertEquals((String)"unormal-upload-part-copy-by-range-bucket-target", (String)partListing.getBucketName());
                Assert.assertEquals((String)"unormal-upload-part-copy-by-range-object-target", (String)partListing.getKey());
                Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
                Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
                Assert.assertNotNull((Object)partListing.getNextPartNumberMarker());
                Assert.assertFalse((boolean)partListing.isTruncated());
                CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest("unormal-upload-part-copy-by-range-bucket-target", "unormal-upload-part-copy-by-range-object-target", uploadId, partETags);
                CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", "unormal-upload-part-copy-by-range-bucket-target", "unormal-upload-part-copy-by-range-object-target"), (String)completeMultipartUploadResult.getLocation());
                Assert.assertEquals((String)"unormal-upload-part-copy-by-range-bucket-target", (String)completeMultipartUploadResult.getBucketName());
                Assert.assertEquals((String)"unormal-upload-part-copy-by-range-object-target", (String)completeMultipartUploadResult.getKey());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
                OSSObject o = secondClient.getObject("unormal-upload-part-copy-by-range-bucket-target", "unormal-upload-part-copy-by-range-object-target");
                long objectSize = 524288L;
                Assert.assertEquals((long)524288L, (long)o.getObjectMetadata().getContentLength());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-by-range-bucket-source");
                UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-by-range-bucket-target");
            }
        }
        finally {
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-by-range-bucket-source");
            UploadPartCopyTest.deleteBucketWithObjects(secondClient, "unormal-upload-part-copy-by-range-bucket-target");
        }
    }
}

