/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetBucketImageResult;
import com.aliyun.oss.model.GetImageStyleResult;
import com.aliyun.oss.model.PutBucketImageRequest;
import com.aliyun.oss.model.PutImageStyleRequest;
import com.aliyun.oss.model.Style;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;

@Ignore
public class TestForImg
extends TestCase {
    private static String accessKeyId = "your-access-id";
    private static String accessKeySecret = "your-access-key";
    private static String bucketName = "img-sdk-test-bucket";
    private static String endpointImg = "http://img-test.aliyun-inc.com";
    private static String endpointOss = "http://oss-test.aliyun-inc.com";
    private static OSSClient clientImg = new OSSClient(endpointImg, accessKeyId, accessKeySecret, new ClientConfiguration().setSupportCname(false));
    private static OSSClient clientOss = new OSSClient(endpointOss, accessKeyId, accessKeySecret, new ClientConfiguration().setSupportCname(false));

    public void sleepSecond(int time) {
        try {
            Thread.sleep(time * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() {
        clientOss.createBucket(bucketName);
        this.sleepSecond(10);
    }

    @After
    public void tearDown() {
        clientOss.deleteBucket(bucketName);
        clientImg.deleteBucketImage(bucketName);
    }

    public void testPutGetBucketImage() {
        PutBucketImageRequest request = new PutBucketImageRequest(bucketName);
        clientImg.putBucketImage(request);
        this.sleepSecond(10);
        GetBucketImageResult result = clientImg.getBucketImage(bucketName);
        Assert.assertEquals((String)result.GetBucketName(), (String)bucketName);
        Assert.assertEquals((String)result.GetDefault404Pic(), (String)"");
        Assert.assertFalse((boolean)result.GetIsAutoSetContentType());
        Assert.assertFalse((boolean)result.GetIsForbidOrigPicAccess());
        Assert.assertFalse((boolean)result.GetIsUseSrcFormat());
        Assert.assertFalse((boolean)result.GetIsSetAttachName());
        Assert.assertEquals((String)result.GetStyleDelimiters(), (String)"!");
        Assert.assertEquals((String)result.GetStatus(), (String)"Enabled");
        request.SetIsForbidOrigPicAccess(true);
        request.SetIsUseStyleOnly(true);
        request.SetIsAutoSetContentType(true);
        request.SetIsUseSrcFormat(true);
        request.SetIsSetAttachName(true);
        String default404Pic = "index.png";
        request.SetDefault404Pic(default404Pic);
        String styleDelimiters = "_";
        request.SetStyleDelimiters(styleDelimiters);
        clientImg.putBucketImage(request);
        this.sleepSecond(20);
        result = clientImg.getBucketImage(bucketName);
        Assert.assertEquals((String)result.GetBucketName(), (String)bucketName);
        Assert.assertEquals((String)result.GetDefault404Pic(), (String)default404Pic);
        Assert.assertFalse((!result.GetIsAutoSetContentType() ? 1 : 0) != 0);
        Assert.assertFalse((!result.GetIsForbidOrigPicAccess() ? 1 : 0) != 0);
        Assert.assertFalse((!result.GetIsUseSrcFormat() ? 1 : 0) != 0);
        Assert.assertFalse((!result.GetIsSetAttachName() ? 1 : 0) != 0);
        Assert.assertEquals((String)result.GetStyleDelimiters(), (String)styleDelimiters);
        Assert.assertEquals((String)result.GetStatus(), (String)"Enabled");
    }

    public void testForDeleteBucketImage() {
        PutBucketImageRequest request = new PutBucketImageRequest(bucketName);
        clientImg.putBucketImage(request);
        this.sleepSecond(10);
        clientImg.deleteBucketImage(bucketName);
        this.sleepSecond(10);
        try {
            clientImg.getBucketImage(bucketName);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPutGetDeleteImageStyle() {
        PutBucketImageRequest request = new PutBucketImageRequest(bucketName);
        clientImg.putBucketImage(request);
        this.sleepSecond(10);
        PutImageStyleRequest requestStyle = new PutImageStyleRequest();
        requestStyle.SetBucketName(bucketName);
        String styleName = "myStyle";
        String style = "200w";
        requestStyle.SetStyle(style);
        requestStyle.SetStyleName(styleName);
        clientImg.putImageStyle(requestStyle);
        this.sleepSecond(10);
        GetImageStyleResult result = clientImg.getImageStyle(bucketName, styleName);
        Assert.assertEquals((String)result.GetStyle(), (String)style);
        Assert.assertEquals((String)result.GetStyleName(), (String)styleName);
        clientImg.deleteImageStyle(bucketName, styleName);
        this.sleepSecond(20);
        try {
            clientImg.getImageStyle(bucketName, styleName);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testListImageStyle() {
        clientImg.deleteBucketImage(bucketName);
        this.sleepSecond(10);
        PutBucketImageRequest request = new PutBucketImageRequest(bucketName);
        clientImg.putBucketImage(request);
        this.sleepSecond(10);
        PutImageStyleRequest requestStyle = new PutImageStyleRequest();
        requestStyle.SetBucketName(bucketName);
        String[] styleName = new String[]{"myStyle", "myStyle1", "myStyle2", "myStyle3", "myStyle4"};
        String[] style = new String[]{"200w", "300w", "400w", "500w", "600w"};
        int i = 0;
        while (i < styleName.length) {
            requestStyle.SetStyle(style[i]);
            requestStyle.SetStyleName(styleName[i]);
            clientImg.putImageStyle(requestStyle);
            ++i;
        }
        this.sleepSecond(10);
        List<Style> styleList = clientImg.listImageStyle(bucketName);
        Assert.assertEquals((int)styleList.size(), (int)styleName.length);
        for (Style s : styleList) {
            int i2 = 0;
            while (i2 < style.length) {
                if (s.GetStyle().equals(style[i2])) break;
                ++i2;
            }
            Assert.assertTrue((i2 != style.length ? 1 : 0) != 0);
            i2 = 0;
            while (i2 < styleName.length) {
                if (s.GetStyleName().equals(styleName[i2])) break;
                ++i2;
            }
            Assert.assertTrue((i2 != styleName.length ? 1 : 0) != 0);
        }
    }

    public void testGenernicRequest() {
        PutBucketImageRequest request = new PutBucketImageRequest(bucketName);
        GenericRequest req = new GenericRequest();
        request.addHeader("oss-request-ip", "31.71.68.91");
        request.addHeader("oss-request-agent", "oss-java-sdk");
        request.addHeader("oss-operation", "PutBucketImage");
        try {
            clientImg.putBucketImage(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        req.addHeader("oss-operation", "GetBucketImage");
        try {
            clientImg.getBucketImage(bucketName, req);
        }
        catch (Exception exception) {
            // empty catch block
        }
        req.addHeader("oss-operation", "DeleteBucketImage");
        try {
            clientImg.deleteBucketImage(bucketName, req);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PutImageStyleRequest requestStyle = new PutImageStyleRequest();
        requestStyle.SetBucketName(bucketName);
        String styleName = "style";
        String styleContent = "200w";
        requestStyle.SetStyle(styleName);
        requestStyle.SetStyleName(styleContent);
        requestStyle.addHeader("oss-operation", "PutImageStyle");
        try {
            clientImg.putImageStyle(requestStyle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        req.addHeader("oss-operation", "DeleteImageStyle");
        try {
            clientImg.deleteImageStyle(bucketName, styleName, req);
        }
        catch (Exception exception) {
            // empty catch block
        }
        req.addHeader("oss-operation", "GetImageStyle");
        try {
            clientImg.getImageStyle(bucketName, styleName, req);
        }
        catch (Exception exception) {
            // empty catch block
        }
        req.addHeader("oss-operation", "ListImageStyle");
        try {
            clientImg.listImageStyle(bucketName, req);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

