/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.Grant;
import com.aliyun.oss.model.GroupGrantee;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.Permission;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class SecurityTokenTest {
    private static final String DUMMY_SUFFIX = "xyz";

    @Test
    public void testBucketOperationsWithToken() {
        OSSClient sessionClient;
        ArrayList<String> resources;
        ArrayList<String> actions;
        block126: {
            block124: {
                GenericRequest request;
                block122: {
                    block120: {
                        block118: {
                            block116: {
                                block114: {
                                    SetBucketLoggingRequest request2;
                                    block112: {
                                        block110: {
                                            block108: {
                                                block106: {
                                                    block104: {
                                                        block102: {
                                                            block100: {
                                                                block98: {
                                                                    block96: {
                                                                        String unmatchedBucketName;
                                                                        block94: {
                                                                            block92: {
                                                                                block90: {
                                                                                    block89: {
                                                                                        actions = new ArrayList<String>();
                                                                                        actions.add("oss:ListBuckets");
                                                                                        resources = new ArrayList<String>();
                                                                                        resources.add("acs:oss:*:1287905056319499:*");
                                                                                        sessionClient = TestUtils.createSessionClient(actions, resources);
                                                                                        try {
                                                                                            try {
                                                                                                sessionClient.listBuckets();
                                                                                            }
                                                                                            catch (Exception e) {
                                                                                                Assert.fail((String)e.getMessage());
                                                                                                actions.clear();
                                                                                                resources.clear();
                                                                                                sessionClient.shutdown();
                                                                                                break block89;
                                                                                            }
                                                                                        }
                                                                                        catch (Throwable throwable) {
                                                                                            actions.clear();
                                                                                            resources.clear();
                                                                                            sessionClient.shutdown();
                                                                                            throw throwable;
                                                                                        }
                                                                                        actions.clear();
                                                                                        resources.clear();
                                                                                        sessionClient.shutdown();
                                                                                    }
                                                                                    String bucketName = "test-bucket-operations-with-token";
                                                                                    actions.add("oss:DeleteBucket");
                                                                                    resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                                                                                    sessionClient = TestUtils.createSessionClient(actions, resources);
                                                                                    try {
                                                                                        sessionClient.deleteBucket("test-bucket-operations-with-token");
                                                                                    }
                                                                                    catch (OSSException oe) {
                                                                                        Assert.assertEquals((String)"NoSuchBucket", (String)oe.getErrorCode());
                                                                                        actions.clear();
                                                                                        resources.clear();
                                                                                        sessionClient.shutdown();
                                                                                        break block90;
                                                                                    }
                                                                                    catch (Exception e) {
                                                                                        try {
                                                                                            Assert.fail((String)e.getMessage());
                                                                                            break block90;
                                                                                        }
                                                                                        catch (Throwable throwable) {
                                                                                            throw throwable;
                                                                                        }
                                                                                        finally {
                                                                                            actions.clear();
                                                                                            resources.clear();
                                                                                            sessionClient.shutdown();
                                                                                        }
                                                                                    }
                                                                                    actions.clear();
                                                                                    resources.clear();
                                                                                    sessionClient.shutdown();
                                                                                }
                                                                                TestUtils.waitForCacheExpiration(2);
                                                                                actions.add("oss:PutBucket");
                                                                                resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                                                                                sessionClient = TestUtils.createSessionClient(actions, resources);
                                                                                try {
                                                                                    try {
                                                                                        sessionClient.createBucket("test-bucket-operations-with-token");
                                                                                    }
                                                                                    catch (Exception e) {
                                                                                        Assert.fail((String)e.getMessage());
                                                                                        actions.clear();
                                                                                        resources.clear();
                                                                                        break block92;
                                                                                    }
                                                                                }
                                                                                catch (Throwable throwable) {
                                                                                    actions.clear();
                                                                                    resources.clear();
                                                                                    throw throwable;
                                                                                }
                                                                                actions.clear();
                                                                                resources.clear();
                                                                            }
                                                                            unmatchedBucketName = "test-bucket-operations-with-tokenxyz";
                                                                            try {
                                                                                try {
                                                                                    sessionClient.createBucket(unmatchedBucketName);
                                                                                }
                                                                                catch (OSSException e) {
                                                                                    Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                                                                                    Assert.assertTrue((boolean)e.getMessage().startsWith("Access denied by authorizer's policy."));
                                                                                    actions.clear();
                                                                                    resources.clear();
                                                                                    break block94;
                                                                                }
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                actions.clear();
                                                                                resources.clear();
                                                                                throw throwable;
                                                                            }
                                                                            actions.clear();
                                                                            resources.clear();
                                                                        }
                                                                        String nonexistentUser = "non-existent-user";
                                                                        actions.add("oss:PutBucket");
                                                                        resources.add("acs:oss:*:non-existent-user:test-bucket-operations-with-token");
                                                                        sessionClient = TestUtils.createSessionClient(actions, resources);
                                                                        try {
                                                                            try {
                                                                                sessionClient.createBucket(unmatchedBucketName);
                                                                            }
                                                                            catch (OSSException e) {
                                                                                Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                                                                                Assert.assertTrue((boolean)e.getMessage().startsWith("Access denied by authorizer's policy."));
                                                                                actions.clear();
                                                                                resources.clear();
                                                                                sessionClient.shutdown();
                                                                                break block96;
                                                                            }
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            actions.clear();
                                                                            resources.clear();
                                                                            sessionClient.shutdown();
                                                                            throw throwable;
                                                                        }
                                                                        actions.clear();
                                                                        resources.clear();
                                                                        sessionClient.shutdown();
                                                                    }
                                                                    String anyone = "*";
                                                                    actions.add("oss:Put*");
                                                                    resources.add("acs:oss:*:*:test-bucket-operations-with-token");
                                                                    sessionClient = TestUtils.createSessionClient(actions, resources);
                                                                    try {
                                                                        try {
                                                                            sessionClient.createBucket("test-bucket-operations-with-token");
                                                                        }
                                                                        catch (Exception e) {
                                                                            Assert.fail((String)e.getMessage());
                                                                            actions.clear();
                                                                            resources.clear();
                                                                            sessionClient.shutdown();
                                                                            break block98;
                                                                        }
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        actions.clear();
                                                                        resources.clear();
                                                                        sessionClient.shutdown();
                                                                        throw throwable;
                                                                    }
                                                                    actions.clear();
                                                                    resources.clear();
                                                                    sessionClient.shutdown();
                                                                }
                                                                actions.add("oss:PutBucketAcl");
                                                                resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                                                                sessionClient = TestUtils.createSessionClient(actions, resources);
                                                                try {
                                                                    try {
                                                                        sessionClient.setBucketAcl("test-bucket-operations-with-token", CannedAccessControlList.PublicRead);
                                                                    }
                                                                    catch (Exception e) {
                                                                        Assert.fail((String)e.getMessage());
                                                                        actions.clear();
                                                                        resources.clear();
                                                                        break block100;
                                                                    }
                                                                }
                                                                catch (Throwable throwable) {
                                                                    actions.clear();
                                                                    resources.clear();
                                                                    throw throwable;
                                                                }
                                                                actions.clear();
                                                                resources.clear();
                                                            }
                                                            try {
                                                                try {
                                                                    sessionClient.getBucketAcl("test-bucket-operations-with-token");
                                                                }
                                                                catch (OSSException e) {
                                                                    Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                                                                    Assert.assertTrue((boolean)e.getMessage().startsWith("Access denied by authorizer's policy."));
                                                                    actions.clear();
                                                                    resources.clear();
                                                                    sessionClient.shutdown();
                                                                    break block102;
                                                                }
                                                            }
                                                            catch (Throwable throwable) {
                                                                actions.clear();
                                                                resources.clear();
                                                                sessionClient.shutdown();
                                                                throw throwable;
                                                            }
                                                            actions.clear();
                                                            resources.clear();
                                                            sessionClient.shutdown();
                                                        }
                                                        actions.add("oss:GetBucketAcl");
                                                        resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                                                        sessionClient = TestUtils.createSessionClient(actions, resources);
                                                        try {
                                                            try {
                                                                AccessControlList returnedAcl = sessionClient.getBucketAcl("test-bucket-operations-with-token");
                                                                Set<Grant> grants = returnedAcl.getGrants();
                                                                Assert.assertEquals((int)1, (int)grants.size());
                                                                Grant grant = (Grant)grants.toArray()[0];
                                                                Assert.assertEquals((Object)GroupGrantee.AllUsers, (Object)grant.getGrantee());
                                                                Assert.assertEquals((Object)((Object)Permission.Read), (Object)((Object)grant.getPermission()));
                                                            }
                                                            catch (Exception e) {
                                                                Assert.fail((String)e.getMessage());
                                                                actions.clear();
                                                                resources.clear();
                                                                break block104;
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            actions.clear();
                                                            resources.clear();
                                                            throw throwable;
                                                        }
                                                        actions.clear();
                                                        resources.clear();
                                                    }
                                                    try {
                                                        try {
                                                            sessionClient.setBucketAcl("test-bucket-operations-with-token", CannedAccessControlList.Private);
                                                        }
                                                        catch (OSSException e) {
                                                            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                                                            Assert.assertTrue((boolean)e.getMessage().startsWith("Access denied by authorizer's policy."));
                                                            actions.clear();
                                                            resources.clear();
                                                            sessionClient.shutdown();
                                                            break block106;
                                                        }
                                                    }
                                                    catch (Throwable grants) {
                                                        actions.clear();
                                                        resources.clear();
                                                        sessionClient.shutdown();
                                                        throw grants;
                                                    }
                                                    actions.clear();
                                                    resources.clear();
                                                    sessionClient.shutdown();
                                                }
                                                String targetPrefix = "bucket-logging-prefix";
                                                actions.add("oss:PutBucketLogging");
                                                resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                                                sessionClient = TestUtils.createSessionClient(actions, resources);
                                                try {
                                                    try {
                                                        request2 = new SetBucketLoggingRequest("test-bucket-operations-with-token");
                                                        request2.setTargetBucket("test-bucket-operations-with-token");
                                                        request2.setTargetPrefix("bucket-logging-prefix");
                                                        sessionClient.setBucketLogging(request2);
                                                    }
                                                    catch (Exception e) {
                                                        Assert.fail((String)e.getMessage());
                                                        actions.clear();
                                                        resources.clear();
                                                        break block108;
                                                    }
                                                }
                                                catch (Throwable grant) {
                                                    actions.clear();
                                                    resources.clear();
                                                    throw grant;
                                                }
                                                actions.clear();
                                                resources.clear();
                                            }
                                            try {
                                                try {
                                                    sessionClient.getBucketLogging("test-bucket-operations-with-token");
                                                }
                                                catch (OSSException e) {
                                                    Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                                                    Assert.assertTrue((boolean)e.getMessage().startsWith("Access denied by authorizer's policy."));
                                                    actions.clear();
                                                    resources.clear();
                                                    sessionClient.shutdown();
                                                    break block110;
                                                }
                                            }
                                            catch (Throwable grant) {
                                                actions.clear();
                                                resources.clear();
                                                sessionClient.shutdown();
                                                throw grant;
                                            }
                                            actions.clear();
                                            resources.clear();
                                            sessionClient.shutdown();
                                        }
                                        actions.add("oss:GetBucketLogging");
                                        resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                                        sessionClient = TestUtils.createSessionClient(actions, resources);
                                        try {
                                            try {
                                                BucketLoggingResult result = sessionClient.getBucketLogging("test-bucket-operations-with-token");
                                                Assert.assertEquals((String)"test-bucket-operations-with-token", (String)result.getTargetBucket());
                                                Assert.assertEquals((String)"bucket-logging-prefix", (String)result.getTargetPrefix());
                                            }
                                            catch (Exception e) {
                                                Assert.fail((String)e.getMessage());
                                                actions.clear();
                                                resources.clear();
                                                break block112;
                                            }
                                        }
                                        catch (Throwable grant) {
                                            actions.clear();
                                            resources.clear();
                                            throw grant;
                                        }
                                        actions.clear();
                                        resources.clear();
                                    }
                                    try {
                                        try {
                                            request2 = new SetBucketLoggingRequest("test-bucket-operations-with-token");
                                            request2.setTargetBucket("test-bucket-operations-with-token");
                                            request2.setTargetPrefix("bucket-logging-prefix");
                                            sessionClient.setBucketLogging(request2);
                                        }
                                        catch (OSSException e) {
                                            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                                            Assert.assertTrue((boolean)e.getMessage().startsWith("Access denied by authorizer's policy."));
                                            actions.clear();
                                            resources.clear();
                                            sessionClient.shutdown();
                                            break block114;
                                        }
                                    }
                                    catch (Throwable grant) {
                                        actions.clear();
                                        resources.clear();
                                        sessionClient.shutdown();
                                        throw grant;
                                    }
                                    actions.clear();
                                    resources.clear();
                                    sessionClient.shutdown();
                                }
                                actions.add("oss:DeleteBucketLogging");
                                resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                                sessionClient = TestUtils.createSessionClient(actions, resources);
                                try {
                                    try {
                                        sessionClient.deleteBucketLogging("test-bucket-operations-with-token");
                                    }
                                    catch (Exception e) {
                                        Assert.fail((String)e.getMessage());
                                        actions.clear();
                                        resources.clear();
                                        sessionClient.shutdown();
                                        break block116;
                                    }
                                }
                                catch (Throwable grant) {
                                    actions.clear();
                                    resources.clear();
                                    sessionClient.shutdown();
                                    throw grant;
                                }
                                actions.clear();
                                resources.clear();
                                sessionClient.shutdown();
                            }
                            String indexDocument = "index.html";
                            String errorDocument = "error.html";
                            actions.add("oss:PutBucketWebsite");
                            resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                            sessionClient = TestUtils.createSessionClient(actions, resources);
                            try {
                                try {
                                    SetBucketWebsiteRequest request3 = new SetBucketWebsiteRequest("test-bucket-operations-with-token");
                                    request3.setIndexDocument("index.html");
                                    request3.setErrorDocument("error.html");
                                    sessionClient.setBucketWebsite(request3);
                                }
                                catch (Exception e) {
                                    Assert.fail((String)e.getMessage());
                                    actions.clear();
                                    resources.clear();
                                    sessionClient.shutdown();
                                    break block118;
                                }
                            }
                            catch (Throwable throwable) {
                                actions.clear();
                                resources.clear();
                                sessionClient.shutdown();
                                throw throwable;
                            }
                            actions.clear();
                            resources.clear();
                            sessionClient.shutdown();
                        }
                        String referer0 = "http://www.aliyun.com";
                        String referer1 = "https://www.aliyun.com";
                        String referer2 = "http://www.*.com";
                        String referer3 = "https://www.?.aliyuncs.com";
                        actions.add("oss:PutBucketReferer");
                        resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                        sessionClient = TestUtils.createSessionClient(actions, resources);
                        try {
                            try {
                                BucketReferer r = new BucketReferer();
                                ArrayList<String> refererList = new ArrayList<String>();
                                refererList.add("http://www.aliyun.com");
                                refererList.add("https://www.aliyun.com");
                                refererList.add("http://www.*.com");
                                refererList.add("https://www.?.aliyuncs.com");
                                r.setRefererList(refererList);
                                sessionClient.setBucketReferer("test-bucket-operations-with-token", r);
                            }
                            catch (Exception e) {
                                Assert.fail((String)e.getMessage());
                                actions.clear();
                                resources.clear();
                                sessionClient.shutdown();
                                break block120;
                            }
                        }
                        catch (Throwable throwable) {
                            actions.clear();
                            resources.clear();
                            sessionClient.shutdown();
                            throw throwable;
                        }
                        actions.clear();
                        resources.clear();
                        sessionClient.shutdown();
                    }
                    String ruleId0 = "delete obsoleted files";
                    String matchPrefix0 = "obsoleted/";
                    String ruleId1 = "delete temporary files";
                    String matchPrefix1 = "temporary/";
                    actions.add("oss:PutBucketLifecycle");
                    resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                    sessionClient = TestUtils.createSessionClient(actions, resources);
                    try {
                        try {
                            request = new SetBucketLifecycleRequest("test-bucket-operations-with-token");
                            ((SetBucketLifecycleRequest)request).AddLifecycleRule(new LifecycleRule("delete obsoleted files", "obsoleted/", LifecycleRule.RuleStatus.Enabled, 3));
                            ((SetBucketLifecycleRequest)request).AddLifecycleRule(new LifecycleRule("delete temporary files", "temporary/", LifecycleRule.RuleStatus.Enabled, DateUtil.parseIso8601Date("2022-10-12T00:00:00.000Z")));
                            sessionClient.setBucketLifecycle((SetBucketLifecycleRequest)request);
                        }
                        catch (Exception e) {
                            Assert.fail((String)e.getMessage());
                            actions.clear();
                            resources.clear();
                            sessionClient.shutdown();
                            break block122;
                        }
                    }
                    catch (Throwable throwable) {
                        actions.clear();
                        resources.clear();
                        sessionClient.shutdown();
                        throw throwable;
                    }
                    actions.clear();
                    resources.clear();
                    sessionClient.shutdown();
                }
                actions.add("oss:PutBucketCors");
                resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
                sessionClient = TestUtils.createSessionClient(actions, resources);
                try {
                    try {
                        request = new SetBucketCORSRequest("test-bucket-operations-with-token");
                        SetBucketCORSRequest.CORSRule r0 = new SetBucketCORSRequest.CORSRule();
                        r0.addAllowdOrigin("http://www.a.com");
                        r0.addAllowdOrigin("http://www.b.com");
                        r0.addAllowedMethod("GET");
                        r0.addAllowedHeader("Authorization");
                        r0.addExposeHeader("x-oss-test");
                        r0.addExposeHeader("x-oss-test1");
                        r0.setMaxAgeSeconds(100);
                        ((SetBucketCORSRequest)request).addCorsRule(r0);
                        sessionClient.setBucketCORS((SetBucketCORSRequest)request);
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                        actions.clear();
                        resources.clear();
                        sessionClient.shutdown();
                        break block124;
                    }
                }
                catch (Throwable throwable) {
                    actions.clear();
                    resources.clear();
                    sessionClient.shutdown();
                    throw throwable;
                }
                actions.clear();
                resources.clear();
                sessionClient.shutdown();
            }
            actions.add("oss:ListObjects");
            resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
            sessionClient = TestUtils.createSessionClient(actions, resources);
            try {
                try {
                    ObjectListing objectListing = sessionClient.listObjects("test-bucket-operations-with-token");
                    Assert.assertEquals((int)0, (int)objectListing.getObjectSummaries().size());
                    Assert.assertEquals((String)"test-bucket-operations-with-token", (String)objectListing.getBucketName());
                    Assert.assertNull((Object)objectListing.getDelimiter());
                    Assert.assertNull((Object)objectListing.getPrefix());
                    Assert.assertNull((Object)objectListing.getMarker());
                    Assert.assertNull((Object)objectListing.getNextMarker());
                    Assert.assertFalse((boolean)objectListing.isTruncated());
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                    actions.clear();
                    resources.clear();
                    sessionClient.shutdown();
                    break block126;
                }
            }
            catch (Throwable throwable) {
                actions.clear();
                resources.clear();
                sessionClient.shutdown();
                throw throwable;
            }
            actions.clear();
            resources.clear();
            sessionClient.shutdown();
        }
        actions.add("oss:DeleteBucket");
        resources.add("acs:oss:*:1287905056319499:test-bucket-operations-with-token");
        sessionClient = TestUtils.createSessionClient(actions, resources);
        try {
            try {
                sessionClient.deleteBucket("test-bucket-operations-with-token");
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                actions.clear();
                resources.clear();
                sessionClient.shutdown();
            }
        }
        finally {
            actions.clear();
            resources.clear();
            sessionClient.shutdown();
        }
    }

    @Test
    public void testObjectOperationsWithToken() {
        OSSClient sessionClient;
        ArrayList<String> resources;
        ArrayList<String> actions;
        block61: {
            block59: {
                GenericRequest request;
                ArrayList<PartETag> partETags;
                String uploadId;
                block57: {
                    block55: {
                        InputStream instream;
                        block53: {
                            block51: {
                                block49: {
                                    block47: {
                                        actions = new ArrayList<String>();
                                        resources = new ArrayList<String>();
                                        String bucketName = "test-object-operations-with-token-bucket0";
                                        actions.add("oss:PutBucket");
                                        resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0");
                                        sessionClient = TestUtils.createSessionClient(actions, resources);
                                        try {
                                            try {
                                                sessionClient.createBucket("test-object-operations-with-token-bucket0");
                                            }
                                            catch (Exception e) {
                                                Assert.fail((String)e.getMessage());
                                                actions.clear();
                                                resources.clear();
                                                sessionClient.shutdown();
                                                break block47;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            actions.clear();
                                            resources.clear();
                                            sessionClient.shutdown();
                                            throw throwable;
                                        }
                                        actions.clear();
                                        resources.clear();
                                        sessionClient.shutdown();
                                    }
                                    String key = "test-object-operations-with-token-key0";
                                    long instreamLength = 1024L;
                                    instream = null;
                                    actions.add("oss:PutObject");
                                    resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0/*");
                                    sessionClient = TestUtils.createSessionClient(actions, resources);
                                    try {
                                        try {
                                            instream = TestUtils.genFixedLengthInputStream(1024L);
                                            sessionClient.putObject("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0", instream, null);
                                        }
                                        catch (Exception e) {
                                            Assert.fail((String)e.getMessage());
                                            actions.clear();
                                            resources.clear();
                                            if (instream != null) {
                                                try {
                                                    instream.close();
                                                }
                                                catch (IOException iOException) {
                                                    // empty catch block
                                                }
                                            }
                                            sessionClient.shutdown();
                                            break block49;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        actions.clear();
                                        resources.clear();
                                        if (instream != null) {
                                            try {
                                                instream.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                        sessionClient.shutdown();
                                        throw throwable;
                                    }
                                    actions.clear();
                                    resources.clear();
                                    if (instream != null) {
                                        try {
                                            instream.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    sessionClient.shutdown();
                                }
                                actions.add("oss:GetObject");
                                resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0/*");
                                sessionClient = TestUtils.createSessionClient(actions, resources);
                                try {
                                    try {
                                        OSSObject o = sessionClient.getObject("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0");
                                        Assert.assertEquals((long)1024L, (long)o.getObjectMetadata().getContentLength());
                                    }
                                    catch (Exception e) {
                                        Assert.fail((String)e.getMessage());
                                        actions.clear();
                                        resources.clear();
                                        sessionClient.shutdown();
                                        break block51;
                                    }
                                }
                                catch (Throwable throwable) {
                                    actions.clear();
                                    resources.clear();
                                    sessionClient.shutdown();
                                    throw throwable;
                                }
                                actions.clear();
                                resources.clear();
                                sessionClient.shutdown();
                            }
                            actions.add("oss:GetObject");
                            actions.add("oss:PutObject");
                            resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0/*");
                            sessionClient = TestUtils.createSessionClient(actions, resources);
                            try {
                                try {
                                    sessionClient.copyObject("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0", "test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0xyz");
                                }
                                catch (Exception e) {
                                    Assert.fail((String)e.getMessage());
                                    actions.clear();
                                    resources.clear();
                                    sessionClient.shutdown();
                                    break block53;
                                }
                            }
                            catch (Throwable throwable) {
                                actions.clear();
                                resources.clear();
                                sessionClient.shutdown();
                                throw throwable;
                            }
                            actions.clear();
                            resources.clear();
                            sessionClient.shutdown();
                        }
                        int partSize = 131072;
                        uploadId = null;
                        partETags = new ArrayList<PartETag>();
                        actions.add("oss:PutObject");
                        resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0/*");
                        sessionClient = TestUtils.createSessionClient(actions, resources);
                        try {
                            try {
                                request = new InitiateMultipartUploadRequest("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0");
                                InitiateMultipartUploadResult result = sessionClient.initiateMultipartUpload((InitiateMultipartUploadRequest)request);
                                instream = TestUtils.genFixedLengthInputStream(131072L);
                                uploadId = result.getUploadId();
                                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                                uploadPartRequest.setBucketName("test-object-operations-with-token-bucket0");
                                uploadPartRequest.setKey("test-object-operations-with-token-key0");
                                uploadPartRequest.setInputStream(instream);
                                uploadPartRequest.setPartNumber(1);
                                uploadPartRequest.setPartSize(131072L);
                                uploadPartRequest.setUploadId(uploadId);
                                UploadPartResult uploadPartResult = sessionClient.uploadPart(uploadPartRequest);
                                partETags.add(uploadPartResult.getPartETag());
                            }
                            catch (Exception e) {
                                Assert.fail((String)e.getMessage());
                                actions.clear();
                                resources.clear();
                                sessionClient.shutdown();
                                break block55;
                            }
                        }
                        catch (Throwable throwable) {
                            actions.clear();
                            resources.clear();
                            sessionClient.shutdown();
                            throw throwable;
                        }
                        actions.clear();
                        resources.clear();
                        sessionClient.shutdown();
                    }
                    actions.add("oss:ListParts");
                    resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0/*");
                    sessionClient = TestUtils.createSessionClient(actions, resources);
                    try {
                        try {
                            ListPartsRequest listPartsRequest = new ListPartsRequest("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0", uploadId);
                            PartListing partListing = sessionClient.listParts(listPartsRequest);
                            Assert.assertEquals((int)1, (int)partListing.getParts().size());
                            Assert.assertEquals((String)"test-object-operations-with-token-bucket0", (String)partListing.getBucketName());
                            Assert.assertEquals((String)"test-object-operations-with-token-key0", (String)partListing.getKey());
                            Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
                            Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
                            Assert.assertEquals((int)1, (int)partListing.getNextPartNumberMarker());
                            Assert.assertFalse((boolean)partListing.isTruncated());
                        }
                        catch (Exception e) {
                            Assert.fail((String)e.getMessage());
                            actions.clear();
                            resources.clear();
                            sessionClient.shutdown();
                            break block57;
                        }
                    }
                    catch (Throwable throwable) {
                        actions.clear();
                        resources.clear();
                        sessionClient.shutdown();
                        throw throwable;
                    }
                    actions.clear();
                    resources.clear();
                    sessionClient.shutdown();
                }
                actions.add("oss:PutObject");
                resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0/*");
                sessionClient = TestUtils.createSessionClient(actions, resources);
                try {
                    try {
                        request = new CompleteMultipartUploadRequest("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0", uploadId, partETags);
                        sessionClient.completeMultipartUpload((CompleteMultipartUploadRequest)request);
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                        actions.clear();
                        resources.clear();
                        sessionClient.shutdown();
                        break block59;
                    }
                }
                catch (Throwable throwable) {
                    actions.clear();
                    resources.clear();
                    sessionClient.shutdown();
                    throw throwable;
                }
                actions.clear();
                resources.clear();
                sessionClient.shutdown();
            }
            actions.add("oss:DeleteObject");
            resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0/*");
            sessionClient = TestUtils.createSessionClient(actions, resources);
            try {
                try {
                    sessionClient.deleteObject("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0");
                    sessionClient.deleteObject("test-object-operations-with-token-bucket0", "test-object-operations-with-token-key0xyz");
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                    actions.clear();
                    resources.clear();
                    sessionClient.shutdown();
                    break block61;
                }
            }
            catch (Throwable throwable) {
                actions.clear();
                resources.clear();
                sessionClient.shutdown();
                throw throwable;
            }
            actions.clear();
            resources.clear();
            sessionClient.shutdown();
        }
        actions.add("oss:DeleteBucket");
        resources.add("acs:oss:*:1287905056319499:test-object-operations-with-token-bucket0");
        sessionClient = TestUtils.createSessionClient(actions, resources);
        try {
            try {
                sessionClient.deleteBucket("test-object-operations-with-token-bucket0");
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                actions.clear();
                resources.clear();
                sessionClient.shutdown();
            }
        }
        finally {
            actions.clear();
            resources.clear();
            sessionClient.shutdown();
        }
    }
}

