/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.util.CMyString;

public class HtmlUtil {
    private HtmlUtil() {
    }

    public static String renderLink(String _sHref, String _sTarget, String _sAlt, String _sExtra, String _sDesc) {
        return HtmlUtil.renderLink(_sHref, _sTarget, _sAlt, _sExtra, _sDesc, _sDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderLink(String _sHref, String _sTarget, String _sAlt, String _sExtra, String _sDesc, String _sLinkText) {
        String sLinkText = _sLinkText;
        if (sLinkText == null || sLinkText.length() <= 0) {
            sLinkText = _sDesc;
        }
        StringBuffer buffer = new StringBuffer(255);
        try {
            buffer.append("<a href=\"");
            buffer.append(_sHref);
            buffer.append('\"');
            if (_sTarget != null && (_sTarget = _sTarget.trim()).length() > 0) {
                buffer.append(" target=\"");
                buffer.append(_sTarget);
                buffer.append('\"');
            }
            if (_sAlt != null && (_sAlt = _sAlt.trim()).length() > 0) {
                buffer.append(" title=\"");
                buffer.append(CMyString.filterForHTMLValue(_sAlt));
                buffer.append('\"');
            }
            if (_sExtra != null && (_sExtra = _sExtra.trim()).length() > 0) {
                buffer.append(' ').append(_sExtra);
            }
            buffer.append(">");
            buffer.append(sLinkText);
            buffer.append("</a>");
            String string = buffer.toString();
            return string;
        }
        finally {
            buffer.setLength(0);
        }
    }

    public static String renderImage(String _sSrc, String _sAlt, String _sExtra) {
        return HtmlUtil.renderImage(_sSrc, _sAlt, _sExtra, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderImage(String _sSrc, String _sAlt, String _sExtra, String _sWidth, String _sHeight) {
        StringBuffer buffer = new StringBuffer(255);
        try {
            buffer.append("<img src=\"");
            buffer.append(_sSrc);
            buffer.append('\"');
            if (_sAlt != null && (_sAlt = _sAlt.trim()).length() > 0) {
                buffer.append(" alt=\"");
                buffer.append(CMyString.filterForHTMLValue(_sAlt));
                buffer.append('\"');
            }
            if (_sExtra != null) {
                buffer.append(' ').append(_sExtra);
            }
            if (_sWidth != null) {
                buffer.append(" width=\"").append(_sWidth).append('\"');
            }
            if (_sHeight != null) {
                buffer.append(" height=\"").append(_sHeight).append('\"');
            }
            buffer.append("/>");
            String string = buffer.toString();
            return string;
        }
        finally {
            buffer.setLength(0);
        }
    }

    public static String extractProtocolInURL(String _sUrl, String _sDefault) {
        int nPos = _sUrl.indexOf("://");
        if (nPos > 0) {
            return _sUrl.substring(0, nPos);
        }
        return _sDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calRelativePath(String _sUrl1, String _sUrl2) {
        int nMinLen;
        String sProtocol2;
        String sProtocol1;
        _sUrl1 = _sUrl1.replace('\\', '/');
        _sUrl2 = _sUrl2.replace('\\', '/');
        int nPos = _sUrl1.indexOf("://");
        if (nPos > 0) {
            sProtocol1 = _sUrl1.substring(0, nPos);
            _sUrl1 = _sUrl1.substring(nPos + 3);
        } else {
            sProtocol1 = "http";
        }
        nPos = _sUrl2.indexOf("://");
        if (nPos > 0) {
            sProtocol2 = _sUrl2.substring(0, nPos);
            _sUrl2 = _sUrl2.substring(nPos + 3);
        } else {
            sProtocol2 = "http";
        }
        if (!sProtocol1.equalsIgnoreCase(sProtocol2)) {
            return sProtocol1 + "://" + _sUrl1;
        }
        char[] charArray1 = _sUrl1.toCharArray();
        char[] charArray2 = _sUrl2.toCharArray();
        int nLength2 = charArray2.length;
        if (nLength2 < (nMinLen = charArray1.length)) {
            nMinLen = nLength2;
        }
        int nLastSlashPos = 0;
        for (nPos = 0; nPos < nMinLen && charArray1[nPos] == charArray2[nPos]; ++nPos) {
            if (charArray1[nPos] != '/') continue;
            nLastSlashPos = nPos;
        }
        if (nLastSlashPos == 0) {
            return sProtocol1 + "://" + _sUrl1;
        }
        nPos = nLastSlashPos + 1;
        if (nPos == nLength2) {
            return "./" + _sUrl1.substring(nLastSlashPos + 1);
        }
        StringBuffer buff = new StringBuffer(255);
        try {
            while (nPos < nLength2) {
                if (charArray2[nPos++] != '/') continue;
                buff.append("../");
            }
            buff.append(_sUrl1.substring(nLastSlashPos + 1));
            String string = buff.toString();
            return string;
        }
        finally {
            buff.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calParentRelativePath(String _sChildDataPath) {
        int nPos;
        _sChildDataPath = _sChildDataPath.replace('\\', '/');
        char[] charArray = _sChildDataPath.toCharArray();
        int nLen = charArray.length;
        for (nPos = 0; nPos < nLen && charArray[nPos] == '/'; ++nPos) {
        }
        StringBuffer buff = new StringBuffer(20);
        try {
            while (nPos < nLen) {
                if (charArray[nPos++] != '/') continue;
                buff.append("../");
            }
            if (charArray[nLen - 1] != '/') {
                buff.append("../");
            }
            String string = buff.toString();
            return string;
        }
        finally {
            buff.setLength(0);
        }
    }

    public static boolean isAbsoluteURL(String url) {
        if (url == null || url.length() <= 0) {
            return false;
        }
        return url.indexOf("://") > 0;
    }

    public static boolean isAbsoluteURLinSite(String url) {
        if (url == null || url.length() <= 0) {
            return false;
        }
        return url.charAt(0) == '/';
    }

    public static String newRelativeURL(String sReference, String sRelative) {
        int index1 = sReference.lastIndexOf(47);
        if (index1 < 0) {
            return sRelative;
        }
        sReference = sReference.substring(0, index1 + 1);
        return sReference + sRelative;
    }
}

