/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.DreamFactory;
import com.trs.dev4.jdk16.utils.EnvConst;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.Loader;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class ImgFileHelperForReadImg {
    private static Logger logger = Logger.getLogger(ImgFileHelperForReadImg.class);
    private static final Set IMAGE_SUFFIX_SET = new HashSet(8);
    private static final long MIN_FILE_SIZE = 10L;
    private static final int SUCCESS = 0;

    public static String convert(String _sImgFileName, int _nWidth) throws WCMException {
        String sDefaultImgRate = ConfigServer.getServer().getSysConfigValue("IMG_RATE_DEFAULT", "85");
        return ImgFileHelperForReadImg.convert(_sImgFileName, _nWidth, Integer.parseInt(sDefaultImgRate), true);
    }

    public static String makeNewAbsolutFileName(String _sAbsolutFileName, int nScaleWidth) {
        String sNewFileName = _sAbsolutFileName;
        String sFileExt = null;
        int nPos = sNewFileName.lastIndexOf(46);
        if (nPos <= 0) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("who call me?[" + _sAbsolutFileName + "]"), (Throwable)new Exception());
            }
            return _sAbsolutFileName;
        }
        sFileExt = sNewFileName.substring(nPos + 1);
        if (nScaleWidth > 0) {
            sNewFileName = sNewFileName.substring(0, nPos) + "_" + nScaleWidth + "." + sFileExt;
        }
        return sNewFileName;
    }

    public static String makeNewFileName(String _sFileName, int nScaleWidth) {
        String sNewFileName = _sFileName;
        String sFileExt = null;
        int nPos = sNewFileName.lastIndexOf(46);
        if (nPos <= 0) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("who call me?[" + _sFileName + "]"), (Throwable)new Exception());
            }
            return _sFileName;
        }
        sFileExt = sNewFileName.substring(nPos + 1);
        if (nScaleWidth > 0) {
            sNewFileName = sNewFileName.substring(0, nPos) + "_" + nScaleWidth + "." + sFileExt;
        }
        return sNewFileName;
    }

    public static String convert(String _sSrcAbsoluteFile, int _nWidth, int _nImgRate, boolean _bImgToJPG) throws WCMException {
        int nMaxTryTimes;
        String sNewAbsolutFileName = ImgFileHelperForReadImg.makeNewAbsolutFileName(_sSrcAbsoluteFile, _nWidth);
        File file = ImgFileHelperForReadImg.makeValidFile(sNewAbsolutFileName);
        if (file != null) {
            return file.getPath();
        }
        File srcFile = ImgFileHelperForReadImg.makeValidFile(_sSrcAbsoluteFile);
        if (srcFile == null) {
            logger.error((Object)("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[" + _sSrcAbsoluteFile + "]"), (Throwable)new Exception("who call me?"));
            throw new WCMException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        _sSrcAbsoluteFile = srcFile.getPath();
        IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        if (!m_libConf.isCmdUsed() && !PluginConfig.isStartPhoto()) {
            return _sSrcAbsoluteFile;
        }
        String sFileExt = "";
        int nPos = _sSrcAbsoluteFile.lastIndexOf(46);
        if (nPos <= 0) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("who call me?[" + _sSrcAbsoluteFile + "]"), (Throwable)new Exception());
            }
            return _sSrcAbsoluteFile;
        }
        sFileExt = _sSrcAbsoluteFile.substring(nPos + 1);
        if (!ImgFileHelperForReadImg.isImageFile(sFileExt)) {
            return _sSrcAbsoluteFile;
        }
        int nNewWidth = _nWidth;
        int nNewRate = _nImgRate;
        boolean bToJPG = _bImgToJPG;
        String sNewFileExt = ("png".equalsIgnoreCase(sFileExt) || "bmp".equalsIgnoreCase(sFileExt)) && bToJPG ? "jpg" : sFileExt;
        for (int i = nMaxTryTimes = 16; i >= 0; --i) {
            block16: {
                if (ImgFileHelperForReadImg.isValidFile(sNewAbsolutFileName)) {
                    return sNewAbsolutFileName;
                }
                try {
                    if ("gif".equalsIgnoreCase(sFileExt)) {
                        ImgFileHelperForReadImg.convertGIF(_sSrcAbsoluteFile, sNewAbsolutFileName, nNewRate, nNewWidth);
                    } else {
                        ImageMagickCmd.convert(_sSrcAbsoluteFile, sNewAbsolutFileName, nNewRate, nNewWidth);
                    }
                    if (ImgFileHelperForReadImg.isValidFile(sNewAbsolutFileName)) {
                        return sNewAbsolutFileName;
                    }
                }
                catch (Exception e) {
                    if (i != 0) break block16;
                    throw new WCMException("Fail to scale image![" + _sSrcAbsoluteFile + "]-->[" + sNewAbsolutFileName + "]", e);
                }
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Wait some millis to retry scale: " + sNewAbsolutFileName));
                }
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.warn((Object)("Failed to generate the scale image: " + sNewAbsolutFileName + ", the original file returned: " + _sSrcAbsoluteFile));
        return sNewAbsolutFileName;
    }

    private static boolean isImageFile(String sFileExt) {
        return sFileExt != null && IMAGE_SUFFIX_SET.contains(sFileExt.toLowerCase());
    }

    public static File makeValidFile(String fileName) {
        int nPos;
        File file = new File(fileName);
        if (!file.exists() && (nPos = fileName.lastIndexOf(46)) > 0) {
            String sFileExt = fileName.substring(nPos + 1);
            file = sFileExt.toLowerCase().equals(sFileExt) ? new File(fileName.substring(0, nPos + 1) + sFileExt.toUpperCase()) : new File(fileName.substring(0, nPos + 1) + sFileExt.toLowerCase());
        }
        if (file.exists() && file.isFile() && file.length() > 10L) {
            return file;
        }
        return null;
    }

    private static boolean isValidFile(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isFile() && file.length() > 10L;
    }

    public static String convertGIF(String _sSrcFile, String _sDstFile, int _nQuality, int _nScaleSizeWidth) throws Exception {
        URL url = Loader.getResource("TRSWCMPhoto.properties");
        Properties m_oConfigProperties = new Properties();
        m_oConfigProperties.load(url.openStream());
        String CMD_CONVERT = null;
        CMD_CONVERT = m_oConfigProperties.getProperty("CMD_CONVERT");
        ImageMagickCmd.ImageObj originalImage = new ImageMagickCmd.ImageObj();
        originalImage.setFilename(_sSrcFile);
        String[] cmd = new String[6];
        if (_nQuality > 0 && _nQuality < 100) {
            cmd[0] = CMD_CONVERT;
            cmd[1] = originalImage.filename;
            cmd[2] = "-coalesce";
            cmd[3] = "-quality";
            cmd[4] = String.valueOf(_nQuality);
            cmd[5] = _sDstFile;
            if (_nScaleSizeWidth > 0 && originalImage.width > _nScaleSizeWidth) {
                String[] newCmd = new String[8];
                System.arraycopy(cmd, 0, newCmd, 0, 5);
                newCmd[5] = "-scale";
                newCmd[6] = _nScaleSizeWidth + "x";
                System.arraycopy(cmd, 5, newCmd, 7, 1);
                cmd = newCmd;
            }
        } else if (_nScaleSizeWidth > 0 && originalImage.width > _nScaleSizeWidth) {
            cmd = new String[]{CMD_CONVERT, "-scale", _nScaleSizeWidth + "x", originalImage.filename, _sDstFile};
        } else {
            return _sSrcFile;
        }
        if (ImgFileHelperForReadImg.exec(cmd, null) == 0) {
            return _sDstFile;
        }
        return _sSrcFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int exec(String[] cmd, String[] result) throws Exception {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream pis = proc.getInputStream();
        final InputStream per = proc.getErrorStream();
        try {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        int a = 0;
                        while ((a = per.read()) != -1) {
                            baos.write(a);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            int a = 0;
            while ((a = pis.read()) != -1) {
                baos.write(a);
            }
            t.join();
            int exitCode = proc.waitFor();
            String msg = new String(baos.toByteArray());
            if (exitCode != 0) {
                throw new Exception("process fail:" + exitCode + ",msg=" + msg);
            }
            if (result != null && result.length > 0) {
                result[0] = msg.trim();
            }
            int n = 0;
            return n;
        }
        finally {
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Exception exception) {}
            }
            if (per != null) {
                try {
                    per.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String arrToString(Object[] aryObjects) {
        if (aryObjects == null) {
            return "null";
        }
        int maxIndex = aryObjects.length - 1;
        if (maxIndex < 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(maxIndex + 1).append(" elements: [");
        sb.append(EnvConst.NEWLINE);
        for (int i = 0; i < maxIndex; ++i) {
            sb.append(i).append(":").append(aryObjects[i]);
            sb.append(EnvConst.NEWLINE);
        }
        sb.append(maxIndex).append(":").append(aryObjects[maxIndex]);
        sb.append("]");
        return sb.toString();
    }

    static {
        IMAGE_SUFFIX_SET.add("png");
        IMAGE_SUFFIX_SET.add("jpg");
        IMAGE_SUFFIX_SET.add("jpeg");
        IMAGE_SUFFIX_SET.add("gif");
        IMAGE_SUFFIX_SET.add("bmp");
    }
}

