/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class WCMTagParserRelViewDatas
extends BaseTagParser4List {
    private static final String FIELD_KEYWORDS = "KEYWORDS";
    private static Logger logger = Logger.getLogger(WCMTagParserRelViewDatas.class);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_DOCUMENT = new ArrayList(16);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_METADATA;
    private MetaView m_oCurrView = null;
    private static TagBeanInfo s_TagBeanInfo;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_RELVIEWDATAS");
            tbi.setDesc("TRS_RELVIEWDATAS");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_blank");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ORDER");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELDNAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue(FIELD_KEYWORDS);
            tbai.setRequired(true);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ISMULTIVALUE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ISSUBSTRING");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SUBSTART");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SUBEND");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VIEWID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHANNELID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        int i;
        this.makeCurrView(_context);
        MetaViewData metaViewData = null;
        IPublishElement upperHost = _context.getUpperHost();
        if (!(upperHost instanceof IPublishContent)) {
            throw new WCMException("TRS_RELVIEWDATAS\u53ea\u80fd\u5e94\u7528\u5230\u5143\u6570\u636e\u4e0a!\u5f53\u524d\u5bf9\u8c61\u662f[" + upperHost.getInfo() + "]");
        }
        try {
            metaViewData = (MetaViewData)upperHost.getSubstance();
        }
        catch (ClassCastException ex) {
            throw new WCMException("TRS_RELVIEWDATAS\u53ea\u80fd\u5e94\u7528\u5230\u5143\u6570\u636e\u4e0a!\u76f8\u5173\u5bf9\u8c61\u662f\uff1a[" + upperHost.getSubstance() + "]", ex);
        }
        String sOrder = _context.getAttribute("Order");
        String sFieldName = _context.getAttribute("FieldName");
        String sFieldValue = metaViewData.getPropertyAsString(sFieldName);
        if (CMyString.isEmpty(sFieldValue)) {
            return new MetaViewDatas(this.m_oCurrView);
        }
        boolean bIsMultiValue = _context.getAttribute("IsMultiValue", true);
        if (bIsMultiValue && FIELD_KEYWORDS.equalsIgnoreCase(sFieldName)) {
            return this.findRelDataByKeyWords(metaViewData, _context);
        }
        boolean bIsSubString = _context.getAttribute("IsSubString", true);
        int subStart = _context.getAttribute("SubStart", -1);
        int subEnd = _context.getAttribute("SubEnd", -1);
        WCMFilter filter = new WCMFilter(null, null, null);
        StringBuffer sbWhere = new StringBuffer(300);
        sbWhere.append("exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.DocId=");
        sbWhere.append(this.m_oCurrView.getTrueTableName() + ".MetaDataId");
        sbWhere.append(" and ").append(this.m_oCurrView.getTrueTableName() + ".MetaDataId!=?");
        filter.addSearchValues(metaViewData.getId());
        if (bIsMultiValue) {
            StringBuffer relWhere = new StringBuffer("(");
            String[] arrFieldValue = sFieldValue.split(" |;|,");
            for (i = 0; i < arrFieldValue.length; ++i) {
                relWhere.append(this.m_oCurrView.getTrueTableName()).append(".").append(sFieldName).append(" like ?");
                if (i != arrFieldValue.length - 1) {
                    relWhere.append(" or ");
                }
                filter.addSearchValues("%" + arrFieldValue[i] + "%");
            }
            relWhere.append(")");
            sbWhere.append(" and ").append(relWhere);
        } else if (bIsSubString) {
            if (sFieldValue.length() < subStart || sFieldValue.length() < subEnd) {
                logger.debug((Object)("\u5b57\u6bb5[" + sFieldName + "]\u503c\u7684\u957f\u5ea6\u5c0f\u4e8e\u8bbe\u7f6e\u7684SubStart\u6216\u8005SubEnd"));
                return new MetaViewDatas(this.m_oCurrView);
            }
            String subValue = sFieldValue.substring(subStart, subEnd);
            StringBuffer queryValue = new StringBuffer();
            for (i = 0; i < subStart; ++i) {
                queryValue.append("_");
            }
            queryValue.append(subValue);
            sbWhere.append(" and ").append(this.m_oCurrView.getTrueTableName()).append(".").append(sFieldName).append(" like ?");
            filter.addSearchValues(queryValue.toString() + "%");
        } else {
            sbWhere.append(" and ").append(this.m_oCurrView.getTrueTableName()).append(".").append(sFieldName).append("=?");
            filter.addSearchValues(sFieldValue);
        }
        sbWhere.append(" and WCMChnlDoc.docKind =? ");
        filter.addSearchValues(this.m_oCurrView.getId());
        sbWhere.append(" and WCMChnlDoc.DOCSTATUS=10");
        sbWhere.append(")");
        filter.setWhere(sbWhere.toString());
        if (!CMyString.isEmpty(sOrder)) {
            filter.setOrder(sOrder);
        }
        MetaViewDatas viewDatas = new MetaViewDatas(this.m_oCurrView);
        String sSelectFields = this.getSelectFields(this.m_oCurrView.getTrueTableName().toUpperCase(), "TRS_VIEWDATA", _context);
        viewDatas.setSelectFieldsOfMetaTable(sSelectFields);
        int nMaxNum = _context.getAttribute("NUM", 5);
        viewDatas.setPageSize(nMaxNum);
        viewDatas.setMaxBufferSize(nMaxNum);
        viewDatas.open(filter);
        return viewDatas;
    }

    private CMSBaseObjs findRelDataByKeyWords(MetaViewData metaViewData, PublishTagContext _context) throws WCMException {
        String sKeywords = metaViewData.getPropertyAsString(FIELD_KEYWORDS);
        String sql = "select relkeywords.docid from wcmdockeyword relkeywords,wcmchnldoc entity where ";
        sql = sql + "relkeywords.docid=entity.docid and entity.docstatus=10 and entity.dockind=? and relkeywords.dockeyword=?";
        sql = sql + " order by relkeywords.doccrtime desc,relkeywords.dockeywordorder asc";
        DBManager dbman = DBManager.getDBManager();
        Statement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            int nMaxNum = _context.getAttribute("NUM", 5);
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            String[] arrFieldValue = sKeywords.split(" |;|,");
            HashSet<String> idSet = new HashSet<String>(nMaxNum);
            idSet.add(String.valueOf(metaViewData.getMetaDataId()));
            StringBuffer buff = new StringBuffer(64);
            int len = arrFieldValue.length;
            for (int i = 0; i < len && nMaxNum > 0; ++i) {
                pstmt.setInt(1, this.m_oCurrView.getId());
                pstmt.setString(2, arrFieldValue[i]);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String id = rs.getString(1);
                    if (idSet.contains(id)) continue;
                    idSet.add(id);
                    buff.append(',').append(id);
                    --nMaxNum;
                }
                rs.close();
            }
            idSet.clear();
            MetaViewDatas datas = null;
            if (buff.length() > 1) {
                String select = this.makeSelectFields(this.m_oCurrView.getTrueTableName(), "TRS_VIEWDATA", _context);
                datas = MetaViewDatas.findByIds(this.m_oCurrView, buff.substring(1));
                datas.setSelectFieldsOfMetaTable(select);
            } else {
                datas = new MetaViewDatas(this.m_oCurrView);
            }
            MetaViewDatas metaViewDatas = datas;
            return metaViewDatas;
        }
        catch (WCMException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new WCMException(40, "\u83b7\u53d6\u76f8\u5173\u5143\u6570\u636e\u8bb0\u5f55\u5931\u8d25.", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbman.freeConnection(conn);
            }
        }
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        this.makeCurrView(_context);
        return true;
    }

    private void makeCurrView(PublishTagContext _context) throws WCMException {
        if (this.m_oCurrView != null) {
            return;
        }
        int nViewId = _context.getAttribute("ViewId", 0);
        if (nViewId > 0) {
            this.m_oCurrView = MetaView.findById(nViewId);
        } else {
            IPublishElement upperHost = _context.getUpperHost();
            CMSObj subinstance = upperHost.getSubstance();
            if (subinstance instanceof MetaView) {
                this.m_oCurrView = (MetaView)subinstance;
            } else if (subinstance instanceof MetaViewData) {
                this.m_oCurrView = ((MetaViewData)subinstance).getMetaView();
            }
        }
        if (this.m_oCurrView == null) {
            throw new WCMException("\u6ca1\u6709\u5173\u8054\u7684\u89c6\u56fe\uff01");
        }
        HashMap<String, MetaView> hExtraAttributes = _context.getExtraAttributes();
        if (hExtraAttributes == null) {
            hExtraAttributes = new HashMap<String, MetaView>(1);
            _context.setExtraAttributes(hExtraAttributes);
        }
        hExtraAttributes.put("Curr.View", this.m_oCurrView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String _sTableName, String _sElementTagName, PublishTagContext _tagContext) {
        String sKey = (_sTableName + ".SELECT").toUpperCase();
        String sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
        if (sSelectFields == null) {
            TagItem tagItem = _tagContext.getTagItem();
            synchronized (tagItem) {
                sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_sTableName, _sElementTagName, _tagContext);
                    _tagContext.getTagItem().setExtraAttribute(sKey, sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(String _sTableName, String _sTagName, PublishTagContext _tagContext) {
        ArrayList arDefaultFields = null;
        arDefaultFields = _sTableName.equalsIgnoreCase("WCMDOCUMENT") ? FIELDS_DEFAULT_LIST_OF_DOCUMENT : FIELDS_DEFAULT_LIST_OF_METADATA;
        String sSelectFields = (String)arDefaultFields.get(0);
        int nSize = arDefaultFields.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + arDefaultFields.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(_tagContext.getTagItem(), _sTagName);
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (arDefaultFields.indexOf(sFieldName) >= 0) continue;
            try {
                if (dbMgr.getFieldInfo(_sTableName, sFieldName) == null) {
                    _tagContext.addWarning("TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[" + sFieldName + "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01");
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning("\u83b7\u53d6\u6307\u5b9a\u7684Field[" + sFieldName + "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01" + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        return sSelectFields;
    }

    static {
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCID");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCTITLE");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCKIND");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_METADATA = new ArrayList(4);
        FIELDS_DEFAULT_LIST_OF_METADATA.add("MetaDataId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("CRTIME");
        s_TagBeanInfo = null;
    }
}

