/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DatasWithChnlDocFilterHelper;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.InjectSQLHelper;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyMemory;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MetaViewDatas
extends CMSBaseObjs {
    private static final long serialVersionUID = -5271196943590033848L;
    private static Logger logger = Logger.getLogger(MetaViewDatas.class);
    private String m_sDbTableName = null;
    private String m_sIdFieldname = "MetaDataId";
    private MetaView m_oMetaView = null;
    private DatasWithChnlDocFilterHelper m_oDatasFilterHelper = null;
    public static int MAX_ROW_NUM = 1000;
    public static final String DB_TABLE_NAME = "WCMCHNLDOC";
    public static final String ID_FIELD_NAME = "RECID";
    private boolean m_bFromRecycle = false;
    private String m_sSelectFieldsFromDB = null;
    private String m_sSelectFieldsFromChnlDoc = "WCMCHNLDOC.RecId,WCMCHNLDOC.ChnlId,WCMCHNLDOC.DocId,WCMCHNLDOC.DocChannel,WCMCHNLDOC.DOCSTATUS";
    public static final Integer ID_NOT_LOAD = new Integer(0);
    public static boolean QUERY_ACCORD_DOCUMENT_RIGHT = false;
    public static int MAX_FETCH_SIZE = 1000;
    private Map<Integer, MetaViewData[]> m_hViewDocumentsCache = null;
    private HashMap<Integer, Object> m_hPublicCache = new HashMap(2);
    private int m_nRightIndex = -1;
    private boolean bLoadAll = false;
    private static final int OPEN_MODE_OLD = 0;
    private static final int OPEN_MODE_NEW = 1;
    private int m_nOpenMode = 1;
    private boolean m_bFromOneTable = false;
    private int m_nRecCount = -1;

    public MetaViewDatas(MetaView _view) {
        this.m_oMetaView = _view;
        this.m_sDbTableName = !_view.isMultiTable() ? MetaDataConstants.makeTrueTableName(_view.getName()) : _view.getName();
        this.m_oDatasFilterHelper = new DatasWithChnlDocFilterHelper(this.m_sDbTableName, "MetaDataId");
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public MetaViewDatas(String _sDbTableName) {
        this.m_sDbTableName = _sDbTableName;
        this.m_oDatasFilterHelper = new DatasWithChnlDocFilterHelper(this.m_sDbTableName, "MetaDataId");
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public MetaViewDatas(String _sDbTableName, String _sIdFieldName) {
        this.m_sDbTableName = _sDbTableName;
        this.m_sIdFieldname = _sIdFieldName;
        this.m_oDatasFilterHelper = new DatasWithChnlDocFilterHelper(this.m_sDbTableName, "MetaDataId");
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public MetaViewDatas(User _currUser, int _initCapacity, int _incCapacity) {
        super(_currUser, _initCapacity, _incCapacity);
    }

    @Override
    protected String getDbTableName() {
        return this.m_sDbTableName;
    }

    public void setDbTableName(String dbTableName) {
        this.m_sDbTableName = dbTableName;
    }

    @Override
    public Class<MetaViewData> getElementClass() {
        return MetaViewData.class;
    }

    public void setMetaView(MetaView oMetaView) {
        this.m_oMetaView = oMetaView;
    }

    public MetaView getMetaView() {
        return this.m_oMetaView;
    }

    @Override
    public String getIdFieldName() {
        return this.m_sIdFieldname;
    }

    public void setIdFieldName(String idFieldname) {
        this.m_sIdFieldname = idFieldname;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new MetaViewDatas(null, 1, 1);
    }

    @Override
    protected BaseObj createElementInstance() {
        MetaViewData viewData = new MetaViewData(this.m_sDbTableName, this.m_sIdFieldname);
        if (this.m_oMetaView != null) {
            viewData.setMetaView(this.m_oMetaView);
        }
        return viewData;
    }

    public static final MetaViewDatas findByIds(String _sTableName, String _sIds) {
        MetaViewDatas currMetaViewDatas = MetaViewDatas.createNewInstance(_sTableName);
        if (_sIds == null || _sIds.length() <= 0) {
            return currMetaViewDatas;
        }
        currMetaViewDatas.addElement(_sIds);
        return currMetaViewDatas;
    }

    public static final MetaViewDatas findByIds(MetaView _view, String _sIds) {
        MetaViewDatas currMetaViewDatas = new MetaViewDatas(_view);
        if (_sIds == null || _sIds.length() <= 0) {
            return currMetaViewDatas;
        }
        currMetaViewDatas.addElement(_sIds);
        return currMetaViewDatas;
    }

    public static final MetaViewDatas openWCMObjs(String _sTableName, WCMFilter _filter) throws WCMException {
        MetaViewDatas currMetaViewDatas = MetaViewDatas.createNewInstance(_sTableName);
        currMetaViewDatas.open(_filter);
        return currMetaViewDatas;
    }

    public static final MetaViewDatas openWCMObjs(MetaView oMetaView, WCMFilter _filter) throws WCMException {
        MetaViewDatas currMetaViewDatas = new MetaViewDatas(oMetaView);
        currMetaViewDatas.loadViewDatas(_filter);
        return currMetaViewDatas;
    }

    public static MetaViewDatas createNewInstance(String _sTableName) {
        return new MetaViewDatas(_sTableName);
    }

    public BaseChannel getCurrChannelOrSite() {
        return (BaseChannel)this.m_hPublicCache.get(MetaViewData.KEY_CURR_HOST);
    }

    public boolean canSort() {
        BaseChannel host = this.getCurrChannelOrSite();
        if (host == null) {
            return false;
        }
        if (host.isSite()) {
            return false;
        }
        Channel channel = (Channel)host;
        if (channel.isOnlySearch()) {
            return false;
        }
        String sOrderBy = channel.getOrderBy();
        return sOrderBy == null || (sOrderBy = sOrderBy.trim()).length() <= 0 || sOrderBy.toUpperCase().indexOf("DOCORDERPRI") >= 0;
    }

    public void open(Channels _channels, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.m_oDatasFilterHelper.makeChannelFilter(_channels, _filter, this.isFromRecycle());
        if (hostFilter == null) {
            return;
        }
        if (_channels.size() == 1) {
            this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, _channels.getAt(0));
        }
        this.loadViewDatas(hostFilter);
    }

    public void open(Channel _channel, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.m_oDatasFilterHelper.makeChannelFilter(_channel, _filter, true, this.isFromRecycle());
        if (hostFilter == null) {
            return;
        }
        this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, _channel);
        this.loadViewDatas(hostFilter);
    }

    public void open(WebSite _site, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.m_oDatasFilterHelper.makeFilter(_site, _filter, true, this.isFromRecycle());
        if (hostFilter == null) {
            return;
        }
        this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, _site);
        this.loadViewDatas(hostFilter);
    }

    public void open(WebSites _sites, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.m_oDatasFilterHelper.makeFilter(_sites, _filter, true, this.isFromRecycle());
        if (hostFilter == null) {
            return;
        }
        if (_sites.size() == 1) {
            this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, _sites.getAt(0));
        }
        this.loadViewDatas(hostFilter);
    }

    public void setLoadAllDatas(boolean bLoadAll) {
        this.bLoadAll = bLoadAll;
    }

    public void loadViewDatas(WCMFilter _filter) throws WCMException {
        if (CMyString.isEmpty(_filter.getFrom())) {
            _filter.setFrom(DB_TABLE_NAME);
        }
        String sWhere = "1=1";
        if (!CMyString.isEmpty(_filter.getWhere())) {
            sWhere = _filter.getWhere();
        }
        if (this.m_oMetaView != null) {
            sWhere = sWhere + " and WCMChnlDoc.DocKind=?";
            _filter.addSearchValues(this.m_oMetaView.getId());
        }
        String sWhereTemp = sWhere.toUpperCase();
        if (!this.isFromRecycle()) {
            if (sWhereTemp.indexOf("DOCCHANNEL") < 0) {
                sWhere = sWhere + " and DOCCHANNEL>0";
            }
            if (sWhereTemp.indexOf("DOCSTATUS") < 0) {
                sWhere = sWhere + " and DOCSTATUS>0";
            }
            if (sWhereTemp.indexOf("CHNLID") < 0) {
                sWhere = sWhere + " and CHNLID>0";
            }
        }
        _filter.setWhere(sWhere);
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"openViewDocuments SQL Info:");
            logger.fatal((Object)(_filter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        int nCount = DBManager.getDBManager().sqlExecuteCountQuery(_filter);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("Query Count use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)(_filter.toCountQueryInfo() + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (nCount == 0) {
            return;
        }
        if (nCount < this.getPageSize()) {
            this.setPageSize(nCount);
        }
        if (nCount < this.getMaxBufferSize()) {
            this.setMaxBufferSize(nCount);
        }
        CPager currPager = new CPager(this.getPageSize());
        currPager.setItemCount(nCount);
        if (this.bLoadAll) {
            currPager.setPageSize(nCount);
            this.setPageSize(nCount);
        }
        currPager.setCurrentPageIndex(this.getCurrPage());
        timer.start();
        this.loadPreDatasOfPage(_filter, currPager);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty() || this.m_sSelectFieldsFromDB == null || this.m_sSelectFieldsFromDB.length() == 0) {
            return;
        }
        timer.start();
        this.loadViewDatasOfPage(currPager.getCurrentPageIndex() - 1);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPreDatasOfPage(WCMFilter _filter, CPager _pager) throws WCMException {
        DebugTimer aTimer = new DebugTimer();
        this.vIdList = new Vector(_pager.getItemCount());
        Connection oConn = null;
        Statement oPreStmt = null;
        ResultSet rsData = null;
        String strSQL = "";
        WCMFilter loadPreDataFilter = null;
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label1", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            loadPreDataFilter = this.makeQueryPreDataFilter(_filter, this.m_sSelectFieldsFromChnlDoc);
            strSQL = loadPreDataFilter.toSQL();
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            if (_pager.getPageSize() < 0) {
                if (_pager.getItemCount() < MAX_FETCH_SIZE) {
                    oPreStmt.setFetchSize(_pager.getItemCount());
                } else {
                    oPreStmt.setFetchSize(MAX_FETCH_SIZE);
                }
            } else if (_pager.getPageSize() < MAX_FETCH_SIZE) {
                oPreStmt.setFetchSize(_pager.getPageSize());
            } else {
                oPreStmt.setFetchSize(MAX_FETCH_SIZE);
            }
            DBManager.setParameters((PreparedStatement)oPreStmt, loadPreDataFilter);
            aTimer.start();
            rsData = oPreStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)loadPreDataFilter);
            }
            int nCount = 0;
            ResultSetMetaData rsmdData = null;
            while (rsData.next()) {
                if (++nCount < _pager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                MetaViewData viewData = null;
                viewData = this.m_oMetaView != null ? new MetaViewData(this.m_oMetaView, this.m_hPublicCache) : new MetaViewData(this.m_sDbTableName);
                viewData.readChnlDocPropertyFromRs(rsData, rsmdData);
                if (!this.isVisible(viewData)) {
                    --nCount;
                    _pager.setItemCount(_pager.getItemCount() - 1);
                    continue;
                }
                int nId = rsData.getInt(ID_FIELD_NAME);
                this.vIdList.add(new Integer(nId));
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(viewData.getKey(), viewData);
                this.putViewDocument(viewData.getMetaDataId(), viewData);
                if (nCount < _pager.getLastItemIndex()) continue;
            }
            rsData.close();
            for (int i = nCount; i < _pager.getItemCount(); ++i) {
                this.vIdList.add(ID_NOT_LOAD);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
        }
        catch (SQLException ex) {
            try {
                throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + loadPreDataFilter, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label3", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn == null) throw throwable;
                this.getDBManager().freeConnection(oConn);
                throw throwable;
            }
        }
        try {
            if (oPreStmt != null) {
                oPreStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn == null) return;
        this.getDBManager().freeConnection(oConn);
    }

    private WCMFilter makeQueryPreDataFilter(WCMFilter _filter, String _sSelectFields) {
        WCMFilter newFilter = new WCMFilter(_filter);
        String strFrom = _filter.getFrom();
        if (strFrom == null || (strFrom = strFrom.trim()).length() == 0) {
            newFilter.setFrom(this.getDbTableName());
        }
        newFilter.setSelect(_sSelectFields);
        return newFilter;
    }

    private boolean loadViewDatasOfPage(int _pageIndex) throws WCMException {
        if (this.pageSize == -1 || this.pageSize > MAX_FETCH_SIZE) {
            this.pageSize = MAX_FETCH_SIZE;
            int nPageIndex = 1;
            int i = 0;
            while (i < this.size()) {
                this.loadViewDatasOfPage(nPageIndex);
                i += MAX_FETCH_SIZE;
                ++nPageIndex;
            }
            return true;
        }
        CPager pager = new CPager(this.pageSize);
        pager.setItemCount(this.size());
        pager.setCurrentPageIndex(_pageIndex);
        WCMFilter oPageFilter = this.createPageSQL(pager);
        if (oPageFilter == null) {
            return false;
        }
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        try {
            int nMetaDataId;
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(oPageFilter.toSQL());
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > MAX_FETCH_SIZE) {
                oStmt.setFetchSize(MAX_FETCH_SIZE);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            DBManager.setParameters(oStmt, oPageFilter);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + oPageFilter));
            }
            aTimer.start();
            while (rsData.next()) {
                MetaViewData[] pViewDatas;
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                if ((pViewDatas = this.getViewDocuments(nMetaDataId = rsData.getInt("MetaDataId"))) == null) {
                    this.printErrorInfo(nMetaDataId, oPageFilter.toSQL(), "MetaViewDatas\u7f13\u51b2\u7ef4\u62a4\u6709\u95ee\u9898\uff1f\u6307\u5b9a\u7684DocId[" + nMetaDataId + "]\u5bf9\u5e94\u7684MetaViewData\u4e0d\u80fd\u83b7\u5f97\uff01");
                    continue;
                }
                MetaViewData currObject = pViewDatas[0];
                currObject.readFromRs(rsData, rsmdData);
                int nCount = pViewDatas.length;
                for (int i = 1; i < nCount; ++i) {
                    pViewDatas[i].cloneDocumentProperties(currObject);
                }
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + oPageFilter));
            }
            nMetaDataId = 1;
            return nMetaDataId != 0;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + oPageFilter, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + oPageFilter, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    private void printErrorInfo(int _nCurrDocId, String _sCurrSQL, String _sTitle) {
        logger.error((Object)_sTitle);
        logger.error((Object)("DocId:" + _nCurrDocId));
        logger.error((Object)("strSQL:" + _sCurrSQL));
        if (this.m_oObjsBuffer != null) {
            logger.error((Object)("m_oObjsBuffer:" + this.m_oObjsBuffer));
            logger.error((Object)("m_oObjsBuffer.size:" + this.m_oObjsBuffer.size()));
        } else {
            logger.error((Object)"m_oObjsBuffer is null.");
        }
    }

    private void putViewDocument(int _nDocId, MetaViewData _ViewDocument2) {
        if (this.m_hViewDocumentsCache == null) {
            this.m_hViewDocumentsCache = this.pageSize > 0 ? new HashMap<Integer, MetaViewData[]>(this.pageSize) : new HashMap<Integer, MetaViewData[]>(this.vIdList.capacity());
        }
        MetaViewData[] pViewDocuments = null;
        Integer iDocIdKey = new Integer(_nDocId);
        pViewDocuments = this.m_hViewDocumentsCache.get(iDocIdKey);
        if (pViewDocuments == null) {
            pViewDocuments = new MetaViewData[]{_ViewDocument2};
        } else {
            int nOldLength = pViewDocuments.length;
            MetaViewData[] pTemp = new MetaViewData[nOldLength + 1];
            if (nOldLength > 0) {
                System.arraycopy(pViewDocuments, 0, pTemp, 0, nOldLength);
            }
            pTemp[nOldLength] = _ViewDocument2;
            pViewDocuments = pTemp;
        }
        this.m_hViewDocumentsCache.put(iDocIdKey, pViewDocuments);
    }

    private MetaViewData[] getViewDocuments(int _nMetaDataId) {
        if (this.m_hViewDocumentsCache == null) {
            return null;
        }
        Integer iDocIdKey = new Integer(_nMetaDataId);
        return this.m_hViewDocumentsCache.get(iDocIdKey);
    }

    public void open(CMSBaseObjs _oSitesOrChannels, WCMFilter _extraFilter) throws WCMException {
        if (_oSitesOrChannels instanceof Channels) {
            this.open((Channels)_oSitesOrChannels, _extraFilter);
        } else if (_oSitesOrChannels instanceof WebSites) {
            this.open((WebSites)_oSitesOrChannels, _extraFilter);
        } else {
            throw new WCMException(I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label7", "\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b[") + _oSitesOrChannels.getClassName(true) + "]\uff01");
        }
    }

    public boolean isFromRecycle() {
        return this.m_bFromRecycle;
    }

    public void setFromRecycle(boolean fromRecycle) {
        this.m_bFromRecycle = fromRecycle;
    }

    public void setSelectFieldsFromChnlDoc(String _sSelectFieldsFromChnlDoc) {
        if (_sSelectFieldsFromChnlDoc == null || (_sSelectFieldsFromChnlDoc = _sSelectFieldsFromChnlDoc.trim()).length() == 0) {
            return;
        }
        this.validInjectSQL(_sSelectFieldsFromChnlDoc, DB_TABLE_NAME);
        String[] pSelectFields = _sSelectFieldsFromChnlDoc.split(",");
        String sAppendPrex = "WCMCHNLDOC.";
        int nAppendPrexLength = _sSelectFieldsFromChnlDoc.indexOf(46) > 0 ? sAppendPrex.length() : 0;
        StringBuffer sbSelectFields = new StringBuffer(_sSelectFieldsFromChnlDoc.length() + nAppendPrexLength * pSelectFields.length);
        for (int i = 0; i < pSelectFields.length; ++i) {
            if (i > 0) {
                sbSelectFields.append(",");
            }
            if (pSelectFields[i].indexOf(46) < 0) {
                sbSelectFields.append(sAppendPrex);
            }
            sbSelectFields.append(pSelectFields[i]);
        }
        this.m_sSelectFieldsFromChnlDoc = sbSelectFields.toString();
    }

    public void setSelectFieldsOfMetaTable(String selectFieldsFromDocument) {
        this.validInjectSQL(selectFieldsFromDocument, this.m_sDbTableName);
        this.m_sSelectFieldsFromDB = selectFieldsFromDocument;
    }

    public void setSelectFields(String _sSelectFieldFromChnlDoc, String _sSelectFieldsFromDocument) {
        this.setSelectFieldsFromChnlDoc(_sSelectFieldFromChnlDoc);
        this.setSelectFieldsOfMetaTable(_sSelectFieldsFromDocument);
    }

    public int getRightIndex() {
        return this.m_nRightIndex;
    }

    public void setRightIndex(int rightIndex) {
        this.m_nRightIndex = rightIndex;
    }

    public MetaViewDatas() {
    }

    public static MetaViewDatas findByIds(String sIds) throws WCMException {
        Document oDocument;
        int[] aIds = CMyString.splitToInt(sIds, ",");
        if (aIds.length == 0) {
            return new MetaViewDatas();
        }
        int nViewId = 0;
        for (int i = 0; i < aIds.length && ((oDocument = Document.findById(aIds[i])) == null || (nViewId = oDocument.getPropertyAsInt("docKind", 0)) == 0); ++i) {
        }
        if (nViewId == 0) {
            return new MetaViewDatas();
        }
        MetaView oMetaView = MetaView.findById(nViewId);
        String sTableName = null;
        sTableName = !oMetaView.isMultiTable() ? MetaDataConstants.makeTrueTableName(oMetaView.getName()) : oMetaView.getName();
        MetaViewDatas oViewDatas = MetaViewDatas.findByIds(sTableName, sIds);
        oViewDatas.setMetaView(oMetaView);
        return oViewDatas;
    }

    public void setNeedWithAuthFilter(User _loginUser, boolean _bNeedWithAuthFilter) {
        this.m_oDatasFilterHelper.setNeedWithAuthFilter(_loginUser, _bNeedWithAuthFilter);
    }

    public int getOpenMode() {
        return this.m_nOpenMode;
    }

    public void setOpenMode(int _sOpenMode) {
        this.m_nOpenMode = _sOpenMode;
    }

    @Override
    public synchronized void open(WCMFilter _filter) throws WCMException {
        this.open(_filter, null);
    }

    public synchronized void open(WCMFilter _filter, WCMFilter _countFilter) throws WCMException {
        if (this.m_nOpenMode == 0) {
            super.open(_filter);
            return;
        }
        if (CMyString.isEmpty(_filter.getFrom())) {
            _filter.setFrom(this.getDbTableName());
        }
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"==========open SQL Info=========");
            logger.fatal((Object)(_filter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        int nCount = this.m_nRecCount;
        DebugTimer timer = new DebugTimer();
        if (nCount < 0) {
            timer.start();
            nCount = _countFilter != null ? DBManager.getDBManager().sqlExecuteCountQuery(_countFilter) : DBManager.getDBManager().sqlExecuteCountQuery(_filter);
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)("Query Count use [" + timer.getTime() + "]ms!"));
                logger.fatal((Object)(_filter.toCountQueryInfo() + "\n"));
                logger.fatal((Object)CMyMemory.toMemoryInfo());
            }
            this.m_nRecCount = nCount;
        }
        if (nCount == 0) {
            return;
        }
        if (nCount < this.getPageSize()) {
            this.setPageSize(nCount);
        }
        if (nCount < this.getMaxBufferSize()) {
            this.setMaxBufferSize(nCount);
        }
        CPager currPager = new CPager(this.getPageSize());
        currPager.setItemCount(nCount);
        currPager.setCurrentPageIndex(this.getCurrPage());
        timer.start();
        int nDataCount = this.loadPrePageDatasOneTable(_filter, currPager);
        if ((nDataCount == 0 || nDataCount < nCount && nDataCount < this.getPageSize()) && _countFilter != null) {
            if ((_filter = this.removeTimeLimitFromSrcFilter(_filter, _countFilter)) == null) {
                return;
            }
            logger.info((Object)"reload data remove time limit!");
            logger.info((Object)_filter);
            nDataCount = this.loadPrePageDatasOneTable(_filter, currPager);
        }
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.m_nRecCount != this.vIdList.size()) {
            return;
        }
        timer.start();
        this.loadViewDatasOfPageOneTable(currPager.getCurrentPageIndex() - 1);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    private WCMFilter removeTimeLimitFromSrcFilter(WCMFilter _filter, WCMFilter _countFilter) {
        if (_countFilter == null) {
            return null;
        }
        List lSearchValuesOfFirst = _filter.getSearchValues();
        if (lSearchValuesOfFirst == null) {
            return null;
        }
        List lSearchValuesOfCount = _countFilter.getSearchValues();
        if (lSearchValuesOfCount == null || lSearchValuesOfFirst.size() <= lSearchValuesOfCount.size()) {
            return null;
        }
        for (int i = lSearchValuesOfFirst.size() - 1; i >= 0; --i) {
            Object oValue = lSearchValuesOfFirst.get(i);
            if (!(oValue instanceof CMyDateTime)) continue;
            lSearchValuesOfFirst.remove(i);
        }
        _filter.setWhere(_countFilter.getWhere());
        return _filter;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadPrePageDatasOneTable(WCMFilter _filter, CPager _pager) throws WCMException {
        int nCount;
        WCMFilter loadPreDataFilter;
        Statement oPreStmt;
        Connection oConn;
        block34: {
            this.m_bFromOneTable = true;
            DebugTimer aTimer = new DebugTimer();
            this.vIdList = new Vector(_pager.getItemCount());
            oConn = null;
            oPreStmt = null;
            ResultSet rsData = null;
            String strSQL = "";
            loadPreDataFilter = null;
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label1", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            loadPreDataFilter = this.makeQueryPreDataFilter(_filter, this.getDbTableName() + "." + this.getIdFieldName());
            strSQL = loadPreDataFilter.toSQL();
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            int nMaxSize = MAX_FETCH_SIZE;
            if (_pager.getPageSize() < 0) {
                if (_pager.getItemCount() < nMaxSize) {
                    oPreStmt.setFetchSize(_pager.getItemCount());
                } else {
                    oPreStmt.setFetchSize(nMaxSize);
                }
            } else {
                int nMaxRowNum;
                if (_pager.getPageSize() < nMaxSize) {
                    oPreStmt.setFetchSize(_pager.getPageSize());
                } else {
                    oPreStmt.setFetchSize(nMaxSize);
                }
                if (_pager.getCurrentPageIndex() == 1) {
                    nMaxRowNum = Math.min(_pager.getPageSize(), this.m_nRecCount);
                    oPreStmt.setMaxRows(nMaxRowNum);
                } else if (MAX_ROW_NUM > 0 && _pager.getLastItemIndex() <= MAX_ROW_NUM) {
                    nMaxRowNum = Math.min(_pager.getLastItemIndex(), this.m_nRecCount);
                    oPreStmt.setMaxRows(nMaxRowNum);
                }
            }
            DBManager.setParameters((PreparedStatement)oPreStmt, loadPreDataFilter);
            aTimer.start();
            rsData = oPreStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)loadPreDataFilter);
                logger.debug((Object)("query id use[" + aTimer.getTime() + "]ms!"));
            }
            nCount = 0;
            ResultSetMetaData rsmdData = null;
            while (rsData.next()) {
                if (++nCount < _pager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                int nId = rsData.getInt(this.getIdFieldName());
                this.vIdList.add(new Integer(nId));
                if (nCount < _pager.getLastItemIndex()) continue;
            }
            rsData.close();
            if (nCount != 0) break block34;
            int n = nCount;
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
            return n;
        }
        for (int i = nCount; i < _pager.getItemCount(); ++i) {
            this.vIdList.add(ID_NOT_LOAD);
        }
        int n = nCount;
        try {
            if (oPreStmt != null) {
                oPreStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        this.currIndex = this.size() > 0 ? 0 : -2;
        return n;
        catch (SQLException ex) {
            try {
                throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + loadPreDataFilter, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label3", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                this.currIndex = this.size() > 0 ? 0 : -2;
                throw throwable;
            }
        }
    }

    private boolean loadViewDatasOfPageOneTable(int _pageIndex) throws WCMException {
        if (this.pageSize == -1 || this.pageSize > MAX_FETCH_SIZE) {
            this.pageSize = MAX_FETCH_SIZE;
            int nPageIndex = 1;
            int i = 0;
            while (i < this.size()) {
                this.loadViewDatasOfPage(nPageIndex);
                i += MAX_FETCH_SIZE;
                ++nPageIndex;
            }
            return true;
        }
        CPager pager = new CPager(this.pageSize);
        pager.setItemCount(this.size());
        pager.setCurrentPageIndex(_pageIndex);
        WCMFilter oPageFilter = this.createPageSQL(pager);
        if (oPageFilter == null) {
            return false;
        }
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        try {
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(oPageFilter.toSQL());
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > MAX_FETCH_SIZE) {
                oStmt.setFetchSize(MAX_FETCH_SIZE);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            DBManager.setParameters(oStmt, oPageFilter);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + oPageFilter));
            }
            aTimer.start();
            while (rsData.next()) {
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                MetaViewData currObject = null;
                currObject = this.m_oMetaView != null ? new MetaViewData(this.m_oMetaView, this.m_hPublicCache) : new MetaViewData(this.m_sDbTableName);
                if (this.m_sDbTableName != null) {
                    currObject.setDbTableName(this.m_sDbTableName);
                }
                currObject.readFromRs(rsData, rsmdData);
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(currObject.getKey(), currObject);
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + oPageFilter));
            }
            boolean currObject = true;
            return currObject;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + oPageFilter, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + oPageFilter, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    @Override
    public void setRecCount(int _nRecCount) {
        if (_nRecCount < 0) {
            return;
        }
        this.m_nRecCount = _nRecCount;
    }

    @Override
    public int getRecCount() {
        if (this.m_nRecCount < 0) {
            return this.size();
        }
        return this.m_nRecCount;
    }

    @Override
    public int size() {
        if (this.m_nRecCount <= 0) {
            return super.size();
        }
        return this.m_nRecCount;
    }

    private boolean hasRight(RightValue _rightValue) {
        if (this.m_nRightIndex == 64) {
            return _rightValue.getValue() > 0L;
        }
        return _rightValue.isHasRight(this.m_nRightIndex);
    }

    private boolean isVisible(MetaViewData _oMetaViewData) throws WCMException {
        if (this.m_nRightIndex == -1 || !QUERY_ACCORD_DOCUMENT_RIGHT) {
            return true;
        }
        int nDocId = _oMetaViewData.getMetaDataId();
        if (!DocumentAuthServer.isDefineRightOnDocument(nDocId)) {
            return true;
        }
        RightValue rightValue = new RightValue();
        rightValue.load(this.currUser, 605, nDocId, true);
        if (this.hasRight(rightValue)) {
            return true;
        }
        String GET_CRUSER_SQL = "select CrUser from WCMDocument where DocId=?";
        String sCrUser = DBManager.getDBManager().sqlExecuteStringQuery("select CrUser from WCMDocument where DocId=?", new int[]{nDocId});
        return this.currUser.getName().equals(sCrUser);
    }

    public static final MetaViewDatas openWCMObjsNew(MetaView oMetaView, WCMFilter _filter) throws WCMException {
        DebugTimer timer = new DebugTimer();
        timer.start();
        MetaViewDatas currMetaViewDatas = new MetaViewDatas(oMetaView);
        currMetaViewDatas.setSelectFields(_filter.getExtSelect(), _filter.getSelect());
        if (!_filter.isLoadAll()) {
            currMetaViewDatas.setPageSize(_filter.getPageSize());
            currMetaViewDatas.setCurrPage(_filter.getCurrPage());
        } else {
            currMetaViewDatas.setLoadAllDatas(true);
        }
        _filter.setSelect(null);
        currMetaViewDatas.loadViewDatasNew(_filter);
        timer.stop();
        if (timer.getTime() > 1500L) {
            logger.warn((Object)("query data use[" + timer.getTime() + "]ms!SQL:" + _filter));
            SimpleLogServer.elapse(LogConstant.Module.EDITORCENTER.desc, LogUserUtil.getLogUser(), "\u67e5\u8be2", "\u67e5\u8be2\u6570\u636eSQL" + _filter.toSQL(), timer.getTime());
        }
        currMetaViewDatas.removeDirtyData();
        return currMetaViewDatas;
    }

    public void removeDirtyData() {
        if (this.m_oObjsBuffer == null) {
            return;
        }
        Enumeration enKeys = this.m_oObjsBuffer.keys();
        int nOldSize = this.size();
        int nDirtyDataCount = 0;
        while (enKeys.hasMoreElements()) {
            Integer iKey = (Integer)enKeys.nextElement();
            MetaViewData oViewData = (MetaViewData)this.m_oObjsBuffer.get(iKey);
            if (oViewData.getProperties() != null) continue;
            this.vIdList.remove(iKey);
            this.m_oObjsBuffer.remove(iKey);
            this.m_hViewDocumentsCache.remove(oViewData.getMetaDataId());
            logger.warn((Object)("dirty data table=" + this.getDbTableName() + " id=" + oViewData.getMetaDataId() + " relateproperties=" + oViewData.getChnlDocProperties()));
            SimpleLogServer.warn(LogConstant.Module.EDITORCENTER.desc, LogUserUtil.getLogUser(), "\u67e5\u8be2", "\u79fb\u9664\u810f\u6570\u636e", "\u810f\u6570\u636e\u8868\u540d=" + this.getDbTableName() + "id=" + oViewData.getMetaDataId() + "\u76f8\u5173\u5b57\u6bb5=" + oViewData.getChnlDocProperties());
            ++nDirtyDataCount;
        }
        if (nDirtyDataCount > 0) {
            logger.warn((Object)("contains dirty data[" + nDirtyDataCount + "/" + nOldSize + "] SQL=" + this.filter));
        }
    }

    @Override
    public BaseObj getAt(int _index) {
        int nId = this.getIdAt(_index);
        if (nId == ID_NOT_LOAD) {
            return null;
        }
        return super.getAt(_index);
    }

    public void loadViewDatasNew(WCMFilter _filter) throws WCMException {
        if (CMyString.isEmpty(_filter.getFrom())) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u6765\u6e90");
        }
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"loadViewDatasNew SQL Info:");
            logger.fatal((Object)(_filter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        int nCount = DBManager.getDBManager().sqlExecuteCountQuery(_filter);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("Query Count use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)(_filter.toCountQueryInfo() + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (nCount == 0) {
            return;
        }
        if (this.currPage <= 0) {
            this.currPage = -1;
        }
        CPager currPager = new CPager(this.getPageSize());
        currPager.setItemCount(nCount);
        if (this.bLoadAll) {
            currPager.setPageSize(nCount);
            this.setPageSize(nCount);
        }
        currPager.setCurrentPageIndex(this.getCurrPage());
        timer.start();
        this.loadPreDatasOfPage(_filter, currPager);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty() || this.m_sSelectFieldsFromDB == null || this.m_sSelectFieldsFromDB.length() == 0) {
            return;
        }
        timer.start();
        this.loadViewDatasOfPage(currPager.getCurrentPageIndex());
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    public void loadChnlDocProperties(String _sChnlDocFields) throws WCMException {
        WCMFilter filter = new WCMFilter(DB_TABLE_NAME, "", "", _sChnlDocFields);
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("DocId in(");
        int nSize = this.vIdList.size();
        for (int i = 0; i < nSize && i < 300; ++i) {
            int nId = (Integer)this.vIdList.get(i);
            sbWhere.append("?,");
            filter.addSearchValues(nId);
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbWhere.append(") and Modal=?");
        filter.addSearchValues(1);
        filter.setWhere(sbWhere.toString());
        this.loadRelationData(filter, "DOCID");
    }

    public void loadDefaultChnlDocProperties() throws WCMException {
        this.loadChnlDocProperties("WCMCHNLDOC.RecId,WCMCHNLDOC.ChnlId,WCMCHNLDOC.DocId,WCMCHNLDOC.DocChannel,WCMCHNLDOC.DOCSTATUS,WCMChnlDoc.MODAL");
    }

    public void loadRelationData(WCMFilter _oRelationFilter, String _sMetaDataIdFieldName) throws WCMException {
        MetaViewData oViewData = (MetaViewData)this.getAt(this.size() - 1);
        if (!oViewData.getChnlDocProperties().isEmpty()) {
            return;
        }
        Connection oConn = null;
        Statement oPreStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(_oRelationFilter.toSQL());
            DBManager.setParameters((PreparedStatement)oPreStmt, _oRelationFilter);
            rsData = oPreStmt.executeQuery();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)_oRelationFilter);
            }
            ResultSetMetaData rsmdData = null;
            while (rsData.next()) {
                int nMetaDataDocId;
                MetaViewData oViewDataTemp;
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                if ((oViewDataTemp = (MetaViewData)this.getById(nMetaDataDocId = rsData.getInt(_sMetaDataIdFieldName))) == null) continue;
                oViewDataTemp.readChnlDocPropertyFromRs(rsData, rsmdData);
                oViewDataTemp.setId(nMetaDataDocId);
            }
            rsData.close();
        }
        catch (Exception ex) {
            throw new WCMException("\u8bfb\u53d6\u5176\u4ed6\u5173\u8054\u8868\u6570\u636e\u5931\u8d25\uff01", ex);
        }
        finally {
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    private final void validInjectSQL(String _sValue, String _sTableName) {
        if (InjectSQLHelper.containsInjectSelectSQL(_sValue, _sTableName)) {
            logger.error((Object)("Inject Select[" + _sValue + "]"), (Throwable)new Exception("who call me?"));
            throw new RuntimeException("Invalid select! Inject?!");
        }
    }

    private WCMFilter createPageSQL(CPager _pager) throws WCMException {
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("MetaDataId in(");
        WCMFilter pageFilter = new WCMFilter(this.getDbTableName(), "", "", "MetaDataId," + this.m_sSelectFieldsFromDB);
        for (int i = _pager.getFirstItemIndex() - 1; i < _pager.getLastItemIndex(); ++i) {
            int nId = 0;
            if (this.m_bFromOneTable) {
                nId = this.getIdAt(i);
            } else {
                MetaViewData viewDocument = (MetaViewData)this.getAt(i);
                if (viewDocument == null) {
                    this.printErrorInfo(this.getIdAt(i), null, "Dirty data on make page sql");
                } else {
                    nId = viewDocument.getMetaDataId();
                }
            }
            sbWhere.append("?,");
            pageFilter.addSearchValues(nId);
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbWhere.append(")");
        pageFilter.setWhere(sbWhere.toString());
        return pageFilter;
    }
}

