/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.CDBText;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;

public class InfoViewData
extends CMSObj {
    public static final int OBJ_TYPE = 3013;
    private String m_sIdFieldName = null;
    private InfoView m_oInfoView = null;
    private Channel m_oDocChannel = null;
    private int m_nInfoViewDataId = 0;
    private HashMap m_hPublicCache = null;
    private Hashtable m_hChnlDocProperties = new Hashtable(1);

    public InfoViewData() {
        this.m_bCheckPropertyValid = false;
    }

    @Override
    public String getDbTableName() {
        return InfoViewConstants.makeTrueTableName(this.getInfoViewId());
    }

    public int getDocChannelId() {
        int nChannelId = Math.abs(this.getPropertyAsInt("ChannelId", 0));
        return nChannelId;
    }

    public Channel getDocChannel() throws WCMException {
        if (this.m_oDocChannel == null) {
            this.m_oDocChannel = Channel.findById(this.getDocChannelId());
        }
        return this.m_oDocChannel;
    }

    @Override
    public String getIdFieldName() {
        return this.m_sIdFieldName == null ? InfoViewConstants.getIdFieldName(this.getDbTableName()) : this.m_sIdFieldName;
    }

    public void setIdFieldName(String _sIdFieldName) {
        this.m_sIdFieldName = _sIdFieldName;
    }

    @Override
    public int getWCMType() {
        return 3013;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static final InfoViewData findById(InfoView _oInfoView, int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        InfoViewData viewData = new InfoViewData();
        viewData.setInfoViewId(_oInfoView.getId());
        viewData.setId(_nId);
        if (viewData.loadFromDB()) {
            return viewData;
        }
        return null;
    }

    public static final InfoViewData createNewInstance() throws WCMException {
        return (InfoViewData)BaseObj.createNewInstance(InfoViewData.class);
    }

    public static final InfoViewData createNewInstance(int _nInfoViewId, int _nDocumentId) throws WCMException {
        InfoViewData oInfoViewData = (InfoViewData)BaseObj.createNewInstance(InfoViewData.class);
        oInfoViewData.setInfoViewId(_nInfoViewId);
        oInfoViewData.setDocumentId(_nDocumentId);
        return oInfoViewData;
    }

    public static final InfoViewData findByKey(Object _oKey) throws WCMException {
        return (InfoViewData)BaseObj.findByKey(InfoViewData.class, _oKey);
    }

    public int getInfoViewId() {
        return this.getPropertyAsInt("InfoViewId", 0);
    }

    public void setInfoViewId(int _nInfoViewId) throws WCMException {
        this.setProperty("InfoViewId", _nInfoViewId);
    }

    public void setDocumentId(int _nDocId) throws WCMException {
        this.setProperty("DocumentId", _nDocId);
    }

    public void setChannelId(int _nChannelId) throws WCMException {
        this.setProperty("ChannelId", _nChannelId);
    }

    public int getChannelId() {
        return this.getPropertyAsInt("ChannelId", 0);
    }

    public Channel getChannel() throws WCMException {
        int nChannelId = this.getChannelId();
        return Channel.findById(nChannelId);
    }

    public Document getDocument() throws WCMException {
        return Document.findById(this.getDocumentId());
    }

    public int getDocumentId() {
        return this.getPropertyAsInt("DocumentId", 0);
    }

    public static InfoViewData findById(int _nDocumentId) throws WCMException {
        Document document = Document.findById(_nDocumentId);
        if (document == null) {
            return null;
        }
        return InfoViewData.findByDocument(document);
    }

    public static InfoViewData findByDocument(Document document) throws WCMException {
        int nInfoViewId = document.getFlag();
        InfoViewData viewData = new InfoViewData();
        viewData.setInfoViewId(nInfoViewId);
        viewData.setIdFieldName("DocumentId");
        viewData.setId(document.getId());
        if (viewData.loadFromDB()) {
            viewData.setIdFieldName(null);
            viewData.setId(viewData.getPropertyAsInt(viewData.getIdFieldName(), 0));
            return viewData;
        }
        return null;
    }

    public static InfoViewData findById2(int _nInfoViewId, int _nDocumentId) throws WCMException {
        InfoViewData viewData = new InfoViewData();
        viewData.setInfoViewId(_nInfoViewId);
        viewData.setIdFieldName("DocumentId");
        viewData.setId(_nDocumentId);
        if (viewData.loadFromDB()) {
            viewData.setIdFieldName(null);
            viewData.setId(viewData.getPropertyAsInt(viewData.getIdFieldName(), 0));
            return viewData;
        }
        return null;
    }

    @Override
    public void setId(int _nId) {
        this.id = _nId;
    }

    public int getInfoViewDataId() {
        if (this.m_nInfoViewDataId != 0) {
            return this.m_nInfoViewDataId;
        }
        return this.getPropertyAsInt("DocumentId", 0);
    }

    public void setInfoViewDataId(int docId) {
        this.m_nInfoViewDataId = docId;
    }

    public InfoViewData(InfoView _Infoview, HashMap _hPublicCache) {
        this.m_hPublicCache = _hPublicCache;
        this.m_bCheckPropertyValid = false;
        this.m_oInfoView = _Infoview;
    }

    public void cloneDocumentProperties(InfoViewData _infoViewData) {
        this.m_hProperties = _infoViewData.getProperties(false);
    }

    public String getChnlDocProperty(String _sFieldName) {
        Object value = this.m_hChnlDocProperties.get(_sFieldName.toUpperCase());
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public int getChnlDocProperty(String _sFieldName, int _nDefault) {
        Number value = (Number)this.m_hChnlDocProperties.get(_sFieldName.toUpperCase());
        if (value == null) {
            return _nDefault;
        }
        return value.intValue();
    }

    public final void readChnlDocPropertyFromRs(ResultSet _rsData, ResultSetMetaData _rsmdData) throws WCMException {
        try {
            if (_rsData == null) {
                return;
            }
            Object objValue = null;
            ResultSetMetaData rsmdData = _rsmdData != null ? _rsmdData : _rsData.getMetaData();
            int nColCount = rsmdData.getColumnCount();
            for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                if (sFieldName.equalsIgnoreCase("DOCID")) {
                    this.setInfoViewDataId(_rsData.getInt(i));
                    continue;
                }
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (rsmdData.getScale(i) <= 0) {
                            long lValue = _rsData.getLong(i);
                            if (_rsData.wasNull()) break;
                            objValue = new Long(lValue);
                            break;
                        }
                        if (_rsData.wasNull()) break;
                        BigDecimal dValue = new BigDecimal(_rsData.getDouble(i));
                        dValue = dValue.setScale(rsmdData.getScale(i), 4);
                        if (_rsData.wasNull()) break;
                        objValue = dValue;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long lValue = _rsData.getLong(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Long(lValue);
                        break;
                    }
                    case 12: {
                        objValue = _rsData.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = new CMyDateTime();
                        ((CMyDateTime)objValue).setDateTimeWithRs(_rsData, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        objValue = new CDBText(this.getDBManager().getDBType());
                        ((CDBText)objValue).readFromRs(_rsData, i);
                        break;
                    }
                    case 8: {
                        double dValue = _rsData.getDouble(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Double(dValue);
                        break;
                    }
                    default: {
                        objValue = _rsData.getObject(i);
                    }
                }
                if (objValue == null) continue;
                this.setChnlDocProperty(sFieldName, objValue);
            }
            this.id = this.getChnlDocProperty("RECID", 0);
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08" + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (CMyException ex) {
            throw new WCMException(1, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08" + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08" + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
    }

    public void setChnlDocProperty(String _sFieldName, Object _value) {
        if (this.m_hChnlDocProperties == null) {
            this.m_hChnlDocProperties = new Hashtable();
        }
        this.m_hChnlDocProperties.put(_sFieldName.toUpperCase(), _value);
    }

    @Override
    public String toString() {
        try {
            return "[InfoViewId=" + this.getInfoViewId() + ",Id=" + this.getId() + ",DocumentId=" + this.getDocumentId() + ",ChannelId=" + this.getChannelId() + "]";
        }
        catch (Exception e) {
            return I18NMessage.get(InfoViewData.class, "InfoViewData.label1", "\u8d44\u6e90\u5e93\u6570\u636e");
        }
    }
}

