/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bbs.plad.upload;

import com.trs.bbs.plad.upload.RFC1867Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class RFC1867InputStream
extends InputStream {
    public static String POST_ENCODING = "GBK";
    protected static final int MAX_HEADER_LENGTH = 1024;
    protected static final byte FORM_PART_TERMINATOR = 45;
    protected static final byte CR = 13;
    protected static final byte LF = 10;
    protected static final byte[] CRLF = new byte[]{13, 10};
    private InputStream m_isOriginal;
    private boolean m_zNextPart = false;
    private boolean m_zEndStream = false;
    private int m_bNextByte = -1;
    private int m_readLength = 0;
    private int m_iBoundaryLength;
    private byte[] m_baLineBuff;
    private byte[] m_baBoundary;
    private byte[] m_parentBoundary;

    public RFC1867InputStream(InputStream originalIns, byte[] boundary) {
        this.m_isOriginal = originalIns;
        this.m_baBoundary = null;
        this.m_baLineBuff = new byte[1024];
        this.m_parentBoundary = null;
        this.pushBoundary(boundary);
    }

    public boolean hasMorePart() {
        if (this.m_zNextPart) {
            return true;
        }
        if (this.m_baBoundary != null) {
            while (true) {
                byte[] arrayOfByte;
                int len;
                if ((len = this.readLine(arrayOfByte = this.m_baLineBuff, 0, 1024)) < 0) {
                    throw new RFC1867Exception("Unexpected EOF");
                }
                if (!this.testNextLine()) continue;
                this.skipCRLF();
                if (this.testBoundary(len)) break;
            }
            return this.m_baBoundary != null;
        }
        return false;
    }

    public boolean inMixedPart() {
        return this.m_parentBoundary != null;
    }

    private void popBoundary() {
        this.m_baBoundary = this.m_parentBoundary;
        this.m_parentBoundary = null;
        if (this.m_baBoundary != null) {
            this.m_iBoundaryLength = this.m_baBoundary.length;
        } else {
            this.m_zNextPart = false;
            this.m_iBoundaryLength = 0;
        }
    }

    public void pushBoundary(byte[] boundaryByteArray) {
        this.m_parentBoundary = this.m_baBoundary;
        this.m_baBoundary = boundaryByteArray;
        this.m_iBoundaryLength = boundaryByteArray.length;
    }

    public int read() throws IOException {
        if (this.m_bNextByte != -1) {
            int i = this.m_bNextByte;
            this.m_bNextByte = -1;
            return i;
        }
        int i = this.m_isOriginal.read();
        if (i != -1) {
            ++this.m_readLength;
        } else {
            this.m_zEndStream = true;
        }
        return i;
    }

    public void readBody(OutputStream outputStream) throws IOException {
        if (this.m_zNextPart) {
            return;
        }
        byte[] baReadBuff = this.m_baLineBuff;
        int lastCRLF = 0;
        while (true) {
            int len;
            if ((len = this.readLine(baReadBuff, 0, 1024)) < 0) {
                throw new RFC1867Exception("Unexpected EOF");
            }
            int thizCRLF = 0;
            if (this.testNextLine()) {
                thizCRLF = this.readCRLF();
                if (this.testBoundary(len)) break;
            }
            if (lastCRLF > 0) {
                outputStream.write(13);
                if (lastCRLF == 2) {
                    outputStream.write(10);
                }
            }
            if (len > 0) {
                outputStream.write(baReadBuff, 0, len);
            }
            lastCRLF = thizCRLF;
        }
    }

    private int readCRLF() throws IOException {
        int i = this.read();
        if (i == 13) {
            i = this.read();
            if (i == 10) {
                return 2;
            }
            this.m_bNextByte = i;
            return 1;
        }
        this.m_bNextByte = i;
        return 0;
    }

    public String readHeader() {
        byte[] baReadBuff = this.m_baLineBuff;
        int len = this.readLine(baReadBuff, 0, 1024);
        if (len < 0) {
            throw new RFC1867Exception("Unexpected EOF");
        }
        if (this.testNextLine()) {
            this.skipCRLF();
            if (len > 0) {
                try {
                    return new String(baReadBuff, 0, len, POST_ENCODING);
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException) {
                    return new String(baReadBuff, 0, len);
                }
            }
            return null;
        }
        throw new RFC1867Exception("header too long");
    }

    public Hashtable readHeaders() {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        String hdr = null;
        while ((hdr = this.readHeader()) != null) {
            int ix = hdr.indexOf(58);
            if (ix <= 0) continue;
            String name = hdr.substring(0, ix).trim();
            String value = hdr.substring(ix + 1).trim();
            if (name.length() <= 0 || value.length() <= 0) continue;
            headers.put(name, value);
        }
        return headers;
    }

    private int readLine(byte[] buff, int off, int len) {
        if (len <= 0) {
            return 0;
        }
        int iCnt = 0;
        int bTmp = 0;
        try {
            while ((bTmp = this.read()) != -1) {
                if (bTmp == 13) {
                    this.m_bNextByte = bTmp;
                } else {
                    buff[off++] = (byte)bTmp;
                    if (++iCnt != len) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new RFC1867Exception(ioe);
        }
        if (iCnt > 0) {
            this.m_zNextPart = false;
        }
        return iCnt == 0 && bTmp == -1 ? -1 : iCnt;
    }

    private void skipCRLF() {
        try {
            int i = this.read();
            if (i == 13) {
                i = this.read();
                if (i != 10) {
                    this.m_bNextByte = i;
                }
            } else {
                this.m_bNextByte = i;
            }
        }
        catch (IOException ex) {
            throw new RFC1867Exception(ex);
        }
    }

    private boolean testBoundary(int dataLength) {
        int boundaryLength = this.m_iBoundaryLength;
        if (dataLength == boundaryLength || dataLength == boundaryLength + 2) {
            byte[] data = this.m_baLineBuff;
            byte[] boundary = this.m_baBoundary;
            int k = 0;
            while (k < boundaryLength) {
                if (data[k] != boundary[k]) {
                    return false;
                }
                ++k;
            }
            this.m_zNextPart = true;
            if (dataLength == boundaryLength + 2 && data[dataLength - 1] == 45 && data[dataLength - 2] == 45) {
                this.popBoundary();
            }
            return true;
        }
        return false;
    }

    private boolean testNextLine() {
        return this.m_bNextByte == 13 || this.m_zEndStream;
    }
}

