/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.Collection;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public abstract class DataAccessUtils {
    public static Object uniqueResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size = results.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object requiredUniqueResult(Collection results) throws IncorrectResultSizeDataAccessException {
        Object result = DataAccessUtils.uniqueResult(results);
        if (result == null) {
            throw new IncorrectResultSizeDataAccessException(1, 0);
        }
        return result;
    }
}

