/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2CallableStatement;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2Socket;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.net.Socket;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected static final short STMT_TYPE_QUERY = 24;
    protected static final short STMT_TYPE_CALL = 25;
    protected static final short STMT_TYPE_OTHER = 26;
    protected static final short STMT_TYPE_SQLJ = 27;
    protected int statementHandle;
    protected DB2Connection connection;
    protected SQLWarning warnings = null;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int rowCount = 0;
    protected int colCount = 0;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected String[] colNames4JSQL = null;
    protected int colCount4JSQL = 0;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected DB2ResultSet resultSet = null;
    protected boolean moreResults = true;
    protected int CLIBlockSize = 0;
    private boolean counted = false;
    private static int statementCount = 0;
    private static int peakStatementCount = 0;
    protected String sql = null;
    protected int SQL_SUCCESS = 0;
    protected int SQL_SUCCESS_WITH_INFO = 1;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected StringBuffer stmtBatch = new StringBuffer();
    protected int batchSize = 0;
    protected int[] batchReturn = null;

    public DB2Statement() throws SQLException {
    }

    public DB2Statement(DB2Connection dB2Connection) throws SQLException {
        this(dB2Connection, false);
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl) throws SQLException {
        this(dB2Connection, bl, 1003, 1007);
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl, int n, int n2) throws SQLException {
        this.connection = dB2Connection;
        this.internalStmt = bl;
        this.sqlExcptGen = dB2Connection.sqlExcptGen;
        this.checkResultSetType(n, n2);
        this.rsType = n;
        this.rsConcur = n2;
        int n3 = n;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
        int n4 = 0;
        try {
            this.db2req.write((short)11);
            this.db2req.write((short)this.rsType);
            this.db2req.sendAndRecv();
            n4 = this.db2req.readInt();
            this.statementHandle = this.db2req.readInt();
            if (this.rsType != 1003 && (n3 = (int)this.db2req.readShort()) != this.rsType) {
                this.rsType = 1003;
                this.connection.addWarning(new SQLWarning("Cursor downgraded to TYPE_FORWARD_ONLY", "01S02", -99999));
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (n4 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n4);
        }
        this.incrementStatementCount();
    }

    public void addBatch(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.batchSize == 0) {
            this.stmtBatch.append(string);
        } else {
            this.stmtBatch.append(";" + string);
        }
        ++this.batchSize;
    }

    protected synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            SQLWarning sQLWarning2 = this.warnings;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
        }
    }

    private static synchronized void adjustStatementCount(int n) {
        if ((statementCount += n) > peakStatementCount) {
            peakStatementCount = statementCount;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Peak statements", peakStatementCount);
            }
            DriverManager.println("DB2 Peak statements = " + peakStatementCount);
        }
    }

    public void cancel() throws SQLException {
        DB2Request dB2Request;
        DB2Socket dB2Socket;
        block28: {
            Object object2;
            dB2Socket = null;
            dB2Request = null;
            int n = -99999;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "cancel()");
                }
                if (this.connection.closed) {
                    SQLExceptionGenerator.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                try {
                    object2 = this.connection.getServer();
                    int n2 = new Integer(this.connection.getPortStr());
                    dB2Socket = new DB2Socket(new Socket((String)object2, n2), this.connection);
                    DB2Request dB2Request2 = dB2Request = new DB2Request(dB2Socket);
                    synchronized (dB2Request2) {
                        dB2Request.write((short)23);
                        dB2Request.write(this.statementHandle);
                        dB2Request.sendAndRecv();
                        n = dB2Request.readInt();
                    }
                    if (n != 0 && n != 1) {
                        throw new DB2Exception("Cancel Failed");
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                block31: {
                    Object var5_9 = null;
                    try {
                        if (dB2Request != null) {
                            dB2Request.write((short)2);
                            dB2Request.sendAndRecv();
                            dB2Request.readInt();
                        }
                    }
                    catch (Exception exception) {
                        if (!DB2Trace.TraceOn) break block31;
                        DB2Trace.data(10, "Exception occurred closing db2req2");
                        DB2Trace.data(10, "Exception", exception.getMessage());
                    }
                }
                try {
                    if (dB2Request != null) {
                        dB2Request.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (dB2Socket != null) {
                        dB2Socket.close();
                    }
                }
                catch (Exception exception) {}
                dB2Request = null;
                dB2Socket = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "cancel()");
                }
                throw throwable;
            }
            try {
                if (dB2Request != null) {
                    dB2Request.write((short)2);
                    dB2Request.sendAndRecv();
                    dB2Request.readInt();
                }
            }
            catch (Exception object2) {
                if (!DB2Trace.TraceOn) break block28;
                DB2Trace.data(10, "Exception occurred closing db2req2");
                DB2Trace.data(10, "Exception", ((Throwable)object2).getMessage());
            }
        }
        try {
            if (dB2Request != null) {
                dB2Request.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (dB2Socket != null) {
                dB2Socket.close();
            }
        }
        catch (Exception exception) {}
        dB2Request = null;
        dB2Socket = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "cancel()");
        }
    }

    protected void checkFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
        if (this.rsType == 1003 && n == 1001) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
    }

    protected void checkFetchSize(int n) throws SQLException {
        if (this.maxRows != 0 && n > this.maxRows || n < 0) {
            this.sqlExcptGen.throwFetchSizeError();
        }
    }

    protected void checkForCursorDowngrade() throws SQLException {
        block9: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "checkForCursorDowngrade()");
                    DB2Trace.data(10, "rsType", this.rsType);
                }
                if (this.rsType == 1003) break block9;
                SQLWarning sQLWarning = this.getWarnings();
                while (sQLWarning != null) {
                    if (sQLWarning.getSQLState().equalsIgnoreCase("01S02")) {
                        this.rsType = 1003;
                        if (this.resultSet != null && this.resultSet instanceof DB2ScrollableResultSet) {
                            this.resultSet = null;
                        }
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "Cursor downgraded to TYPE_FORWARD_ONLY");
                        }
                    }
                    sQLWarning = sQLWarning.getNextWarning();
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "checkForCursorDowngrade()");
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "checkForCursorDowngrade()");
        }
    }

    protected void checkResultSetType(int n, int n2) throws SQLException {
        if (n2 == 1008) {
            this.sqlExcptGen.throwNotSupportedByDB2("Updatable result set");
        }
        if (n2 != 1007) {
            this.sqlExcptGen.throwUnknownResultSetType(n2);
        }
        if (n == 1005) {
            this.sqlExcptGen.throwNotSupportedByDB2("Scroll sensitive result set");
        }
        if (n != 1003 && n != 1004) {
            this.sqlExcptGen.throwUnknownResultSetType(n);
        }
    }

    public void clearBatch() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.batchSize = 0;
        this.stmtBatch = new StringBuffer();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.decrementStatementCount();
        if (this.connection == null) {
            return;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            if (this.connection.closed) {
                Object var2_2 = null;
                return;
            }
            if (this.resultSet != null) {
                this.resultSet.clearIsList();
                this.resultSet = null;
            }
            int n = 0;
            try {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)13);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
            }
            this.statementHandle = 0;
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
    }

    private synchronized void decrementStatementCount() {
        if (this.counted) {
            DB2Statement.adjustStatementCount(-1);
            this.counted = false;
        }
    }

    public boolean execute(String string) throws SQLException {
        this.sql = string;
        this.execute2(string);
        return this.colCount > 0;
    }

    protected void execute2(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (string == null || string.trim().length() == 0) {
            this.sqlExcptGen.throwNullError();
        }
        this.warnings = null;
        this.moreResults = true;
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)12);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.write((short)this.rsType);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                if (n == 100) {
                    this.rowCount = 0;
                    this.colCount = 0;
                    if (this.rsType == 1004) {
                        ((DB2ScrollableResultSet)this.resultSet).resetRowNum(0);
                    }
                } else if (n == this.SQL_SUCCESS) {
                    int n2 = this.rsType;
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                    this.rsType = this.db2req.readShort();
                    if (this.rsType != n2 && this.resultSet != null && !(this.resultSet instanceof DB2ScrollableResultSet)) {
                        this.resultSet = null;
                    }
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                        if (this.rsType == 1004) {
                            ((DB2ScrollableResultSet)this.resultSet).resetRowNum(this.rowCount);
                        }
                    }
                } else if (n == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n);
                    this.checkForCursorDowngrade();
                    this.getCounts();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                        if (this.rsType == 1004) {
                            ((DB2ScrollableResultSet)this.resultSet).resetRowNum(this.rowCount);
                        }
                    }
                } else {
                    this.sqlExcptGen.check_return_code(this, n);
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public int[] executeBatch() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.batchSize == 0) {
            this.batchReturn = new int[0];
            return this.batchReturn;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)201);
                this.db2req.write(this.statementHandle);
                this.db2req.write(this.stmtBatch.toString());
                this.db2req.write(this.batchSize);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                this.batchReturn = new int[this.batchSize];
                int n2 = 0;
                while (n2 < this.batchSize) {
                    this.batchReturn[n2] = this.db2req.readInt();
                    ++n2;
                }
                if (this.SQL_SUCCESS_WITH_INFO == n) {
                    BatchUpdateException batchUpdateException = null;
                    SQLException sQLException = null;
                    int n3 = this.db2req.readInt();
                    while (n3 > 0) {
                        BatchUpdateException batchUpdateException2 = this.db2req.readBoolean() ? new BatchUpdateException(SQLExceptionGenerator.errMsgClass.getString("0641"), "HY000", -99999, this.batchReturn) : new BatchUpdateException(this.db2req.readString(), this.db2req.readString(), this.db2req.readInt(), this.batchReturn);
                        if (batchUpdateException == null) {
                            batchUpdateException = batchUpdateException2;
                        } else {
                            sQLException.setNextException(batchUpdateException2);
                        }
                        sQLException = batchUpdateException2;
                        --n3;
                    }
                    if (batchUpdateException != null) {
                        throw batchUpdateException;
                    }
                } else if (n != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_batch_return_code(this, n);
                }
            }
            this.clearBatch();
            return this.batchReturn;
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            return null;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        short s;
        this.sql = string;
        if (string == null || string.trim().length() == 0) {
            this.sqlExcptGen.throwNullError();
        }
        if ((s = this.getStatementType(string)) != 24 && s != 25 && s != 27) {
            this.sqlExcptGen.throwInvalidQueryError();
        }
        this.execute2(string);
        this.getResultSet();
        return this.resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        this.sql = string;
        if (this.getStatementType(string) == 24) {
            this.sqlExcptGen.throwInvalidUpdateError();
        }
        this.execute2(string);
        return this.getUpdateCount();
    }

    public void finalize() throws SQLException {
        block6: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "finalize()");
                }
                if (this.closed) break block6;
                String string = null;
                string = this instanceof DB2CallableStatement ? "DB2CallableStatement closed in finalizer: \"" + this.sql + "\"" : (this instanceof DB2PreparedStatement ? "DB2PreparedStatement closed in finalizer: \"" + this.sql + "\"" : "DB2Statement closed in finalizer, last SQL: \"" + this.sql + "\"");
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, string);
                }
                DriverManager.println(string);
                this.close();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "finalize()");
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "finalize()");
        }
    }

    protected int[] getBatchReturn() {
        return this.batchReturn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void getCounts() throws SQLException {
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)16);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                if (n == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.fetchDirection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getFetchSize() throws SQLException {
        int n;
        int n2 = this.CLIBlockSize;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFetchSize()");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (this.fetchSize > 0) {
                n2 = this.fetchSize;
            }
            n = n2;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getFetchSize()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getFetchSize()", n2);
        return n;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.maxRows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean getMoreResults() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (!this.moreResults) {
            return false;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)15);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n == 100) {
                    this.moreResults = false;
                    return false;
                }
                if (n == this.SQL_SUCCESS || n == this.SQL_SUCCESS_WITH_INFO) {
                    if (n != this.SQL_SUCCESS) {
                        this.sqlExcptGen.check_return_code(this, n);
                    }
                    this.colCount = this.db2req.readShort();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                    }
                    if (this.colCount != 0) return true;
                    this.rowCount = this.db2req.readInt();
                    return true;
                }
                this.sqlExcptGen.check_return_code(this, n);
                this.moreResults = false;
                return false;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            this.moreResults = false;
            return false;
        }
    }

    public static int getPeakStatementCount() {
        return peakStatementCount;
    }

    public int getQueryTimeout() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)21);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                } else {
                    n = this.db2req.readInt();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.resultSet == null) {
            this.resultSet = this.rsType != 1003 ? (DB2Trace.TraceOn ? new DB2ScrollableResultSetTrace(this, this.colCount, this.rowCount) : new DB2ScrollableResultSet(this, this.colCount, this.rowCount)) : (DB2Trace.TraceOn ? new DB2ResultSetTrace(this, this.colCount) : new DB2ResultSet(this, this.colCount));
        }
        if (this.colCount <= 0 || !this.moreResults) {
            return null;
        }
        return this.resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.rsConcur;
    }

    public int getResultSetType() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.rsType;
    }

    public static int getStatementCount() {
        return statementCount;
    }

    public int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected short getStatementType(String string) {
        int n;
        int n2;
        block23: {
            String string2;
            short s;
            block22: {
                n2 = 26;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getStatementType( " + string + " )");
                    }
                    if (string != null) {
                        int n3 = string.length();
                        int n4 = 0;
                        if (n3 > 0 && string.charAt(n4) == '#') {
                            s = 27;
                            Object var5_10 = null;
                            if (!DB2Trace.TraceOn) return s;
                            string2 = null;
                            break block22;
                        }
                        while (true) {
                            char c;
                            if (n4 >= n3 || !Character.isWhitespace(c = string.charAt(n4)) && c != '{' && c != ';' && c != '?' && c != '(' && c != '=') {
                                n2 = string.regionMatches(true, n4, "select", 0, 6) || string.regionMatches(true, n4, "values", 0, 6) || string.regionMatches(true, n4, "with", 0, 4) ? 24 : (string.regionMatches(true, n4, "call", 0, 4) ? 25 : 26);
                            }
                            ++n4;
                        }
                    }
                    n = n2;
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    String string3 = null;
                    switch (n2) {
                        case 24: {
                            string3 = "STMT_TYPE_QUERY (24)";
                            break;
                        }
                        case 25: {
                            string3 = "STMT_TYPE_CALL (25)";
                            break;
                        }
                        case 27: {
                            string3 = "STMT_TYPE_SQLJ (27)";
                            break;
                        }
                        default: {
                            string3 = "STMT_TYPE_OTHER (26)";
                        }
                    }
                    DB2Trace.methodExit((Object)this, "getStatementType()", string3);
                    throw throwable;
                }
            }
            switch (n2) {
                case 24: {
                    string2 = "STMT_TYPE_QUERY (24)";
                    break;
                }
                case 25: {
                    string2 = "STMT_TYPE_CALL (25)";
                    break;
                }
                case 27: {
                    string2 = "STMT_TYPE_SQLJ (27)";
                    break;
                }
                default: {
                    string2 = "STMT_TYPE_OTHER (26)";
                }
            }
            DB2Trace.methodExit((Object)this, "getStatementType()", string2);
            return s;
        }
        Object var5_11 = null;
        if (!DB2Trace.TraceOn) return (short)n;
        String string4 = null;
        switch (n2) {
            case 24: {
                string4 = "STMT_TYPE_QUERY (24)";
                break;
            }
            case 25: {
                string4 = "STMT_TYPE_CALL (25)";
                break;
            }
            case 27: {
                string4 = "STMT_TYPE_SQLJ (27)";
                break;
            }
            default: {
                string4 = "STMT_TYPE_OTHER (26)";
            }
        }
        DB2Trace.methodExit((Object)this, "getStatementType()", string4);
        return (short)n;
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }

    public int getUpdateCount() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.colCount > 0 || !this.moreResults) {
            return -1;
        }
        if (this.rowCount < 0) {
            return 0;
        }
        return this.rowCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    private synchronized void incrementStatementCount() {
        if (!this.counted) {
            DB2Statement.adjustStatementCount(1);
            this.counted = true;
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    protected int numberColumns() throws SQLException {
        if (this.colCount != -1) {
            return this.colCount;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)49);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                this.colCount = this.db2req.readShort();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return this.colCount;
    }

    public void setCursorName(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)22);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)19);
                this.db2req.write(this.statementHandle);
                short s = 0;
                if (bl) {
                    s = 1;
                }
                this.db2req.write(s);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchDirection( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchDirection(n);
            this.fetchDirection = n;
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "setFetchDirection()", this.fetchDirection);
            }
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchSize( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchSize(n);
            this.fetchSize = n;
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "setFetchSize()", this.fetchSize);
            }
        }
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        if (this.maxFieldSize == n) {
            return;
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)17);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxFieldSize = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.maxRows == n) {
            return;
        }
        if (n < 0 || n > 0 && n < this.fetchSize) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)18);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxRows = n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)20);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }
}

